/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr;

import com.sap.ip.mmr.applications.IProgressMonitor;
import com.sap.ip.mmr.foundation.Utilities;
import com.sap.ip.mmr.persistence.Workspace;
import com.sap.tc.logging.Log;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;

public class ConnectionSpec
implements javax.resource.cci.ConnectionSpec {
    public static final String PROPERTY_SERIALIZED_FILE_WRITE = "serializedFileWrite";
    public static final String PROPERTY_TEMP_DIR = "tempDir";
    private String userName;
    private String password;
    private String language;
    private int dbType = -1;
    private Set workspacesM1 = new HashSet();
    private Set workspacesM2 = new HashSet();
    private List connectionsRequired = new LinkedList();
    private Properties properties = new Properties();
    private boolean readOnly = false;
    private Locale locale = null;
    private Log log = null;
    private IProgressMonitor pmOverall;
    private IProgressMonitor pmDetail;
    private ClassLoader componentClassLoader;

    public ConnectionSpec() {
        this.setUserName(System.getProperty("user.name"));
        this.setPassword(null);
        this.setLanguage(System.getProperty("user.language"));
        this.setLocale(Locale.getDefault());
        String tempDir = System.getProperty("java.io.tmpdir").replace('\\', '/');
        this.properties.put(PROPERTY_TEMP_DIR, tempDir);
    }

    public String toString() {
        return super.toString() + "\n" + "userName='" + this.userName + "', lanugage='" + this.language + "'\n workspacesM1=" + this.workspacesM1 + "\n workspacesM2=" + this.workspacesM2 + "\n properties=" + this.properties;
    }

    public String getUserName() {
        return this.userName;
    }

    public final void setUserName(String userName) {
        this.userName = userName;
    }

    public final void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public final void setLanguage(String language) {
        this.language = language;
        if (this.language == null) {
            this.language = "en";
        }
    }

    public String getLanguage() {
        return this.language;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public int getDbType() {
        return this.dbType;
    }

    public void setDbType(int dbType) {
        this.dbType = dbType;
    }

    public List getConnectionsRequired() {
        return this.connectionsRequired;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public final void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Log getLog() {
        return this.log;
    }

    public void setLog(Log log) {
        this.log = log;
    }

    public Log createConsoleLog() {
        return Utilities.getUtilities().getConsoleLog();
    }

    public final void setWorkspace(Workspace workspace) {
        this.workspacesM1.clear();
        this.workspacesM1.add(workspace);
        this.workspacesM2.add(workspace);
    }

    public final Set getWorkspacesM1() {
        return this.workspacesM1;
    }

    public final Set getWorkspacesM2() {
        return this.workspacesM2;
    }

    public IProgressMonitor getPmDetail() {
        return this.pmDetail;
    }

    public IProgressMonitor getPmOverall() {
        return this.pmOverall;
    }

    public void setPmDetail(IProgressMonitor monitor) {
        this.pmDetail = monitor;
    }

    public void setPmOverall(IProgressMonitor monitor) {
        this.pmOverall = monitor;
    }

    public ClassLoader getComponentClassLoader() {
        return this.componentClassLoader;
    }

    public void setComponentClassLoader(ClassLoader loader) {
        this.componentClassLoader = loader;
    }
}

