/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr;

import java.io.File;
import java.util.ArrayList;

public class Configuration {
    private String repositoryHomeDir = null;
    private int cacheMaxNumOfObjects = 200;
    private int cacheTimeInvalidate = 300000;
    private int databaseType = -1;
    private String dataSourceName = "SAP/BW_MMR";

    public Configuration() {
        this.setDefaults();
    }

    private final void setDefaults() {
        this.repositoryHomeDir = null;
        String userDir = System.getProperty("user.dir");
        ArrayList<String> paths = new ArrayList<String>(3);
        paths.add("." + File.separator + "SAPMMR");
        paths.add("C:" + File.separator + "SAPMMR");
        paths.add("D:" + File.separator + "SAPMMR");
        paths.add(File.separator + "SAPMMR");
        paths.add(userDir + File.separator + "SAPMMR");
        for (int i = 0; i < paths.size() && this.repositoryHomeDir == null; ++i) {
            File file = new File((String)paths.get(i));
            if (!file.exists() || !file.isDirectory()) continue;
            this.repositoryHomeDir = (String)paths.get(i);
        }
        if (this.repositoryHomeDir == null) {
            this.repositoryHomeDir = System.getProperty("java.io.tmpdir") + "SAPMMR";
        }
        this.repositoryHomeDir = this.repositoryHomeDir + File.separator;
    }

    public int getCacheMaxNumOfObjects() {
        return this.cacheMaxNumOfObjects;
    }

    public int getCacheTimeInvalidate() {
        return this.cacheTimeInvalidate;
    }

    public int getDatabaseType() {
        return this.databaseType;
    }

    public String getRepositoryHomeDir() {
        return this.repositoryHomeDir;
    }

    public void setCacheMaxNumOfObjects(int cacheMaxNumOfObjects) {
        this.cacheMaxNumOfObjects = cacheMaxNumOfObjects;
    }

    public void setCacheTimeInvalidate(int cacheTimeInvalidate) {
        this.cacheTimeInvalidate = cacheTimeInvalidate;
    }

    public void setDatabaseType(int databaseType) {
        this.databaseType = databaseType;
    }

    public void setRepositoryHomeDir(String repositoryHomeDirInput) {
        this.repositoryHomeDir = repositoryHomeDirInput.replace('\\', '/');
        if (this.repositoryHomeDir.charAt(this.repositoryHomeDir.length() - 1) != '/') {
            this.repositoryHomeDir = this.repositoryHomeDir + "/";
        }
        if (this.repositoryHomeDir.indexOf("SAPMMR") < 0) {
            this.repositoryHomeDir = this.repositoryHomeDir + "SAPMMR/";
        }
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }
}

