/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.system.naming.provider;

import com.sap.engine.system.naming.provider.DefaultInitialContext;
import com.sap.engine.system.naming.provider.DefaultObjectFactory;
import com.sap.engine.system.naming.provider.LogHelper;
import com.sap.engine.system.naming.provider.Manager;
import com.sap.engine.system.naming.provider.ResolverManager;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import javax.naming.spi.ObjectFactoryBuilder;

public class ObjectFactoryBuilderImpl
implements ObjectFactoryBuilder {
    private ObjectFactory defaultOF = new DefaultObjectFactory();
    private ObjectFactory proxyFactory = new DispatchObjectFactory();
    private LogHelper logger = null;

    public ObjectFactory createObjectFactory(Object refInfo, Hashtable env) throws NamingException {
        this.log("A dummy ObjectFactory implementation will be returned. The real search and loading of a proper object factory will be made in getObjectInstance() call.");
        return this.proxyFactory;
    }

    private Object _getObjectInstance(Object refInfo, Name name, Context nameCtx, Hashtable env) throws Exception {
        String objFacs;
        Reference ref = null;
        Object result = null;
        if (refInfo instanceof Reference) {
            ref = (Reference)refInfo;
        } else if (refInfo instanceof Referenceable) {
            ref = ((Referenceable)refInfo).getReference();
        }
        ResolverManager mgr = (ResolverManager)Manager.getInstance();
        ObjectFactory fac = null;
        if (ref != null) {
            String f = ref.getFactoryClassName();
            if (f != null) {
                try {
                    fac = mgr.findObjectFactory(f);
                }
                catch (Exception e) {
                    NamingException ne = new NamingException("Exception while trying to load factory with name : " + f);
                    ne.setRootCause(e);
                    throw ne;
                }
                if (fac != null) {
                    return fac.getObjectInstance(refInfo, name, nameCtx, env);
                }
                return refInfo;
            }
            int i = 0;
            while (i < ref.size()) {
                String url;
                RefAddr addr = ref.get(i);
                if (addr instanceof StringRefAddr && addr.getType().equalsIgnoreCase("URL") && (url = (String)addr.getContent()) != null) {
                    String scheme = DefaultInitialContext._getURLScheme(url);
                    try {
                        fac = mgr.findURLContextFactory(scheme, env);
                        if (fac != null) {
                            return fac.getObjectInstance(refInfo, name, nameCtx, env);
                        }
                    }
                    catch (NamingException ne) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
        if ((objFacs = (String)env.get("java.naming.factory.object")) != null) {
            this.log("Environment property java.naming.factory.object = " + objFacs + " will be searched for a proper factory");
            StringTokenizer tokenizer = new StringTokenizer(objFacs, ":");
            String objFac = null;
            ObjectFactory of = null;
            Vector<ObjectFactory> factories = new Vector<ObjectFactory>();
            while (tokenizer.hasMoreTokens()) {
                objFac = tokenizer.nextToken().trim();
                try {
                    this.log("Will try to load ObjectFactory with name " + objFac);
                    of = mgr.findObjectFactory(objFac);
                    if (of == null) continue;
                    factories.add(of);
                }
                catch (Exception ne) {
                    NamingException e = new NamingException("No Object Factory found for java.naming.factory.object=" + objFacs);
                    e.setRootCause(ne);
                    throw e;
                }
            }
            if (factories != null && factories.size() > 0) {
                result = this.createObjectFromFactories(refInfo, name, nameCtx, env, factories);
            }
        }
        return result != null ? result : refInfo;
    }

    private Object createObjectFromFactories(Object obj, Name name, Context nameCtx, Hashtable environment, Vector factories) throws Exception {
        ObjectFactory factory = null;
        Object answer = null;
        this.log("Will try the loaded factories to see which one will return non null result.");
        int i = 0;
        while (i < factories.size()) {
            factory = (ObjectFactory)factories.get(i);
            answer = factory.getObjectInstance(obj, name, nameCtx, environment);
            this.log("Factory " + factory + " getObjectInstance() result " + answer);
            if (answer != null) {
                return answer;
            }
            ++i;
        }
        return null;
    }

    private void initLogger() {
        if (this.logger == null) {
            ResolverManager mgr = null;
            try {
                mgr = (ResolverManager)Manager.getInstance();
            }
            catch (NamingException namingException) {
                // empty catch block
            }
            this.logger = mgr.getLogger();
        }
    }

    private void log(String message) {
        if (this.logger == null) {
            this.initLogger();
        }
        if (this.logger != null && this.logger.toLogPathInLocation()) {
            this.logger.logStringInPath(message);
        }
    }

    private void logThrowable(Throwable ex) {
        if (this.logger == null) {
            this.initLogger();
        }
        if (this.logger != null && this.logger.toLogPathInLocation()) {
            this.logger.logThrowable(ex);
        }
    }

    class DispatchObjectFactory
    implements ObjectFactory {
        DispatchObjectFactory() {
        }

        public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
            ObjectFactoryBuilderImpl.this.log("Will delegate the call to the ObjectFactoryBuilder to find a proper factory");
            return ObjectFactoryBuilderImpl.this._getObjectInstance(obj, name, nameCtx, environment);
        }
    }
}

