/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.system;

import com.sap.engine.boot.SystemProperties;
import java.lang.ref.WeakReference;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.StringTokenizer;
import java.util.Vector;

public class SystemURLStreamHandlerFactory
implements URLStreamHandlerFactory {
    private static Vector weakReferences = new Vector(10, 10);

    public void registerHandlerPackage(String packageName) {
        AccessController.doPrivileged(new AddPackageAction(packageName));
    }

    public void registerClassLoader(ClassLoader loader) {
        weakReferences.add(new WeakReference<ClassLoader>(loader));
    }

    public URLStreamHandler createURLStreamHandler(String protocol) {
        URLStreamHandler handler = null;
        String packagesList = (String)AccessController.doPrivileged(new GetPackagesAction());
        StringTokenizer tokens = new StringTokenizer(packagesList, "|");
        while (handler == null && tokens.hasMoreTokens()) {
            String handlerPackage = tokens.nextToken().trim();
            try {
                Class handlerClass = this.loadClass(handlerPackage + "." + protocol + ".Handler");
                if (handlerClass == null) continue;
                handler = (URLStreamHandler)handlerClass.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return handler;
    }

    private Class loadClass(String className) throws Exception {
        Vector vector = weakReferences;
        synchronized (vector) {
            int i = 0;
            while (i < weakReferences.size()) {
                WeakReference ref = (WeakReference)weakReferences.elementAt(i);
                ClassLoader loader = (ClassLoader)ref.get();
                if (loader == null) {
                    weakReferences.removeElementAt(i);
                    --i;
                } else {
                    Class<?> clazz = loader.loadClass(className);
                    return clazz;
                }
                ++i;
            }
        }
        return null;
    }

    class GetPackagesAction
    implements PrivilegedAction {
        GetPackagesAction() {
        }

        public Object run() {
            String result = SystemProperties.getProperty("java.protocol.handler.pkgs");
            return result != null ? result : "";
        }
    }

    class AddPackageAction
    implements PrivilegedAction {
        String packageName = null;

        public AddPackageAction(String packageName) {
            this.packageName = packageName;
        }

        public Object run() {
            if (this.packageName != null) {
                String result = null;
                this.packageName = this.packageName.trim();
                result = SystemProperties.getProperty("java.protocol.handler.pkgs");
                result = result != null ? result + "|" + this.packageName : this.packageName;
                SystemProperties.setProperty("java.protocol.handler.pkgs", result);
            }
            return null;
        }
    }
}

