/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.system;

import com.sap.engine.system.SystemProtectionDomain;
import com.sap.engine.system.SystemSecurityReference;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.Security;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.security.auth.Policy;
import javax.security.auth.Subject;
import javax.security.auth.SubjectDomainCombiner;

public class SystemSubjectDomainCombiner
extends SubjectDomainCombiner {
    private static WeakReference securityRef = null;
    private Object session;
    private Subject subject;
    private boolean allowCaching = true;
    private Hashtable cachedProtectionDomains = new Hashtable();
    static /* synthetic */ Class class$com$sap$engine$system$SystemProtectionDomain;

    public SystemSubjectDomainCombiner(Subject subject) {
        super(subject);
        this.subject = subject;
        SystemSecurityReference ref = (SystemSecurityReference)securityRef.get();
        if (ref != null) {
            this.session = ref.login(subject);
        }
        this.allowCaching = this.cachePolicy();
    }

    public Object getSession() {
        return this.session;
    }

    public void finalize() throws Throwable {
        try {
            block5: {
                try {
                    SystemSecurityReference ref = (SystemSecurityReference)securityRef.get();
                    if (ref == null) break block5;
                    ref.logout(this.session);
                }
                catch (ThreadDeath t) {
                    throw t;
                }
                catch (Throwable t) {
                    Object var4_4 = null;
                    super.finalize();
                    return;
                }
            }
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            super.finalize();
            throw throwable;
        }
        super.finalize();
    }

    public static void useSecurityReference(SystemSecurityReference reference) {
        securityRef = new WeakReference<SystemSecurityReference>(reference);
    }

    public ProtectionDomain[] combine(ProtectionDomain[] aprotectiondomain, ProtectionDomain[] aprotectiondomain1) {
        if (aprotectiondomain == null || aprotectiondomain.length == 0) {
            return this.optimize(aprotectiondomain1);
        }
        if (!this.allowCaching) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Policy.getPolicy().refresh();
                    return null;
                }
            });
        }
        aprotectiondomain = this.optimize(aprotectiondomain);
        aprotectiondomain1 = this.optimize(aprotectiondomain1);
        if (aprotectiondomain == null && aprotectiondomain1 == null) {
            return null;
        }
        int i = aprotectiondomain != null ? aprotectiondomain.length : 0;
        int j = aprotectiondomain1 != null ? aprotectiondomain1.length : 0;
        ProtectionDomain[] aprotectiondomain2 = new ProtectionDomain[i + j];
        int k = 0;
        int l = 0;
        while (l < i) {
            CodeSource codesource = aprotectiondomain[l].getCodeSource();
            ProtectionDomain protectiondomain = null;
            CacheEntry cacheentry = new CacheEntry(this.subject, codesource);
            protectiondomain = (ProtectionDomain)this.cachedProtectionDomains.get(cacheentry);
            if (protectiondomain == null) {
                Permissions permissions = new Permissions();
                Enumeration<Permission> enumeration = aprotectiondomain[l].getPermissions().elements();
                while (enumeration.hasMoreElements()) {
                    Permission permission = enumeration.nextElement();
                    permissions.add(permission);
                }
                PermissionCollection permissioncollection = null;
                final CodeSource codesource1 = codesource;
                final Subject finalS = this.subject;
                permissioncollection = (PermissionCollection)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return Policy.getPolicy().getPermissions(finalS, codesource1);
                    }
                });
                Enumeration<Permission> enumeration1 = permissioncollection.elements();
                while (enumeration1.hasMoreElements()) {
                    Permission permission1 = enumeration1.nextElement();
                    if (permissions.implies(permission1)) continue;
                    permissions.add(permission1);
                }
                protectiondomain = (class$com$sap$engine$system$SystemProtectionDomain == null ? SystemSubjectDomainCombiner.class$("com.sap.engine.system.SystemProtectionDomain") : class$com$sap$engine$system$SystemProtectionDomain).isAssignableFrom(aprotectiondomain[l].getClass()) ? ((SystemProtectionDomain)aprotectiondomain[l]).clone(permissions) : new ProtectionDomain(codesource, permissions);
            }
            aprotectiondomain2[k++] = protectiondomain;
            if (this.allowCaching) {
                this.cachedProtectionDomains.put(cacheentry, protectiondomain);
            }
            ++l;
        }
        if (j > 0) {
            System.arraycopy(aprotectiondomain1, 0, aprotectiondomain2, k, j);
        }
        if ((aprotectiondomain2 = this.optimize(aprotectiondomain2)) == null || aprotectiondomain2.length == 0) {
            return null;
        }
        return aprotectiondomain2;
    }

    protected ProtectionDomain[] optimize(ProtectionDomain[] aprotectiondomain) {
        if (aprotectiondomain == null) {
            return null;
        }
        ProtectionDomain[] aprotectiondomain1 = new ProtectionDomain[aprotectiondomain.length];
        int i = 0;
        int j = 0;
        while (j < aprotectiondomain.length) {
            if (aprotectiondomain[j] != null) {
                boolean flag = false;
                int k = 0;
                while (k < i) {
                    if (aprotectiondomain1[k] == aprotectiondomain[j]) {
                        flag = true;
                        break;
                    }
                    ++k;
                }
                if (!flag) {
                    aprotectiondomain1[i++] = aprotectiondomain[j];
                }
            }
            ++j;
        }
        if (i < aprotectiondomain.length) {
            ProtectionDomain[] aprotectiondomain2 = new ProtectionDomain[i];
            System.arraycopy(aprotectiondomain1, 0, aprotectiondomain2, 0, aprotectiondomain2.length);
            aprotectiondomain1 = aprotectiondomain2;
        }
        return aprotectiondomain1.length != 0 ? aprotectiondomain1 : null;
    }

    private boolean cachePolicy() {
        String s = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Security.getProperty("cache.auth.policy");
            }
        });
        if (s != null) {
            Boolean boolean1 = new Boolean(s);
            return boolean1;
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class CacheEntry {
        private Subject subject;
        private CodeSource codesource;

        public CacheEntry(Subject subject1, CodeSource codesource1) {
            this.subject = subject1;
            this.codesource = codesource1;
        }

        public int hashCode() {
            if (this.codesource != null) {
                return this.codesource.hashCode();
            }
            if (this.subject == null) {
                return 0;
            }
            return this.subject.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            if (obj instanceof CacheEntry) {
                CacheEntry cacheentry = (CacheEntry)obj;
                if ((this.codesource == null && cacheentry.codesource == null || this.codesource != null && cacheentry.codesource != null && this.codesource.equals(cacheentry.codesource)) && (this.subject == null && cacheentry.subject == null || this.subject != null && cacheentry.subject != null && this.subject.getPrincipals().containsAll(cacheentry.subject.getPrincipals()) && cacheentry.subject.getPrincipals().containsAll(this.subject.getPrincipals()))) {
                    return true;
                }
            }
            return false;
        }
    }
}

