/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.system;

import java.io.BufferedOutputStream;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Properties;

public final class SystemEnvironment {
    private static final Properties DEFAULT_PROPERTIES = null;
    private static Properties props = new Properties(DEFAULT_PROPERTIES);
    public static final String LINE_SEPARATOR = SystemEnvironment.getProperty("line.separator", "\n");
    public static final PrintStream STD_OUT = new ConstantPrintStream(new BufferedOutputStream(new FileOutputStream(FileDescriptor.out), 128), true);
    public static final PrintStream STD_ERR = new ConstantPrintStream(new BufferedOutputStream(new FileOutputStream(FileDescriptor.err), 128), true);

    public static Properties getProperties() {
        try {
            return System.getProperties();
        }
        catch (SecurityException e) {
            return props;
        }
    }

    public static String getProperty(String key) {
        try {
            return System.getProperty(key);
        }
        catch (SecurityException e) {
            if (key == null) {
                throw new NullPointerException("key can't be null");
            }
            if (key.equals("")) {
                throw new IllegalArgumentException("key can't be empty");
            }
            return props.getProperty(key);
        }
    }

    public static String getProperty(String key, String def) {
        try {
            return System.getProperty(key, def);
        }
        catch (SecurityException e) {
            if (key == null) {
                throw new NullPointerException("key can't be null");
            }
            if (key.equals("")) {
                throw new IllegalArgumentException("key can't be empty");
            }
            return props.getProperty(key, def);
        }
    }

    public static void setProperties(Properties p) {
        try {
            System.setProperties(p);
        }
        catch (SecurityException e) {
            if (p == null) {
                p = new Properties(DEFAULT_PROPERTIES);
            }
            props = p;
        }
    }

    public static String setProperty(String key, String value) {
        try {
            return System.setProperty(key, value);
        }
        catch (SecurityException e) {
            if (key == null) {
                throw new NullPointerException("key can't be null");
            }
            if (key.equals("")) {
                throw new IllegalArgumentException("key can't be empty");
            }
            return (String)props.setProperty(key, value);
        }
    }

    public static boolean getBoolean(String name) {
        try {
            return "true".equalsIgnoreCase(SystemEnvironment.getProperty(name));
        }
        catch (IllegalArgumentException ie) {
            return false;
        }
        catch (NullPointerException ne) {
            return false;
        }
    }

    private static final class ConstantPrintStream
    extends PrintStream {
        ConstantPrintStream(OutputStream out) {
            super(out);
        }

        ConstantPrintStream(OutputStream out, boolean autoFlush) {
            super(out, autoFlush);
        }

        public void close() {
        }

        protected void finalize() {
            super.close();
        }
    }
}

