/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.boot.coverage;

import com.sap.engine.boot.coverage.Node;

public class NodeList {
    static final int INITIAL_ARRAY_SIZE = 10000;
    static final int POWER_OF_TWO = 17;
    static final int MAX_ITEMS = (int)Math.pow(2.0, 17.0);
    private Node[][] storage = new Node[10000][];
    private int currentArrayIndex = -1;
    private int currentItemIndex = 0;

    public NodeList() {
        this.extend();
    }

    private void extend() {
        try {
            this.storage[++this.currentArrayIndex] = new Node[MAX_ITEMS];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("ArrayIndexOutOfBoundsException in com.sap.engine.boot.coverage.NodeList: You have reached the limit of " + 10000 * MAX_ITEMS + " loaded classes");
        }
        this.currentItemIndex = 0;
    }

    public void add(Node object) {
        this.storage[this.currentArrayIndex][this.currentItemIndex++] = object;
        if (this.currentItemIndex == MAX_ITEMS) {
            this.extend();
        }
    }

    public Node get(int index) {
        return this.storage[index >> 17][index % MAX_ITEMS];
    }
}

