/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.boot.coverage;

import com.sap.engine.boot.ModificationFactory;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class Node
implements Serializable,
Cloneable {
    private final String CLASS_SEPARATOR = ".";
    private static final int UNKNOWN = -1;
    private static final Node NULL = null;
    private static final byte NONE = 0;
    private static final byte PACKAGE = 1;
    private static final byte CLASS = 2;
    private static final byte METHOD = 4;
    private long executes = 0L;
    private byte type = 0;
    private static int indexer = 0;
    private String name = null;
    private ArrayList nodes = null;
    private int identity = -1;

    public Node() {
        this.init();
    }

    public Node(String name, byte type) {
        this.name = name;
        this.type = type;
        this.init();
    }

    public Node(String name, byte type, int identity) {
        this.identity = identity;
        this.type = type;
        this.name = name;
    }

    public int getIdentity() {
        return this.identity;
    }

    private void init() {
        this.nodes = new ArrayList();
    }

    public String getName() {
        return this.name;
    }

    public byte getType() {
        return this.type;
    }

    public void increase() {
        ++this.executes;
    }

    public long getExecuteCounter() {
        return this.executes;
    }

    public int getTreeSize() {
        return indexer;
    }

    private int addMethod(String method) {
        int size = this.nodes.size();
        Node node = null;
        int i = 0;
        i = 0;
        while (i < size) {
            node = (Node)this.nodes.get(i);
            if (node.getName().equals(method)) {
                return node.identity;
            }
            ++i;
        }
        node = new Node(method, 4, indexer);
        this.nodes.add(node);
        ModificationFactory.nodes.add(node);
        return indexer++;
    }

    public int add(String search, String method) {
        int size = this.nodes.size();
        int searchType = 0;
        Node node = null;
        int i = 0;
        String title = "";
        String nextSearch = "";
        if (search.indexOf(".") > 0) {
            searchType = 1;
            title = search.substring(0, search.indexOf("."));
            nextSearch = search.substring(search.indexOf(".") + 1);
        } else {
            searchType = 2;
            title = search;
            nextSearch = "";
        }
        switch (searchType) {
            case 1: {
                i = 0;
                while (i < size) {
                    node = (Node)this.nodes.get(i);
                    if (node.getName().equals(title) && node.getType() == 1) {
                        return node.add(nextSearch, method);
                    }
                    ++i;
                }
                node = new Node(title, 1);
                this.nodes.add(node);
                return node.add(nextSearch, method);
            }
            case 2: {
                i = 0;
                while (i < size) {
                    node = (Node)this.nodes.get(i);
                    if (node.getName().equals(title) && node.getType() == 2) {
                        return node.addMethod(method);
                    }
                    ++i;
                }
                node = new Node(title, 2);
                this.nodes.add(node);
                return node.addMethod(method);
            }
        }
        return -1;
    }

    private int addMethodItem(String method, long count) {
        int size = this.nodes.size();
        Node node = null;
        int i = 0;
        i = 0;
        while (i < size) {
            node = (Node)this.nodes.get(i);
            if (node.getName().equals(method)) {
                long currentCount = node.executes;
                node.executes = currentCount <= currentCount + count ? (node.executes += count) : Long.MAX_VALUE;
                return node.identity;
            }
            ++i;
        }
        node = new Node(method, 4, indexer);
        node.executes = count;
        this.nodes.add(node);
        ModificationFactory.nodes.add(node);
        return indexer++;
    }

    public int addItem(String search, String method, long count) {
        int size = this.nodes.size();
        int searchType = 0;
        Node node = null;
        int i = 0;
        String title = "";
        String nextSearch = "";
        if (search.indexOf(".") > 0) {
            searchType = 1;
            title = search.substring(0, search.indexOf("."));
            nextSearch = search.substring(search.indexOf(".") + 1);
        } else {
            searchType = 2;
            title = search;
            nextSearch = "";
        }
        switch (searchType) {
            case 1: {
                i = 0;
                while (i < size) {
                    node = (Node)this.nodes.get(i);
                    if (node.getName().equals(title) && node.getType() == 1) {
                        return node.addItem(nextSearch, method, count);
                    }
                    ++i;
                }
                node = new Node(title, 1);
                this.nodes.add(node);
                return node.addItem(nextSearch, method, count);
            }
            case 2: {
                i = 0;
                while (i < size) {
                    node = (Node)this.nodes.get(i);
                    if (node.getName().equals(title) && node.getType() == 2) {
                        return node.addMethodItem(method, count);
                    }
                    ++i;
                }
                node = new Node(title, 2);
                this.nodes.add(node);
                return node.addMethodItem(method, count);
            }
        }
        return -1;
    }

    private int findMethod(String method) {
        int size = this.nodes.size();
        Node node = null;
        int i = 0;
        i = 0;
        while (i < size) {
            node = (Node)this.nodes.get(i);
            if (node.getName().equals(method)) {
                return node.getIdentity();
            }
            ++i;
        }
        return -1;
    }

    public int find(String search, String method) {
        int size = this.nodes.size();
        int searchType = 0;
        Node node = null;
        int i = 0;
        String title = "";
        String nextSearch = "";
        if (search.indexOf(".") > 0) {
            searchType = 1;
            title = search.substring(0, search.indexOf("."));
            nextSearch = search.substring(search.indexOf(".") + 1);
        } else {
            searchType = 2;
            title = search;
            nextSearch = "";
        }
        switch (searchType) {
            case 1: {
                i = 0;
                while (i < size) {
                    node = (Node)this.nodes.get(i);
                    if (node.getName().equals(title) && node.getType() == 1) {
                        return node.find(nextSearch, method);
                    }
                    ++i;
                }
                break;
            }
            case 2: {
                i = 0;
                while (i < size) {
                    node = (Node)this.nodes.get(i);
                    if (node.getName().equals(title) && node.getType() == 2) {
                        return node.findMethod(method);
                    }
                    ++i;
                }
                break;
            }
        }
        return -1;
    }

    private Node getNodeMethod(String method) {
        int size = this.nodes.size();
        Node node = null;
        int i = 0;
        i = 0;
        while (i < size) {
            node = (Node)this.nodes.get(i);
            if (node.getName().equals(method)) {
                return node;
            }
            ++i;
        }
        return NULL;
    }

    public Node getNode(String search, String method) {
        int size = this.nodes.size();
        int searchType = 0;
        Node node = null;
        int i = 0;
        String title = "";
        String nextSearch = "";
        if (search.indexOf(".") > 0) {
            searchType = 1;
            title = search.substring(0, search.indexOf("."));
            nextSearch = search.substring(search.indexOf(".") + 1);
        } else {
            searchType = 2;
            title = search;
            nextSearch = "";
        }
        switch (searchType) {
            case 1: {
                i = 0;
                while (i < size) {
                    node = (Node)this.nodes.get(i);
                    if (node.getName().equals(title) && node.getType() == 1) {
                        return node.getNode(nextSearch, method);
                    }
                    ++i;
                }
                break;
            }
            case 2: {
                i = 0;
                while (i < size) {
                    node = (Node)this.nodes.get(i);
                    if (node.getName().equals(title) && node.getType() == 2) {
                        return node.getNodeMethod(method);
                    }
                    ++i;
                }
                break;
            }
        }
        return NULL;
    }

    public String toXml() {
        String xml = "";
        int size = 0;
        if (this.type != 4) {
            size = this.nodes.size();
        }
        switch (this.type) {
            case 0: {
                xml = "<document>\r\n";
                break;
            }
            case 1: {
                xml = "<package size=\"" + size + "\" name=\"" + this.name + "\">\r\n";
                break;
            }
            case 2: {
                xml = "<class size=\"" + size + "\" name=\"" + this.name + "\">\r\n";
                break;
            }
            case 4: {
                xml = "<method name=\"" + this.name + "\" id=\"" + this.identity + "\">" + this.executes + "</method>\r\n";
            }
        }
        if (this.type != 4) {
            int i = 0;
            while (i < size) {
                xml = xml + ((Node)this.nodes.get(i)).toXml();
                ++i;
            }
        }
        switch (this.type) {
            case 0: {
                xml = xml + "</document>\r\n";
                break;
            }
            case 1: {
                xml = xml + "</package>\r\n";
                break;
            }
            case 2: {
                xml = xml + "</class>\r\n";
            }
        }
        return xml;
    }

    public void reset() {
        int size = 0;
        if (this.type != 4) {
            size = this.nodes.size();
            int i = 0;
            while (i < size) {
                ((Node)this.nodes.get(i)).reset();
                ++i;
            }
        } else {
            this.executes = 0L;
        }
    }

    public void toTxtFormat(OutputStream out) throws Exception {
        int size = 0;
        Node node = null;
        size = this.nodes.size();
        int i = 0;
        while (i < size) {
            node = (Node)this.nodes.get(i);
            if (node.getType() != 4) {
                node.toTxtFormat(out, node.getName());
            } else {
                out.write((":" + node.getName() + ":" + node.getExecuteCounter() + "\r\n").getBytes());
            }
            ++i;
        }
    }

    private void toTxtFormat(OutputStream out, String path) throws Exception {
        int size = 0;
        Node node = null;
        size = this.nodes.size();
        int i = 0;
        while (i < size) {
            node = (Node)this.nodes.get(i);
            if (node.getType() != 4) {
                node.toTxtFormat(out, path + "." + node.getName());
            } else {
                out.write((path + ":" + node.getName() + ":" + node.getExecuteCounter() + "\r\n").getBytes());
            }
            ++i;
        }
    }

    public void load(InputStream in) throws Exception {
        LineNumberReader reader = null;
        String line = null;
        reader = new LineNumberReader(new InputStreamReader(in));
        StringTokenizer lineTokenizer = null;
        while ((line = reader.readLine()) != null) {
            if (line.trim().length() <= 0) continue;
            lineTokenizer = new StringTokenizer(line, ":");
            this.add(lineTokenizer.nextToken(), lineTokenizer.nextToken());
            lineTokenizer = null;
        }
        if (reader != null) {
            reader.close();
        }
    }

    public void merge(InputStream in) throws Exception {
        LineNumberReader reader = null;
        String line = null;
        reader = new LineNumberReader(new InputStreamReader(in));
        StringTokenizer lineTokenizer = null;
        while ((line = reader.readLine()) != null) {
            if (line.trim().length() <= 0) continue;
            lineTokenizer = new StringTokenizer(line, ":");
            String packageName = lineTokenizer.nextToken();
            String methodName = lineTokenizer.nextToken();
            String counts = lineTokenizer.nextToken();
            long count = 0L;
            try {
                count = Long.parseLong(counts);
            }
            catch (NumberFormatException e) {
                count = Long.MAX_VALUE;
            }
            this.addItem(packageName, methodName, count);
            lineTokenizer = null;
        }
        if (reader != null) {
            reader.close();
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

