/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.boot;

import com.sap.engine.boot.BootScriptProcessor;
import com.sap.engine.boot.FileClassLoader;
import com.sap.engine.boot.FrameThread;
import com.sap.engine.boot.ModificationFactory;
import com.sap.engine.boot.PipedSystemInputStream;
import com.sap.engine.boot.SystemProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

final class StartFrame {
    private static final String MODIFICATION_FILE = ".." + File.separator + "coverage.runtime.filter.properties";
    private static final String MODIFICATION_FILE_OLD = "modification.properties";
    private static final String MODIFICATION_PROPERTY = "modification";
    private static FrameThread frameThread;
    private String frameDir;
    private String coreDir;
    private String coreLibraryDir;
    private boolean working = true;

    StartFrame(String[] args) {
        Properties props;
        String propertyValue;
        try {
            Class.forName("com.sap.engine.system.naming.provider.ResolverManager");
        }
        catch (Throwable t) {
            System.out.println("Warning: Naming resolver manager class cannot be instantiated due to : " + t.toString());
        }
        new BootScriptProcessor().processIfAny();
        String separator = File.separator;
        this.frameDir = "." + separator + "bin" + separator + "system" + separator;
        this.coreDir = "." + separator + "bin" + separator + "kernel" + separator;
        this.coreLibraryDir = "." + separator + "bin" + separator + "core_lib" + separator;
        int i = 0;
        while (i < args.length) {
            if (args[i].startsWith("jars=")) {
                this.frameDir = args[i].substring(5);
            } else if (args[i].startsWith("kernel=")) {
                this.coreDir = args[i].substring(7);
            }
            ++i;
        }
        if (!this.frameDir.endsWith(File.separator)) {
            this.frameDir = this.frameDir + File.separator;
        }
        if (!SystemProperties.getBoolean("redirect.input")) {
            PipedSystemInputStream pis = new PipedSystemInputStream();
            pis.start();
        }
        File file = new File(MODIFICATION_FILE);
        File file_old = new File(MODIFICATION_FILE_OLD);
        if (file.exists()) {
            Properties props2 = this.readProps(file);
            ModificationFactory.init(props2, true);
        } else if (file_old.exists() && (propertyValue = (props = this.readProps(file_old)).getProperty(MODIFICATION_PROPERTY)) != null && propertyValue.trim().equalsIgnoreCase("true")) {
            ModificationFactory.init(props, false);
            FileClassLoader.setUseTracing();
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Properties readProps(File file) {
        FileInputStream in = null;
        in = new FileInputStream(file);
        Properties props = new Properties();
        props.load(in);
        Properties properties = props;
        Object var6_6 = null;
        try {
            in.close();
            return properties;
        }
        catch (Exception e2) {
            return properties;
        }
        {
            catch (IOException e) {
                System.out.println("Warning: Modification properties file \"" + MODIFICATION_FILE + "\" cannot be read !");
                Object var6_7 = null;
                try {
                    in.close();
                    return null;
                }
                catch (Exception e2) {
                    return null;
                }
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            try {
                in.close();
                throw throwable;
            }
            catch (Exception e2) {
                in = null;
            }
            throw throwable;
        }
    }

    public void work() {
        while (this.working) {
            frameThread = new FrameThread(this);
            StartFrame startFrame = this;
            synchronized (startFrame) {
                new Thread(frameThread).start();
                try {
                    this.wait();
                }
                catch (InterruptedException iException) {
                    this.working = false;
                }
                if (this.working) {
                    SystemProperties.setProperty("INQMY_SERVER_REBOOTED", "YES");
                    System.out.println("System down. Rebooting");
                    System.gc();
                }
            }
        }
    }

    public String getFrameDir() {
        return this.frameDir;
    }

    public String getCoreDir() {
        return this.coreDir;
    }

    public String getCoreLibraryDir() {
        return this.coreLibraryDir;
    }

    public synchronized void setResult(boolean result) {
        this.working = result;
        this.notify();
    }

    public static void shutdown() {
        FrameThread.shutdown();
    }
}

