/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.boot;

import com.sap.engine.boot.ControlledCryptographyProvider;
import com.sap.engine.boot.JarFilter;
import com.sap.engine.boot.ModificationFactory;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class FileClassLoader
extends ClassLoader {
    public static final String FRAME_LOADER = "Frame ClassLoader";
    public static final String CORE_LOADER = "Core ClassLoader";
    public static final String CORE_LIBRARY_LOADER = "library:core_lib";
    public static final String CORE_LIBRARY_NAME = "core_lib";
    protected static final byte EMPTY = 0;
    protected static final byte JARS = 1;
    protected static final byte DIRS = 2;
    protected static final byte MIXED = 3;
    protected static boolean logStarted = false;
    protected String name;
    protected byte pattern;
    protected ClassLoader parent;
    protected ProtectionDomain loaderDomain;
    protected String[] jars = new String[0];
    protected JarFilter[] jarFilters = new JarFilter[0];
    protected ProtectionDomain[] jarDomains = new ProtectionDomain[0];
    protected boolean[] dumpedException = new boolean[0];
    protected File[] dirs = new File[0];
    protected ProtectionDomain[] dirDomains = new ProtectionDomain[0];
    private static boolean useTrace = false;

    public FileClassLoader(ClassLoader parent, String name) {
        super(parent);
        this.init(name, null, (byte)0);
    }

    public FileClassLoader(ClassLoader parent, String name, ProtectionDomain domain) {
        super(parent);
        this.init(name, domain, (byte)0);
    }

    public FileClassLoader(ClassLoader parent, String name, String fileName, boolean isJar, ProtectionDomain domain) {
        super(parent);
        this.init(name, domain, isJar ? (byte)1 : 2);
        if (isJar) {
            this.addJar(fileName);
        } else {
            this.addDir(fileName);
        }
    }

    public FileClassLoader(ClassLoader parent, String name, String[] fileNames, boolean areJars, ProtectionDomain domain) {
        super(parent);
        this.init(name, domain, areJars ? (byte)1 : 2);
        if (areJars) {
            this.addJars(fileNames);
        } else {
            this.addDirs(fileNames);
        }
    }

    public FileClassLoader(ClassLoader parent, String name, String[] jarNames, String[] dirNames, ProtectionDomain domain) {
        super(parent);
        this.init(name, domain, (byte)3);
        this.addJars(jarNames);
        this.addDirs(dirNames);
    }

    public FileClassLoader(ClassLoader parent, String name, File[] dirFiles, ProtectionDomain domain) {
        super(parent);
        this.init(name, domain, (byte)2);
        this.addDirs(dirFiles);
    }

    public FileClassLoader(ClassLoader parent, String name, File[] files, boolean areJars, ProtectionDomain domain) {
        super(parent);
        this.init(name, domain, areJars ? (byte)1 : 2);
        if (areJars) {
            this.addJars(files);
        } else {
            this.addDirs(files);
        }
    }

    private void init(String name, ProtectionDomain protectionDomain, byte pattern) {
        this.parent = this.getParent();
        if (this.parent == null) {
            this.parent = ClassLoader.getSystemClassLoader();
        }
        this.name = name == null ? this.getClass().getName() + "@" + Integer.toHexString(this.hashCode()) : name;
        this.loaderDomain = protectionDomain;
        this.pattern = pattern;
    }

    public String getName() {
        return this.name;
    }

    public ClassLoader getParentLoader() {
        return this.parent;
    }

    public String getParentName() {
        ClassLoader parentLoader = this.getParentLoader();
        String parentLoaderName = null;
        parentLoaderName = parentLoader != null ? (parentLoader instanceof FileClassLoader ? ((FileClassLoader)parentLoader).getName() : parentLoader.toString()) : "BOOTSRAP";
        return parentLoaderName;
    }

    public final String getInfo() {
        StringBuffer buffer = new StringBuffer(228);
        buffer.append("\r\n------------------------- Loader Info -------------------------\r\nClassLoader name: [" + this.name + "]");
        buffer.append("\r\n Parent loader name: [" + this.getParentName() + "]");
        String[] names = this.getResourceNames();
        if (names != null && names.length != 0) {
            buffer.append("\r\n Resources:");
            int i = 0;
            while (i < names.length) {
                buffer.append("\r\n   " + names[i]);
                ++i;
            }
        } else {
            buffer.append("\r\n No resources !");
        }
        buffer.append("\r\n---------------------------------------------------------------");
        return buffer.toString();
    }

    public void addJar(String jarName) {
        if (jarName == null) {
            return;
        }
        this.addJars(new File[]{new File(jarName)});
    }

    public void addJars(String[] jarNames) {
        if (jarNames == null) {
            return;
        }
        File[] jarFiles = new File[jarNames.length];
        int i = 0;
        while (i < jarNames.length) {
            if (jarNames[i] != null) {
                jarFiles[i] = new File(jarNames[i]);
            }
            ++i;
        }
        this.addJars(jarFiles);
    }

    public void addJars(File[] jarFiles) {
        if (jarFiles == null) {
            return;
        }
        String[] jarPaths = new String[jarFiles.length];
        int i = 0;
        while (i < jarFiles.length) {
            if (jarFiles[i] != null) {
                try {
                    jarPaths[i] = jarFiles[i].getCanonicalPath();
                }
                catch (IOException e) {
                    jarPaths[i] = jarFiles[i].getAbsolutePath();
                }
            }
            ++i;
        }
        String string = this.name;
        synchronized (string) {
            switch (this.pattern) {
                case 0: 
                case 2: {
                    this.pattern = (byte)(this.pattern + 1);
                    this.jars = jarPaths;
                    this.jarFilters = new JarFilter[this.jars.length];
                    break;
                }
                case 1: 
                case 3: {
                    String[] newJars = new String[this.jars.length + jarPaths.length];
                    System.arraycopy(this.jars, 0, newJars, 0, this.jars.length);
                    System.arraycopy(jarPaths, 0, newJars, this.jars.length, jarPaths.length);
                    this.jars = newJars;
                    JarFilter[] newJarFilters = new JarFilter[this.jars.length];
                    System.arraycopy(this.jarFilters, 0, newJarFilters, 0, this.jarFilters.length);
                    this.jarFilters = newJarFilters;
                    break;
                }
            }
            ProtectionDomain[] newJarDomains = new ProtectionDomain[this.jarDomains.length + jarPaths.length];
            System.arraycopy(this.jarDomains, 0, newJarDomains, 0, this.jarDomains.length);
            int i2 = this.jarDomains.length;
            while (i2 < newJarDomains.length) {
                newJarDomains[i2] = this.jars[i2] != null ? this.getProtectionDomain(new File(this.jars[i2])) : this.loaderDomain;
                ++i2;
            }
            this.jarDomains = newJarDomains;
            boolean[] newDumpedException = new boolean[this.dumpedException.length + jarPaths.length];
            System.arraycopy(this.dumpedException, 0, newDumpedException, 0, this.dumpedException.length);
            this.dumpedException = newDumpedException;
        }
    }

    public void addDir(String dirName) {
        if (dirName == null) {
            return;
        }
        this.addDirs(new File[]{new File(dirName)});
    }

    public void addDirs(String[] dirNames) {
        if (dirNames == null) {
            return;
        }
        File[] dirFiles = new File[dirNames.length];
        int i = 0;
        while (i < dirNames.length) {
            if (dirNames[i] != null) {
                dirFiles[i] = new File(dirNames[i]);
            }
            ++i;
        }
        this.addDirs(dirFiles);
    }

    public void addDirs(File[] dirFiles) {
        if (dirFiles == null) {
            return;
        }
        int i = 0;
        while (i < dirFiles.length) {
            if (dirFiles[i] != null) {
                try {
                    dirFiles[i] = dirFiles[i].getCanonicalFile();
                }
                catch (IOException e) {
                    dirFiles[i] = dirFiles[i].getAbsoluteFile();
                }
            }
            ++i;
        }
        String string = this.name;
        synchronized (string) {
            switch (this.pattern) {
                case 0: 
                case 1: {
                    this.pattern = (byte)(this.pattern + 2);
                    this.dirs = dirFiles;
                    break;
                }
                case 2: 
                case 3: {
                    File[] newDirs = new File[dirFiles.length + this.dirs.length];
                    System.arraycopy(this.dirs, 0, newDirs, 0, this.dirs.length);
                    System.arraycopy(dirFiles, 0, newDirs, this.dirs.length, dirFiles.length);
                    this.dirs = newDirs;
                    break;
                }
            }
            ProtectionDomain[] newDirDomains = new ProtectionDomain[this.dirDomains.length + dirFiles.length];
            System.arraycopy(this.dirDomains, 0, newDirDomains, 0, this.dirDomains.length);
            int i2 = this.dirDomains.length;
            while (i2 < newDirDomains.length) {
                newDirDomains[i2] = dirFiles[i2] != null ? this.getProtectionDomain(dirFiles[i2]) : this.loaderDomain;
                ++i2;
            }
            this.dirDomains = newDirDomains;
        }
    }

    public void addMixed(File[] files) {
        if (files == null) {
            return;
        }
        String string = this.name;
        synchronized (string) {
            Vector<String> jarsTmp = new Vector<String>();
            Vector<File> dirsTmp = new Vector<File>();
            int i = 0;
            while (i < files.length) {
                String token = files[i].getPath().toLowerCase();
                if (token.endsWith(".jar") || token.endsWith(".zip")) {
                    jarsTmp.add(token);
                } else {
                    dirsTmp.add(files[i]);
                }
                ++i;
            }
            String[] jarsTemp = new String[jarsTmp.size()];
            File[] dirsTemp = new File[dirsTmp.size()];
            int i2 = 0;
            while (i2 < jarsTmp.size()) {
                jarsTemp[i2] = (String)jarsTmp.elementAt(i2);
                ++i2;
            }
            int i3 = 0;
            while (i3 < dirsTmp.size()) {
                dirsTemp[i3] = (File)dirsTmp.elementAt(i3);
                ++i3;
            }
            this.addJars(jarsTemp);
            this.addDirs(dirsTemp);
        }
    }

    public String[] getJars() {
        String[] result = new String[this.jars.length];
        int i = 0;
        while (i < result.length) {
            result[i] = this.jars[i];
            ++i;
        }
        return result;
    }

    public File[] getDirs() {
        File[] result = new File[this.dirs.length];
        int i = 0;
        while (i < result.length) {
            result[i] = this.dirs[i];
            ++i;
        }
        return result;
    }

    public String[] getResourceNames() {
        switch (this.pattern) {
            case 1: {
                String[] result = new String[this.jars.length];
                int i = 0;
                while (i < result.length) {
                    result[i] = this.jars[i];
                    ++i;
                }
                return result;
            }
            case 2: {
                String[] result = new String[this.dirs.length];
                int i = 0;
                while (i < result.length) {
                    result[i] = this.dirs[i].getAbsolutePath();
                    ++i;
                }
                return result;
            }
            case 3: {
                int jarsLength = this.jars.length;
                int dirsLength = this.dirs.length;
                String[] result = new String[jarsLength + dirsLength];
                int j = 0;
                int i = 0;
                while (i < jarsLength) {
                    result[j] = this.jars[i];
                    ++i;
                    ++j;
                }
                int i2 = 0;
                while (i2 < dirsLength) {
                    result[j] = this.dirs[i2].getAbsolutePath();
                    ++i2;
                    ++j;
                }
                return result;
            }
        }
        return new String[0];
    }

    public ProtectionDomain getProtectionDomain() {
        return this.loaderDomain;
    }

    protected ProtectionDomain getProtectionDomain(String className, int findIndexLocal, boolean isFromJarLocal) {
        try {
            if (isFromJarLocal) {
                return this.jarDomains[findIndexLocal];
            }
            return this.dirDomains[findIndexLocal];
        }
        catch (Exception e) {
            return this.loaderDomain;
        }
    }

    protected ProtectionDomain getProtectionDomain(File file) {
        URL url = this.getURL(file);
        Certificate[] certificates = this.getCertificates(file);
        CodeSource codeSource = new CodeSource(url, certificates);
        PermissionCollection permissionCollection = this.getPermissionCollection(file, certificates, codeSource);
        return new ProtectionDomain(codeSource, permissionCollection);
    }

    protected URL getURL(File file) {
        try {
            return file.toURL();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            try {
                return new URL("file:" + file.getAbsolutePath());
            }
            catch (MalformedURLException e2) {
                return null;
            }
        }
    }

    protected Certificate[] getCertificates(File file) {
        return null;
    }

    protected PermissionCollection getPermissionCollection(File file, Certificate[] certs, CodeSource codeSource) {
        PermissionCollection collection;
        if (this.loaderDomain != null && (collection = this.loaderDomain.getPermissions()) != null) {
            return collection;
        }
        return Policy.getPolicy().getPermissions(codeSource);
    }

    public static void clearInloadableContainer() {
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class result = this.findLoadedClass(name);
        if (result == null) {
            try {
                result = this.parent.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                result = this.findClass(name);
            }
        }
        if (resolve) {
            this.resolveClass(result);
        }
        return result;
    }

    public Class findClass(String className) throws ClassNotFoundException {
        String fileName = className.replace('.', '/') + ".class";
        boolean isFindInJarLocal = false;
        int findIndexLocal = 0;
        byte[] buffer = null;
        JarFilter[] jarFilters = this.jarFilters;
        block3 : switch (this.pattern) {
            case 1: {
                int i = 0;
                while (i < jarFilters.length) {
                    if (this.openJar(jarFilters, i) && jarFilters[i].accept(fileName) && (buffer = this.readResourceFromJar(fileName, jarFilters[i].getJar())) != null) {
                        isFindInJarLocal = true;
                        findIndexLocal = i;
                        break block3;
                    }
                    ++i;
                }
                break;
            }
            case 2: {
                int i = 0;
                while (i < this.dirs.length) {
                    if (this.dirs[i] != null && (buffer = this.readResourceFromDir(fileName, this.dirs[i])) != null) {
                        isFindInJarLocal = false;
                        findIndexLocal = i;
                        break block3;
                    }
                    ++i;
                }
                break;
            }
            case 3: {
                int i = 0;
                while (i < jarFilters.length) {
                    if (this.openJar(jarFilters, i) && jarFilters[i].accept(fileName) && (buffer = this.readResourceFromJar(fileName, jarFilters[i].getJar())) != null) {
                        isFindInJarLocal = true;
                        findIndexLocal = i;
                        break;
                    }
                    ++i;
                }
                if (buffer != null) break;
                int i2 = 0;
                while (i2 < this.dirs.length) {
                    if (this.dirs[i2] != null && (buffer = this.readResourceFromDir(fileName, this.dirs[i2])) != null) {
                        isFindInJarLocal = false;
                        findIndexLocal = i2;
                        break block3;
                    }
                    ++i2;
                }
                break;
            }
        }
        if (buffer == null) {
            throw new ClassNotFoundException(className);
        }
        FileClassLoader fileClassLoader = this;
        synchronized (fileClassLoader) {
            Class<?> cls = this.findLoadedClass(className);
            if (cls != null) {
                Class<?> clazz = cls;
                return clazz;
            }
            if (useTrace) {
                try {
                    buffer = ModificationFactory.getModificator(this).modify(buffer, className);
                }
                catch (Exception exc) {
                    this.log(this.getClass(), "ModificationFactory.getModificator(this).modify(" + buffer + ", " + className + ")", exc);
                }
            }
            this.loadPackageForClass(className, findIndexLocal, isFindInJarLocal, jarFilters);
            Class<?> clazz = this.defineClass(className, buffer, 0, buffer.length, this.getProtectionDomain(className, findIndexLocal, isFindInJarLocal));
            return clazz;
        }
    }

    public URL getResource(String fileName) {
        URL result = this.parent.getResource(fileName);
        if (result != null) {
            return result;
        }
        return this.getLocalResource(fileName);
    }

    public URL getLocalResource(String fileName) {
        switch (this.pattern) {
            case 1: {
                JarFilter[] jarFilters = this.jarFilters;
                int i = 0;
                while (i < jarFilters.length) {
                    if (this.openJar(jarFilters, i) && jarFilters[i].accept(fileName) && jarFilters[i].getJar().getJarEntry(fileName) != null) {
                        Object var6_13;
                        try {
                            try {
                                URL uRL = new URL("jar", "", new File(this.jars[i]).toURL() + "!/" + fileName);
                                var6_13 = null;
                                return uRL;
                            }
                            catch (MalformedURLException e) {
                                this.log(this.getClass(), "getLocalResource(" + this.jars[i] + ", " + fileName + ")", e);
                                var6_13 = null;
                            }
                        }
                        catch (Throwable throwable) {
                            var6_13 = null;
                            throw throwable;
                        }
                    }
                    ++i;
                }
                break;
            }
            case 2: {
                int i = 0;
                while (i < this.dirs.length) {
                    if (this.dirs[i] != null && new File(this.dirs[i], fileName).exists()) {
                        try {
                            return new File(this.dirs[i], fileName).toURL();
                        }
                        catch (MalformedURLException e) {
                            this.log(this.getClass(), "getLocalResource(" + this.dirs[i] + ", " + fileName + ")", e);
                        }
                    }
                    ++i;
                }
                break;
            }
            case 3: {
                JarFilter[] jarFilters = this.jarFilters;
                int i = 0;
                while (i < jarFilters.length) {
                    if (this.openJar(jarFilters, i) && jarFilters[i].accept(fileName) && jarFilters[i].getJar().getJarEntry(fileName) != null) {
                        Object var8_16;
                        try {
                            try {
                                URL e = new URL("jar", "", new File(this.jars[i]).toURL() + "!/" + fileName);
                                var8_16 = null;
                                return e;
                            }
                            catch (MalformedURLException e) {
                                this.log(this.getClass(), "getLocalResource(" + this.jars[i] + ", " + fileName + ")", e);
                                var8_16 = null;
                            }
                        }
                        catch (Throwable throwable) {
                            var8_16 = null;
                            throw throwable;
                        }
                    }
                    ++i;
                }
                int i2 = 0;
                while (i2 < this.dirs.length) {
                    if (this.dirs[i2] != null && new File(this.dirs[i2], fileName).exists()) {
                        try {
                            return new File(this.dirs[i2], fileName).toURL();
                        }
                        catch (MalformedURLException e) {
                            this.log(this.getClass(), "getLocalResource(" + this.dirs[i2] + ", " + fileName + ")", e);
                        }
                    }
                    ++i2;
                }
                break;
            }
        }
        return null;
    }

    public InputStream getResourceAsStream(String fileName) {
        InputStream in = this.parent.getResourceAsStream(fileName);
        if (in != null) {
            return in;
        }
        return this.getLocalResourceAsStream(fileName);
    }

    public InputStream getLocalResourceAsStream(String fileName) {
        byte[] buffer = null;
        block0 : switch (this.pattern) {
            case 1: {
                JarFilter[] jarFilters = this.jarFilters;
                int i = 0;
                while (i < jarFilters.length) {
                    if (this.openJar(jarFilters, i) && jarFilters[i].accept(fileName) && (buffer = this.readResourceFromJar(fileName, jarFilters[i].getJar())) != null) break block0;
                    ++i;
                }
                break;
            }
            case 2: {
                int i = 0;
                while (i < this.dirs.length) {
                    if (this.dirs[i] != null && (buffer = this.readResourceFromDir(fileName, this.dirs[i])) != null) break block0;
                    ++i;
                }
                break;
            }
            case 3: {
                JarFilter[] jarFilters = this.jarFilters;
                int i = 0;
                while (i < jarFilters.length) {
                    if (this.openJar(jarFilters, i) && jarFilters[i].accept(fileName) && (buffer = this.readResourceFromJar(fileName, jarFilters[i].getJar())) != null) break;
                    ++i;
                }
                if (buffer != null) break;
                int i2 = 0;
                while (i2 < this.dirs.length) {
                    if (this.dirs[i2] != null && (buffer = this.readResourceFromDir(fileName, this.dirs[i2])) != null) break block0;
                    ++i2;
                }
                break;
            }
        }
        if (buffer == null) {
            return null;
        }
        return new ByteArrayInputStream(buffer);
    }

    protected Enumeration findResources(String fileName) throws IOException {
        return this.findLocalResources(fileName);
    }

    public Enumeration findLocalResources(String fileName) throws IOException {
        Vector<URL> array = new Vector<URL>();
        switch (this.pattern) {
            case 1: {
                JarFilter[] jarFilters = this.jarFilters;
                int i = 0;
                while (i < jarFilters.length) {
                    if (this.openJar(jarFilters, i) && jarFilters[i].accept(fileName) && jarFilters[i].getJar().getJarEntry(fileName) != null) {
                        try {
                            array.add(new URL("jar", "", new File(this.jars[i]).toURL() + "!/" + fileName));
                        }
                        catch (MalformedURLException e) {
                            this.log(this.getClass(), "findLocalResources(" + this.jars[i] + ", " + fileName + ")", e);
                        }
                    }
                    ++i;
                }
                break;
            }
            case 2: {
                int i = 0;
                while (i < this.dirs.length) {
                    if (this.dirs[i] != null && new File(this.dirs[i], fileName).exists()) {
                        try {
                            array.add(new File(this.dirs[i], fileName).toURL());
                        }
                        catch (MalformedURLException e) {
                            this.log(this.getClass(), "findLocalResources(" + this.dirs[i] + ", " + fileName + ")", e);
                        }
                    }
                    ++i;
                }
                break;
            }
            case 3: {
                JarFilter[] jarFilters = this.jarFilters;
                int i = 0;
                while (i < jarFilters.length) {
                    if (this.openJar(jarFilters, i) && jarFilters[i].accept(fileName) && jarFilters[i].getJar().getJarEntry(fileName) != null) {
                        try {
                            array.add(new URL("jar", "", new File(this.jars[i]).toURL() + "!/" + fileName));
                        }
                        catch (MalformedURLException e) {
                            this.log(this.getClass(), "findLocalResources(" + this.jars[i] + ", " + fileName + ")", e);
                        }
                    }
                    ++i;
                }
                int i2 = 0;
                while (i2 < this.dirs.length) {
                    if (this.dirs[i2] != null && new File(this.dirs[i2], fileName).exists()) {
                        try {
                            array.add(new File(this.dirs[i2], fileName).toURL());
                        }
                        catch (MalformedURLException e) {
                            this.log(this.getClass(), "findLocalResources(" + this.dirs[i2] + ", " + fileName + ")", e);
                        }
                    }
                    ++i2;
                }
                break;
            }
        }
        return array.elements();
    }

    protected void loadPackageForClass(String className, int findIndexLocal, boolean isFindInJarLocal, JarFilter[] jarFilters) {
        String pkgName;
        int index = className.lastIndexOf(46);
        if (index != -1 && this.getPackage(pkgName = className.substring(0, index)) == null) {
            try {
                if (isFindInJarLocal) {
                    Manifest manifest = jarFilters[findIndexLocal].getManifest();
                    this.definePackage(pkgName, manifest);
                } else {
                    this.definePackage(pkgName, null, null, null, null, null, null, null);
                }
            }
            catch (IllegalArgumentException e) {
                return;
            }
        }
    }

    protected Package definePackage(String pkgName, Manifest manifest) {
        if (manifest == null) {
            return this.definePackage(pkgName, null, null, null, null, null, null, null);
        }
        String specTitle = null;
        String specVersion = null;
        String specVendor = null;
        String implTitle = null;
        String implVersion = null;
        String implVendor = null;
        String sealed = null;
        Attributes attributes = manifest.getAttributes(pkgName.replace('.', '/'));
        if (attributes != null) {
            specTitle = attributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
            specVersion = attributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
            specVendor = attributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            implTitle = attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            implVersion = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            implVendor = attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            sealed = attributes.getValue(Attributes.Name.SEALED);
        }
        if ((attributes = manifest.getMainAttributes()) != null) {
            if (specTitle == null) {
                specTitle = attributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
            }
            if (specVersion == null) {
                specVersion = attributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
            }
            if (specVendor == null) {
                specVendor = attributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            }
            if (implTitle == null) {
                implTitle = attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            }
            if (implVersion == null) {
                implVersion = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            }
            if (implVendor == null) {
                implVendor = attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            }
            if (sealed == null) {
                sealed = attributes.getValue(Attributes.Name.SEALED);
            }
        }
        return this.definePackage(pkgName, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, null);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private byte[] readResourceFromJar(String fileName, JarFile jar) {
        JarEntry entry = jar.getJarEntry(fileName);
        if (entry == null) {
            return null;
        }
        InputStream in = null;
        String provider = null;
        int len = (int)entry.getSize();
        byte[] result = new byte[len];
        provider = ControlledCryptographyProvider.useProvider("SUN");
        in = jar.getInputStream(entry);
        int n = 0;
        while (n < len) {
            int count = in.read(result, n, len - n);
            if (count < 0) {
                throw new EOFException();
            }
            n += count;
        }
        byte[] byArray = result;
        Object var11_12 = null;
        ControlledCryptographyProvider.revertToProvider(provider);
        try {
            in.close();
            return byArray;
        }
        catch (Exception e) {
            return byArray;
        }
        {
            catch (IOException ioException) {
                this.log(this.getClass(), "readResourceFromJar(" + fileName + ", " + jar.getName() + ")", ioException);
                Object var11_13 = null;
                ControlledCryptographyProvider.revertToProvider(provider);
                try {
                    in.close();
                    return null;
                }
                catch (Exception e) {
                    return null;
                }
            }
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            ControlledCryptographyProvider.revertToProvider(provider);
            try {
                in.close();
                throw throwable;
            }
            catch (Exception e) {
                in = null;
            }
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] readResourceFromDir(String fileName, File dirFile) {
        file = new File(dirFile, fileName);
        in = null;
        if (file.exists() == false) return null;
        try {
            try {
                in = new FileInputStream(file);
                len = in.available();
                result = new byte[len];
                n = 0;
                while (true) {
                    if (n >= len) {
                        var8_10 = result;
                        var10_11 = null;
                        break;
                    }
                    count = in.read(result, n, len - n);
                    if (count < 0) {
                        throw new EOFException();
                    }
                    n += count;
                }
            }
            catch (IOException ioException) {
                this.log(this.getClass(), "readResourceFromDir(" + dirFile + ", " + fileName + ", " + dirFile.getAbsolutePath() + ")", ioException);
                var10_12 = null;
                try {
                    in.close();
                    return null;
                }
                catch (Exception e) {
                    this.log(this.getClass(), "readResourceFromDir(" + dirFile + ", " + fileName + ", " + dirFile.getAbsolutePath() + ")", e);
                    return null;
                }
            }
        }
        catch (Throwable var9_17) {
            var10_13 = null;
            ** try [egrp 2[TRYBLOCK] [2 : 176->184)] { 
lbl37:
            // 1 sources

            in.close();
            throw var9_17;
lbl39:
            // 1 sources

            catch (Exception e) {
                this.log(this.getClass(), "readResourceFromDir(" + dirFile + ", " + fileName + ", " + dirFile.getAbsolutePath() + ")", e);
            }
            throw var9_17;
        }
        ** try [egrp 2[TRYBLOCK] [2 : 176->184)] { 
lbl45:
        // 1 sources

        in.close();
        return var8_10;
lbl47:
        // 1 sources

        catch (Exception e) {
            this.log(this.getClass(), "readResourceFromDir(" + dirFile + ", " + fileName + ", " + dirFile.getAbsolutePath() + ")", e);
        }
        return var8_10;
    }

    private boolean openJar(JarFilter[] jarFilters, int i) {
        if (jarFilters[i] == null) {
            try {
                jarFilters[i] = new JarFilter(this.jars[i]);
            }
            catch (IOException ioException) {
                if (!this.dumpedException[i]) {
                    this.dumpedException[i] = this.log(this.getClass(), "openJar(" + this.jars[i] + ")", ioException);
                }
                return false;
            }
        }
        return true;
    }

    protected static String[] getJars(String dirName) {
        String[] jarNames = new File(dirName).list(new FilenameFilter(){

            public boolean accept(File parentDir, String fileName) {
                return new File(parentDir, fileName).isFile() && ((fileName = fileName.toLowerCase()).endsWith(".jar") || fileName.endsWith(".zip"));
            }
        });
        if (jarNames != null) {
            if (!dirName.endsWith(File.separator)) {
                dirName = dirName + File.separator;
            }
            int i = 0;
            while (i < jarNames.length) {
                jarNames[i] = dirName + jarNames[i];
                ++i;
            }
        }
        return jarNames;
    }

    protected static File[] getJarFiles(String dirName) {
        File[] jarFiles = new File(dirName).listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                String fileName;
                return pathname.isFile() && ((fileName = pathname.getName().toLowerCase()).endsWith(".jar") || fileName.endsWith(".zip"));
            }
        });
        return jarFiles;
    }

    public static void setLogSuccessfullyStarted() {
        logStarted = true;
    }

    static final void setUseTracing() {
        useTrace = true;
    }

    public static final boolean useTracing() {
        return useTrace;
    }

    public boolean log(Class classLocation, String subLocation, Exception rootException) {
        if (!logStarted) {
            return false;
        }
        if (this.parent instanceof FileClassLoader) {
            FileClassLoader fileClassLoaderParent = (FileClassLoader)this.parent;
            return fileClassLoaderParent.log(classLocation, subLocation, rootException);
        }
        return true;
    }
}

