/*
 * Decompiled with CFR 0.152.
 */
package com.sap.localization;

import com.sap.localization.Localizable;
import com.sap.localization.LocalizableText;
import com.sap.localization.LocalizationException;
import com.sap.localization.ResourceAccessor;
import com.sap.tc.logging.Location;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class LocalizableTextFormatter
implements LocalizableText {
    private static final Location classLocation = Location.getLocation((Class)(class$com$sap$localization$LocalizableTextFormatter == null ? (class$com$sap$localization$LocalizableTextFormatter = LocalizableTextFormatter.class$("com.sap.localization.LocalizableTextFormatter")) : class$com$sap$localization$LocalizableTextFormatter));
    private static final long serialVersionUID = -1987066547108755872L;
    private ResourceAccessor resourceAccessor;
    private String patternKey;
    private Object[] arguments;
    private String applicationName;
    private Locale locale;
    private Calendar calendar = new GregorianCalendar();
    private boolean isLocalFormat = true;
    private boolean isCacheSetting = false;
    private boolean isFinallySetting = false;
    private String localizedText;
    static /* synthetic */ Class class$com$sap$localization$LocalizableTextFormatter;

    public LocalizableTextFormatter() {
    }

    public LocalizableTextFormatter(ResourceAccessor resourceAccessor, String patternKey) {
        this(resourceAccessor, patternKey, null, null);
    }

    public LocalizableTextFormatter(ResourceAccessor resourceAccessor, String patternKey, Object[] args) {
        this(resourceAccessor, patternKey, args, null);
    }

    public LocalizableTextFormatter(ResourceAccessor resourceAccessor, String patternKey, Object[] args, String applicationName) {
        this.resourceAccessor = resourceAccessor;
        this.patternKey = patternKey;
        this.arguments = args;
        this.applicationName = applicationName;
    }

    public LocalizableTextFormatter(ResourceAccessor resourceAccessor, LocalizableText.Msg msg) {
        this(resourceAccessor, msg.getPatternKey(), msg.getArguments(), null);
    }

    public static String formatString(ResourceAccessor resourceAccessor, String patternKey) throws LocalizationException {
        LocalizableTextFormatter tmp = new LocalizableTextFormatter(resourceAccessor, patternKey);
        return tmp.format(Localizable.defaultLocale, TimeZone.getDefault());
    }

    public static String formatString(ResourceAccessor resourceAccessor, String patternKey, Object[] args) throws LocalizationException {
        LocalizableTextFormatter tmp = new LocalizableTextFormatter(resourceAccessor, patternKey, args);
        return tmp.format(Localizable.defaultLocale, TimeZone.getDefault());
    }

    public static String formatString(ResourceAccessor resourceAccessor, String patternKey, Object[] args, Locale loc, TimeZone timeZone) throws LocalizationException {
        LocalizableTextFormatter tmp = new LocalizableTextFormatter(resourceAccessor, patternKey, args);
        return tmp.format(loc, timeZone);
    }

    public static String formatString(ResourceAccessor resourceAccessor, LocalizableText.Msg msg) throws LocalizationException {
        LocalizableTextFormatter tmp = new LocalizableTextFormatter(resourceAccessor, msg);
        return tmp.format(Localizable.defaultLocale, TimeZone.getDefault());
    }

    public static String formatString(ResourceAccessor resourceAccessor, LocalizableText.Msg msg, Locale loc, TimeZone timeZone) throws LocalizationException {
        LocalizableTextFormatter tmp = new LocalizableTextFormatter(resourceAccessor, msg);
        return tmp.format(loc, timeZone);
    }

    public String format(Locale loc) throws LocalizationException {
        this.setLocale(loc);
        return this.format();
    }

    public String format(TimeZone tZone) throws LocalizationException {
        this.setTimeZone(tZone);
        return this.format();
    }

    public String format(Locale loc, TimeZone tZone) throws LocalizationException {
        this.setTimeZone(tZone);
        this.setLocale(loc);
        return this.format();
    }

    public String format() throws LocalizationException {
        String tmpResult;
        if (this.isFinallySetting()) {
            return this.localizedText;
        }
        if (this.isCacheSetting() && this.localizedText != null) {
            return this.localizedText;
        }
        String string = tmpResult = this.isLocalFormat() ? this.formatLocal() : this.formatRemote();
        if (this.isCacheSetting()) {
            this.localizedText = tmpResult;
        }
        return tmpResult;
    }

    public void finallyLocalize() throws LocalizationException {
        if (this.isFinallySetting()) {
            return;
        }
        this.localizedText = this.format();
        this.isFinallySetting = true;
    }

    public void finallyLocalize(Locale loc) throws LocalizationException {
        if (this.isFinallySetting()) {
            return;
        }
        this.localizedText = this.format(loc);
        this.isFinallySetting = true;
    }

    public void finallyLocalize(TimeZone tZone) throws LocalizationException {
        if (this.isFinallySetting()) {
            return;
        }
        this.localizedText = this.format(tZone);
        this.isFinallySetting = true;
    }

    public void finallyLocalize(Locale loc, TimeZone tZone) throws LocalizationException {
        if (this.isFinallySetting()) {
            return;
        }
        this.localizedText = this.format(loc, tZone);
        this.isFinallySetting = true;
    }

    public void setLocale(Locale locale) {
        if (locale == null && this.locale == null) {
            return;
        }
        if (locale != null && !locale.equals(this.locale) || this.locale != null && !this.locale.equals(locale)) {
            this.clearCache();
        }
        this.locale = locale;
        if (this.arguments != null) {
            int i = 0;
            while (i < this.arguments.length) {
                if (this.arguments[i] instanceof LocalizableText) {
                    ((LocalizableText)this.arguments[i]).setLocale(locale);
                }
                ++i;
            }
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setTimeZone(TimeZone timeZone) {
        if (this.calendar == null) {
            this.calendar = new GregorianCalendar();
        }
        if (timeZone == null && this.calendar.getTimeZone() == null) {
            return;
        }
        if (timeZone != null && !timeZone.equals(this.calendar.getTimeZone()) || this.calendar.getTimeZone() != null && !this.calendar.getTimeZone().equals(timeZone)) {
            this.clearCache();
        }
        this.calendar.setTimeZone(timeZone);
        if (this.arguments != null) {
            int i = 0;
            while (i < this.arguments.length) {
                if (this.arguments[i] instanceof LocalizableText) {
                    ((LocalizableText)this.arguments[i]).setTimeZone(timeZone);
                }
                ++i;
            }
        }
    }

    public TimeZone getTimeZone() {
        if (this.calendar == null) {
            return ((Calendar)new GregorianCalendar()).getTimeZone();
        }
        return this.calendar.getTimeZone();
    }

    public void setApplicationName(String applicationName) {
        if (applicationName == null && this.applicationName == null) {
            return;
        }
        if (applicationName != null && !applicationName.equals(this.applicationName) || this.applicationName != null && !this.applicationName.equals(applicationName)) {
            this.clearCache();
        }
        this.applicationName = applicationName;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getResourceBundleName() {
        if (this.resourceAccessor == null) {
            return null;
        }
        return this.resourceAccessor.getResourceBundleName();
    }

    public void setPatternKey(String patternKey) {
        if (patternKey == null && this.patternKey == null) {
            return;
        }
        if (patternKey != null && !patternKey.equals(this.patternKey) || this.patternKey != null && !this.patternKey.equals(patternKey)) {
            this.clearCache();
        }
        this.patternKey = patternKey;
    }

    public String getPatternKey() {
        return this.patternKey;
    }

    public void setArguments(Object[] obj) {
        if (this.arguments == null && obj == null) {
            return;
        }
        if (this.arguments != null && obj != null && this.arguments.length == obj.length) {
            int i = 0;
            while (i < obj.length) {
                if (obj[i] != null && !obj[i].equals(this.arguments[i]) || this.arguments[i] != null && !this.arguments[i].equals(obj[i])) {
                    this.clearCache();
                    break;
                }
                ++i;
            }
        } else {
            this.clearCache();
        }
        this.arguments = obj;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public void setResourceAccessor(ResourceAccessor resAccessor) {
        String bundleNameOld;
        if (resAccessor == null && this.resourceAccessor == null) {
            return;
        }
        String bundleNameNew = resAccessor == null ? null : resAccessor.getResourceBundleName();
        String string = bundleNameOld = this.resourceAccessor == null ? null : this.resourceAccessor.getResourceBundleName();
        if (bundleNameOld == null && bundleNameNew == null) {
            return;
        }
        if (bundleNameOld != null && !bundleNameOld.equals(bundleNameNew) || bundleNameNew != null && !bundleNameNew.equals(bundleNameOld)) {
            this.clearCache();
        }
        this.resourceAccessor = resAccessor;
    }

    public ResourceAccessor getResourceAccessor() {
        return this.resourceAccessor;
    }

    public void setCacheSetting(boolean setting) {
        this.isCacheSetting = setting;
        if (!setting) {
            this.clearCache();
        }
    }

    public boolean isCacheSetting() {
        return this.isCacheSetting;
    }

    public void setLocalFormat(boolean local) {
        this.isLocalFormat = local;
    }

    public boolean isLocalFormat() {
        return this.isLocalFormat;
    }

    public boolean isFinallySetting() {
        return this.isFinallySetting;
    }

    public void clearCache() {
        if (!this.isFinallySetting()) {
            this.localizedText = null;
        }
    }

    public void clearLocalizableTextFormatter() {
        if (!this.isFinallySetting()) {
            this.setPatternKey(null);
            this.setApplicationName(null);
            this.setCacheSetting(false);
            this.arguments = null;
            this.locale = null;
            this.calendar = null;
        }
    }

    public String getCacheEntry() {
        return this.localizedText;
    }

    /*
     * Unable to fully structure code
     */
    private String formatLocal() throws LocalizationException {
        block11: {
            block12: {
                originalError = null;
                message = null;
                if (this.getLocale() == null) {
                    this.setLocale(Localizable.defaultLocale);
                }
                try {
                    if (this.getResourceBundleName() == null || this.getPatternKey() == null) {
                        throw new IllegalStateException("Resource bundle name and/or pattern key are null");
                    }
                    message = this.resourceAccessor.getMessageText(this.getLocale(), this.getPatternKey());
                    if (this.arguments != null) {
                        tmpArg = new Object[this.arguments.length];
                        i = 0;
                        while (i < this.arguments.length) {
                            tmpArg[i] = this.arguments[i] instanceof LocalizableText != false ? ((LocalizableText)this.arguments[i]).format() : this.arguments[i];
                            ++i;
                        }
                        mf = new MessageFormat("");
                        mf.setLocale(this.locale);
                        mf.applyPattern(message);
                        return mf.format(tmpArg);
                    }
                    return message;
                }
                catch (RuntimeException e) {
                    originalError = e;
                    if (this.getPatternKey() == null) break block11;
                    buffer = new StringBuffer();
                    buffer.append("<--Localization failed: ResourceBundle='");
                    if (this.resourceAccessor != null && this.resourceAccessor.getResourceBundleName() != null) {
                        buffer.append(this.resourceAccessor.getResourceBundleName());
                    }
                    buffer.append("', ID='" + this.getPatternKey() + "', Arguments: [");
                    if (this.arguments == null) break block12;
                    i = 0;
                    ** while (i < this.arguments.length)
                }
lbl-1000:
                // 1 sources

                {
                    if (i != 0) {
                        buffer.append(", ");
                    }
                    buffer.append("'");
                    buffer.append(this.arguments[i]);
                    buffer.append("'");
                    ++i;
                    continue;
                }
            }
            if (originalError.getMessage() != null) {
                buffer.append("]--> : " + originalError.getMessage());
            } else {
                buffer.append("]-->");
            }
            return buffer.toString();
        }
        throw new LocalizationException(originalError);
    }

    private String formatRemote() throws LocalizationException {
        throw new LocalizationException();
    }

    public String toString() {
        String tmpStr = null;
        try {
            tmpStr = this.format();
        }
        catch (LocalizationException e) {
            classLocation.logT(500, " Localization failed because of a LocalizationException.");
        }
        return tmpStr;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        Object[] tmpArg = this.arguments;
        if (this.arguments != null) {
            this.arguments = new Object[tmpArg.length];
            int i = 0;
            while (i < tmpArg.length) {
                this.arguments[i] = tmpArg[i] == null || tmpArg[i] instanceof Serializable ? tmpArg[i] : tmpArg[i].toString();
                ++i;
            }
        }
        out.defaultWriteObject();
        if (this.arguments != null) {
            this.arguments = tmpArg;
        }
    }

    public static LocalizableText.Key0 createKey0(String key) {
        return new KeyImpl(key);
    }

    public static LocalizableText.Key1 createKey1(String key) {
        return new KeyImpl(key);
    }

    public static LocalizableText.Key2 createKey2(String key) {
        return new KeyImpl(key);
    }

    public static LocalizableText.Key3 createKey3(String key) {
        return new KeyImpl(key);
    }

    public static LocalizableText.Key4 createKey4(String key) {
        return new KeyImpl(key);
    }

    public static LocalizableText.Key5 createKey5(String key) {
        return new KeyImpl(key);
    }

    public static LocalizableText.Key6 createKey6(String key) {
        return new KeyImpl(key);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class KeyImpl
    implements LocalizableText.Key0,
    LocalizableText.Key1,
    LocalizableText.Key2,
    LocalizableText.Key3,
    LocalizableText.Key4,
    LocalizableText.Key5,
    LocalizableText.Key6 {
        private final String key;

        private KeyImpl(String key) {
            this.key = key;
        }

        public LocalizableText.Msg msg() {
            return new MsgImpl(this.key, null);
        }

        public LocalizableText.Msg msg(Object obj1) {
            return new MsgImpl(this.key, new Object[]{obj1});
        }

        public LocalizableText.Msg msg(Object obj1, Object obj2) {
            return new MsgImpl(this.key, new Object[]{obj1, obj2});
        }

        public LocalizableText.Msg msg(Object obj1, Object obj2, Object obj3) {
            return new MsgImpl(this.key, new Object[]{obj1, obj2, obj3});
        }

        public LocalizableText.Msg msg(Object obj1, Object obj2, Object obj3, Object obj4) {
            return new MsgImpl(this.key, new Object[]{obj1, obj2, obj3, obj4});
        }

        public LocalizableText.Msg msg(Object obj1, Object obj2, Object obj3, Object obj4, Object obj5) {
            return new MsgImpl(this.key, new Object[]{obj1, obj2, obj3, obj4, obj5});
        }

        public LocalizableText.Msg msg(Object obj1, Object obj2, Object obj3, Object obj4, Object obj5, Object obj6) {
            return new MsgImpl(this.key, new Object[]{obj1, obj2, obj3, obj4, obj5, obj6});
        }
    }

    private static class MsgImpl
    implements LocalizableText.Msg {
        private String key;
        private Object[] obj;

        private MsgImpl(String key, Object[] obj) {
            this.key = key;
            this.obj = obj;
        }

        public String getPatternKey() {
            return this.key;
        }

        public Object[] getArguments() {
            return this.obj;
        }
    }
}

