/*
 * Decompiled with CFR 0.152.
 */
package com.sap.exception.remote;

import com.sap.exception.remote.Cause;
import java.lang.reflect.Method;
import java.util.Vector;

public class CauseFactory {
    public Cause getCause(Throwable rootCause) {
        if (this.isJDK_1_4()) {
            return this.wrap(rootCause);
        }
        return new Cause(rootCause);
    }

    private Cause wrap(Throwable rootCause) {
        try {
            Class<?> classThrowable = Class.forName("java.lang.Throwable");
            Vector<Throwable> chain = new Vector<Throwable>();
            while (rootCause != null) {
                chain.add(rootCause);
                Method getCause = classThrowable.getMethod("getCause", new Class[0]);
                Object nestedCause = getCause.invoke((Object)rootCause, null);
                if (nestedCause == null) break;
                rootCause = (Throwable)nestedCause;
            }
            Vector<Cause> causes = new Vector<Cause>(chain.size());
            while (chain.size() > 0) {
                causes.add(new Cause((Throwable)chain.remove(chain.size() - 1)));
            }
            Object[] causesArr = causes.toArray();
            int i = 0;
            while (i < causesArr.length) {
                if (i + 1 < causesArr.length) {
                    Class[] params = new Class[]{classThrowable};
                    Method initCause = classThrowable.getMethod("initCause", params);
                    Object[] args = new Object[]{causesArr[i]};
                    initCause.invoke(causesArr[i + 1], args);
                }
                ++i;
            }
            return (Cause)causesArr[causesArr.length - 1];
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private boolean isJDK_1_4() {
        try {
            Class<?> c = Class.forName("java.lang.Throwable");
            c.getMethod("getStackTrace", new Class[0]);
            c.getMethod("getCause", new Class[0]);
            Class.forName("java.lang.StackTraceElement");
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

