/*
 * Decompiled with CFR 0.152.
 */
package com.sap.exception.remote;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Method;

public class Cause
extends Throwable {
    public String causeStackTrace;
    public String realCauseName;
    public String realCauseMessage;
    private static final long serialVersionUID = 2485861870474650376L;

    Cause(Throwable realCause) {
        if (this.isJDK_1_4()) {
            this.reflectionHandler(realCause);
        } else {
            this.saveStackTrace(realCause);
        }
        this.realCauseName = realCause.getClass().toString();
        this.realCauseMessage = realCause.getLocalizedMessage();
    }

    private void reflectionHandler(Throwable cause) {
        try {
            Class<?> throwableClass = Class.forName("java.lang.Throwable");
            Method getStackTrace = throwableClass.getMethod("getStackTrace", new Class[0]);
            Object[] causeElements = (Object[])getStackTrace.invoke((Object)cause, null);
            Class<?> stackTraceElementClass = Class.forName("java.lang.StackTraceElement");
            Class<?> causeClass = Class.forName("com.sap.exception.remote.Cause");
            Object in = Array.newInstance(stackTraceElementClass, causeElements.length);
            Method setStackTrace = causeClass.getMethod("setStackTrace", in.getClass());
            Object[] param = new Object[]{causeElements};
            setStackTrace.invoke((Object)this, param);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void saveStackTrace(Throwable rootCause) {
        StringWriter s = new StringWriter();
        rootCause.printStackTrace(new PrintWriter(s));
        this.causeStackTrace = s.toString();
    }

    public void printStackTrace(PrintWriter s) {
        s.print(this.causeStackTrace);
    }

    public String getMessage() {
        return this.realCauseMessage;
    }

    public String getRealExceptionName() {
        return this.realCauseName;
    }

    public String toString() {
        return super.toString() + " [" + this.realCauseName + "]";
    }

    private boolean isJDK_1_4() {
        try {
            Class<?> c = Class.forName("java.lang.Throwable");
            c.getMethod("getStackTrace", new Class[0]);
            c.getMethod("getCause", new Class[0]);
            Class.forName("java.lang.StackTraceElement");
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

