/*
 * Decompiled with CFR 0.152.
 */
package com.sap.exception;

import com.sap.exception.IBaseException;
import com.sap.localization.LocalizableText;
import com.sap.localization.LocalizableTextFormatter;
import com.sap.localization.LocalizationException;
import com.sap.localization.ResourceAccessor;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;

public class BaseExceptionInfo
implements Serializable {
    private static final Location classLocation = Location.getLocation((Class)(class$com$sap$exception$BaseExceptionInfo == null ? (class$com$sap$exception$BaseExceptionInfo = BaseExceptionInfo.class$("com.sap.exception.BaseExceptionInfo")) : class$com$sap$exception$BaseExceptionInfo));
    private static final long serialVersionUID = 38151717837638447L;
    private Throwable action;
    private Throwable cause;
    private LocalizableText localizableMessage;
    private String actionStackTrace;
    private String causeStackTrace;
    private transient boolean IsStackTraceUpToDate;
    private transient Category category = null;
    private transient Category originalCategory = null;
    private transient int severity = 701;
    private transient int originalSeverity = 701;
    private transient Location location = null;
    private transient Location originalLocation = null;
    static /* synthetic */ Class class$com$sap$exception$BaseExceptionInfo;

    public BaseExceptionInfo(Throwable action) {
        this.init(null, action, null);
    }

    public BaseExceptionInfo(Location loc, Throwable action) {
        this.init(null, action, null);
        this.location = loc;
        this.traceAutomatically();
    }

    public BaseExceptionInfo(Throwable action, Throwable cause) {
        this.init(null, action, cause);
    }

    public BaseExceptionInfo(Location loc, Throwable action, Throwable cause) {
        this.init(null, action, cause);
        this.location = loc;
        this.traceAutomatically();
    }

    public BaseExceptionInfo(LocalizableText locMessage, Throwable action) {
        this.init(locMessage, action, null);
    }

    public BaseExceptionInfo(Location loc, LocalizableText locMessage, Throwable action) {
        this.init(locMessage, action, null);
        this.location = loc;
        this.traceAutomatically();
    }

    public BaseExceptionInfo(LocalizableText locMessage, Throwable action, Throwable cause) {
        this.init(locMessage, action, cause);
    }

    public BaseExceptionInfo(Location loc, LocalizableText locMessage, Throwable action, Throwable cause) {
        this.init(locMessage, action, cause);
        this.location = loc;
        this.traceAutomatically();
    }

    public BaseExceptionInfo(Category cat, int severity, Location loc, LocalizableText locMessage, Throwable action, Throwable cause) {
        this.init(locMessage, action, cause);
        this.saveLogSettings(cat, severity, loc);
        this.traceAutomatically();
    }

    public BaseExceptionInfo(ResourceAccessor accessor, String patternKey, Throwable action) {
        this(accessor, patternKey, null, action, null);
    }

    public BaseExceptionInfo(Location loc, ResourceAccessor accessor, String patternKey, Throwable action) {
        this(accessor, patternKey, null, action, null);
        this.location = loc;
        this.traceAutomatically();
    }

    public BaseExceptionInfo(ResourceAccessor accessor, String patternKey, Throwable action, Throwable rootCause) {
        this(accessor, patternKey, null, action, rootCause);
    }

    public BaseExceptionInfo(Location loc, ResourceAccessor accessor, String patternKey, Throwable action, Throwable rootCause) {
        this(accessor, patternKey, null, action, rootCause);
        this.location = loc;
        this.traceAutomatically();
    }

    public BaseExceptionInfo(ResourceAccessor accessor, String patternKey, Object[] parameters, Throwable action) {
        this(accessor, patternKey, parameters, action, null);
    }

    public BaseExceptionInfo(Location loc, ResourceAccessor accessor, String patternKey, Object[] parameters, Throwable action) {
        this(accessor, patternKey, parameters, action, null);
        this.location = loc;
        this.traceAutomatically();
    }

    public BaseExceptionInfo(ResourceAccessor accessor, String patternKey, Object[] parameters, Throwable action, Throwable rootCause) {
        this.init(new LocalizableTextFormatter(accessor, patternKey, parameters), action, rootCause);
    }

    public BaseExceptionInfo(Location loc, ResourceAccessor accessor, String patternKey, Object[] parameters, Throwable action, Throwable rootCause) {
        this.init(new LocalizableTextFormatter(accessor, patternKey, parameters), action, rootCause);
        this.location = loc;
        this.traceAutomatically();
    }

    public BaseExceptionInfo(Category cat, int severity, Location loc, ResourceAccessor accessor, String patternKey, Object[] parameters, Throwable action, Throwable rootCause) {
        this.init(new LocalizableTextFormatter(accessor, patternKey, parameters), action, rootCause);
        this.saveLogSettings(cat, severity, loc);
        this.traceAutomatically();
    }

    public BaseExceptionInfo(ResourceAccessor accessor, LocalizableText.Msg msg, Throwable action, Throwable cause) {
        this.init(new LocalizableTextFormatter(accessor, msg), action, cause);
    }

    public BaseExceptionInfo(Location loc, ResourceAccessor accessor, LocalizableText.Msg msg, Throwable action, Throwable cause) {
        this.init(new LocalizableTextFormatter(accessor, msg), action, cause);
        this.location = loc;
        this.traceAutomatically();
    }

    public Throwable initCause(Throwable cause) {
        if (this.cause != this.action) {
            throw new IllegalStateException("Can't overwrite cause");
        }
        if (cause == this.action) {
            throw new IllegalArgumentException("Self-causation not permitted");
        }
        if (cause != null) {
            this.cause = cause;
        }
        return this.action;
    }

    private void init(LocalizableText locMessage, Throwable action, Throwable rootCause) {
        if (action == null) {
            throw new IllegalArgumentException("Null-action not permitted");
        }
        if (rootCause == action) {
            throw new IllegalArgumentException("Self-causation not permitted");
        }
        this.action = action;
        this.cause = rootCause == null ? action : rootCause;
        this.localizableMessage = locMessage;
    }

    public void printStackTrace() {
        PrintStream printStream = System.err;
        synchronized (printStream) {
            System.err.println(this.getNestedStackTraceString());
        }
    }

    public void printStackTrace(PrintStream s) {
        PrintStream printStream = s;
        synchronized (printStream) {
            s.println(this.getNestedStackTraceString());
        }
    }

    public void printStackTrace(PrintWriter s) {
        PrintWriter printWriter = s;
        synchronized (printWriter) {
            s.println(this.getNestedStackTraceString());
        }
    }

    public String getStackTraceString() {
        if (!this.IsStackTraceUpToDate) {
            this.updateStackTraceString();
        }
        return this.actionStackTrace;
    }

    public String getNestedStackTraceString() {
        if (!this.IsStackTraceUpToDate) {
            this.updateStackTraceString();
        }
        StringBuffer traceBuffer = new StringBuffer();
        traceBuffer.append(this.actionStackTrace);
        if (!this.isJDKHigherThan1_3()) {
            if (this.getCause() != null && this.getCause() instanceof IBaseException) {
                traceBuffer.append("-------- caused by --------\n");
                traceBuffer.append(((IBaseException)((Object)this.getCause())).getNestedStackTraceString());
            } else if (this.getCause() != null) {
                traceBuffer.append("-------- caused by --------\n");
                traceBuffer.append(this.causeStackTrace);
            }
        }
        return traceBuffer.toString();
    }

    private void updateStackTraceString() {
        StringBuffer buffer;
        String tmpActionTrace = ((IBaseException)((Object)this.action)).getSystemStackTraceString();
        if (this.getCause() != null && !(this.getCause() instanceof IBaseException)) {
            if (this.causeStackTrace != null) {
                buffer = new StringBuffer();
                buffer.append(this.causeStackTrace).append("-------- predecessor system --------\n");
                buffer.append(this.getCause().toString()).append(tmpActionTrace.substring(tmpActionTrace.indexOf("\n", 0)));
                this.causeStackTrace = buffer.toString();
            } else {
                StringWriter s = new StringWriter();
                this.getCause().printStackTrace(new PrintWriter(s));
                this.causeStackTrace = s.toString();
            }
        }
        if (this.actionStackTrace == null) {
            this.actionStackTrace = tmpActionTrace;
        } else {
            buffer = new StringBuffer();
            buffer.append(this.actionStackTrace).append("-------- predecessor system --------\n").append(tmpActionTrace);
            this.actionStackTrace = buffer.toString();
        }
        this.IsStackTraceUpToDate = true;
    }

    public Throwable getCause() {
        return this.cause == this.action ? null : this.cause;
    }

    public LocalizableText getLocalizableMessage() {
        return this.localizableMessage;
    }

    public void finallyLocalize() {
        this.finallyLocalize(IBaseException.defaultLocale, TimeZone.getDefault());
    }

    public void finallyLocalize(Locale loc) {
        this.finallyLocalize(loc, TimeZone.getDefault());
    }

    public void finallyLocalize(TimeZone timeZone) {
        this.finallyLocalize(IBaseException.defaultLocale, timeZone);
    }

    public void finallyLocalize(Locale loc, TimeZone timeZone) {
        if (this.localizableMessage == null) {
            return;
        }
        try {
            if (loc == null) {
                this.localizableMessage.setLocale(IBaseException.defaultLocale);
            } else {
                this.localizableMessage.setLocale(loc);
            }
            if (timeZone == null) {
                this.localizableMessage.setTimeZone(TimeZone.getDefault());
            } else {
                this.localizableMessage.setTimeZone(timeZone);
            }
            this.localizableMessage.finallyLocalize();
            if (this.getCause() != null && this.getCause() instanceof IBaseException) {
                ((IBaseException)((Object)this.getCause())).finallyLocalize(loc, timeZone);
            }
        }
        catch (LocalizationException e) {
            classLocation.logT(500, " Localization failed because of a LocalizationException.");
        }
    }

    public String getLocalizedMessage() {
        return this.getLocalizedMessage(IBaseException.defaultLocale, TimeZone.getDefault());
    }

    public String getLocalizedMessage(Locale loc) {
        return this.getLocalizedMessage(loc, TimeZone.getDefault());
    }

    public String getLocalizedMessage(TimeZone timeZone) {
        return this.getLocalizedMessage(IBaseException.defaultLocale, timeZone);
    }

    public String getLocalizedMessage(Locale loc, TimeZone timeZone) {
        if (this.localizableMessage != null) {
            if (timeZone == null) {
                this.localizableMessage.setTimeZone(TimeZone.getDefault());
            } else {
                this.localizableMessage.setTimeZone(timeZone);
            }
            if (loc == null) {
                this.localizableMessage.setLocale(IBaseException.defaultLocale);
            } else {
                this.localizableMessage.setLocale(loc);
            }
            String tmpStr = null;
            try {
                tmpStr = this.localizableMessage.format();
                return tmpStr;
            }
            catch (LocalizationException e) {
                classLocation.logT(500, " Localization failed because of a LocalizationException.");
            }
        }
        if (this.getCause() != null && this.getCause() instanceof IBaseException) {
            return ((IBaseException)((Object)this.getCause())).getLocalizedMessage(loc, timeZone);
        }
        if (this.getCause() != null) {
            return this.getCause().getLocalizedMessage();
        }
        return null;
    }

    public String getNestedLocalizedMessage() {
        return this.getNestedLocalizedMessage(IBaseException.defaultLocale, TimeZone.getDefault());
    }

    public String getNestedLocalizedMessage(Locale loc) {
        return this.getNestedLocalizedMessage(loc, TimeZone.getDefault());
    }

    public String getNestedLocalizedMessage(TimeZone timeZone) {
        return this.getNestedLocalizedMessage(IBaseException.defaultLocale, timeZone);
    }

    public String getNestedLocalizedMessage(Locale loc, TimeZone timeZone) {
        String actionMessage = null;
        if (this.getLocalizableMessage() != null) {
            actionMessage = ((IBaseException)((Object)this.action)).getLocalizedMessage(loc, timeZone);
        }
        if (this.getCause() == null) {
            return actionMessage;
        }
        String causeMessage = null;
        causeMessage = this.getCause() instanceof IBaseException ? ((IBaseException)((Object)this.getCause())).getNestedLocalizedMessage(loc, timeZone) : this.getCause().getLocalizedMessage();
        if (causeMessage == null) {
            return actionMessage;
        }
        if (actionMessage != null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(actionMessage).append(": ").append(causeMessage);
            return buffer.toString();
        }
        return causeMessage;
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        if (!this.IsStackTraceUpToDate) {
            this.updateStackTraceString();
        } else {
            this.IsStackTraceUpToDate = true;
        }
        s.defaultWriteObject();
    }

    public Category getLogCategory() {
        return this.category;
    }

    public int getLogSeverity() {
        return this.severity;
    }

    public Location getLogLocation() {
        return this.location;
    }

    public void setLogSettings(Category cat, int severity, Location loc) {
        this.category = cat;
        this.severity = severity;
        this.location = loc;
    }

    public void log() {
        if (this.category != null) {
            String message = ((IBaseException)((Object)this.action)).getLocalizedMessage(IBaseException.defaultLocale);
            if (message == null) {
                message = this.action.toString();
            }
            if (message != null) {
                LocalizableText locText = ((IBaseException)((Object)this.action)).getLocalizableMessage();
                if (locText instanceof LocalizableTextFormatter) {
                    LocalizableTextFormatter formatter = (LocalizableTextFormatter)locText;
                    String oldBundleName = this.category.getResourceBundleName();
                    this.category.setResourceBundleName(formatter.getResourceBundleName());
                    this.category.log(this.severity, this.location, (Object)formatter.getPatternKey(), formatter.getArguments(), message);
                    this.category.setResourceBundleName(oldBundleName);
                } else {
                    this.category.log(this.severity, this.location, (Object)null, message);
                }
            }
        }
        if (this.location != null) {
            IBaseException cfr_ignored_0 = (IBaseException)((Object)this.action);
            this.location.logT(this.severity, IBaseException.audit, "Exception {0}", new Object[]{this.getNestedStackTraceString()});
        }
    }

    public void trace(int severity, Location loc) {
        if (loc != null) {
            IBaseException cfr_ignored_0 = (IBaseException)((Object)this.action);
            loc.logT(severity, IBaseException.audit, "Exception {0}", new Object[]{this.getNestedStackTraceString()});
        }
    }

    public void trace(int severity, Location loc, String subloc) {
        if (loc != null) {
            IBaseException cfr_ignored_0 = (IBaseException)((Object)this.action);
            loc.logT(severity, IBaseException.audit, subloc, "Exception {0}", new Object[]{this.getNestedStackTraceString()});
        }
    }

    public void restoreLogSettings() {
        this.category = this.originalCategory;
        this.location = this.originalLocation;
        this.severity = this.originalSeverity;
    }

    private void saveLogSettings(Category cat, int severity, Location loc) {
        this.category = cat;
        this.severity = severity;
        this.location = loc;
        this.originalCategory = this.category;
        this.originalSeverity = this.severity;
        this.originalLocation = this.location;
    }

    private void traceAutomatically() {
        try {
            if (this.location != null && this.location.bePath()) {
                Exception e = new Exception();
                Vector stack = this.getStackTraceElements(e);
                StringBuffer buff = new StringBuffer();
                if (stack.size() > 0) {
                    buff.append(": ");
                    buff.append(this.getLocalizedMessage());
                    buff.append("\n");
                    while (stack.size() > 0) {
                        buff.append(stack.remove(0).toString());
                        buff.append("\n");
                    }
                }
                String actionStackTraceTmp = buff.toString();
                String causeStackTraceTmp = "";
                StringWriter s = new StringWriter();
                if (this.getCause() != null) {
                    this.getCause().printStackTrace(new PrintWriter(s));
                    causeStackTraceTmp = !this.isJDKHigherThan1_3() ? "-------- caused by --------\n" + s.toString() : "Caused by: " + s.toString();
                    String endsWith = causeStackTraceTmp.substring(causeStackTraceTmp.length() - 4);
                    char c13 = '\r';
                    char c10 = '\n';
                    String more = "" + c13 + c10 + c13 + c10;
                    if (more.equals(endsWith)) {
                        causeStackTraceTmp = causeStackTraceTmp.substring(0, causeStackTraceTmp.length() - 2);
                    }
                }
                String wholeStackTrace = actionStackTraceTmp + causeStackTraceTmp;
                this.location.logT(200, "Exception {0}", new Object[]{wholeStackTrace});
            }
        }
        catch (Exception e) {
            StringWriter s = new StringWriter();
            e.printStackTrace(new PrintWriter(s));
            System.out.println("traceAutomatically() fails because of an Exception: " + s);
        }
    }

    private String getClassName(String stackTraceLine) {
        String exPackageClassMethod = stackTraceLine.substring(4, stackTraceLine.indexOf("(") != -1 ? stackTraceLine.indexOf("(") : stackTraceLine.length());
        return exPackageClassMethod.substring(0, exPackageClassMethod.lastIndexOf("."));
    }

    private Vector getStackTraceElements(Exception e) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        e.printStackTrace(printWriter);
        String st = stringWriter.toString();
        StringReader stringReader = new StringReader(st);
        BufferedReader bufferedReader = new BufferedReader(stringReader);
        Vector<String> stackTraceElements = new Vector<String>(20);
        try {
            String line = bufferedReader.readLine();
            while (line != null) {
                stackTraceElements.add(line);
                line = bufferedReader.readLine();
            }
        }
        catch (Exception ioe) {
            classLocation.logT(500, " IOException while trying to get stack trace elements: " + ioe.getMessage());
        }
        return stackTraceElements;
    }

    private boolean isJDKHigherThan1_3() {
        int versionNum = 0;
        try {
            versionNum = Integer.parseInt(System.getProperty("java.version").substring(2, 3));
            if (versionNum < 4) {
                return false;
            }
        }
        catch (NumberFormatException nfex) {
            classLocation.logT(500, " NumberFormatException while trying to check if JDK Version is higher than 1.3.");
            return false;
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

