/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.db.tasks;

import com.sap.exception.BaseException;
import com.sap.exception.BaseRuntimeException;
import com.sap.ip.mmr.IConnection;
import com.sap.ip.mmr.IRepositoryServer;
import com.sap.ip.mmr.db.RepositoryDB;
import com.sap.ip.mmr.tasks.TaskDefault;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class TaskUndeployFromDB
extends TaskDefault {
    private IRepositoryServer repositoryServer;
    private IConnection connection;
    private Map properties;

    public boolean runTask(IRepositoryServer repositoryServerIn, IConnection connectionIn, Collection modelElements, Collection objects, Collection modelElementsDeleted, Collection objectsDeleted, Map propertiesIn) {
        String method = "runTask(...)";
        this.repositoryServer = repositoryServerIn;
        this.connection = connectionIn;
        this.properties = propertiesIn;
        boolean result = true;
        RepositoryDB pc = null;
        Set set = this.repositoryServer.getPersistenceComponent("com.sap.ip.mmr.db.RepositoryDB");
        if (set != null && set.size() > 0) {
            pc = (RepositoryDB)set.iterator().next();
        }
        if (pc != null) {
            try {
                pc.transactionBegin(this.connection);
                String deployUnitName = (String)this.properties.get("dstpath");
                result = pc.undeploy(this.connection, deployUnitName);
                if (result) {
                    pc.transactionCommit(this.connection);
                } else {
                    pc.transactionRollback(this.connection);
                }
            }
            catch (BaseRuntimeException e) {
                RepositoryDB.writeExceptionToLog("runTask(...)", (Exception)((Object)e));
                return false;
            }
            catch (BaseException e) {
                RepositoryDB.writeExceptionToLog("runTask(...)", (Exception)((Object)e));
                return false;
            }
        }
        return result;
    }
}

