/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.db.tasks;

import com.sap.ip.mmr.IConnection;
import com.sap.ip.mmr.IRepositoryServer;
import com.sap.ip.mmr.RepositoryServer;
import com.sap.ip.mmr.db.RepositoryDB;
import com.sap.ip.mmr.foundation.AssociationsOfObject;
import com.sap.ip.mmr.foundation.Bytes;
import com.sap.ip.mmr.foundation.Utilities;
import com.sap.ip.mmr.persistence.PersistenceJar;
import com.sap.ip.mmr.search.AttributesValues;
import com.sap.ip.mmr.tasks.TaskDefault;
import com.sap.tc.logging.Location;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class TaskDeployToDB
extends TaskDefault {
    private IRepositoryServer repositoryServer;
    private IConnection connection;
    private Map properties;
    private Collection mofIdsToDeleteM1 = new ArrayList();
    private Collection mofIdsToDeleteM2 = new ArrayList();
    private Map dataM1InstanceXMI = new HashMap();
    private Map dataM1AssociationXMI = new HashMap();
    private Map dataM2InstanceXMI = new HashMap();
    private Map dataM2AssociationXMI = new HashMap();
    private List classDataM2 = new ArrayList();
    private Properties indexM1TypeInformation = new Properties();
    private Properties indexM2TypeInformation = new Properties();
    private Properties indexM2QualifiedName = new Properties();
    private AttributesValues avM1 = new AttributesValues();
    private AttributesValues avM2 = new AttributesValues();
    private static final Location location = Utilities.getUtilities().getLocation(class$com$sap$ip$mmr$db$tasks$TaskDeployToDB == null ? (class$com$sap$ip$mmr$db$tasks$TaskDeployToDB = TaskDeployToDB.class$("com.sap.ip.mmr.db.tasks.TaskDeployToDB")) : class$com$sap$ip$mmr$db$tasks$TaskDeployToDB);
    static /* synthetic */ Class class$com$sap$ip$mmr$db$tasks$TaskDeployToDB;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean runTask(IRepositoryServer repositoryServerIn, IConnection connectionIn, Collection modelElements, Collection objects, Collection modelElementsDeleted, Collection objectsDeleted, Map propertiesIn) {
        boolean result;
        block13: {
            this.repositoryServer = repositoryServerIn;
            this.connection = connectionIn;
            this.properties = propertiesIn;
            result = true;
            RepositoryDB pc = null;
            Set set = this.repositoryServer.getPersistenceComponent("com.sap.ip.mmr.db.RepositoryDB");
            if (set != null && set.size() > 0) {
                pc = (RepositoryDB)set.iterator().next();
            }
            if (pc != null) {
                pc.transactionBegin(this.connection);
                this.checkJars();
                this.extractData();
                String deployUnitName = (String)this.properties.get("dstpath");
                pc.deploy(this.connection, this, deployUnitName);
                pc.transactionCommit(this.connection);
                Object var14_13 = null;
                try {
                    pc.transactionCommit(this.connection);
                }
                catch (Exception e1) {
                    RepositoryServer.getCategory().errorT(location, e1.toString());
                }
                break block13;
                {
                    catch (Exception e) {
                        try {
                            pc.transactionRollback(this.connection);
                        }
                        catch (Exception e1) {
                            RepositoryServer.getCategory().errorT(location, e1.toString());
                        }
                        RepositoryServer.getCategory().errorT(location, e.toString());
                        boolean bl = false;
                        Object var14_14 = null;
                        try {
                            pc.transactionCommit(this.connection);
                        }
                        catch (Exception e1) {
                            RepositoryServer.getCategory().errorT(location, e1.toString());
                        }
                        return bl;
                    }
                }
                catch (Throwable throwable) {
                    Object var14_15 = null;
                    try {
                        pc.transactionCommit(this.connection);
                    }
                    catch (Exception e1) {
                        RepositoryServer.getCategory().errorT(location, e1.toString());
                    }
                    throw throwable;
                }
            }
        }
        return result;
    }

    public Properties getIndexM2TypeInformation() {
        return this.indexM2TypeInformation;
    }

    public Map getDataM2InstanceXMI() {
        return this.dataM2InstanceXMI;
    }

    public Map getIndexM2QualifiedName() {
        return this.indexM2QualifiedName;
    }

    public Map getDataM2AssociationXMI() {
        return this.dataM2AssociationXMI;
    }

    public AttributesValues getAvM2() {
        return this.avM2;
    }

    public List getClassDataM2() {
        return this.classDataM2;
    }

    public Properties getIndexM1TypeInformation() {
        return this.indexM1TypeInformation;
    }

    public Map getDataM1InstanceXMI() {
        return this.dataM1InstanceXMI;
    }

    public Map getDataM1AssociationXMI() {
        return this.dataM1AssociationXMI;
    }

    public AttributesValues getAvM1() {
        return this.avM1;
    }

    public Collection getMofIdsToDeleteM1() {
        return this.mofIdsToDeleteM1;
    }

    public Collection getMofIdsToDeleteM2() {
        return this.mofIdsToDeleteM2;
    }

    private void checkJars() {
        String srcPath = (String)this.properties.get("srcpath");
        List srcPaths = Utilities.getUtilities().splitClassPath(srcPath);
        location.infoT("checkJars()", "srcPath=" + srcPath);
        location.infoT("checkJars()", "srcPaths=" + srcPaths);
        if (srcPaths.size() <= 0) {
            return;
        }
        Iterator iterPaths = srcPaths.iterator();
        while (iterPaths.hasNext()) {
            String path = (String)iterPaths.next();
            PersistenceJar pj = new PersistenceJar(this.repositoryServer, path);
            pj.checkPersistence(this.connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void extractData() {
        String method = "extractData()";
        String srcPath = (String)this.properties.get("srcpath");
        List srcPaths = Utilities.getUtilities().splitClassPath(srcPath);
        if (srcPaths.size() <= 0) {
            return;
        }
        Iterator iterPaths = srcPaths.iterator();
        while (iterPaths.hasNext()) {
            String path = (String)iterPaths.next();
            File f = new File(path);
            if (!f.exists() || f.isDirectory()) {
                location.infoT("extractData()", "JAR doesn't exist! " + path);
                continue;
            }
            location.infoT("extractData()", "Extract data of JAR: " + path);
            JarFile jar = null;
            jar = new JarFile(f, true);
            Enumeration<JarEntry> enumeration = jar.entries();
            while (enumeration.hasMoreElements()) {
                String mofId;
                JarEntry je = enumeration.nextElement();
                if (je.isDirectory()) continue;
                String dirName = this.getDirectoryOfJarEntry(je.getName());
                if (dirName == null) {
                    dirName = "";
                }
                if (je.getName().indexOf("IndexQualifiedName.properties") > 0) {
                    if (dirName.compareTo("MMR_M2") != 0 || this.indexM2QualifiedName == null) continue;
                    Properties prop = new Properties();
                    prop.load(new BufferedInputStream(jar.getInputStream(je)));
                    this.indexM2QualifiedName.putAll((Map<?, ?>)prop);
                    continue;
                }
                if (je.getName().indexOf("IndexSearch.xml") > 0) {
                    if (dirName.compareTo("MMR_M1") == 0) {
                        if (this.avM1 == null) continue;
                        this.avM1.xmlImport(this.getBytesOfInputStream(jar.getInputStream(je)).getData());
                        continue;
                    }
                    if (dirName.compareTo("MMR_M2") != 0 || this.avM2 == null) continue;
                    this.avM2.xmlImport(this.getBytesOfInputStream(jar.getInputStream(je)).getData());
                    continue;
                }
                if (je.getName().indexOf("IndexTypeInformation.properties") > 0) {
                    if (dirName.compareTo("MMR_M1") == 0) {
                        if (this.indexM1TypeInformation == null) continue;
                        this.indexM1TypeInformation.load(new BufferedInputStream(jar.getInputStream(je)));
                        continue;
                    }
                    if (dirName.compareTo("MMR_M2") != 0 || this.indexM2TypeInformation == null) continue;
                    this.indexM2TypeInformation.load(new BufferedInputStream(jar.getInputStream(je)));
                    continue;
                }
                if (je.getName().indexOf(".class") > 0) {
                    if (this.classDataM2 == null) continue;
                    String name = je.getName().replace('\\', '/');
                    String type = null;
                    int index = name.indexOf(".class");
                    if (index < 0) continue;
                    type = name.substring(0, index).replace('/', '.');
                    Bytes b = this.getBytesOfInputStream(jar.getInputStream(je));
                    b.setName(type.toLowerCase());
                    this.classDataM2.add(b);
                    continue;
                }
                if (je.getName().indexOf(".xml") <= 0) continue;
                if (je.getName().indexOf("_I") > 0) {
                    mofId = this.getMofIdOfJarEntry(je.getName(), "_I");
                    if (mofId == null) continue;
                    if (dirName.compareTo("MMR_M1") == 0) {
                        if (this.dataM1InstanceXMI == null) continue;
                        this.dataM1InstanceXMI.put(mofId, this.getBytesOfInputStream(jar.getInputStream(je)));
                        continue;
                    }
                    if (dirName.compareTo("MMR_M2") != 0 || this.dataM2InstanceXMI == null) continue;
                    this.dataM2InstanceXMI.put(mofId, this.getBytesOfInputStream(jar.getInputStream(je)));
                    continue;
                }
                if (je.getName().indexOf("_A") > 0) {
                    AssociationsOfObject aoo;
                    mofId = this.getMofIdOfJarEntry(je.getName(), "_A");
                    if (mofId == null) continue;
                    if (dirName.compareTo("MMR_M1") == 0) {
                        if (this.dataM1AssociationXMI == null || (aoo = AssociationsOfObject.decodeAssocXML((IConnection)this.connection, (byte[])this.getBytesOfInputStream(jar.getInputStream(je)).getData())) == null) continue;
                        this.dataM1AssociationXMI.put(mofId, aoo);
                        continue;
                    }
                    if (dirName.compareTo("MMR_M2") != 0 || this.dataM2AssociationXMI == null || (aoo = AssociationsOfObject.decodeAssocXML((IConnection)this.connection, (byte[])this.getBytesOfInputStream(jar.getInputStream(je)).getData())) == null) continue;
                    this.dataM2AssociationXMI.put(mofId, aoo);
                    continue;
                }
                if (je.getName().indexOf("_D") <= 0 || (mofId = this.getMofIdOfJarEntry(je.getName(), "_D")) == null) continue;
                if (dirName.compareTo("MMR_M1") == 0) {
                    if (this.mofIdsToDeleteM1 == null) continue;
                    this.mofIdsToDeleteM1.add(mofId);
                    continue;
                }
                if (dirName.compareTo("MMR_M2") != 0 || this.mofIdsToDeleteM2 == null) continue;
                this.mofIdsToDeleteM2.add(mofId);
            }
            location.infoT("extractData()", "Extraction of data done. JAR: " + path);
            Object var16_16 = null;
            try {
                jar.close();
            }
            catch (IOException e1) {
                RepositoryServer.getCategory().errorT(location, "extractData()", e1.toString());
            }
            continue;
            {
                catch (IOException e) {
                    RepositoryServer.category.errorT(location, e.toString());
                    var16_16 = null;
                    try {
                        jar.close();
                    }
                    catch (IOException e1) {
                        RepositoryServer.getCategory().errorT(location, "extractData()", e1.toString());
                    }
                    continue;
                }
            }
            catch (Throwable throwable) {
                var16_16 = null;
                try {
                    jar.close();
                }
                catch (IOException e1) {
                    RepositoryServer.getCategory().errorT(location, "extractData()", e1.toString());
                }
                throw throwable;
            }
        }
    }

    private String getDirectoryOfJarEntry(String name) {
        String dir = null;
        if (name != null) {
            int idx1 = name.indexOf("MMR_M2");
            if (idx1 == 0) {
                dir = "MMR_M2";
            } else {
                idx1 = name.indexOf("MMR_M1");
                if (idx1 == 0) {
                    dir = "MMR_M1";
                }
            }
        }
        return dir;
    }

    private String getMofIdOfJarEntry(String name, String suffix) {
        String mofId = null;
        if (name != null) {
            int idx1 = name.lastIndexOf(47);
            mofId = idx1 >= 0 ? name.substring(idx1 + 1) : name;
            int idx2 = mofId.indexOf(suffix);
            mofId = idx2 < 0 ? null : mofId.substring(0, idx2);
        }
        return mofId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected Bytes getBytesOfInputStream(InputStream is) {
        Bytes bytes;
        block9: {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            bytes = null;
            int size = 1024;
            byte[] data = new byte[1024];
            int n = 0;
            while (n >= 0) {
                n = is.read(data, 0, 1024);
                if (n <= 0) continue;
                baos.write(data, 0, n);
            }
            bytes = new Bytes(baos.toByteArray());
            Object var8_8 = null;
            try {
                is.close();
                baos.close();
            }
            catch (IOException e2) {
                RepositoryServer.category.errorT(location, e2.toString());
            }
            break block9;
            {
                catch (IOException e) {
                    RepositoryServer.category.errorT(location, e.toString());
                    Object var8_9 = null;
                    try {
                        is.close();
                        baos.close();
                    }
                    catch (IOException e2) {
                        RepositoryServer.category.errorT(location, e2.toString());
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                try {
                    is.close();
                    baos.close();
                }
                catch (IOException e2) {
                    RepositoryServer.category.errorT(location, e2.toString());
                }
                throw throwable;
            }
        }
        return bytes;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

