/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.db.cache;

import com.sap.ip.mmr.RepositoryServer;
import com.sap.ip.mmr.db.RepositoryDB;
import com.sap.ip.mmr.foundation.MMRResourceAccessor;
import com.sap.ip.mmr.foundation.Utilities;
import com.sap.tc.logging.Location;
import java.util.HashMap;
import java.util.Iterator;

public class CacheSIDs {
    protected RepositoryDB repositoryDB;
    private String numberRangeID;
    private HashMap valueToSID;
    private HashMap SIDToValue;
    private boolean readAllDone = false;
    private static final Location location = Utilities.getUtilities().getLocation(class$com$sap$ip$mmr$db$cache$CacheSIDs == null ? (class$com$sap$ip$mmr$db$cache$CacheSIDs = CacheSIDs.class$("com.sap.ip.mmr.db.cache.CacheSIDs")) : class$com$sap$ip$mmr$db$cache$CacheSIDs);
    static /* synthetic */ Class class$com$sap$ip$mmr$db$cache$CacheSIDs;

    public CacheSIDs(String numberRangeID, RepositoryDB repositoryDB) {
        this.numberRangeID = numberRangeID;
        this.repositoryDB = repositoryDB;
        this.initialize();
    }

    private void initialize() {
        this.valueToSID = new HashMap(100);
        this.SIDToValue = new HashMap(100);
    }

    public int getSIDForValue(String value) {
        int sid = 0;
        if (value == null) {
            return 0;
        }
        if (!this.valueToSID.containsKey(value)) {
            sid = this.repositoryDB.getNumberRange().readSID(this.numberRangeID, value);
            if (sid < 0) {
                sid = this.addValue(value);
            }
            this.addPair(value, sid);
        } else {
            String sids = (String)this.valueToSID.get(value);
            sid = Integer.parseInt(sids);
        }
        return sid;
    }

    public String getValueBySID(int sid) {
        String method = "String getValueBySID(int sid)";
        String value = null;
        String sids = String.valueOf(sid);
        if (!this.SIDToValue.containsKey(sids)) {
            value = this.repositoryDB.getNumberRange().readValue(this.numberRangeID, sid);
            if (value == null) {
                RepositoryServer.getCategory().errorT(location, "String getValueBySID(int sid)", MMRResourceAccessor.getInstance().getMessageText("3100"), new Object[]{this.numberRangeID, new Integer(sid)});
            } else {
                this.addPair(value, sid);
            }
        } else {
            value = (String)this.SIDToValue.get(sids);
        }
        return value;
    }

    public void readAll() {
        if (!this.readAllDone) {
            HashMap mappings = this.repositoryDB.getNumberRange().readAll(this.numberRangeID);
            this.valueToSID = new HashMap(mappings.size());
            this.SIDToValue = new HashMap(mappings.size());
            Iterator iter = mappings.keySet().iterator();
            while (iter.hasNext()) {
                String value = (String)iter.next();
                String sid = (String)mappings.get(value);
                this.valueToSID.put(value, sid);
                this.SIDToValue.put(sid, value);
            }
            this.readAllDone = true;
        }
    }

    private int addValue(String value) {
        String method = "addValue(String value)";
        int sid = this.repositoryDB.getNumberRange().getNextNumber(this.numberRangeID);
        if (sid < 0) {
            RepositoryServer.getCategory().errorT(location, "addValue(String value)", MMRResourceAccessor.getInstance().getMessageText("3101"), new Object[]{this.numberRangeID});
        } else {
            this.repositoryDB.getNumberRange().addMapping(this.numberRangeID, value, sid);
            this.addPair(value, sid);
        }
        return sid;
    }

    private void addPair(String value, int sid) {
        this.valueToSID.put(value, String.valueOf(sid));
        this.SIDToValue.put(String.valueOf(sid), value);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

