/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.db;

import com.sap.exception.BaseException;
import com.sap.exception.BaseRuntimeException;
import com.sap.ip.mmr.IConnection;
import com.sap.ip.mmr.IPersistence;
import com.sap.ip.mmr.IRepository;
import com.sap.ip.mmr.IRepositoryClassLoader;
import com.sap.ip.mmr.IRepositoryDB;
import com.sap.ip.mmr.IRepositoryServer;
import com.sap.ip.mmr.Repository;
import com.sap.ip.mmr.RepositoryServer;
import com.sap.ip.mmr.ResourceException;
import com.sap.ip.mmr.StateEnum;
import com.sap.ip.mmr.db.DataSource;
import com.sap.ip.mmr.db.NumberRange;
import com.sap.ip.mmr.db.cache.Cache;
import com.sap.ip.mmr.db.search.AttributesValues;
import com.sap.ip.mmr.db.tasks.TaskDeployToDB;
import com.sap.ip.mmr.dbmodel.Index;
import com.sap.ip.mmr.dbmodel.Table;
import com.sap.ip.mmr.foundation.AssociationsOfObject;
import com.sap.ip.mmr.foundation.Bytes;
import com.sap.ip.mmr.foundation.Hierarchy;
import com.sap.ip.mmr.foundation.ListInstanceInfo;
import com.sap.ip.mmr.foundation.MMRResourceAccessor;
import com.sap.ip.mmr.foundation.ObjectInputStreamWithClassLoader;
import com.sap.ip.mmr.foundation.Utilities;
import com.sap.ip.mmr.m1layer.IMMRObject;
import com.sap.ip.mmr.m2layer.IModelElement;
import com.sap.ip.mmr.m2layer.model.ModelElementImpl;
import com.sap.ip.mmr.persistence.Workspace;
import com.sap.ip.mmr.search.QueryFilters;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Log;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.jmi.model.ModelElement;
import javax.jmi.model.MofClass;
import javax.jmi.model.MofPackage;
import javax.jmi.model.Namespace;
import javax.jmi.reflect.RefBaseObject;
import javax.jmi.reflect.RefObject;
import javax.jmi.reflect.RefPackage;
import javax.jmi.xmi.MalformedXMIException;
import javax.naming.Context;
import javax.naming.NamingException;

public class RepositoryDB
implements IRepositoryDB {
    public static final String INDEX_NAME_PREFIX = "IDX";
    private static final String CONNECTION_NULL = "null";
    private static final String PERF_COUNTER_M1_INSERT = "M1 insert";
    private static final String PERF_COUNTER_M1_UPDATE = "M1 update";
    private static final String PERF_COUNTER_M1_DELETE = "M1 delete";
    private static final String PERF_COUNTER_M1_DELETE_ASSOC = "M1 delete, association";
    private static final String PERF_COUNTER_M1_SELECT_SER = "M1 select, serialized";
    private static final String PERF_COUNTER_M1_SELECT_XMI = "M1 select, XMI";
    private static final String PERF_COUNTER_M1_SELECT_ASSOC_SER = "M1 select, associations, serialized";
    private static final String PERF_COUNTER_M1_SELECT_ASSOC_XML = "M1 select, associations, XML";
    private static final String PERF_COUNTER_M1_INSERT_ASSOC = "M1 insert, associations";
    private static final String PERF_COUNTER_M1_UPDATE_ASSOC = "M1 update, associations";
    private static final String PERF_COUNTER_M2_INSERT = "M2 insert";
    private static final String PERF_COUNTER_M2_UPDATE = "M2 iupdate";
    private static final String PERF_COUNTER_M2_DELETE = "M2 delete";
    private static final String PERF_COUNTER_M2_DELETE_ASSOC = "M2 delete, association";
    private static final String PERF_COUNTER_M2_SELECT_SER = "M2 select, serialized";
    private static final String PERF_COUNTER_M2_SELECT_XMI = "M2 select, XMI";
    private static final String PERF_COUNTER_M2_SELECT_ASSOC_SER = "M2 select, associations, serialized";
    private static final String PERF_COUNTER_M2_SELECT_ASSOC_XML = "M2 select, associations, XML";
    private static final String PERF_COUNTER_M2_INSERT_ASSOC = "M2 insert, associations";
    private static final String PERF_COUNTER_M2_UPDATE_ASSOC = "M2 update, associations";
    private static final String WORKSPACE_TYPE_DB = "WorkspaceTypeDB";
    private static boolean testDirectConnection = false;
    private IRepositoryServer repositoryServer;
    private Object dataSource;
    private NumberRange numberRange;
    private Cache cache;
    private AttributesValues attributesValuesM1;
    private AttributesValues attributesValuesM2;
    private List workspaces = null;
    private Properties properties;
    private boolean initialized = false;
    private Map conTransactions;
    protected Table tableOM1;
    protected Table tableAM1;
    protected Table tableHM1;
    protected Table tableOM2;
    protected Table tableAM2;
    protected Table tableHM2;
    protected Table tableCM2;
    private static final Location location = Utilities.getUtilities().getLocation(class$com$sap$ip$mmr$db$RepositoryDB == null ? (class$com$sap$ip$mmr$db$RepositoryDB = RepositoryDB.class$("com.sap.ip.mmr.db.RepositoryDB")) : class$com$sap$ip$mmr$db$RepositoryDB);
    private Connection theConnection = null;
    static /* synthetic */ Class class$com$sap$ip$mmr$db$RepositoryDB;

    public static void writeExceptionToLog(String method, Exception e) {
        RepositoryDB.writeExceptionToLog(location, method, e);
    }

    public static void writeExceptionToLog(Location aLocation, String method, Exception e) {
        if (e instanceof BaseException) {
            ((BaseException)e).log();
        } else if (e instanceof BaseRuntimeException) {
            ((BaseRuntimeException)e).log();
        } else {
            RepositoryServer.getCategory().errorT(aLocation, method, e.toString());
        }
    }

    public void setRepositoryServer(IRepositoryServer repositoryServer) {
        this.repositoryServer = repositoryServer;
    }

    protected Connection getConnection(IConnection connection) {
        String method = "getConnection(IConnection connection)";
        location.entering("getConnection(IConnection connection)", new Object[]{connection});
        Connection con = null;
        con = connection != null ? (Connection)this.conTransactions.get(connection.getConnectionId()) : (Connection)this.conTransactions.get(CONNECTION_NULL);
        if (con != null) {
            try {
                if (con.isClosed()) {
                    con = null;
                }
            }
            catch (SQLException e) {
                con = null;
            }
        }
        if (con == null) {
            con = this.getConnection();
            if (connection != null) {
                this.conTransactions.put(connection.getConnectionId(), con);
            } else {
                this.conTransactions.put(CONNECTION_NULL, con);
            }
        }
        location.exiting((Object)new Object[]{con});
        return con;
    }

    protected void clearConnection(IConnection connection) {
        String method = "clearConnection(IConnection connection)";
        location.entering("clearConnection(IConnection connection)", new Object[]{connection});
        if (this.conTransactions != null) {
            if (connection != null) {
                this.conTransactions.remove(connection.getConnectionId());
            } else {
                this.conTransactions.remove(CONNECTION_NULL);
            }
        }
        location.exiting();
    }

    public static void conClose(Connection con, String method) {
        RepositoryDB.conClose(location, con, method);
    }

    public static void conClose(Location aLocation, Connection con, String method) {
        String thisMethod = "conClose(Connection con, String method)";
        location.entering("conClose(Connection con, String method)", new Object[]{con});
        try {
            if (con != null && !con.isClosed()) {
                con.close();
            }
        }
        catch (Exception e) {
            RepositoryDB.writeExceptionToLog(aLocation, method, e);
        }
        location.exiting();
    }

    public static void conCommit(Connection con, String method) {
        RepositoryDB.conCommit(location, con, method);
    }

    public static void conCommit(Location aLocation, Connection con, String method) {
        String thisMethod = "conCommit(Connection con, String method)";
        location.entering("conCommit(Connection con, String method)", new Object[]{con});
        try {
            if (con != null) {
                con.commit();
            }
        }
        catch (Exception e) {
            RepositoryDB.writeExceptionToLog(aLocation, method, e);
        }
        location.exiting();
    }

    public static void conRollback(Connection con, String method) {
        RepositoryDB.conRollback(location, con, method);
    }

    public static void conRollback(Location aLocation, Connection con, String method) {
        String thisMethod = "conRollback(Connection con, String method)";
        location.entering("conRollback(Connection con, String method)", new Object[]{con});
        try {
            if (con != null) {
                con.rollback();
            }
        }
        catch (Exception e) {
            RepositoryDB.writeExceptionToLog(aLocation, method, e);
        }
        location.exiting();
    }

    public boolean initialize() throws BaseException, BaseRuntimeException {
        String method = "initialize()";
        location.entering("initialize()");
        if (!this.initialized) {
            this.conTransactions = new HashMap();
            this.numberRange = new NumberRange(this);
            this.cache = new Cache(this);
            this.getTables();
            this.initialized = true;
            this.upgradeToNW05();
        }
        location.exiting();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradeToNW05() {
        String method = "upgradeToNW05()";
        String sql = "UPDATE " + this.tableOM1.getName() + " SET " + "QUALNAME" + " = " + "MOFID" + " WHERE " + "QUALNAME" + " IS NULL";
        Connection con = this.getConnection();
        try {
            Statement st = con.createStatement();
            st.executeUpdate(sql);
            RepositoryDB.conClose(con, "upgradeToNW05()");
        }
        catch (Exception e) {
            RepositoryDB.writeExceptionToLog("upgradeToNW05()", e);
        }
        finally {
            RepositoryDB.conClose(con, "upgradeToNW05()");
        }
    }

    public void finalizer() throws BaseException, BaseRuntimeException {
        String method = "finalizer()";
        location.entering("finalizer()");
        Iterator iter = this.conTransactions.values().iterator();
        while (iter.hasNext()) {
            Connection con = (Connection)iter.next();
            RepositoryDB.conClose(con, "finalizer()");
        }
        if (this.theConnection != null) {
            RepositoryDB.conClose(this.theConnection, "finalizer()");
        }
        location.exiting();
    }

    public NumberRange getNumberRange() {
        return this.numberRange;
    }

    private AttributesValues getAttributesValuesM1() {
        if (this.attributesValuesM1 == null) {
            this.attributesValuesM1 = new AttributesValues(this, 1);
        }
        return this.attributesValuesM1;
    }

    private AttributesValues getAttributesValuesM2() {
        if (this.attributesValuesM2 == null) {
            this.attributesValuesM2 = new AttributesValues(this, 2);
        }
        return this.attributesValuesM2;
    }

    public Object getDataSource() {
        Context context;
        String method = "getDataSource()";
        String dsname = "jdbc/notx/" + RepositoryServer.getConfiguration().getDataSourceName();
        if (this.dataSource == null && (context = this.repositoryServer.getJndiInitialContext()) != null) {
            try {
                this.dataSource = context.lookup(dsname);
                RepositoryServer.getCategory().infoT(location, "getDataSource()", MMRResourceAccessor.getInstance().getMessageText("3116"), new Object[]{this.dataSource, dsname});
            }
            catch (NamingException e) {
                this.dataSource = null;
            }
        }
        if (this.dataSource == null && testDirectConnection) {
            this.dataSource = new DataSource((IPersistence)this.repositoryServer);
            Connection con = this.getConnection();
            if (con != null) {
                RepositoryDB.conClose(con, "getDataSource()");
                RepositoryServer.getCategory().infoT(location, "getDataSource()", MMRResourceAccessor.getInstance().getMessageText("3117"), new Object[]{this.dataSource});
            } else {
                this.dataSource = null;
            }
        }
        if (this.dataSource == null) {
            RepositoryServer.getCategory().infoT(location, "getDataSource()", MMRResourceAccessor.getInstance().getMessageText("3118"));
        }
        return this.dataSource;
    }

    public Connection getConnection() {
        String method = "getConnection()";
        location.entering("getConnection()");
        Connection con = null;
        Object source = this.getDataSource();
        if (source != null) {
            if (source instanceof DataSource) {
                con = ((DataSource)source).getConnection();
            } else {
                try {
                    if (source instanceof javax.sql.DataSource) {
                        con = ((javax.sql.DataSource)source).getConnection();
                    }
                }
                catch (Exception e) {
                    location.catching((Throwable)e);
                }
            }
        }
        if (con != null) {
            try {
                if (con.getAutoCommit()) {
                    con.setAutoCommit(false);
                }
                con.clearWarnings();
            }
            catch (Exception e) {
                RepositoryDB.writeExceptionToLog("getConnection()", e);
            }
        }
        location.exiting();
        return con;
    }

    public boolean transactionBegin(IConnection connection) throws BaseException, BaseRuntimeException {
        String method = "transactionBegin(IConnection connection)";
        location.entering("transactionBegin(IConnection connection)");
        boolean flag = true;
        if (this.getConnection(connection) == null) {
            flag = false;
        }
        location.exiting();
        return flag;
    }

    public boolean transactionBeforeCommit(IConnection arg0, Collection arg1, Map arg2, Collection arg3, Collection arg4, Map arg5, Collection arg6) throws BaseException, BaseRuntimeException {
        return true;
    }

    public boolean transactionCommit(IConnection connection) throws BaseException, BaseRuntimeException {
        Connection conTransaction;
        String method = "transactionCommit(IConnection connection)";
        location.entering("transactionCommit(IConnection connection)");
        boolean flag = true;
        String conId = CONNECTION_NULL;
        if (connection != null) {
            conId = connection.getConnectionId();
        }
        if ((conTransaction = (Connection)this.conTransactions.get(conId)) != null) {
            RepositoryDB.conCommit(conTransaction, "transactionCommit(IConnection connection)");
            RepositoryDB.conClose(conTransaction, "transactionCommit(IConnection connection)");
            this.clearConnection(connection);
        }
        location.exiting();
        return flag;
    }

    public boolean transactionRollback(IConnection connection) throws BaseException, BaseRuntimeException {
        Connection conTransaction;
        String method = "transactionRollback(IConnection connection)";
        location.entering("transactionRollback(IConnection connection)");
        boolean flag = true;
        String conId = CONNECTION_NULL;
        if (connection != null) {
            conId = connection.getConnectionId();
        }
        if ((conTransaction = (Connection)this.conTransactions.get(conId)) != null) {
            RepositoryDB.conRollback(conTransaction, "transactionRollback(IConnection connection)");
            RepositoryDB.conClose(conTransaction, "transactionRollback(IConnection connection)");
            this.clearConnection(connection);
        }
        location.exiting();
        return flag;
    }

    private boolean assertTransactionActive(String method, IConnection connection) {
        Connection conTransaction = this.getConnection(connection);
        if (conTransaction == null) {
            RepositoryServer.getCategory().errorT(location, method, MMRResourceAccessor.getInstance().getMessageText("3115"));
            return false;
        }
        return true;
    }

    public int getSIDForValue(String cacheName, String value) {
        return this.cache.getSIDForValue(cacheName, value);
    }

    public String getValueBySID(String cacheName, int sid) {
        return this.cache.getValueBySID(cacheName, sid);
    }

    protected List getTables() {
        Index idx;
        LinkedList<Table> tables = new LinkedList<Table>();
        if (this.tableOM1 == null) {
            this.tableOM1 = new Table("BI_MMRL1INST");
            this.tableOM1.addColumn("WORKSPACE", 4, 10, true);
            this.tableOM1.addColumn("MOFID", 0, 32, true);
            this.tableOM1.addColumn("OBJTYPE", 4, 10, false);
            this.tableOM1.addColumn("OBJXML", 6, 0, false);
            this.tableOM1.addColumn("OBJSER", 7, 0, false);
            this.tableOM1.addColumn("QUALNAME", 1, 256, false);
            this.tableOM1.addColumn("DEPLOYUNITNAME", 4, 10, false);
            tables.add(this.tableOM1);
        }
        if (this.tableAM1 == null) {
            this.tableAM1 = new Table("BI_MMRL1ASC");
            this.tableAM1.addColumn("WORKSPACE", 4, 10, true);
            this.tableAM1.addColumn("MOFID", 0, 32, true);
            this.tableAM1.addColumn("OBJXML", 6, 0, false);
            this.tableAM1.addColumn("OBJSER", 7, 0, false);
            tables.add(this.tableAM1);
        }
        if (this.tableHM1 == null) {
            this.tableHM1 = new Table("BI_MMRL1HIER");
            this.tableHM1.addColumn("WORKSPACE", 4, 10, true);
            this.tableHM1.addColumn("MOFID", 0, 32, true);
            this.tableHM1.addColumn("QUALNAME", 1, 256, false);
            this.tableHM1.addColumn("OBJXML", 6, 0, false);
            this.tableHM1.addColumn("OBJSER", 7, 0, false);
            idx = new Index(this.tableHM1.getName(), "IDX1");
            idx.setUnique(true);
            idx.addColumn("WORKSPACE");
            idx.addColumn("QUALNAME");
            this.tableHM1.addIndex(idx);
            tables.add(this.tableHM1);
        }
        if (this.tableOM2 == null) {
            this.tableOM2 = new Table("BI_MMRL2INST");
            this.tableOM2.addColumn("WORKSPACE", 4, 10, true);
            this.tableOM2.addColumn("MOFID", 0, 32, true);
            this.tableOM2.addColumn("OBJTYPE", 4, 10, false);
            this.tableOM2.addColumn("QUALNAME", 1, 256, false);
            this.tableOM2.addColumn("OBJXML", 6, 0, false);
            this.tableOM2.addColumn("OBJSER", 7, 0, false);
            this.tableOM2.addColumn("DEPLOYUNITNAME", 4, 10, false);
            tables.add(this.tableOM2);
            idx = new Index(this.tableOM2.getName(), "IDX1");
            idx.setUnique(true);
            idx.addColumn("WORKSPACE");
            idx.addColumn("QUALNAME");
            this.tableOM2.addIndex(idx);
        }
        if (this.tableAM2 == null) {
            this.tableAM2 = new Table("BI_MMRL2ASC");
            this.tableAM2.addColumn("WORKSPACE", 4, 10, true);
            this.tableAM2.addColumn("MOFID", 0, 32, true);
            this.tableAM2.addColumn("OBJXML", 6, 0, false);
            this.tableAM2.addColumn("OBJSER", 7, 0, false);
            tables.add(this.tableAM2);
        }
        if (this.tableHM2 == null) {
            this.tableHM2 = new Table("BI_MMRL2HIER");
            this.tableHM2.addColumn("WORKSPACE", 4, 10, true);
            this.tableHM2.addColumn("MOFID", 0, 32, true);
            this.tableHM2.addColumn("QUALNAME", 1, 256, false);
            this.tableHM2.addColumn("OBJXML", 6, 0, false);
            this.tableHM2.addColumn("OBJSER", 7, 0, false);
            idx = new Index(this.tableHM2.getName(), "IDX1");
            idx.setUnique(true);
            idx.addColumn("WORKSPACE");
            idx.addColumn("QUALNAME");
            this.tableHM2.addIndex(idx);
            tables.add(this.tableHM2);
        }
        if (this.tableCM2 == null) {
            this.tableCM2 = new Table("BI_MMRL2JCLASS");
            this.tableCM2.addColumn("WORKSPACE", 4, 10, true);
            this.tableCM2.addColumn("CLASSNAME", 4, 10, true);
            this.tableCM2.addColumn("CLASSDATA", 7, 0, false);
            tables.add(this.tableCM2);
        }
        return tables;
    }

    protected PreparedStatement getPSInsertOM1(Connection con) {
        String method = "getPSInsertOM1(Connection con)";
        String sql = "INSERT INTO " + this.tableOM1.getName() + this.tableOM1.getColumnList() + " VALUES (?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(sql);
        }
        catch (Exception e) {
            RepositoryDB.writeExceptionToLog("getPSInsertOM1(Connection con)", e);
        }
        return ps;
    }

    protected PreparedStatement getPSInsertAM1(Connection con) {
        String method = "getPSInsertAM1(Connection con)";
        String sql = "INSERT INTO " + this.tableAM1.getName() + this.tableAM1.getColumnList() + " VALUES (?, ?, ?, ?)";
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(sql);
        }
        catch (Exception e) {
            RepositoryDB.writeExceptionToLog("getPSInsertAM1(Connection con)", e);
        }
        return ps;
    }

    protected PreparedStatement getPSInsertHM1(Connection con) {
        String method = "getPSInsertHM1(Connection con)";
        String sql = "INSERT INTO " + this.tableHM1.getName() + this.tableHM1.getColumnList() + " VALUES (?, ?, ?, ?, ?)";
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(sql);
        }
        catch (Exception e) {
            RepositoryDB.writeExceptionToLog("getPSInsertHM1(Connection con)", e);
        }
        return ps;
    }

    protected PreparedStatement getPSInsertOM2(Connection con) {
        String method = "getPSInsertOM2(Connection con)";
        String sql = "INSERT INTO " + this.tableOM2.getName() + this.tableOM2.getColumnList() + " VALUES (?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(sql);
        }
        catch (Exception e) {
            RepositoryDB.writeExceptionToLog("getPSInsertOM2(Connection con)", e);
        }
        return ps;
    }

    protected PreparedStatement getPSInsertAM2(Connection con) {
        String method = "getPSInsertAM2(Connection con)";
        String sql = "INSERT INTO " + this.tableAM2.getName() + this.tableAM2.getColumnList() + " VALUES (?, ?, ?, ?)";
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(sql);
        }
        catch (Exception e) {
            RepositoryDB.writeExceptionToLog("getPSInsertAM2(Connection con)", e);
        }
        return ps;
    }

    protected PreparedStatement getPSInsertHM2(Connection con) {
        String method = "getPSInsertHM2(Connection con)";
        String sql = "INSERT INTO " + this.tableHM2.getName() + this.tableHM2.getColumnList() + " VALUES (?, ?, ?, ?, ?)";
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(sql);
        }
        catch (Exception e) {
            RepositoryDB.writeExceptionToLog("getPSInsertHM2(Connection con)", e);
        }
        return ps;
    }

    protected PreparedStatement getPSInsertCM2(Connection con) {
        String method = "getPSInsertCM2(Connection con)";
        String sql = "INSERT INTO " + this.tableCM2.getName() + this.tableCM2.getColumnList() + " VALUES (?, ?, ?)";
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(sql);
        }
        catch (Exception e) {
            RepositoryDB.writeExceptionToLog("getPSInsertCM2(Connection con)", e);
        }
        return ps;
    }

    protected PreparedStatement getPSUpdateOM1(Connection con) {
        String method = "getPSUpdateOM1(Connection con)";
        String sql = "UPDATE " + this.tableOM1.getName() + " SET " + "OBJTYPE" + " = ? ," + "OBJXML" + " = ? ," + "OBJSER" + " = ? ," + "QUALNAME" + " = ? ," + "DEPLOYUNITNAME" + " = ? " + " WHERE " + "WORKSPACE" + " = ? " + " AND " + "MOFID" + " = ?";
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(sql);
        }
        catch (Exception e) {
            RepositoryDB.writeExceptionToLog("getPSUpdateOM1(Connection con)", e);
        }
        return ps;
    }

    protected PreparedStatement getPSUpdateSerM1(Connection con) {
        String method = "getPSUpdateSerM1(Connection con)";
        String sql = "UPDATE " + this.tableOM1.getName() + " SET " + "OBJSER" + " = ? " + " WHERE " + "WORKSPACE" + " = ? " + " AND " + "MOFID" + " = ?";
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(sql);
        }
        catch (Exception e) {
            RepositoryDB.writeExceptionToLog("getPSUpdateSerM1(Connection con)", e);
        }
        return ps;
    }

    protected PreparedStatement getPSUpdateAM1(Connection con) {
        String method = "getPSUpdateAM1(Connection con)";
        String sql = "UPDATE " + this.tableAM1.getName() + " SET " + "OBJXML" + " = ? ," + "OBJSER" + " = ? " + " WHERE " + "WORKSPACE" + " = ? " + " AND " + "MOFID" + " = ?";
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(sql);
        }
        catch (Exception e) {
            RepositoryDB.writeExceptionToLog("getPSUpdateAM1(Connection con)", e);
        }
        return ps;
    }

    protected PreparedStatement getPSUpdateHM1(Connection con) {
        String method = "getPSUpdateHM1(Connection con)";
        String sql = "UPDATE " + this.tableHM1.getName() + " SET " + "QUALNAME" + " = ? " + " SET " + "OBJXML" + " = ? ," + "OBJSER" + " = ? " + " WHERE " + "WORKSPACE" + " = ? " + " AND " + "MOFID" + " = ?";
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(sql);
        }
        catch (Exception e) {
            RepositoryDB.writeExceptionToLog("getPSUpdateHM1(Connection con)", e);
        }
        return ps;
    }

    protected PreparedStatement getPSUpdateOM2(Connection con) {
        String method = "getPSUpdateOM2(Connection con)";
        String sql = "UPDATE " + this.tableOM2.getName() + " SET " + "OBJTYPE" + " = ? ," + "QUALNAME" + " = ? ," + "OBJXML" + " = ? ," + "OBJSER" + " = ? ," + "DEPLOYUNITNAME" + " = ? " + " WHERE " + "WORKSPACE" + " = ? " + " AND " + "MOFID" + " = ?";
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(sql);
        }
        catch (Exception e) {
            RepositoryDB.writeExceptionToLog("getPSUpdateOM2(Connection con)", e);
        }
        return ps;
    }

    protected PreparedStatement getPSUpdateSerM2(Connection con) {
        String method = "getPSUpdateSerM2(Connection con)";
        String sql = "UPDATE " + this.tableOM2.getName() + " SET " + "OBJSER" + " = ? " + " WHERE " + "WORKSPACE" + " = ? " + " AND " + "MOFID" + " = ?";
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(sql);
        }
        catch (Exception e) {
            RepositoryDB.writeExceptionToLog("getPSUpdateSerM2(Connection con)", e);
        }
        return ps;
    }

    protected PreparedStatement getPSUpdateAM2(Connection con) {
        String method = "getPSUpdateAM2(Connection con)";
        String sql = "UPDATE " + this.tableAM2.getName() + " SET " + "OBJXML" + " = ? ," + "OBJSER" + " = ? " + " WHERE " + "WORKSPACE" + " = ? " + " AND " + "MOFID" + " = ?";
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(sql);
        }
        catch (Exception e) {
            RepositoryDB.writeExceptionToLog("getPSUpdateAM2(Connection con)", e);
        }
        return ps;
    }

    protected PreparedStatement getPSUpdateHM2(Connection con) {
        String method = "getPSUpdateHM2(Connection con)";
        String sql = "UPDATE " + this.tableHM2.getName() + " SET " + "QUALNAME" + " = ? " + " SET " + "OBJXML" + " = ? ," + "OBJSER" + " = ? " + " WHERE " + "WORKSPACE" + " = ? " + " AND " + "MOFID" + " = ?";
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(sql);
        }
        catch (Exception e) {
            RepositoryDB.writeExceptionToLog("getPSUpdateHM2(Connection con)", e);
        }
        return ps;
    }

    protected PreparedStatement getPSUpdateCM2(Connection con) {
        String method = "getPSUpdateCM2(Connection con)";
        String sql = "UPDATE " + this.tableCM2.getName() + " SET " + "CLASSDATA" + " = ? " + " WHERE " + "WORKSPACE" + " = ? " + " AND " + "CLASSNAME" + " = ?";
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(sql);
        }
        catch (Exception e) {
            RepositoryDB.writeExceptionToLog("getPSUpdateCM2(Connection con)", e);
        }
        return ps;
    }

    protected PreparedStatement getPSDeleteOM1(Connection con) {
        String method = "getPSDeleteOM1(Connection con)";
        String sql = "DELETE FROM " + this.tableOM1.getName() + " WHERE " + "WORKSPACE" + " = ? " + " AND " + "MOFID" + " = ?";
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(sql);
        }
        catch (Exception e) {
            RepositoryDB.writeExceptionToLog("getPSDeleteOM1(Connection con)", e);
        }
        return ps;
    }

    protected PreparedStatement getPSDeleteAM1(Connection con) {
        String method = "getPSDeleteAM1(Connection con)";
        String sql = "DELETE FROM " + this.tableAM1.getName() + " WHERE " + "WORKSPACE" + " = ? " + " AND " + "MOFID" + " = ?";
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(sql);
        }
        catch (Exception e) {
            RepositoryDB.writeExceptionToLog("getPSDeleteAM1(Connection con)", e);
        }
        return ps;
    }

    protected PreparedStatement getPSDeleteHM1(Connection con) {
        String method = "getPSDeleteHM1(Connection con)";
        String sql = "DELETE FROM " + this.tableHM1.getName() + " WHERE " + "WORKSPACE" + " = ? " + " AND " + "MOFID" + " = ?";
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(sql);
        }
        catch (Exception e) {
            RepositoryDB.writeExceptionToLog("getPSDeleteHM1(Connection con)", e);
        }
        return ps;
    }

    protected PreparedStatement getPSDeleteOM2(Connection con) {
        String method = "getPSDeleteOM2(Connection con)";
        String sql = "DELETE FROM " + this.tableOM2.getName() + " WHERE " + "WORKSPACE" + " = ? " + " AND " + "MOFID" + " = ?";
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(sql);
        }
        catch (Exception e) {
            RepositoryDB.writeExceptionToLog("getPSDeleteOM2(Connection con)", e);
        }
        return ps;
    }

    protected PreparedStatement getPSDeleteAM2(Connection con) {
        String method = "getPSDeleteAM2(Connection con)";
        String sql = "DELETE FROM " + this.tableAM2.getName() + " WHERE " + "WORKSPACE" + " = ? " + " AND " + "MOFID" + " = ?";
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(sql);
        }
        catch (Exception e) {
            RepositoryDB.writeExceptionToLog("getPSDeleteAM2(Connection con)", e);
        }
        return ps;
    }

    protected PreparedStatement getPSDeleteHM2(Connection con) {
        String method = "getPSDeleteHM2(Connection con)";
        String sql = "DELETE FROM " + this.tableHM2.getName() + " WHERE " + "WORKSPACE" + " = ? " + " AND " + "MOFID" + " = ?";
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(sql);
        }
        catch (Exception e) {
            RepositoryDB.writeExceptionToLog("getPSDeleteHM2(Connection con)", e);
        }
        return ps;
    }

    protected PreparedStatement getPSDeleteCM2(Connection con) {
        String method = "getPSDeleteCM2(Connection con)";
        String sql = "DELETE FROM " + this.tableCM2.getName() + " WHERE " + "WORKSPACE" + " = ? " + " AND " + "CLASSNAME" + " = ?";
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(sql);
        }
        catch (Exception e) {
            RepositoryDB.writeExceptionToLog("getPSDeleteCM2(Connection con)", e);
        }
        return ps;
    }

    protected PreparedStatement getPSSelectXMLOM1(Connection con) {
        String method = "getPSSelectXMLOM1(Connection con)";
        String sql = "SELECT OBJXML, OBJTYPE FROM " + this.tableOM1.getName() + " WHERE " + "WORKSPACE" + " = ? " + " AND " + "MOFID" + " = ?";
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(sql);
        }
        catch (Exception e) {
            RepositoryDB.writeExceptionToLog("getPSSelectXMLOM1(Connection con)", e);
        }
        return ps;
    }

    protected PreparedStatement getPSSelectSerOM1(Connection con) {
        String method = "getPSSelectSerOM1(Connection con)";
        String sql = "SELECT OBJSER, OBJTYPE FROM " + this.tableOM1.getName() + " WHERE " + "WORKSPACE" + " = ? " + " AND " + "MOFID" + " = ?";
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(sql);
        }
        catch (Exception e) {
            RepositoryDB.writeExceptionToLog("getPSSelectSerOM1(Connection con)", e);
        }
        return ps;
    }

    protected PreparedStatement getPSSelectXMLAM1(Connection con) {
        String method = "getPSSelectXMLAM1(Connection con)";
        String sql = "SELECT OBJXML FROM " + this.tableAM1.getName() + " WHERE " + "WORKSPACE" + " = ? " + " AND " + "MOFID" + " = ?";
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(sql);
        }
        catch (Exception e) {
            RepositoryDB.writeExceptionToLog("getPSSelectXMLAM1(Connection con)", e);
        }
        return ps;
    }

    protected PreparedStatement getPSSelectSerAM1(Connection con) {
        String method = "getPSSelectSerAM1(Connection con)";
        String sql = "SELECT OBJSER FROM " + this.tableAM1.getName() + " WHERE " + "WORKSPACE" + " = ? " + " AND " + "MOFID" + " = ?";
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(sql);
        }
        catch (Exception e) {
            RepositoryDB.writeExceptionToLog("getPSSelectSerAM1(Connection con)", e);
        }
        return ps;
    }

    protected PreparedStatement getPSSelectXMLHM1(Connection con) {
        String method = "getPSSelectXMLHM1(Connection con)";
        String sql = "SELECT OBJXML FROM " + this.tableHM1.getName() + " WHERE " + "WORKSPACE" + " = ? " + " AND " + "MOFID" + " = ?";
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(sql);
        }
        catch (Exception e) {
            RepositoryDB.writeExceptionToLog("getPSSelectXMLHM1(Connection con)", e);
        }
        return ps;
    }

    protected PreparedStatement getPSSelectSerHM1(Connection con) {
        String method = "getPSSelectSerHM1(Connection con)";
        String sql = "SELECT OBJSER FROM " + this.tableHM1.getName() + " WHERE " + "WORKSPACE" + " = ? " + " AND " + "MOFID" + " = ?";
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(sql);
        }
        catch (Exception e) {
            RepositoryDB.writeExceptionToLog("getPSSelectSerHM1(Connection con)", e);
        }
        return ps;
    }

    protected PreparedStatement getPSSelectXMLOM2(Connection con) {
        String method = "getPSSelectXMLOM2(Connection con)";
        String sql = "SELECT OBJXML FROM " + this.tableOM2.getName() + " WHERE " + "WORKSPACE" + " = ? " + " AND " + "MOFID" + " = ?";
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(sql);
        }
        catch (Exception e) {
            RepositoryDB.writeExceptionToLog("getPSSelectXMLOM2(Connection con)", e);
        }
        return ps;
    }

    protected PreparedStatement getPSSelectSerOM2(Connection con) {
        String method = "getPSSelectSerOM2(Connection con)";
        String sql = "SELECT OBJSER FROM " + this.tableOM2.getName() + " WHERE " + "WORKSPACE" + " = ? " + " AND " + "MOFID" + " = ?";
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(sql);
        }
        catch (Exception e) {
            RepositoryDB.writeExceptionToLog("getPSSelectSerOM2(Connection con)", e);
        }
        return ps;
    }

    protected PreparedStatement getPSSelectXMLOM2Qn(Connection con) {
        String method = "getPSSelectXMLOM2Qn(Connection con)";
        String sql = "SELECT OBJXML FROM " + this.tableOM2.getName() + " WHERE " + "WORKSPACE" + " = ? " + " AND " + "QUALNAME" + " = ?";
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(sql);
        }
        catch (Exception e) {
            RepositoryDB.writeExceptionToLog("getPSSelectXMLOM2Qn(Connection con)", e);
        }
        return ps;
    }

    protected PreparedStatement getPSSelectSerOM2Qn(Connection con) {
        String method = "getPSSelectSerOM2Qn(Connection con)";
        String sql = "SELECT OBJSER FROM " + this.tableOM2.getName() + " WHERE " + "WORKSPACE" + " = ? " + " AND " + "QUALNAME" + " = ?";
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(sql);
        }
        catch (Exception e) {
            RepositoryDB.writeExceptionToLog("getPSSelectSerOM2Qn(Connection con)", e);
        }
        return ps;
    }

    protected PreparedStatement getPSSelectXMLAM2(Connection con) {
        String method = "getPSSelectXMLAM2(Connection con)";
        String sql = "SELECT OBJXML FROM " + this.tableAM2.getName() + " WHERE " + "WORKSPACE" + " = ? " + " AND " + "MOFID" + " = ?";
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(sql);
        }
        catch (Exception e) {
            RepositoryDB.writeExceptionToLog("getPSSelectXMLAM2(Connection con)", e);
        }
        return ps;
    }

    protected PreparedStatement getPSSelectSerAM2(Connection con) {
        String method = "getPSSelectSerAM2(Connection con)";
        String sql = "SELECT OBJSER FROM " + this.tableAM2.getName() + " WHERE " + "WORKSPACE" + " = ? " + " AND " + "MOFID" + " = ?";
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(sql);
        }
        catch (Exception e) {
            RepositoryDB.writeExceptionToLog("getPSSelectSerAM2(Connection con)", e);
        }
        return ps;
    }

    protected PreparedStatement getPSSelectXMLHM2(Connection con) {
        String method = "getPSSelectXMLHM2(Connection con)";
        String sql = "SELECT OBJXML FROM " + this.tableHM2.getName() + " WHERE " + "WORKSPACE" + " = ? " + " AND " + "MOFID" + " = ?";
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(sql);
        }
        catch (Exception e) {
            RepositoryDB.writeExceptionToLog("getPSSelectXMLHM2(Connection con)", e);
        }
        return ps;
    }

    protected PreparedStatement getPSSelectSerHM2(Connection con) {
        String method = "getPSSelectSerHM2(Connection con)";
        String sql = "SELECT OBJSER FROM " + this.tableHM2.getName() + " WHERE " + "WORKSPACE" + " = ? " + " AND " + "MOFID" + " = ?";
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(sql);
        }
        catch (Exception e) {
            RepositoryDB.writeExceptionToLog("getPSSelectSerHM2(Connection con)", e);
        }
        return ps;
    }

    protected PreparedStatement getPSSelectCM2(Connection con) {
        String method = "getPSSelectCM2(Connection con)";
        String sql = "SELECT CLASSDATA FROM " + this.tableCM2.getName() + " WHERE " + "WORKSPACE" + " = ? " + " AND " + "CLASSNAME" + " = ?";
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(sql);
        }
        catch (Exception e) {
            RepositoryDB.writeExceptionToLog("getPSSelectCM2(Connection con)", e);
        }
        return ps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteM1All(IConnection connection) throws BaseException, BaseRuntimeException {
        String method = "deleteM1All(IConnection connection)";
        location.entering("deleteM1All(IConnection connection)");
        if (!this.assertTransactionActive("deleteM1All(IConnection connection)", connection)) {
            return;
        }
        Iterator iterW = this.getWorkspacesDB(connection.getConnectionSpec().getWorkspacesM1()).iterator();
        while (iterW.hasNext()) {
            Workspace w = (Workspace)iterW.next();
            if (w.isReadOnly()) continue;
            int wsSid = this.getSIDForValue("WORKSPACE", w.getName());
            LinkedList<Table> l = new LinkedList<Table>();
            l.add(this.tableOM1);
            l.add(this.tableAM1);
            l.add(this.tableHM1);
            l.addAll(this.getAttributesValuesM1().getTables());
            Iterator iter = l.iterator();
            while (iter.hasNext()) {
                Table t = (Table)iter.next();
                String sql = "DELETE FROM " + t.getName() + " WHERE " + "WORKSPACE" + " = ?";
                Statement stmt = null;
                try {
                    stmt = this.getConnection(connection).prepareStatement(sql);
                    stmt.setInt(1, wsSid);
                    stmt.executeUpdate();
                }
                catch (Exception e) {
                    RepositoryServer.getCategory().errorT(location, "deleteM1All(IConnection connection)", MMRResourceAccessor.getInstance().getMessageText("0003"), new Object[]{e.toString()});
                }
                finally {
                    try {
                        stmt.close();
                    }
                    catch (Exception e) {
                        RepositoryDB.writeExceptionToLog("deleteM1All(IConnection connection)", e);
                    }
                }
            }
        }
        location.exiting();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteM2All(IConnection connection) throws BaseException, BaseRuntimeException {
        String method = "deleteM2All(IConnection connection)";
        location.entering("deleteM2All(IConnection connection)");
        if (!this.assertTransactionActive("deleteM2All(IConnection connection)", connection)) {
            return;
        }
        Iterator iterW = this.getWorkspacesDB(connection.getConnectionSpec().getWorkspacesM2()).iterator();
        while (iterW.hasNext()) {
            Workspace w = (Workspace)iterW.next();
            if (w.isReadOnly()) continue;
            int wsSid = this.getSIDForValue("WORKSPACE", w.getName());
            LinkedList<Table> l = new LinkedList<Table>();
            l.add(this.tableOM2);
            l.add(this.tableAM2);
            l.add(this.tableHM2);
            l.addAll(this.getAttributesValuesM2().getTables());
            Iterator iter = l.iterator();
            while (iter.hasNext()) {
                Table t = (Table)iter.next();
                String sql = "DELETE FROM " + t.getName() + " WHERE " + "WORKSPACE" + " = ?";
                Statement stmt = null;
                try {
                    stmt = this.getConnection(connection).prepareStatement(sql);
                    stmt.setInt(1, wsSid);
                    stmt.executeUpdate();
                }
                catch (Exception e) {
                    RepositoryDB.writeExceptionToLog("deleteM2All(IConnection connection)", e);
                }
                finally {
                    try {
                        stmt.close();
                    }
                    catch (Exception e) {
                        RepositoryDB.writeExceptionToLog("deleteM2All(IConnection connection)", e);
                    }
                }
            }
        }
        location.exiting();
    }

    public Collection insertM2(IConnection connection, Collection modelElements) throws BaseException, BaseRuntimeException {
        String method = "insertM2(IConnection connection,\tCollection modelElements)";
        location.entering("insertM2(IConnection connection,\tCollection modelElements)");
        if (!this.assertTransactionActive("insertM2(IConnection connection,\tCollection modelElements)", connection)) {
            return null;
        }
        LinkedList<ModelElement> colFailed = null;
        Iterator iterW = this.getWorkspacesDB(connection.getConnectionSpec().getWorkspacesM2()).iterator();
        while (iterW.hasNext()) {
            Workspace w = (Workspace)iterW.next();
            if (w.isReadOnly()) continue;
            Iterator iter = modelElements.iterator();
            while (iter.hasNext()) {
                ModelElement me = (ModelElement)iter.next();
                int type = -1;
                RefObject mo = me.refMetaObject();
                if (mo != null && mo instanceof MofClass) {
                    type = this.getSIDForValue("OBJTYPE", Utilities.getUtilities().encodeQualifiedName(((MofClass)mo).getQualifiedName()));
                }
                String dataXML = this.encodeObjectXML(connection, me);
                byte[] dataSer = this.encodeObjectSer(me);
                String qn = Utilities.getUtilities().encodeQualifiedName(me.getQualifiedName());
                if (this.insertM2(connection, w, me.refMofId(), type, qn, dataXML, dataSer, me, null)) continue;
                RepositoryServer.getCategory().errorT(location, "insertM2(IConnection connection,\tCollection modelElements)", MMRResourceAccessor.getInstance().getMessageText("3110"), new Object[]{me});
                if (colFailed == null) {
                    colFailed = new LinkedList<ModelElement>();
                }
                colFailed.add(me);
            }
        }
        location.exiting();
        return colFailed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateM2Ser(Connection con, int workspaceSid, Collection col) {
        String method = "updateM2Ser(Connection con, int workspaceSid, Collection col)";
        location.entering("updateM2Ser(Connection con, int workspaceSid, Collection col)");
        boolean flag = true;
        if (col != null && col.size() > 0) {
            Iterator iter = col.iterator();
            while (iter.hasNext()) {
                ModelElement me = (ModelElement)iter.next();
                PreparedStatement stmt = this.getPSUpdateSerM2(con);
                try {
                    byte[] dataSer = this.encodeObjectSer(me);
                    stmt.setBytes(1, dataSer);
                    stmt.setInt(2, workspaceSid);
                    stmt.setString(3, me.refMofId());
                    stmt.executeUpdate();
                }
                catch (Exception e) {
                    flag = false;
                }
                finally {
                    try {
                        stmt.close();
                    }
                    catch (Exception e) {
                        RepositoryDB.writeExceptionToLog("updateM2Ser(Connection con, int workspaceSid, Collection col)", e);
                    }
                }
            }
        }
        location.exiting();
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean insertM2(IConnection connection, Workspace workspace, String mofId, int type, String qualifiedName, String dataXMLIn, byte[] dataSerIn, ModelElement me, String deployUnitName) throws BaseException, BaseRuntimeException {
        String dataXML;
        String method = "insertM2(Connection con,int workspaceSid,String mofId,int type,String qualifiedName,String dataXML,byte dataSer[],ModelElement me)";
        location.entering("insertM2(Connection con,int workspaceSid,String mofId,int type,String qualifiedName,String dataXML,byte dataSer[],ModelElement me)");
        boolean flag = false;
        String qn = null;
        qn = qualifiedName == null ? "" : (qualifiedName.length() > 256 ? qualifiedName.substring(0, 256) : qualifiedName);
        byte[] dataSer = dataSerIn;
        if (dataSer == null || dataSer.length <= 0) {
            dataSer = new byte[1];
        }
        if ((dataXML = dataXMLIn) == null || dataXML.length() <= 0) {
            dataXML = " ";
        }
        int deployUnitNameSid = -1;
        if (deployUnitName != null) {
            deployUnitNameSid = this.getSIDForValue("DEPLOYUNIT", deployUnitName);
        }
        Connection con = this.getConnection(connection);
        int workspaceSid = this.getSIDForValue("WORKSPACE", workspace.getName());
        PreparedStatement stmt = this.getPSUpdateOM2(con);
        try {
            stmt.setInt(1, type);
            stmt.setString(2, qn);
            stmt.setString(3, dataXML);
            stmt.setBytes(4, dataSer);
            stmt.setInt(5, deployUnitNameSid);
            stmt.setInt(6, workspaceSid);
            stmt.setString(7, mofId);
            int n = stmt.executeUpdate();
            if (n == 1) {
                connection.incrementCounter(this.getComponentNameMeasurement(workspace), PERF_COUNTER_M2_UPDATE);
                flag = true;
            }
        }
        catch (Exception e) {
            flag = false;
        }
        finally {
            try {
                stmt.close();
            }
            catch (Exception e) {
                RepositoryDB.writeExceptionToLog("insertM2(Connection con,int workspaceSid,String mofId,int type,String qualifiedName,String dataXML,byte dataSer[],ModelElement me)", e);
            }
        }
        if (!flag) {
            stmt = this.getPSInsertOM2(con);
            try {
                stmt.setInt(1, workspaceSid);
                stmt.setString(2, mofId);
                stmt.setInt(3, type);
                stmt.setString(4, qn);
                stmt.setString(5, dataXML);
                stmt.setBytes(6, dataSer);
                stmt.setInt(7, deployUnitNameSid);
                stmt.executeUpdate();
                flag = true;
                connection.incrementCounter(this.getComponentNameMeasurement(workspace), PERF_COUNTER_M2_INSERT);
            }
            catch (Exception e) {
                RepositoryDB.writeExceptionToLog("insertM2(Connection con,int workspaceSid,String mofId,int type,String qualifiedName,String dataXML,byte dataSer[],ModelElement me)", e);
                flag = false;
            }
            finally {
                try {
                    stmt.close();
                }
                catch (Exception e) {
                    RepositoryDB.writeExceptionToLog("insertM2(Connection con,int workspaceSid,String mofId,int type,String qualifiedName,String dataXML,byte dataSer[],ModelElement me)", e);
                }
            }
        }
        if (me != null) {
            this.getAttributesValuesM2().add(con, workspaceSid, (RefObject)me, connection, workspace);
        }
        location.exiting();
        return flag;
    }

    public Collection insertM1(IConnection connection, Collection objects) throws BaseException, BaseRuntimeException {
        String method = "insertM1(IConnection connection, Collection objects)";
        location.entering("insertM1(IConnection connection, Collection objects)");
        if (!this.assertTransactionActive("insertM1(IConnection connection, Collection objects)", connection)) {
            return null;
        }
        LinkedList<RefObject> colFailed = null;
        Iterator iterW = this.getWorkspacesDB(connection.getConnectionSpec().getWorkspacesM1()).iterator();
        while (iterW.hasNext()) {
            Workspace w = (Workspace)iterW.next();
            if (w.isReadOnly()) continue;
            Iterator iter = objects.iterator();
            while (iter.hasNext()) {
                RefObject ro = (RefObject)iter.next();
                int type = -1;
                RefObject mo = ro.refMetaObject();
                if (mo != null && mo instanceof MofClass) {
                    type = this.getSIDForValue("OBJTYPE", Utilities.getUtilities().encodeQualifiedName(((MofClass)mo).getQualifiedName()));
                }
                String dataXML = this.encodeObjectXML(connection, ro);
                byte[] dataSer = this.encodeObjectSer(ro);
                if (this.insertM1(connection, w, ro.refMofId(), type, dataXML, dataSer, ro, null)) continue;
                RepositoryServer.getCategory().errorT(location, "insertM1(IConnection connection, Collection objects)", MMRResourceAccessor.getInstance().getMessageText("3111"), new Object[]{ro});
                if (colFailed == null) {
                    colFailed = new LinkedList<RefObject>();
                }
                colFailed.add(ro);
            }
        }
        location.exiting();
        return colFailed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateM1Ser(Connection con, int workspaceSid, Collection col) {
        String method = "updateM1Ser(Connection con, int workspaceSid, Collection col)";
        location.entering("updateM1Ser(Connection con, int workspaceSid, Collection col)");
        boolean flag = true;
        if (col != null && col.size() > 0) {
            Iterator iter = col.iterator();
            while (iter.hasNext()) {
                RefBaseObject rbo = (RefBaseObject)iter.next();
                if (!(rbo instanceof RefObject)) continue;
                RefObject ro = (RefObject)rbo;
                PreparedStatement stmt = this.getPSUpdateSerM1(con);
                try {
                    byte[] dataSer = this.encodeObjectSer(ro);
                    stmt.setBytes(1, dataSer);
                    stmt.setInt(2, workspaceSid);
                    stmt.setString(3, ro.refMofId());
                    stmt.executeUpdate();
                }
                catch (Exception e) {
                    flag = false;
                }
                finally {
                    try {
                        stmt.close();
                    }
                    catch (Exception e) {
                        RepositoryDB.writeExceptionToLog("updateM1Ser(Connection con, int workspaceSid, Collection col)", e);
                    }
                }
            }
        }
        location.exiting();
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean insertM1(IConnection connection, Workspace workspace, String mofId, int type, String dataXMLIn, byte[] dataSerIn, RefObject ro, String deployUnitName) throws BaseException, BaseRuntimeException {
        String dataXML;
        boolean flag = false;
        String method = "insertM1(Connection con,int workspaceSid,String mofId,int type,String dataXML,byte dataSer[],RefObject ro)";
        location.entering("insertM1(Connection con,int workspaceSid,String mofId,int type,String dataXML,byte dataSer[],RefObject ro)");
        Connection con = this.getConnection(connection);
        int workspaceSid = this.getSIDForValue("WORKSPACE", workspace.getName());
        byte[] dataSer = dataSerIn;
        if (dataSer == null || dataSer.length <= 0) {
            dataSer = new byte[1];
        }
        if ((dataXML = dataXMLIn) == null || dataXML.length() <= 0) {
            dataXML = " ";
        }
        int deployUnitNameSid = -1;
        if (deployUnitName != null) {
            deployUnitNameSid = this.getSIDForValue("DEPLOYUNIT", deployUnitName);
        }
        PreparedStatement stmt = this.getPSUpdateOM1(con);
        try {
            stmt.setInt(1, type);
            stmt.setString(2, dataXML);
            stmt.setBytes(3, dataSer);
            stmt.setString(4, mofId);
            stmt.setInt(5, deployUnitNameSid);
            stmt.setInt(6, workspaceSid);
            stmt.setString(7, mofId);
            int n = stmt.executeUpdate();
            if (n == 1) {
                flag = true;
                connection.incrementCounter(this.getComponentNameMeasurement(workspace), PERF_COUNTER_M1_UPDATE);
            } else {
                flag = false;
            }
        }
        catch (Exception e) {
            RepositoryDB.writeExceptionToLog("insertM1(Connection con,int workspaceSid,String mofId,int type,String dataXML,byte dataSer[],RefObject ro)", e);
            flag = false;
        }
        finally {
            try {
                stmt.close();
            }
            catch (Exception e) {
                RepositoryDB.writeExceptionToLog("insertM1(Connection con,int workspaceSid,String mofId,int type,String dataXML,byte dataSer[],RefObject ro)", e);
            }
        }
        if (!flag) {
            stmt = this.getPSInsertOM1(con);
            try {
                stmt.setInt(1, workspaceSid);
                stmt.setString(2, mofId);
                stmt.setInt(3, type);
                stmt.setString(4, dataXML);
                stmt.setBytes(5, dataSer);
                stmt.setString(6, mofId);
                stmt.setInt(7, deployUnitNameSid);
                stmt.executeUpdate();
                flag = true;
                connection.incrementCounter(this.getComponentNameMeasurement(workspace), PERF_COUNTER_M1_INSERT);
            }
            catch (Exception e) {
                RepositoryDB.writeExceptionToLog("insertM1(Connection con,int workspaceSid,String mofId,int type,String dataXML,byte dataSer[],RefObject ro)", e);
                flag = false;
            }
            finally {
                try {
                    stmt.close();
                }
                catch (Exception e) {
                    RepositoryDB.writeExceptionToLog("insertM1(Connection con,int workspaceSid,String mofId,int type,String dataXML,byte dataSer[],RefObject ro)", e);
                }
            }
        }
        if (ro != null) {
            this.getAttributesValuesM1().add(con, workspaceSid, ro, connection, workspace);
        }
        location.exiting();
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean insertClassDataM2(IConnection connection, Workspace workspace, String className, byte[] classData) {
        String method = "insertClassDataM2(Connection con,int workspaceSid,String className,byte classData[])";
        location.entering("insertClassDataM2(Connection con,int workspaceSid,String className,byte classData[])");
        boolean flag = false;
        Connection con = this.getConnection(connection);
        int workspaceSid = this.getSIDForValue("WORKSPACE", workspace.getName());
        int cnSid = this.getSIDForValue("JAVACLNAME", className.toLowerCase());
        PreparedStatement stmt = this.getPSUpdateCM2(con);
        try {
            stmt.setBytes(1, classData);
            stmt.setInt(2, workspaceSid);
            stmt.setInt(3, cnSid);
            int n = stmt.executeUpdate();
            if (n == 1) {
                flag = true;
            }
        }
        catch (Exception e) {
            flag = false;
        }
        finally {
            try {
                stmt.close();
            }
            catch (Exception e) {
                RepositoryDB.writeExceptionToLog("insertClassDataM2(Connection con,int workspaceSid,String className,byte classData[])", e);
            }
        }
        if (!flag) {
            stmt = this.getPSInsertCM2(con);
            try {
                stmt.setInt(1, workspaceSid);
                stmt.setInt(2, cnSid);
                stmt.setBytes(3, classData);
                stmt.executeUpdate();
                flag = true;
            }
            catch (Exception e) {
                RepositoryDB.writeExceptionToLog("insertClassDataM2(Connection con,int workspaceSid,String className,byte classData[])", e);
                flag = false;
            }
            finally {
                try {
                    stmt.close();
                }
                catch (Exception e) {
                    RepositoryDB.writeExceptionToLog("insertClassDataM2(Connection con,int workspaceSid,String className,byte classData[])", e);
                }
            }
        }
        location.exiting();
        return flag;
    }

    public Collection deleteM2(IConnection connection, Collection mofIdsOrModelElements) throws BaseException, BaseRuntimeException {
        String method = "deleteM2(IConnection connection, Collection mofIdsOrModelElements)";
        location.entering("deleteM2(IConnection connection, Collection mofIdsOrModelElements)");
        if (!this.assertTransactionActive("deleteM2(IConnection connection, Collection mofIdsOrModelElements)", connection)) {
            return null;
        }
        LinkedList colFailed = null;
        Iterator iterW = this.getWorkspacesDB(connection.getConnectionSpec().getWorkspacesM2()).iterator();
        while (iterW.hasNext()) {
            Collection col;
            Workspace w = (Workspace)iterW.next();
            if (w.isReadOnly() || (col = this.deleteM2(connection, w, mofIdsOrModelElements)) == null || col.size() <= 0) continue;
            if (colFailed == null) {
                colFailed = new LinkedList();
            }
            colFailed.addAll(col);
        }
        location.exiting();
        return colFailed;
    }

    private Collection deleteM2(IConnection connection, Workspace workspace, Collection mofIdsOrModelElements) {
        String method = "deleteM2(Connection con, int workspaceSid, Collection mofIdsOrModelElements)";
        location.entering("deleteM2(Connection con, int workspaceSid, Collection mofIdsOrModelElements)");
        Collection colFailed = this.deleteM2Assoc(connection, workspace, mofIdsOrModelElements);
        if (colFailed != null && colFailed.size() > 0) {
            return colFailed;
        }
        Connection con = this.getConnection(connection);
        int workspaceSid = this.getSIDForValue("WORKSPACE", workspace.getName());
        PreparedStatement stmt = this.getPSDeleteOM2(con);
        Iterator iter = mofIdsOrModelElements.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            String mofId = null;
            if (o instanceof String) {
                mofId = (String)o;
            } else if (o instanceof ModelElement) {
                mofId = ((ModelElement)o).refMofId();
            }
            if (mofId == null) continue;
            try {
                stmt.setInt(1, workspaceSid);
                stmt.setString(2, mofId);
                stmt.executeUpdate();
                connection.incrementCounter(this.getComponentNameMeasurement(workspace), PERF_COUNTER_M2_DELETE);
            }
            catch (Exception e) {
                colFailed = null;
            }
            this.getAttributesValuesM2().delete(con, workspaceSid, mofId, connection, workspace);
        }
        try {
            stmt.close();
        }
        catch (Exception e) {
            RepositoryDB.writeExceptionToLog("deleteM2(Connection con, int workspaceSid, Collection mofIdsOrModelElements)", e);
        }
        location.exiting();
        return colFailed;
    }

    public Collection deleteM1(IConnection connection, Collection mofIdsOrObjects) throws BaseException, BaseRuntimeException {
        String method = "deleteM1(IConnection connection, Collection mofIdsOrObjects)";
        location.entering("deleteM1(IConnection connection, Collection mofIdsOrObjects)");
        if (!this.assertTransactionActive("deleteM1(IConnection connection, Collection mofIdsOrObjects)", connection)) {
            return null;
        }
        LinkedList colFailed = null;
        Iterator iterW = this.getWorkspacesDB(connection.getConnectionSpec().getWorkspacesM1()).iterator();
        while (iterW.hasNext()) {
            Collection col;
            Workspace w = (Workspace)iterW.next();
            if (w.isReadOnly() || (col = this.deleteM1(connection, w, mofIdsOrObjects)) == null || col.size() <= 0) continue;
            if (colFailed == null) {
                colFailed = new LinkedList();
            }
            colFailed.addAll(col);
        }
        location.exiting();
        return colFailed;
    }

    private Collection deleteM1(IConnection connection, Workspace workspace, Collection mofIdsOrObjects) {
        String method = "deleteM1(Connection con, int workspaceSid, Collection mofIdsOrObjects)";
        location.entering("deleteM1(Connection con, int workspaceSid, Collection mofIdsOrObjects)");
        Collection colFailed = this.deleteM1Assoc(connection, workspace, mofIdsOrObjects);
        if (colFailed != null && colFailed.size() > 0) {
            return colFailed;
        }
        Connection con = this.getConnection(connection);
        int workspaceSid = this.getSIDForValue("WORKSPACE", workspace.getName());
        PreparedStatement stmt = this.getPSDeleteOM1(con);
        Iterator iter = mofIdsOrObjects.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            String mofId = null;
            if (o instanceof String) {
                mofId = (String)o;
            } else if (o instanceof RefObject) {
                mofId = ((RefObject)o).refMofId();
            }
            if (mofId == null) continue;
            try {
                stmt.setInt(1, workspaceSid);
                stmt.setString(2, mofId);
                stmt.executeUpdate();
                connection.incrementCounter(this.getComponentNameMeasurement(workspace), PERF_COUNTER_M1_DELETE);
            }
            catch (Exception e) {
                colFailed = null;
            }
            this.getAttributesValuesM1().delete(con, workspaceSid, mofId, connection, workspace);
        }
        try {
            stmt.close();
        }
        catch (Exception e) {
            RepositoryDB.writeExceptionToLog("deleteM1(Connection con, int workspaceSid, Collection mofIdsOrObjects)", e);
        }
        location.exiting();
        return colFailed;
    }

    public boolean deleteJavaClass(IConnection connection, String className) throws BaseException, BaseRuntimeException {
        String method = "loadJavaClass(IConnection connection, String className)";
        location.entering("loadJavaClass(IConnection connection, String className)");
        if (!this.assertTransactionActive("loadJavaClass(IConnection connection, String className)", connection)) {
            return false;
        }
        boolean flag = true;
        Iterator iterW = this.getWorkspacesDB(connection.getConnectionSpec().getWorkspacesM2()).iterator();
        while (iterW.hasNext()) {
            Workspace w = (Workspace)iterW.next();
            if (w.isReadOnly()) continue;
            int wsSid = this.getSIDForValue("WORKSPACE", w.getName());
            if (this.deleteClassDataM2(this.getConnection(connection), wsSid, className)) continue;
            flag = false;
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deleteClassDataM2(Connection con, int workspaceSid, String className) {
        String method = "deleteClassDataM2(Connection con, int workspaceSid, String className)";
        location.entering("deleteClassDataM2(Connection con, int workspaceSid, String className)");
        boolean res = true;
        int cnSid = this.getSIDForValue("JAVACLNAME", className.toLowerCase());
        PreparedStatement stmt = this.getPSDeleteCM2(con);
        try {
            stmt.setInt(1, workspaceSid);
            stmt.setInt(2, cnSid);
            stmt.executeUpdate();
        }
        catch (Exception e) {
            res = false;
        }
        finally {
            try {
                stmt.close();
            }
            catch (Exception e) {
                RepositoryDB.writeExceptionToLog("deleteClassDataM2(Connection con, int workspaceSid, String className)", e);
            }
        }
        location.exiting();
        return res;
    }

    public Collection selectM2(IConnection connection, Collection mofIds, boolean forUpdate) throws BaseException, BaseRuntimeException {
        String method = "selectM2(IConnection connection, Collection mofIds, boolean forUpdate)";
        location.entering("selectM2(IConnection connection, Collection mofIds, boolean forUpdate)");
        LinkedList<ModelElement> list = new LinkedList<ModelElement>();
        Iterator iterW = this.getWorkspacesDB(connection.getConnectionSpec().getWorkspacesM2()).iterator();
        while (iterW.hasNext()) {
            ModelElement me;
            Workspace w = (Workspace)iterW.next();
            int wsSid = this.getSIDForValue("WORKSPACE", w.getName());
            Iterator iter = mofIds.iterator();
            while (iter.hasNext()) {
                Collection col;
                String mofId = (String)iter.next();
                me = this.selectM2Ser(wsSid, mofId);
                if (me != null) {
                    list.add(me);
                    connection.incrementCounter(this.getComponentNameMeasurement(w), PERF_COUNTER_M2_SELECT_SER);
                    continue;
                }
                connection.incrementCounter(this.getComponentNameMeasurement(w), PERF_COUNTER_M2_SELECT_XMI);
                String data = this.selectM2XMI(wsSid, mofId);
                if (data == null || data.length() <= 0 || (col = this.decodeObjectXML(connection, data, 2)) == null) continue;
                list.addAll(col);
                Connection con = this.getConnection();
                this.updateM2Ser(con, wsSid, col);
                RepositoryDB.conCommit(con, "selectM2(IConnection connection, Collection mofIds, boolean forUpdate)");
                RepositoryDB.conClose(con, "selectM2(IConnection connection, Collection mofIds, boolean forUpdate)");
            }
            IRepository repository = Repository.getInstance((IConnection)connection);
            iter = list.iterator();
            while (iter.hasNext()) {
                me = (ModelElementImpl)iter.next();
                me.setRepository(repository);
                me.setMofLayer(2);
                me.setState(StateEnum.STATE_UNCHANGED);
            }
        }
        location.exiting();
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String selectM2XMI(int workspaceSid, String mofId) {
        String data;
        block15: {
            data = null;
            String method = "selectM2XMI(int workspaceSid, String mofId)";
            location.entering("selectM2XMI(int workspaceSid, String mofId)");
            Connection con = this.getConnection();
            PreparedStatement stmt = this.getPSSelectXMLOM2(con);
            ResultSet set = null;
            stmt.setInt(1, workspaceSid);
            stmt.setString(2, mofId);
            set = stmt.executeQuery();
            while (set.next()) {
                data = set.getString(1);
            }
            Object var10_8 = null;
            RepositoryDB.conClose(con, "selectM2XMI(int workspaceSid, String mofId)");
            try {
                set.close();
            }
            catch (Exception e2) {
                RepositoryDB.writeExceptionToLog("selectM2XMI(int workspaceSid, String mofId)", e2);
            }
            try {
                stmt.close();
            }
            catch (Exception e2) {
                RepositoryDB.writeExceptionToLog("selectM2XMI(int workspaceSid, String mofId)", e2);
            }
            break block15;
            {
                catch (Exception e) {
                    RepositoryDB.writeExceptionToLog("selectM2XMI(int workspaceSid, String mofId)", e);
                    Object var10_9 = null;
                    RepositoryDB.conClose(con, "selectM2XMI(int workspaceSid, String mofId)");
                    try {
                        set.close();
                    }
                    catch (Exception e2) {
                        RepositoryDB.writeExceptionToLog("selectM2XMI(int workspaceSid, String mofId)", e2);
                    }
                    try {
                        stmt.close();
                    }
                    catch (Exception e2) {
                        RepositoryDB.writeExceptionToLog("selectM2XMI(int workspaceSid, String mofId)", e2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                RepositoryDB.conClose(con, "selectM2XMI(int workspaceSid, String mofId)");
                try {
                    set.close();
                }
                catch (Exception e2) {
                    RepositoryDB.writeExceptionToLog("selectM2XMI(int workspaceSid, String mofId)", e2);
                }
                try {
                    stmt.close();
                }
                catch (Exception e2) {
                    RepositoryDB.writeExceptionToLog("selectM2XMI(int workspaceSid, String mofId)", e2);
                }
                throw throwable;
            }
        }
        location.exiting();
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private ModelElement selectM2Ser(int workspaceSid, String mofId) {
        ModelElement me;
        block21: {
            me = null;
            String method = "selectM2Ser(Connection con,int workspaceSid,String mofId)";
            location.entering("selectM2Ser(Connection con,int workspaceSid,String mofId)");
            Connection con = this.getConnection();
            PreparedStatement stmt = this.getPSSelectSerOM2(con);
            ResultSet set = null;
            stmt.setInt(1, workspaceSid);
            stmt.setString(2, mofId);
            byte[] b = null;
            set = stmt.executeQuery();
            while (set.next()) {
                b = set.getBytes(1);
            }
            if (b != null) {
                try {
                    ByteArrayInputStream bais = new ByteArrayInputStream(b);
                    ObjectInputStream ois = new ObjectInputStream(bais);
                    me = (ModelElement)ois.readObject();
                }
                catch (ClassNotFoundException e) {
                    me = null;
                }
                catch (InvalidClassException e) {
                    me = null;
                }
                catch (EOFException e) {
                    me = null;
                }
                catch (Exception e) {
                    RepositoryDB.writeExceptionToLog("selectM2Ser(Connection con,int workspaceSid,String mofId)", e);
                }
            }
            Object var12_16 = null;
            RepositoryDB.conClose(con, "selectM2Ser(Connection con,int workspaceSid,String mofId)");
            try {
                set.close();
            }
            catch (Exception e2) {
                RepositoryDB.writeExceptionToLog("selectM2Ser(Connection con,int workspaceSid,String mofId)", e2);
            }
            try {
                stmt.close();
            }
            catch (Exception e2) {
                RepositoryDB.writeExceptionToLog("selectM2Ser(Connection con,int workspaceSid,String mofId)", e2);
            }
            break block21;
            {
                catch (Exception e) {
                    RepositoryDB.writeExceptionToLog("selectM2Ser(Connection con,int workspaceSid,String mofId)", e);
                    Object var12_17 = null;
                    RepositoryDB.conClose(con, "selectM2Ser(Connection con,int workspaceSid,String mofId)");
                    try {
                        set.close();
                    }
                    catch (Exception e2) {
                        RepositoryDB.writeExceptionToLog("selectM2Ser(Connection con,int workspaceSid,String mofId)", e2);
                    }
                    try {
                        stmt.close();
                    }
                    catch (Exception e2) {
                        RepositoryDB.writeExceptionToLog("selectM2Ser(Connection con,int workspaceSid,String mofId)", e2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var12_18 = null;
                RepositoryDB.conClose(con, "selectM2Ser(Connection con,int workspaceSid,String mofId)");
                try {
                    set.close();
                }
                catch (Exception e2) {
                    RepositoryDB.writeExceptionToLog("selectM2Ser(Connection con,int workspaceSid,String mofId)", e2);
                }
                try {
                    stmt.close();
                }
                catch (Exception e2) {
                    RepositoryDB.writeExceptionToLog("selectM2Ser(Connection con,int workspaceSid,String mofId)", e2);
                }
                throw throwable;
            }
        }
        location.exiting();
        return me;
    }

    public Collection selectM1(IConnection connection, Collection mofIds, boolean forUpdate) throws BaseException, BaseRuntimeException {
        String method = "selectM1(IConnection connection, Collection mofIds, boolean forUpdate)";
        location.entering("selectM1(IConnection connection, Collection mofIds, boolean forUpdate)");
        LinkedList<Object> list = new LinkedList<Object>();
        Iterator iterW = this.getWorkspacesDB(connection.getConnectionSpec().getWorkspacesM1()).iterator();
        while (iterW.hasNext()) {
            Object o;
            Workspace w = (Workspace)iterW.next();
            int wsSid = this.getSIDForValue("WORKSPACE", w.getName());
            Iterator iter = mofIds.iterator();
            while (iter.hasNext()) {
                String mofId = (String)iter.next();
                o = this.selectM1Ser(connection, wsSid, mofId);
                if (o != null) {
                    list.add(o);
                    connection.incrementCounter(this.getComponentNameMeasurement(w), PERF_COUNTER_M1_SELECT_SER);
                    continue;
                }
                connection.incrementCounter(this.getComponentNameMeasurement(w), PERF_COUNTER_M1_SELECT_XMI);
                Collection col = this.selectM1XMI(connection, wsSid, mofId);
                if (col == null) continue;
                list.addAll(col);
                Connection con = this.getConnection();
                this.updateM1Ser(con, wsSid, col);
                RepositoryDB.conCommit(con, "selectM1(IConnection connection, Collection mofIds, boolean forUpdate)");
                RepositoryDB.conClose(con, "selectM1(IConnection connection, Collection mofIds, boolean forUpdate)");
            }
            IRepository repository = Repository.getInstance((IConnection)connection);
            iter = list.iterator();
            while (iter.hasNext()) {
                o = (IMMRObject)iter.next();
                if (o.get___GeneratorVersion().compareTo("1.1.1") < 0) {
                    RepositoryServer.getCategory().errorT(location, "selectM1(IConnection connection, Collection mofIds, boolean forUpdate)", MMRResourceAccessor.getInstance().getMessageText(connection, "1015"), new Object[]{o.get___GeneratorVersion(), "1.1.1", o, this});
                    iter.remove();
                    continue;
                }
                o.set___Repository(repository);
                o.set___State(StateEnum.STATE_UNCHANGED);
            }
        }
        location.exiting();
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Collection selectM1XMI(IConnection connection, int workspaceSid, String mofId) {
        Collection col;
        block18: {
            ResultSet set;
            PreparedStatement stmt;
            Connection con;
            block15: {
                col = null;
                String method = "selectM1XMI(IConnection connection, int workspaceSid, String mofId)";
                location.entering("selectM1XMI(IConnection connection, int workspaceSid, String mofId)");
                con = this.getConnection();
                stmt = this.getPSSelectXMLOM1(con);
                set = null;
                String qn = null;
                stmt.setInt(1, workspaceSid);
                stmt.setString(2, mofId);
                set = stmt.executeQuery();
                String data = null;
                while (set.next()) {
                    data = set.getString(1);
                    int qnsid = set.getInt(2);
                    qn = this.getValueBySID("OBJTYPE", qnsid);
                }
                if (data != null && data.length() > 0) {
                    col = this.decodeObjectXML(connection, data, 1);
                }
                RefObject o = null;
                if (col != null && col.size() == 1) {
                    o = (RefObject)col.iterator().next();
                }
                if (o == null || !(o instanceof IMMRObject)) break block15;
                ((IMMRObject)o).set___QualifiedName(qn);
            }
            Object var13_14 = null;
            RepositoryDB.conClose(con, "selectM1XMI(IConnection connection, int workspaceSid, String mofId)");
            try {
                set.close();
            }
            catch (Exception e2) {
                RepositoryDB.writeExceptionToLog("selectM1XMI(IConnection connection, int workspaceSid, String mofId)", e2);
            }
            try {
                stmt.close();
            }
            catch (Exception e2) {
                RepositoryDB.writeExceptionToLog("selectM1XMI(IConnection connection, int workspaceSid, String mofId)", e2);
            }
            break block18;
            {
                catch (Exception e) {
                    RepositoryDB.writeExceptionToLog("selectM1XMI(IConnection connection, int workspaceSid, String mofId)", e);
                    Object var13_15 = null;
                    RepositoryDB.conClose(con, "selectM1XMI(IConnection connection, int workspaceSid, String mofId)");
                    try {
                        set.close();
                    }
                    catch (Exception e2) {
                        RepositoryDB.writeExceptionToLog("selectM1XMI(IConnection connection, int workspaceSid, String mofId)", e2);
                    }
                    try {
                        stmt.close();
                    }
                    catch (Exception e2) {
                        RepositoryDB.writeExceptionToLog("selectM1XMI(IConnection connection, int workspaceSid, String mofId)", e2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var13_16 = null;
                RepositoryDB.conClose(con, "selectM1XMI(IConnection connection, int workspaceSid, String mofId)");
                try {
                    set.close();
                }
                catch (Exception e2) {
                    RepositoryDB.writeExceptionToLog("selectM1XMI(IConnection connection, int workspaceSid, String mofId)", e2);
                }
                try {
                    stmt.close();
                }
                catch (Exception e2) {
                    RepositoryDB.writeExceptionToLog("selectM1XMI(IConnection connection, int workspaceSid, String mofId)", e2);
                }
                throw throwable;
            }
        }
        location.exiting();
        return col;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Object selectM1Ser(IConnection connection, int workspaceSid, String mofId) {
        Object o;
        block22: {
            ResultSet set;
            PreparedStatement stmt;
            Connection con;
            block19: {
                o = null;
                String method = "selectM1Ser(IConnection connection, int workspaceSid, String mofId)";
                location.entering("selectM1Ser(IConnection connection, int workspaceSid, String mofId)");
                con = this.getConnection();
                stmt = this.getPSSelectSerOM1(con);
                set = null;
                String qn = null;
                stmt.setInt(1, workspaceSid);
                stmt.setString(2, mofId);
                set = stmt.executeQuery();
                byte[] b = null;
                int qnsid = -1;
                while (set.next()) {
                    b = set.getBytes(1);
                    qnsid = set.getInt(2);
                }
                if (b != null) {
                    qn = this.getValueBySID("OBJTYPE", qnsid);
                    try {
                        ByteArrayInputStream bais = new ByteArrayInputStream(b);
                        ObjectInputStreamWithClassLoader ois = new ObjectInputStreamWithClassLoader((InputStream)bais, (IRepositoryClassLoader)this.repositoryServer, connection);
                        o = ois.readObject();
                    }
                    catch (ClassNotFoundException e) {
                        o = null;
                    }
                    catch (InvalidClassException e) {
                        o = null;
                    }
                    catch (EOFException e) {
                        o = null;
                    }
                    catch (Exception e) {
                        RepositoryDB.writeExceptionToLog("selectM1Ser(IConnection connection, int workspaceSid, String mofId)", e);
                    }
                }
                if (o == null || !(o instanceof IMMRObject)) break block19;
                ((IMMRObject)o).set___QualifiedName(qn);
            }
            Object var15_19 = null;
            RepositoryDB.conClose(con, "selectM1Ser(IConnection connection, int workspaceSid, String mofId)");
            try {
                set.close();
            }
            catch (Exception e2) {
                RepositoryDB.writeExceptionToLog("selectM1Ser(IConnection connection, int workspaceSid, String mofId)", e2);
            }
            try {
                stmt.close();
            }
            catch (Exception e2) {
                RepositoryDB.writeExceptionToLog("selectM1Ser(IConnection connection, int workspaceSid, String mofId)", e2);
            }
            break block22;
            {
                catch (Exception e) {
                    RepositoryDB.writeExceptionToLog("selectM1Ser(IConnection connection, int workspaceSid, String mofId)", e);
                    Object var15_20 = null;
                    RepositoryDB.conClose(con, "selectM1Ser(IConnection connection, int workspaceSid, String mofId)");
                    try {
                        set.close();
                    }
                    catch (Exception e2) {
                        RepositoryDB.writeExceptionToLog("selectM1Ser(IConnection connection, int workspaceSid, String mofId)", e2);
                    }
                    try {
                        stmt.close();
                    }
                    catch (Exception e2) {
                        RepositoryDB.writeExceptionToLog("selectM1Ser(IConnection connection, int workspaceSid, String mofId)", e2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var15_21 = null;
                RepositoryDB.conClose(con, "selectM1Ser(IConnection connection, int workspaceSid, String mofId)");
                try {
                    set.close();
                }
                catch (Exception e2) {
                    RepositoryDB.writeExceptionToLog("selectM1Ser(IConnection connection, int workspaceSid, String mofId)", e2);
                }
                try {
                    stmt.close();
                }
                catch (Exception e2) {
                    RepositoryDB.writeExceptionToLog("selectM1Ser(IConnection connection, int workspaceSid, String mofId)", e2);
                }
                throw throwable;
            }
        }
        location.exiting();
        return o;
    }

    public byte[] loadJavaClass(String className) {
        return this.loadJavaClass(className, null);
    }

    public byte[] loadJavaClass(String className, Set workspaces) {
        String method = "loadJavaClass(IConnection connection, String className)";
        location.entering("loadJavaClass(IConnection connection, String className)");
        byte[] data = null;
        HashSet<Workspace> set = workspaces;
        if (set == null) {
            set = new HashSet<Workspace>();
            set.add(new Workspace("[default]"));
        }
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            Workspace w = (Workspace)iter.next();
            int wsSid = this.getSIDForValue("WORKSPACE", w.getName());
            if (wsSid < 0) continue;
            data = this.selectClassDataM2(wsSid, className);
        }
        return data;
    }

    public Set getWorkspaces() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private byte[] selectClassDataM2(int workspaceSid, String className) {
        byte[] classData;
        block18: {
            classData = null;
            String method = "selectClassDataM2(int workspaceSid, String className)";
            location.entering("selectClassDataM2(int workspaceSid, String className)");
            int cnSid = this.getSIDForValue("JAVACLNAME", className.toLowerCase());
            Connection con = this.getConnection();
            PreparedStatement stmt = this.getPSSelectCM2(con);
            ResultSet set = null;
            stmt.setInt(1, workspaceSid);
            stmt.setInt(2, cnSid);
            set = stmt.executeQuery();
            byte[] b = null;
            while (set.next()) {
                b = set.getBytes(1);
            }
            if (b != null) {
                try {
                    ByteArrayInputStream bais = new ByteArrayInputStream(b);
                    classData = this.getBytesOfInputStream(bais);
                }
                catch (Exception e1) {
                    RepositoryDB.writeExceptionToLog("selectClassDataM2(int workspaceSid, String className)", e1);
                }
            }
            Object var12_13 = null;
            RepositoryDB.conClose(con, "selectClassDataM2(int workspaceSid, String className)");
            try {
                set.close();
            }
            catch (Exception e2) {
                RepositoryDB.writeExceptionToLog("selectClassDataM2(int workspaceSid, String className)", e2);
            }
            try {
                stmt.close();
            }
            catch (Exception e2) {
                RepositoryDB.writeExceptionToLog("selectClassDataM2(int workspaceSid, String className)", e2);
            }
            break block18;
            {
                catch (Exception e) {
                    RepositoryDB.writeExceptionToLog("selectClassDataM2(int workspaceSid, String className)", e);
                    Object var12_14 = null;
                    RepositoryDB.conClose(con, "selectClassDataM2(int workspaceSid, String className)");
                    try {
                        set.close();
                    }
                    catch (Exception e2) {
                        RepositoryDB.writeExceptionToLog("selectClassDataM2(int workspaceSid, String className)", e2);
                    }
                    try {
                        stmt.close();
                    }
                    catch (Exception e2) {
                        RepositoryDB.writeExceptionToLog("selectClassDataM2(int workspaceSid, String className)", e2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var12_15 = null;
                RepositoryDB.conClose(con, "selectClassDataM2(int workspaceSid, String className)");
                try {
                    set.close();
                }
                catch (Exception e2) {
                    RepositoryDB.writeExceptionToLog("selectClassDataM2(int workspaceSid, String className)", e2);
                }
                try {
                    stmt.close();
                }
                catch (Exception e2) {
                    RepositoryDB.writeExceptionToLog("selectClassDataM2(int workspaceSid, String className)", e2);
                }
                throw throwable;
            }
        }
        location.exiting();
        return classData;
    }

    public ModelElement resolveQualifiedNameM2(IConnection connection, List qualifiedName) throws BaseException, BaseRuntimeException {
        if (qualifiedName == null) {
            return null;
        }
        String method = "resolveQualifiedNameM2(IConnection connection, List qualifiedName)";
        location.entering("resolveQualifiedNameM2(IConnection connection, List qualifiedName)");
        String qn = Utilities.getUtilities().encodeQualifiedName(qualifiedName);
        ModelElement me = null;
        Iterator iterW = this.getWorkspacesDB(connection.getConnectionSpec().getWorkspacesM2()).iterator();
        while (iterW.hasNext() && me == null) {
            String data;
            Collection col;
            Workspace w = (Workspace)iterW.next();
            int wsSid = this.getSIDForValue("WORKSPACE", w.getName());
            me = this.selectM2SerQn(wsSid, qn);
            if (me == null && (col = this.decodeObjectXML(connection, data = this.selectM2XMIQn(wsSid, qn), 2)) != null && col.size() > 0) {
                me = (ModelElement)col.iterator().next();
                Connection con = this.getConnection();
                this.updateM2Ser(con, wsSid, col);
                RepositoryDB.conCommit(con, "resolveQualifiedNameM2(IConnection connection, List qualifiedName)");
                RepositoryDB.conClose(con, "resolveQualifiedNameM2(IConnection connection, List qualifiedName)");
            }
            if (!(me instanceof IModelElement)) continue;
            IModelElement ime = (IModelElement)me;
            IRepository repository = Repository.getInstance((IConnection)connection);
            ime.setRepository(repository);
            ime.setMofLayer(2);
            ime.setState(StateEnum.STATE_UNCHANGED);
        }
        location.exiting();
        return me;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String selectM2XMIQn(int workspaceSid, String qualifiedName) {
        String data;
        block20: {
            data = null;
            if (qualifiedName == null) {
                return data;
            }
            String method = "selectM2XMIQn(int workspaceSid,String qualifiedName)";
            location.entering("selectM2XMIQn(int workspaceSid,String qualifiedName)");
            Connection con = this.getConnection();
            PreparedStatement stmt = this.getPSSelectXMLOM2Qn(con);
            ResultSet set = null;
            stmt.setInt(1, workspaceSid);
            stmt.setString(2, qualifiedName);
            set = stmt.executeQuery();
            while (set.next()) {
                data = set.getString(1);
            }
            Object var10_8 = null;
            RepositoryDB.conClose(con, "selectM2XMIQn(int workspaceSid,String qualifiedName)");
            try {
                set.close();
            }
            catch (Exception e2) {
                RepositoryDB.writeExceptionToLog("selectM2XMIQn(int workspaceSid,String qualifiedName)", e2);
            }
            try {
                stmt.close();
            }
            catch (Exception e2) {
                RepositoryDB.writeExceptionToLog("selectM2XMIQn(int workspaceSid,String qualifiedName)", e2);
            }
            break block20;
            {
                catch (Exception e) {
                    RepositoryDB.writeExceptionToLog("selectM2XMIQn(int workspaceSid,String qualifiedName)", e);
                    Object var10_9 = null;
                    RepositoryDB.conClose(con, "selectM2XMIQn(int workspaceSid,String qualifiedName)");
                    try {
                        set.close();
                    }
                    catch (Exception e2) {
                        RepositoryDB.writeExceptionToLog("selectM2XMIQn(int workspaceSid,String qualifiedName)", e2);
                    }
                    try {
                        stmt.close();
                    }
                    catch (Exception e2) {
                        RepositoryDB.writeExceptionToLog("selectM2XMIQn(int workspaceSid,String qualifiedName)", e2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                RepositoryDB.conClose(con, "selectM2XMIQn(int workspaceSid,String qualifiedName)");
                try {
                    set.close();
                }
                catch (Exception e2) {
                    RepositoryDB.writeExceptionToLog("selectM2XMIQn(int workspaceSid,String qualifiedName)", e2);
                }
                try {
                    stmt.close();
                }
                catch (Exception e2) {
                    RepositoryDB.writeExceptionToLog("selectM2XMIQn(int workspaceSid,String qualifiedName)", e2);
                }
                throw throwable;
            }
        }
        if (data == null) {
            if (qualifiedName.compareTo("Model.Package") == 0) {
                data = this.selectM2XMIQn(workspaceSid, "Model.MofPackage");
            }
            if (qualifiedName.compareTo("Model.Class") == 0) {
                data = this.selectM2XMIQn(workspaceSid, "Model.MofClass");
            }
            if (qualifiedName.compareTo("Model.Exception") == 0) {
                data = this.selectM2XMIQn(workspaceSid, "Model.MofException");
            }
        }
        location.exiting();
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private ModelElement selectM2SerQn(int workspaceSid, String qualifiedName) {
        ModelElement me;
        block26: {
            me = null;
            if (qualifiedName == null) {
                return me;
            }
            String method = "selectM2SerQn(int workspaceSid,String qualifiedName)";
            location.entering("selectM2SerQn(int workspaceSid,String qualifiedName)");
            Connection con = this.getConnection();
            PreparedStatement stmt = this.getPSSelectSerOM2Qn(con);
            ResultSet set = null;
            stmt.setInt(1, workspaceSid);
            stmt.setString(2, qualifiedName);
            set = stmt.executeQuery();
            byte[] b = null;
            while (set.next()) {
                b = set.getBytes(1);
            }
            if (b != null) {
                try {
                    ByteArrayInputStream bais = new ByteArrayInputStream(b);
                    ObjectInputStream ois = new ObjectInputStream(bais);
                    me = (ModelElement)ois.readObject();
                }
                catch (ClassNotFoundException e) {
                    me = null;
                }
                catch (InvalidClassException e) {
                    me = null;
                }
                catch (EOFException e) {
                    me = null;
                }
                catch (Exception e) {
                    RepositoryDB.writeExceptionToLog("selectM2SerQn(int workspaceSid,String qualifiedName)", e);
                }
            }
            Object var12_16 = null;
            RepositoryDB.conClose(con, "selectM2SerQn(int workspaceSid,String qualifiedName)");
            try {
                set.close();
            }
            catch (Exception e2) {
                RepositoryDB.writeExceptionToLog("selectM2SerQn(int workspaceSid,String qualifiedName)", e2);
            }
            try {
                stmt.close();
            }
            catch (Exception e2) {
                RepositoryDB.writeExceptionToLog("selectM2SerQn(int workspaceSid,String qualifiedName)", e2);
            }
            break block26;
            {
                catch (Exception e) {
                    RepositoryDB.writeExceptionToLog("selectM2SerQn(int workspaceSid,String qualifiedName)", e);
                    Object var12_17 = null;
                    RepositoryDB.conClose(con, "selectM2SerQn(int workspaceSid,String qualifiedName)");
                    try {
                        set.close();
                    }
                    catch (Exception e2) {
                        RepositoryDB.writeExceptionToLog("selectM2SerQn(int workspaceSid,String qualifiedName)", e2);
                    }
                    try {
                        stmt.close();
                    }
                    catch (Exception e2) {
                        RepositoryDB.writeExceptionToLog("selectM2SerQn(int workspaceSid,String qualifiedName)", e2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var12_18 = null;
                RepositoryDB.conClose(con, "selectM2SerQn(int workspaceSid,String qualifiedName)");
                try {
                    set.close();
                }
                catch (Exception e2) {
                    RepositoryDB.writeExceptionToLog("selectM2SerQn(int workspaceSid,String qualifiedName)", e2);
                }
                try {
                    stmt.close();
                }
                catch (Exception e2) {
                    RepositoryDB.writeExceptionToLog("selectM2SerQn(int workspaceSid,String qualifiedName)", e2);
                }
                throw throwable;
            }
        }
        if (me == null) {
            if (qualifiedName.compareTo("Model.Package") == 0) {
                me = this.selectM2SerQn(workspaceSid, "Model.MofPackage");
            }
            if (qualifiedName.compareTo("Model.Class") == 0) {
                me = this.selectM2SerQn(workspaceSid, "Model.MofClass");
            }
            if (qualifiedName.compareTo("Model.Exception") == 0) {
                me = this.selectM2SerQn(workspaceSid, "Model.MofException");
            }
        }
        location.exiting();
        return me;
    }

    public Collection selectM2AllOfClass(IConnection connection, List qualifiedName) throws BaseException, BaseRuntimeException {
        String method = "selectM2AllOfClass(IConnection connection, List qualifiedName)";
        location.entering("selectM2AllOfClass(IConnection connection, List qualifiedName)");
        LinkedList col = new LinkedList();
        String qn = Utilities.getUtilities().encodeQualifiedName(qualifiedName);
        int type = this.getSIDForValue("OBJTYPE", qn);
        Iterator iterW = this.getWorkspacesDB(connection.getConnectionSpec().getWorkspacesM2()).iterator();
        while (iterW.hasNext()) {
            Collection c;
            Workspace w = (Workspace)iterW.next();
            int wsSid = this.getSIDForValue("WORKSPACE", w.getName());
            Collection mofIds = this.selectM2AllOfClass(wsSid, type);
            if (mofIds == null || (c = this.selectM2(connection, mofIds, false)) == null) continue;
            col.addAll(c);
        }
        if (qn.compareTo("Model.Package") == 0) {
            col.addAll(this.selectM2AllOfClass(connection, Utilities.getUtilities().decodeQualifiedName("Model.MofPackage")));
        }
        if (qn.compareTo("Model.Class") == 0) {
            col.addAll(this.selectM2AllOfClass(connection, Utilities.getUtilities().decodeQualifiedName("Model.MofClass")));
        }
        if (qn.compareTo("Model.Exception") == 0) {
            col.addAll(this.selectM2AllOfClass(connection, Utilities.getUtilities().decodeQualifiedName("Model.MofException")));
        }
        location.exiting();
        return col;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Collection selectM2AllOfClass(int workspaceSid, int type) throws BaseException, BaseRuntimeException {
        LinkedList<String> col;
        block16: {
            col = new LinkedList<String>();
            String method = "selectM2AllOfClass(int workspaceSid,int type)";
            location.entering("selectM2AllOfClass(int workspaceSid,int type)");
            String sql = "SELECT MOFID FROM " + this.tableOM2.getName() + " WHERE " + "WORKSPACE" + " = ? AND " + "OBJTYPE" + " = ?";
            PreparedStatement stmt = null;
            ResultSet set = null;
            Connection con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setInt(1, workspaceSid);
            stmt.setInt(2, type);
            set = stmt.executeQuery();
            if (set != null) {
                while (set.next()) {
                    String mofId = set.getString(1);
                    if (mofId == null) continue;
                    col.add(mofId);
                }
            }
            Object var11_11 = null;
            RepositoryDB.conClose(con, "selectM2AllOfClass(int workspaceSid,int type)");
            try {
                set.close();
            }
            catch (Exception e2) {
                RepositoryDB.writeExceptionToLog("selectM2AllOfClass(int workspaceSid,int type)", e2);
            }
            try {
                stmt.close();
            }
            catch (Exception e2) {
                RepositoryDB.writeExceptionToLog("selectM2AllOfClass(int workspaceSid,int type)", e2);
            }
            break block16;
            {
                catch (Exception e) {
                    RepositoryDB.writeExceptionToLog("selectM2AllOfClass(int workspaceSid,int type)", e);
                    Object var11_12 = null;
                    RepositoryDB.conClose(con, "selectM2AllOfClass(int workspaceSid,int type)");
                    try {
                        set.close();
                    }
                    catch (Exception e2) {
                        RepositoryDB.writeExceptionToLog("selectM2AllOfClass(int workspaceSid,int type)", e2);
                    }
                    try {
                        stmt.close();
                    }
                    catch (Exception e2) {
                        RepositoryDB.writeExceptionToLog("selectM2AllOfClass(int workspaceSid,int type)", e2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                RepositoryDB.conClose(con, "selectM2AllOfClass(int workspaceSid,int type)");
                try {
                    set.close();
                }
                catch (Exception e2) {
                    RepositoryDB.writeExceptionToLog("selectM2AllOfClass(int workspaceSid,int type)", e2);
                }
                try {
                    stmt.close();
                }
                catch (Exception e2) {
                    RepositoryDB.writeExceptionToLog("selectM2AllOfClass(int workspaceSid,int type)", e2);
                }
                throw throwable;
            }
        }
        location.exiting();
        return col;
    }

    public Collection selectM1AllOfClass(IConnection connection, List qualifiedName) throws BaseException, BaseRuntimeException {
        String method = "selectM1AllOfClass(IConnection connection, List qualifiedName)";
        location.entering("selectM1AllOfClass(IConnection connection, List qualifiedName)");
        int type = this.getSIDForValue("OBJTYPE", Utilities.getUtilities().encodeQualifiedName(qualifiedName));
        LinkedList col = new LinkedList();
        Iterator iterW = this.getWorkspacesDB(connection.getConnectionSpec().getWorkspacesM1()).iterator();
        while (iterW.hasNext()) {
            Collection c;
            Workspace w = (Workspace)iterW.next();
            int wsSid = this.getSIDForValue("WORKSPACE", w.getName());
            Collection mofIds = this.selectM1AllOfClass(wsSid, type);
            if (mofIds == null || mofIds.size() <= 0 || (c = this.selectM1(connection, mofIds, false)) == null) continue;
            col.addAll(c);
        }
        location.exiting();
        return col;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Collection selectM1AllOfClass(int workspaceSid, int type) throws BaseException, BaseRuntimeException {
        LinkedList<String> col;
        block16: {
            col = new LinkedList<String>();
            String method = "selectM1AllOfClass(int workspaceSid,int type)";
            location.entering("selectM1AllOfClass(int workspaceSid,int type)");
            String sql = "SELECT MOFID FROM " + this.tableOM1.getName() + " WHERE " + "WORKSPACE" + " = ? AND " + "OBJTYPE" + " = ?";
            PreparedStatement stmt = null;
            ResultSet set = null;
            Connection con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setInt(1, workspaceSid);
            stmt.setInt(2, type);
            set = stmt.executeQuery();
            if (set != null) {
                while (set.next()) {
                    String mofId = set.getString(1);
                    if (mofId == null) continue;
                    col.add(mofId);
                }
            }
            Object var11_11 = null;
            RepositoryDB.conClose(con, "selectM1AllOfClass(int workspaceSid,int type)");
            try {
                set.close();
            }
            catch (Exception e2) {
                RepositoryDB.writeExceptionToLog("selectM1AllOfClass(int workspaceSid,int type)", e2);
            }
            try {
                stmt.close();
            }
            catch (Exception e2) {
                RepositoryDB.writeExceptionToLog("selectM1AllOfClass(int workspaceSid,int type)", e2);
            }
            break block16;
            {
                catch (Exception e) {
                    RepositoryDB.writeExceptionToLog("selectM1AllOfClass(int workspaceSid,int type)", e);
                    Object var11_12 = null;
                    RepositoryDB.conClose(con, "selectM1AllOfClass(int workspaceSid,int type)");
                    try {
                        set.close();
                    }
                    catch (Exception e2) {
                        RepositoryDB.writeExceptionToLog("selectM1AllOfClass(int workspaceSid,int type)", e2);
                    }
                    try {
                        stmt.close();
                    }
                    catch (Exception e2) {
                        RepositoryDB.writeExceptionToLog("selectM1AllOfClass(int workspaceSid,int type)", e2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                RepositoryDB.conClose(con, "selectM1AllOfClass(int workspaceSid,int type)");
                try {
                    set.close();
                }
                catch (Exception e2) {
                    RepositoryDB.writeExceptionToLog("selectM1AllOfClass(int workspaceSid,int type)", e2);
                }
                try {
                    stmt.close();
                }
                catch (Exception e2) {
                    RepositoryDB.writeExceptionToLog("selectM1AllOfClass(int workspaceSid,int type)", e2);
                }
                throw throwable;
            }
        }
        location.exiting();
        return col;
    }

    public ListInstanceInfo selectM1InstanceInfos(IConnection connection, List qualifiedName, String pattern) throws BaseException, BaseRuntimeException {
        Collection col = this.selectM1AllOfClass(connection, qualifiedName);
        ListInstanceInfo lli = new ListInstanceInfo();
        if (col != null) {
            String type = Utilities.getUtilities().encodeQualifiedName(qualifiedName);
            Iterator i = col.iterator();
            while (i.hasNext()) {
                RefBaseObject rbo = (RefBaseObject)i.next();
                String lastChangedAt = "";
                if (rbo instanceof IMMRObject) {
                    lastChangedAt = ((IMMRObject)rbo).get___LastChangedAt();
                }
                ListInstanceInfo.InstanceInfo ii = new ListInstanceInfo.InstanceInfo(rbo.refMofId(), type, null, lastChangedAt, rbo);
                lli.add((Object)ii);
            }
        }
        return lli;
    }

    public String getQualifiedNameM1(IConnection connection, RefBaseObject rbo) throws BaseException, BaseRuntimeException {
        return null;
    }

    public Collection selectM1AllClasses(IConnection connection) throws BaseException, BaseRuntimeException {
        return null;
    }

    public List selectM2All(IConnection connection) throws BaseException, BaseRuntimeException {
        String method = "selectM2All(IConnection connection)";
        location.entering("selectM2All(IConnection connection)");
        LinkedList list = new LinkedList();
        Iterator iterW = this.getWorkspacesDB(connection.getConnectionSpec().getWorkspacesM2()).iterator();
        while (iterW.hasNext()) {
            Collection c;
            Workspace w = (Workspace)iterW.next();
            int wsSid = this.getSIDForValue("WORKSPACE", w.getName());
            List mofIds = this.selectM2All(wsSid);
            if (mofIds == null || (c = this.selectM2(connection, mofIds, false)) == null) continue;
            list.addAll(c);
        }
        location.exiting();
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private List selectM2All(int workspaceSid) throws BaseException, BaseRuntimeException {
        LinkedList<String> list;
        block16: {
            list = new LinkedList<String>();
            String method = "selectM2All(int workspaceSid)";
            location.entering("selectM2All(int workspaceSid)");
            String sql = "SELECT MOFID FROM " + this.tableOM2.getName() + " WHERE " + "WORKSPACE" + " = ?";
            PreparedStatement stmt = null;
            ResultSet set = null;
            Connection con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setInt(1, workspaceSid);
            set = stmt.executeQuery();
            if (set != null) {
                while (set.next()) {
                    String mofId = set.getString(1);
                    if (mofId == null) continue;
                    list.add(mofId);
                }
            }
            Object var10_10 = null;
            RepositoryDB.conClose(con, "selectM2All(int workspaceSid)");
            try {
                set.close();
            }
            catch (Exception e2) {
                RepositoryDB.writeExceptionToLog("selectM2All(int workspaceSid)", e2);
            }
            try {
                stmt.close();
            }
            catch (Exception e2) {
                RepositoryDB.writeExceptionToLog("selectM2All(int workspaceSid)", e2);
            }
            break block16;
            {
                catch (Exception e) {
                    RepositoryDB.writeExceptionToLog("selectM2All(int workspaceSid)", e);
                    Object var10_11 = null;
                    RepositoryDB.conClose(con, "selectM2All(int workspaceSid)");
                    try {
                        set.close();
                    }
                    catch (Exception e2) {
                        RepositoryDB.writeExceptionToLog("selectM2All(int workspaceSid)", e2);
                    }
                    try {
                        stmt.close();
                    }
                    catch (Exception e2) {
                        RepositoryDB.writeExceptionToLog("selectM2All(int workspaceSid)", e2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                RepositoryDB.conClose(con, "selectM2All(int workspaceSid)");
                try {
                    set.close();
                }
                catch (Exception e2) {
                    RepositoryDB.writeExceptionToLog("selectM2All(int workspaceSid)", e2);
                }
                try {
                    stmt.close();
                }
                catch (Exception e2) {
                    RepositoryDB.writeExceptionToLog("selectM2All(int workspaceSid)", e2);
                }
                throw throwable;
            }
        }
        location.exiting();
        return list;
    }

    public List selectM1All(IConnection connection) throws BaseException, BaseRuntimeException {
        String method = "selectM1All(IConnection connection)";
        location.entering("selectM1All(IConnection connection)");
        LinkedList list = new LinkedList();
        Iterator iterW = this.getWorkspacesDB(connection.getConnectionSpec().getWorkspacesM1()).iterator();
        while (iterW.hasNext()) {
            Collection c;
            Workspace w = (Workspace)iterW.next();
            int wsSid = this.getSIDForValue("WORKSPACE", w.getName());
            List mofIds = this.selectM1All(wsSid);
            if (mofIds == null || (c = this.selectM1(connection, mofIds, false)) == null) continue;
            list.addAll(c);
        }
        location.exiting();
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private List selectM1All(int workspaceSid) throws BaseException, BaseRuntimeException {
        LinkedList<String> list;
        block16: {
            list = new LinkedList<String>();
            String method = "selectM1All(int workspaceSid)";
            location.entering("selectM1All(int workspaceSid)");
            String sql = "SELECT MOFID FROM " + this.tableOM1.getName() + " WHERE " + "WORKSPACE" + " = ?";
            PreparedStatement stmt = null;
            ResultSet set = null;
            Connection con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setInt(1, workspaceSid);
            set = stmt.executeQuery();
            if (set != null) {
                while (set.next()) {
                    String mofId = set.getString(1);
                    if (mofId == null) continue;
                    list.add(mofId);
                }
            }
            Object var10_10 = null;
            RepositoryDB.conClose(con, "selectM1All(int workspaceSid)");
            try {
                set.close();
            }
            catch (Exception e2) {
                RepositoryDB.writeExceptionToLog("selectM1All(int workspaceSid)", e2);
            }
            try {
                stmt.close();
            }
            catch (Exception e2) {
                RepositoryDB.writeExceptionToLog("selectM1All(int workspaceSid)", e2);
            }
            break block16;
            {
                catch (Exception e) {
                    RepositoryDB.writeExceptionToLog("selectM1All(int workspaceSid)", e);
                    Object var10_11 = null;
                    RepositoryDB.conClose(con, "selectM1All(int workspaceSid)");
                    try {
                        set.close();
                    }
                    catch (Exception e2) {
                        RepositoryDB.writeExceptionToLog("selectM1All(int workspaceSid)", e2);
                    }
                    try {
                        stmt.close();
                    }
                    catch (Exception e2) {
                        RepositoryDB.writeExceptionToLog("selectM1All(int workspaceSid)", e2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                RepositoryDB.conClose(con, "selectM1All(int workspaceSid)");
                try {
                    set.close();
                }
                catch (Exception e2) {
                    RepositoryDB.writeExceptionToLog("selectM1All(int workspaceSid)", e2);
                }
                try {
                    stmt.close();
                }
                catch (Exception e2) {
                    RepositoryDB.writeExceptionToLog("selectM1All(int workspaceSid)", e2);
                }
                throw throwable;
            }
        }
        location.exiting();
        return list;
    }

    public IMMRObject selectM1ByName(IConnection connection, String type, List args, List instantiators, boolean forUpdate) throws BaseException, BaseRuntimeException {
        String method = "selectM1ByName(IConnection connection,String type,List args,List instantiators,boolean forUpdate)";
        location.entering("selectM1ByName(IConnection connection,String type,List args,List instantiators,boolean forUpdate)");
        RepositoryServer.getCategory().errorT(location, "selectM1ByName(IConnection connection,String type,List args,List instantiators,boolean forUpdate)", MMRResourceAccessor.getInstance().getMessageText("0000"));
        location.exiting();
        return null;
    }

    public boolean insertM2Assoc(IConnection connection, Map aoos) throws BaseException, BaseRuntimeException {
        String method = "insertM2Assoc(IConnection connection, Map aoos)";
        location.entering("insertM2Assoc(IConnection connection, Map aoos)");
        if (!this.assertTransactionActive("insertM2Assoc(IConnection connection, Map aoos)", connection)) {
            return false;
        }
        boolean flag = true;
        Iterator iterW = this.getWorkspacesDB(connection.getConnectionSpec().getWorkspacesM2()).iterator();
        while (iterW.hasNext()) {
            Workspace w = (Workspace)iterW.next();
            if (w.isReadOnly()) continue;
            Iterator iter = aoos.values().iterator();
            while (iter.hasNext()) {
                AssociationsOfObject aoo = (AssociationsOfObject)iter.next();
                if (aoo.getMofId().compareTo("MOF_PACKAGE_M2_ROOT") == 0) continue;
                String dataXML = aoo.encodeAssocXML(connection);
                byte[] dataSer = aoo.encodeAssocSer(connection);
                if (this.insertM2Assoc(connection, w, aoo.getMofId(), dataXML, dataSer)) continue;
                RepositoryServer.getCategory().errorT(location, "insertM2Assoc(IConnection connection, Map aoos)", MMRResourceAccessor.getInstance().getMessageText("3112"), new Object[]{aoo});
                flag = false;
            }
        }
        location.exiting();
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean insertM2Assoc(IConnection connection, Workspace workspace, String mofId, String dataXML, byte[] dataSer) throws BaseException, BaseRuntimeException {
        String method = "insertM2Assoc(Connection con,int workspaceSid,String mofId,String dataXML,byte dataSer[])";
        location.entering("insertM2Assoc(Connection con,int workspaceSid,String mofId,String dataXML,byte dataSer[])");
        boolean flag = false;
        Connection con = this.getConnection(connection);
        int workspaceSid = this.getSIDForValue("WORKSPACE", workspace.getName());
        PreparedStatement stmt = this.getPSUpdateAM2(con);
        try {
            stmt.setString(1, dataXML);
            stmt.setBytes(2, dataSer);
            stmt.setInt(3, workspaceSid);
            stmt.setString(4, mofId);
            int n = stmt.executeUpdate();
            if (n == 1) {
                connection.incrementCounter(this.getComponentNameMeasurement(workspace), PERF_COUNTER_M2_UPDATE_ASSOC);
                flag = true;
            }
        }
        catch (Exception e) {
            flag = false;
        }
        finally {
            try {
                stmt.close();
            }
            catch (Exception e) {
                RepositoryDB.writeExceptionToLog("insertM2Assoc(Connection con,int workspaceSid,String mofId,String dataXML,byte dataSer[])", e);
            }
        }
        if (!flag) {
            stmt = this.getPSInsertAM2(con);
            try {
                stmt.setInt(1, workspaceSid);
                stmt.setString(2, mofId);
                stmt.setString(3, dataXML);
                stmt.setBytes(4, dataSer);
                stmt.executeUpdate();
                flag = true;
                connection.incrementCounter(this.getComponentNameMeasurement(workspace), PERF_COUNTER_M2_INSERT_ASSOC);
            }
            catch (Exception e) {
                RepositoryDB.writeExceptionToLog("insertM2Assoc(Connection con,int workspaceSid,String mofId,String dataXML,byte dataSer[])", e);
                flag = false;
            }
            finally {
                try {
                    stmt.close();
                }
                catch (Exception e) {
                    RepositoryDB.writeExceptionToLog("insertM2Assoc(Connection con,int workspaceSid,String mofId,String dataXML,byte dataSer[])", e);
                }
            }
        }
        location.exiting();
        return flag;
    }

    public boolean insertM1Assoc(IConnection connection, Map aoos) throws BaseException, BaseRuntimeException {
        String method = "insertM1Assoc(IConnection connection, Map aoos)";
        location.entering("insertM1Assoc(IConnection connection, Map aoos)");
        if (!this.assertTransactionActive("insertM1Assoc(IConnection connection, Map aoos)", connection)) {
            return false;
        }
        boolean flag = true;
        Iterator iterW = this.getWorkspacesDB(connection.getConnectionSpec().getWorkspacesM1()).iterator();
        while (iterW.hasNext()) {
            Workspace w = (Workspace)iterW.next();
            if (w.isReadOnly()) continue;
            Iterator iter = aoos.values().iterator();
            while (iter.hasNext()) {
                AssociationsOfObject aoo = (AssociationsOfObject)iter.next();
                if (aoo.getMofId().compareTo("MOF_PACKAGE_M1_ROOT") == 0) continue;
                String dataXML = aoo.encodeAssocXML(connection);
                byte[] dataSer = aoo.encodeAssocSer(connection);
                if (this.insertM1Assoc(connection, w, aoo.getMofId(), dataXML, dataSer)) continue;
                RepositoryServer.getCategory().errorT(location, "insertM1Assoc(IConnection connection, Map aoos)", MMRResourceAccessor.getInstance().getMessageText("3112"), new Object[]{aoo});
                flag = false;
            }
        }
        location.exiting();
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean insertM1Assoc(IConnection connection, Workspace workspace, String mofId, String dataXML, byte[] dataSer) throws BaseException, BaseRuntimeException {
        boolean flag = false;
        String method = "insertM1Assoc(Connection con,int workspaceSid,String mofId,String dataXML,byte dataSer[])";
        location.entering("insertM1Assoc(Connection con,int workspaceSid,String mofId,String dataXML,byte dataSer[])");
        Connection con = this.getConnection(connection);
        int workspaceSid = this.getSIDForValue("WORKSPACE", workspace.getName());
        PreparedStatement stmt = this.getPSUpdateAM1(con);
        try {
            stmt.setString(1, dataXML);
            stmt.setBytes(2, dataSer);
            stmt.setInt(3, workspaceSid);
            stmt.setString(4, mofId);
            int n = stmt.executeUpdate();
            if (n == 1) {
                flag = true;
                connection.incrementCounter(this.getComponentNameMeasurement(workspace), PERF_COUNTER_M1_UPDATE_ASSOC);
            } else {
                flag = false;
            }
        }
        catch (Exception e) {
            RepositoryDB.writeExceptionToLog("insertM1Assoc(Connection con,int workspaceSid,String mofId,String dataXML,byte dataSer[])", e);
            flag = false;
        }
        finally {
            try {
                stmt.close();
            }
            catch (Exception e) {
                RepositoryDB.writeExceptionToLog("insertM1Assoc(Connection con,int workspaceSid,String mofId,String dataXML,byte dataSer[])", e);
            }
        }
        if (!flag) {
            stmt = this.getPSInsertAM1(con);
            try {
                stmt.setInt(1, workspaceSid);
                stmt.setString(2, mofId);
                stmt.setString(3, dataXML);
                stmt.setBytes(4, dataSer);
                stmt.executeUpdate();
                flag = true;
                connection.incrementCounter(this.getComponentNameMeasurement(workspace), PERF_COUNTER_M1_INSERT_ASSOC);
            }
            catch (Exception e) {
                RepositoryDB.writeExceptionToLog("insertM1Assoc(Connection con,int workspaceSid,String mofId,String dataXML,byte dataSer[])", e);
                flag = false;
            }
            finally {
                try {
                    stmt.close();
                }
                catch (Exception e) {
                    RepositoryDB.writeExceptionToLog("insertM1Assoc(Connection con,int workspaceSid,String mofId,String dataXML,byte dataSer[])", e);
                }
            }
        }
        location.exiting();
        return flag;
    }

    public boolean deleteM2Assoc(IConnection connection, Collection mofIds) throws BaseException, BaseRuntimeException {
        String method = "deleteM2Assoc(IConnection connection, Collection mofIds)";
        location.entering("deleteM2Assoc(IConnection connection, Collection mofIds)");
        if (!this.assertTransactionActive("deleteM2Assoc(IConnection connection, Collection mofIds)", connection)) {
            return false;
        }
        boolean flag = true;
        Iterator iterW = this.getWorkspacesDB(connection.getConnectionSpec().getWorkspacesM2()).iterator();
        while (iterW.hasNext()) {
            Workspace w = (Workspace)iterW.next();
            if (w.isReadOnly()) continue;
            Collection colFailed = this.deleteM2Assoc(connection, w, mofIds);
            if (colFailed != null && colFailed.size() > 0) {
                flag = false;
                continue;
            }
            flag = true;
        }
        location.exiting();
        return flag;
    }

    private Collection deleteM2Assoc(IConnection connection, Workspace workspace, Collection mofIds) {
        String method = "deleteM2Assoc(Connection con, int workspaceSid, Collection mofIds)";
        location.entering("deleteM2Assoc(Connection con, int workspaceSid, Collection mofIds)");
        Collection colFailed = null;
        Connection con = this.getConnection(connection);
        int workspaceSid = this.getSIDForValue("WORKSPACE", workspace.getName());
        PreparedStatement stmt = this.getPSDeleteAM2(con);
        Iterator iter = mofIds.iterator();
        while (iter.hasNext()) {
            String mofId = (String)iter.next();
            try {
                stmt.setInt(1, workspaceSid);
                stmt.setString(2, mofId);
                stmt.executeUpdate();
                connection.incrementCounter(this.getComponentNameMeasurement(workspace), PERF_COUNTER_M2_DELETE_ASSOC);
            }
            catch (Exception e) {
                colFailed = null;
            }
        }
        try {
            stmt.close();
        }
        catch (Exception e) {
            RepositoryDB.writeExceptionToLog("deleteM2Assoc(Connection con, int workspaceSid, Collection mofIds)", e);
        }
        location.exiting();
        return colFailed;
    }

    public boolean deleteM1Assoc(IConnection connection, Collection mofIds) throws BaseException, BaseRuntimeException {
        String method = "deleteM1Assoc(IConnection connection, Collection mofIds)";
        location.entering("deleteM1Assoc(IConnection connection, Collection mofIds)");
        if (!this.assertTransactionActive("deleteM1Assoc(IConnection connection, Collection mofIds)", connection)) {
            return false;
        }
        boolean flag = true;
        Iterator iterW = this.getWorkspacesDB(connection.getConnectionSpec().getWorkspacesM1()).iterator();
        while (iterW.hasNext()) {
            Workspace w = (Workspace)iterW.next();
            if (w.isReadOnly()) continue;
            Collection colFailed = this.deleteM1Assoc(connection, w, mofIds);
            if (colFailed != null && colFailed.size() > 0) {
                flag = false;
                continue;
            }
            flag = true;
        }
        location.exiting();
        return flag;
    }

    private Collection deleteM1Assoc(IConnection connection, Workspace workspace, Collection mofIds) {
        String method = "deleteM1Assoc(Connection con, int workspaceSid, Collection mofIds)";
        location.entering("deleteM1Assoc(Connection con, int workspaceSid, Collection mofIds)");
        Collection colFailed = null;
        Connection con = this.getConnection(connection);
        int workspaceSid = this.getSIDForValue("WORKSPACE", workspace.getName());
        PreparedStatement stmt = this.getPSDeleteAM1(con);
        Iterator iter = mofIds.iterator();
        while (iter.hasNext()) {
            String mofId = (String)iter.next();
            try {
                stmt.setInt(1, workspaceSid);
                stmt.setString(2, mofId);
                stmt.executeUpdate();
                connection.incrementCounter(workspace.getName(), PERF_COUNTER_M1_DELETE_ASSOC);
            }
            catch (Exception e) {
                colFailed = null;
            }
        }
        try {
            stmt.close();
        }
        catch (Exception e) {
            RepositoryDB.writeExceptionToLog("deleteM1Assoc(Connection con, int workspaceSid, Collection mofIds)", e);
        }
        location.exiting();
        return colFailed;
    }

    public AssociationsOfObject selectM2Assoc(IConnection connection, String associationId, String mofId) throws BaseException, BaseRuntimeException {
        String method = "selectM2Assoc(IConnection connection, String associationId, String mofId)";
        location.entering("selectM2Assoc(IConnection connection, String associationId, String mofId)");
        AssociationsOfObject aoo = null;
        Iterator iterW = this.getWorkspacesDB(connection.getConnectionSpec().getWorkspacesM2()).iterator();
        while (iterW.hasNext() && aoo == null) {
            Workspace w = (Workspace)iterW.next();
            int wsSid = this.getSIDForValue("WORKSPACE", w.getName());
            aoo = this.selectM2AssocSer(wsSid, mofId);
            if (aoo != null) {
                connection.incrementCounter(this.getComponentNameMeasurement(w), PERF_COUNTER_M2_SELECT_ASSOC_SER);
                continue;
            }
            connection.incrementCounter(this.getComponentNameMeasurement(w), PERF_COUNTER_M2_SELECT_ASSOC_XML);
            String data = this.selectM2AssocXML(wsSid, mofId);
            if (data == null || data.length() <= 0 || (aoo = AssociationsOfObject.decodeAssocXML((IConnection)connection, (byte[])data.getBytes())) == null) continue;
            HashMap<String, AssociationsOfObject> aoos = new HashMap<String, AssociationsOfObject>(1);
            aoos.put(aoo.getMofId(), aoo);
            this.insertM2Assoc(connection, aoos);
        }
        location.exiting();
        return aoo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String selectM2AssocXML(int workspaceSid, String mofId) {
        String data;
        block15: {
            data = null;
            String method = "selectM2AssocXML(int workspaceSid, String mofId)";
            location.entering("selectM2AssocXML(int workspaceSid, String mofId)");
            Connection con = this.getConnection();
            PreparedStatement stmt = this.getPSSelectXMLAM2(con);
            ResultSet set = null;
            stmt.setInt(1, workspaceSid);
            stmt.setString(2, mofId);
            set = stmt.executeQuery();
            while (set.next()) {
                data = set.getString(1);
            }
            Object var10_8 = null;
            RepositoryDB.conClose(con, "selectM2AssocXML(int workspaceSid, String mofId)");
            try {
                set.close();
            }
            catch (Exception e2) {
                RepositoryDB.writeExceptionToLog("selectM2AssocXML(int workspaceSid, String mofId)", e2);
            }
            try {
                stmt.close();
            }
            catch (Exception e2) {
                RepositoryDB.writeExceptionToLog("selectM2AssocXML(int workspaceSid, String mofId)", e2);
            }
            break block15;
            {
                catch (Exception e) {
                    RepositoryDB.writeExceptionToLog("selectM2AssocXML(int workspaceSid, String mofId)", e);
                    Object var10_9 = null;
                    RepositoryDB.conClose(con, "selectM2AssocXML(int workspaceSid, String mofId)");
                    try {
                        set.close();
                    }
                    catch (Exception e2) {
                        RepositoryDB.writeExceptionToLog("selectM2AssocXML(int workspaceSid, String mofId)", e2);
                    }
                    try {
                        stmt.close();
                    }
                    catch (Exception e2) {
                        RepositoryDB.writeExceptionToLog("selectM2AssocXML(int workspaceSid, String mofId)", e2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                RepositoryDB.conClose(con, "selectM2AssocXML(int workspaceSid, String mofId)");
                try {
                    set.close();
                }
                catch (Exception e2) {
                    RepositoryDB.writeExceptionToLog("selectM2AssocXML(int workspaceSid, String mofId)", e2);
                }
                try {
                    stmt.close();
                }
                catch (Exception e2) {
                    RepositoryDB.writeExceptionToLog("selectM2AssocXML(int workspaceSid, String mofId)", e2);
                }
                throw throwable;
            }
        }
        location.exiting();
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private AssociationsOfObject selectM2AssocSer(int workspaceSid, String mofId) {
        AssociationsOfObject aoo;
        block20: {
            aoo = null;
            String method = "selectM2AssocSer(int workspaceSid, String mofId)";
            location.entering("selectM2AssocSer(int workspaceSid, String mofId)");
            Connection con = this.getConnection();
            PreparedStatement stmt = this.getPSSelectSerAM2(con);
            ResultSet set = null;
            stmt.setInt(1, workspaceSid);
            stmt.setString(2, mofId);
            set = stmt.executeQuery();
            byte[] b = null;
            while (set.next()) {
                b = set.getBytes(1);
            }
            if (b != null) {
                try {
                    ByteArrayInputStream bais = new ByteArrayInputStream(b);
                    ObjectInputStream ois = new ObjectInputStream(bais);
                    aoo = (AssociationsOfObject)ois.readObject();
                }
                catch (InvalidClassException e0) {
                    aoo = null;
                }
                catch (EOFException e) {
                    aoo = null;
                }
                catch (Exception e1) {
                    RepositoryDB.writeExceptionToLog("selectM2AssocSer(int workspaceSid, String mofId)", e1);
                }
            }
            Object var12_15 = null;
            RepositoryDB.conClose(con, "selectM2AssocSer(int workspaceSid, String mofId)");
            try {
                set.close();
            }
            catch (Exception e2) {
                RepositoryDB.writeExceptionToLog("selectM2AssocSer(int workspaceSid, String mofId)", e2);
            }
            try {
                stmt.close();
            }
            catch (Exception e2) {
                RepositoryDB.writeExceptionToLog("selectM2AssocSer(int workspaceSid, String mofId)", e2);
            }
            break block20;
            {
                catch (Exception e) {
                    RepositoryDB.writeExceptionToLog("selectM2AssocSer(int workspaceSid, String mofId)", e);
                    Object var12_16 = null;
                    RepositoryDB.conClose(con, "selectM2AssocSer(int workspaceSid, String mofId)");
                    try {
                        set.close();
                    }
                    catch (Exception e2) {
                        RepositoryDB.writeExceptionToLog("selectM2AssocSer(int workspaceSid, String mofId)", e2);
                    }
                    try {
                        stmt.close();
                    }
                    catch (Exception e2) {
                        RepositoryDB.writeExceptionToLog("selectM2AssocSer(int workspaceSid, String mofId)", e2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var12_17 = null;
                RepositoryDB.conClose(con, "selectM2AssocSer(int workspaceSid, String mofId)");
                try {
                    set.close();
                }
                catch (Exception e2) {
                    RepositoryDB.writeExceptionToLog("selectM2AssocSer(int workspaceSid, String mofId)", e2);
                }
                try {
                    stmt.close();
                }
                catch (Exception e2) {
                    RepositoryDB.writeExceptionToLog("selectM2AssocSer(int workspaceSid, String mofId)", e2);
                }
                throw throwable;
            }
        }
        location.exiting();
        return aoo;
    }

    public AssociationsOfObject selectM1Assoc(IConnection connection, String associationId, String mofId) throws BaseException, BaseRuntimeException {
        String method = "selectM1Assoc(IConnection connection, String associationId, String mofId)";
        location.entering("selectM1Assoc(IConnection connection, String associationId, String mofId)");
        AssociationsOfObject aoo = null;
        Iterator iterW = this.getWorkspacesDB(connection.getConnectionSpec().getWorkspacesM1()).iterator();
        while (iterW.hasNext() && aoo == null) {
            Workspace w = (Workspace)iterW.next();
            int wsSid = this.getSIDForValue("WORKSPACE", w.getName());
            aoo = this.selectM1AssocSer(wsSid, mofId);
            if (aoo != null) {
                connection.incrementCounter(this.getComponentNameMeasurement(w), PERF_COUNTER_M1_SELECT_ASSOC_SER);
                continue;
            }
            connection.incrementCounter(this.getComponentNameMeasurement(w), PERF_COUNTER_M1_SELECT_ASSOC_XML);
            String data = this.selectM1AssocXML(wsSid, mofId);
            if (data == null || data.length() <= 0 || (aoo = AssociationsOfObject.decodeAssocXML((IConnection)connection, (byte[])data.getBytes())) == null) continue;
            HashMap<String, AssociationsOfObject> aoos = new HashMap<String, AssociationsOfObject>(1);
            aoos.put(aoo.getMofId(), aoo);
            this.insertM1Assoc(connection, aoos);
        }
        location.exiting();
        return aoo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String selectM1AssocXML(int workspaceSid, String mofId) {
        String data;
        block15: {
            data = null;
            String method = "selectM1AssocXML(int workspaceSid, String mofId)";
            location.entering("selectM1AssocXML(int workspaceSid, String mofId)");
            Connection con = this.getConnection();
            PreparedStatement stmt = this.getPSSelectXMLAM1(con);
            ResultSet set = null;
            stmt.setInt(1, workspaceSid);
            stmt.setString(2, mofId);
            set = stmt.executeQuery();
            while (set.next()) {
                data = set.getString(1);
            }
            Object var10_8 = null;
            RepositoryDB.conClose(con, "selectM1AssocXML(int workspaceSid, String mofId)");
            try {
                set.close();
            }
            catch (Exception e2) {
                RepositoryDB.writeExceptionToLog("selectM1AssocXML(int workspaceSid, String mofId)", e2);
            }
            try {
                stmt.close();
            }
            catch (Exception e2) {
                RepositoryDB.writeExceptionToLog("selectM1AssocXML(int workspaceSid, String mofId)", e2);
            }
            break block15;
            {
                catch (Exception e) {
                    RepositoryDB.writeExceptionToLog("selectM1AssocXML(int workspaceSid, String mofId)", e);
                    Object var10_9 = null;
                    RepositoryDB.conClose(con, "selectM1AssocXML(int workspaceSid, String mofId)");
                    try {
                        set.close();
                    }
                    catch (Exception e2) {
                        RepositoryDB.writeExceptionToLog("selectM1AssocXML(int workspaceSid, String mofId)", e2);
                    }
                    try {
                        stmt.close();
                    }
                    catch (Exception e2) {
                        RepositoryDB.writeExceptionToLog("selectM1AssocXML(int workspaceSid, String mofId)", e2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                RepositoryDB.conClose(con, "selectM1AssocXML(int workspaceSid, String mofId)");
                try {
                    set.close();
                }
                catch (Exception e2) {
                    RepositoryDB.writeExceptionToLog("selectM1AssocXML(int workspaceSid, String mofId)", e2);
                }
                try {
                    stmt.close();
                }
                catch (Exception e2) {
                    RepositoryDB.writeExceptionToLog("selectM1AssocXML(int workspaceSid, String mofId)", e2);
                }
                throw throwable;
            }
        }
        location.exiting();
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private AssociationsOfObject selectM1AssocSer(int workspaceSid, String mofId) {
        AssociationsOfObject aoo;
        block20: {
            aoo = null;
            String method = "selectM1AssocSer(int workspaceSid, String mofId)";
            location.entering("selectM1AssocSer(int workspaceSid, String mofId)");
            Connection con = this.getConnection();
            PreparedStatement stmt = this.getPSSelectSerAM1(con);
            ResultSet set = null;
            stmt.setInt(1, workspaceSid);
            stmt.setString(2, mofId);
            set = stmt.executeQuery();
            byte[] b = null;
            while (set.next()) {
                b = set.getBytes(1);
            }
            if (b != null) {
                try {
                    ByteArrayInputStream bais = new ByteArrayInputStream(b);
                    ObjectInputStream ois = new ObjectInputStream(bais);
                    aoo = (AssociationsOfObject)ois.readObject();
                }
                catch (InvalidClassException e0) {
                    aoo = null;
                }
                catch (EOFException e) {
                    aoo = null;
                }
                catch (Exception e1) {
                    RepositoryDB.writeExceptionToLog("selectM1AssocSer(int workspaceSid, String mofId)", e1);
                }
            }
            Object var12_15 = null;
            RepositoryDB.conClose(con, "selectM1AssocSer(int workspaceSid, String mofId)");
            try {
                set.close();
            }
            catch (Exception e2) {
                RepositoryDB.writeExceptionToLog("selectM1AssocSer(int workspaceSid, String mofId)", e2);
            }
            try {
                stmt.close();
            }
            catch (Exception e2) {
                RepositoryDB.writeExceptionToLog("selectM1AssocSer(int workspaceSid, String mofId)", e2);
            }
            break block20;
            {
                catch (Exception e) {
                    RepositoryDB.writeExceptionToLog("selectM1AssocSer(int workspaceSid, String mofId)", e);
                    Object var12_16 = null;
                    RepositoryDB.conClose(con, "selectM1AssocSer(int workspaceSid, String mofId)");
                    try {
                        set.close();
                    }
                    catch (Exception e2) {
                        RepositoryDB.writeExceptionToLog("selectM1AssocSer(int workspaceSid, String mofId)", e2);
                    }
                    try {
                        stmt.close();
                    }
                    catch (Exception e2) {
                        RepositoryDB.writeExceptionToLog("selectM1AssocSer(int workspaceSid, String mofId)", e2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var12_17 = null;
                RepositoryDB.conClose(con, "selectM1AssocSer(int workspaceSid, String mofId)");
                try {
                    set.close();
                }
                catch (Exception e2) {
                    RepositoryDB.writeExceptionToLog("selectM1AssocSer(int workspaceSid, String mofId)", e2);
                }
                try {
                    stmt.close();
                }
                catch (Exception e2) {
                    RepositoryDB.writeExceptionToLog("selectM1AssocSer(int workspaceSid, String mofId)", e2);
                }
                throw throwable;
            }
        }
        location.exiting();
        return aoo;
    }

    public RefObject selectM3(IConnection connection, String mofId) throws BaseException, BaseRuntimeException {
        String method = "selectM3(IConnection connection, String mofId)";
        RepositoryServer.getCategory().errorT(location, "selectM3(IConnection connection, String mofId)", MMRResourceAccessor.getInstance().getMessageText("0000"));
        return null;
    }

    public RefObject selectM3ByName(IConnection connection, String qualifiedName) throws BaseException, BaseRuntimeException {
        String method = " selectM3ByName(IConnection connection,String qualifiedName)";
        RepositoryServer.getCategory().errorT(location, " selectM3ByName(IConnection connection,String qualifiedName)", MMRResourceAccessor.getInstance().getMessageText("0000"));
        return null;
    }

    public AssociationsOfObject selectM3Assoc(IConnection connection, String associationId, String mofId) throws BaseException, BaseRuntimeException {
        String method = "selectM3Assoc(IConnection connection,String associationId,String mofId))";
        RepositoryServer.getCategory().errorT(location, "selectM3Assoc(IConnection connection,String associationId,String mofId))", MMRResourceAccessor.getInstance().getMessageText("0000"));
        return null;
    }

    public List getMofPackageNamesResponsible() {
        LinkedList<String> list = new LinkedList<String>();
        list.add("*");
        return list;
    }

    public List getWorkspacesAvailableM1(IConnection connection) {
        return this.getWorkspacesAvailable(connection);
    }

    public List getWorkspacesAvailableM2(IConnection connection) {
        return this.getWorkspacesAvailable(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private List getWorkspacesAvailable(IConnection connection) {
        block18: {
            String method = "getWorkspacesAvailable(IConnection connection)";
            location.entering("getWorkspacesAvailable(IConnection connection)");
            if (this.workspaces == null) {
                this.workspaces = new LinkedList();
                String sql = "SELECT DISTINCT WORKSPACE FROM " + this.tableOM2.getName();
                PreparedStatement stmt = null;
                ResultSet set = null;
                Connection con = this.getConnection();
                stmt = con.prepareStatement(sql);
                set = stmt.executeQuery();
                if (set != null) {
                    while (set.next()) {
                        int wsSid = set.getInt(1);
                        String wsName = this.getValueBySID("WORKSPACE", wsSid);
                        if (wsName == null) continue;
                        if (wsName.length() < 1) {
                            wsName = "[default]";
                        }
                        Workspace ws = new Workspace(wsName);
                        ws.setDescription("Workspace on database with name: " + wsName);
                        ws.getProperties().put(WORKSPACE_TYPE_DB, Boolean.TRUE);
                        ws.setPath("");
                        this.workspaces.add(ws);
                    }
                }
                Object var11_11 = null;
                RepositoryDB.conClose(con, "getWorkspacesAvailable(IConnection connection)");
                try {
                    set.close();
                }
                catch (Exception e2) {
                    RepositoryDB.writeExceptionToLog("getWorkspacesAvailable(IConnection connection)", e2);
                }
                try {
                    stmt.close();
                }
                catch (Exception e2) {
                    RepositoryDB.writeExceptionToLog("getWorkspacesAvailable(IConnection connection)", e2);
                }
                break block18;
                {
                    catch (Exception e) {
                        RepositoryDB.writeExceptionToLog("getWorkspacesAvailable(IConnection connection)", e);
                        Object var11_12 = null;
                        RepositoryDB.conClose(con, "getWorkspacesAvailable(IConnection connection)");
                        try {
                            set.close();
                        }
                        catch (Exception e2) {
                            RepositoryDB.writeExceptionToLog("getWorkspacesAvailable(IConnection connection)", e2);
                        }
                        try {
                            stmt.close();
                        }
                        catch (Exception e2) {
                            RepositoryDB.writeExceptionToLog("getWorkspacesAvailable(IConnection connection)", e2);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var11_13 = null;
                    RepositoryDB.conClose(con, "getWorkspacesAvailable(IConnection connection)");
                    try {
                        set.close();
                    }
                    catch (Exception e2) {
                        RepositoryDB.writeExceptionToLog("getWorkspacesAvailable(IConnection connection)", e2);
                    }
                    try {
                        stmt.close();
                    }
                    catch (Exception e2) {
                        RepositoryDB.writeExceptionToLog("getWorkspacesAvailable(IConnection connection)", e2);
                    }
                    throw throwable;
                }
            }
        }
        location.exiting();
        return this.workspaces;
    }

    public boolean deregisterWorkspace(Workspace workspace, int mofLayer) {
        if (this.workspaces != null) {
            if (!this.workspaces.contains(workspace)) {
                return false;
            }
            this.workspaces.remove(workspace);
        }
        return true;
    }

    public boolean registerWorkspace(Workspace workspace, int mofLayer) {
        if (this.workspaces == null) {
            this.workspaces = new LinkedList();
        }
        if (this.workspaces.contains(workspace)) {
            return false;
        }
        this.workspaces.add(workspace);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected String encodeObjectXML(IConnection connection, Object o) {
        String str;
        block9: {
            String method = "encodeObjectXML(IConnection connection, Object o)";
            str = null;
            location.entering("encodeObjectXML(IConnection connection, Object o)");
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
            LinkedList<Object> objects = new LinkedList<Object>();
            objects.add(o);
            connection.write((OutputStream)baos, objects, "SAP_1.0");
            str = baos.toString();
            Object var9_7 = null;
            try {
                baos.close();
            }
            catch (IOException e1) {
                RepositoryServer.category.errorT(location, e1.toString());
            }
            break block9;
            {
                catch (IOException e) {
                    str = null;
                    Object var9_8 = null;
                    try {
                        baos.close();
                    }
                    catch (IOException e1) {
                        RepositoryServer.category.errorT(location, e1.toString());
                    }
                }
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                try {
                    baos.close();
                }
                catch (IOException e1) {
                    RepositoryServer.category.errorT(location, e1.toString());
                }
                throw throwable;
            }
        }
        location.exiting();
        if (str == null || str.length() < 1) {
            str = " ";
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected byte[] encodeObjectSer(Object o) {
        byte[] res;
        block17: {
            block15: {
                ByteArrayOutputStream baos;
                block16: {
                    String method = "encodeObjectSer(Object o)";
                    location.entering("encodeObjectSer(Object o)");
                    res = null;
                    if (!(o instanceof Serializable)) break block15;
                    Serializable oser = (Serializable)o;
                    baos = new ByteArrayOutputStream();
                    ObjectOutputStream os = null;
                    os = new ObjectOutputStream(baos);
                    os.writeObject(oser);
                    Object var9_7 = null;
                    try {
                        os.close();
                    }
                    catch (IOException e1) {
                        RepositoryServer.category.errorT(location, e1.toString());
                    }
                    try {
                        baos.close();
                    }
                    catch (IOException e1) {
                        RepositoryServer.category.errorT(location, e1.toString());
                    }
                    break block16;
                    {
                        catch (IOException e) {
                            RepositoryDB.writeExceptionToLog("encodeObjectSer(Object o)", e);
                            Object var9_8 = null;
                            try {
                                os.close();
                            }
                            catch (IOException e1) {
                                RepositoryServer.category.errorT(location, e1.toString());
                            }
                            try {
                                baos.close();
                            }
                            catch (IOException e1) {
                                RepositoryServer.category.errorT(location, e1.toString());
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        Object var9_9 = null;
                        try {
                            os.close();
                        }
                        catch (IOException e1) {
                            RepositoryServer.category.errorT(location, e1.toString());
                        }
                        try {
                            baos.close();
                        }
                        catch (IOException e1) {
                            RepositoryServer.category.errorT(location, e1.toString());
                        }
                        throw throwable;
                    }
                }
                res = baos.toByteArray();
                break block17;
            }
            res = null;
        }
        if (res == null) {
            res = new byte[]{};
        }
        location.exiting();
        return res;
    }

    protected Collection decodeObjectXML(IConnection connection, String data, int mofLayer) {
        String method = "decodeObjectXML(IConnection connection, String data)";
        location.entering("decodeObjectXML(IConnection connection, String data)");
        Collection col = null;
        if (data == null || data.length() <= 0) {
            return col;
        }
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(data.getBytes());
            try {
                switch (mofLayer) {
                    case 1: {
                        col = connection.read((InputStream)bais, null, connection.getTopLevelPackageM1());
                        break;
                    }
                    case 2: {
                        col = connection.read((InputStream)bais, null, (RefPackage)connection.getTopLevelPackageM2());
                    }
                }
            }
            catch (MalformedXMIException e1) {
                RepositoryServer.getCategory().errorT(location, "decodeObjectXML(IConnection connection, String data)", MMRResourceAccessor.getInstance().getMessageText("0003"), new Object[]{e1.toString()});
            }
            catch (ResourceException e2) {
                RepositoryServer.getCategory().errorT(location, "decodeObjectXML(IConnection connection, String data)", MMRResourceAccessor.getInstance().getMessageText("0003"), new Object[]{e2.toString()});
            }
        }
        catch (IOException e) {
            RepositoryDB.writeExceptionToLog("decodeObjectXML(IConnection connection, String data)", e);
        }
        location.exiting();
        return col;
    }

    protected Object decodeObjectSer(byte[] data, IConnection connection) {
        String version;
        String method = "decodeObjectSer(IConnection connection, byte data[])";
        location.entering("decodeObjectSer(IConnection connection, byte data[])");
        Object o = null;
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        try {
            ObjectInputStreamWithClassLoader ois = new ObjectInputStreamWithClassLoader((InputStream)bais, (IRepositoryClassLoader)this.repositoryServer, connection);
            o = ois.readObject();
            ois.close();
            bais.close();
        }
        catch (IOException e) {
            o = null;
        }
        catch (ClassNotFoundException e) {
            o = null;
        }
        if (o instanceof IMMRObject && (version = ((IMMRObject)o).get___GeneratorVersion()).compareTo("1.1.1") < 0) {
            o = null;
        }
        location.exiting();
        return o;
    }

    public List queryM2(IConnection connection, List qualifiedNameOfType, QueryFilters filters, boolean includeSubTypes) throws BaseException, BaseRuntimeException {
        String method = "queryM2(IConnection connection, List qualifiedNameOfType, QueryFilters filters, boolean includeSubTypes)";
        if (qualifiedNameOfType == null && filters == null) {
            return this.selectM2All(connection);
        }
        location.entering("queryM2(IConnection connection, List qualifiedNameOfType, QueryFilters filters, boolean includeSubTypes)");
        int qnSid = -1;
        String qn = null;
        if (qualifiedNameOfType != null) {
            qn = Utilities.getUtilities().encodeQualifiedName(qualifiedNameOfType);
            qnSid = this.getSIDForValue("OBJTYPE", qn);
        }
        LinkedList list = new LinkedList();
        Iterator iterW = this.getWorkspacesDB(connection.getConnectionSpec().getWorkspacesM2()).iterator();
        while (iterW.hasNext()) {
            Workspace w = (Workspace)iterW.next();
            int wsSid = this.getSIDForValue("WORKSPACE", w.getName());
            List l = this.getAttributesValuesM2().query(wsSid, qnSid, filters, connection, w);
            if (l == null) continue;
            list.addAll(l);
        }
        if (qn != null) {
            if (qn.compareTo("Model.Package") == 0) {
                list.addAll(this.queryM2(connection, Utilities.getUtilities().decodeQualifiedName("Model.MofPackage"), filters, includeSubTypes));
            }
            if (qn.compareTo("Model.Class") == 0) {
                list.addAll(this.queryM2(connection, Utilities.getUtilities().decodeQualifiedName("Model.MofClass"), filters, includeSubTypes));
            }
            if (qn.compareTo("Model.Exception") == 0) {
                list.addAll(this.queryM2(connection, Utilities.getUtilities().decodeQualifiedName("Model.MofException"), filters, includeSubTypes));
            }
        }
        location.exiting();
        return list;
    }

    public List queryM1(IConnection connection, List qualifiedNameOfType, QueryFilters filters, boolean includeSubTypes) throws BaseException, BaseRuntimeException {
        String method = "queryM1(IConnection connection, List qualifiedNameOfType, QueryFilters filters, boolean includeSubTypes)";
        if (qualifiedNameOfType == null && filters == null) {
            return this.selectM1All(connection);
        }
        location.entering("queryM1(IConnection connection, List qualifiedNameOfType, QueryFilters filters, boolean includeSubTypes)");
        int qnSid = -1;
        if (qualifiedNameOfType != null) {
            qnSid = this.getSIDForValue("OBJTYPE", Utilities.getUtilities().encodeQualifiedName(qualifiedNameOfType));
        }
        LinkedList list = new LinkedList();
        Iterator iterW = this.getWorkspacesDB(connection.getConnectionSpec().getWorkspacesM1()).iterator();
        while (iterW.hasNext()) {
            Workspace w = (Workspace)iterW.next();
            int wsSid = this.getSIDForValue("WORKSPACE", w.getName());
            List l = this.getAttributesValuesM1().query(wsSid, qnSid, filters, connection, w);
            if (l == null) continue;
            list.addAll(l);
        }
        location.exiting();
        return list;
    }

    public Hierarchy getHierarchyM1(IConnection connection, String mofId) throws BaseException, BaseRuntimeException {
        String method = "getHierarchyM1(IConnection connection, String mofId)";
        location.entering("getHierarchyM1(IConnection connection, String mofId)");
        Hierarchy h = null;
        Iterator iterW = this.getWorkspacesDB(connection.getConnectionSpec().getWorkspacesM1()).iterator();
        while (iterW.hasNext() && h == null) {
            String data;
            Workspace w = (Workspace)iterW.next();
            int wsSid = this.getSIDForValue("WORKSPACE", w.getName());
            h = this.getHierarchyM1Ser(wsSid, mofId);
            if (h != null || (data = this.getHierarchyM1XML(wsSid, mofId)) == null) continue;
            h = Hierarchy.readXML(null, (byte[])data.getBytes());
        }
        location.exiting();
        return h;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String getHierarchyM1XML(int workspaceSid, String mofId) {
        String data;
        block15: {
            data = null;
            String method = "getHierarchyM1XML(int workspaceSid, String mofId)";
            location.entering("getHierarchyM1XML(int workspaceSid, String mofId)");
            Connection con = this.getConnection();
            PreparedStatement stmt = this.getPSSelectXMLHM1(con);
            ResultSet set = null;
            stmt.setInt(1, workspaceSid);
            stmt.setString(2, mofId);
            set = stmt.executeQuery();
            while (set.next()) {
                data = set.getString(1);
            }
            Object var10_8 = null;
            RepositoryDB.conClose(con, "getHierarchyM1XML(int workspaceSid, String mofId)");
            try {
                set.close();
            }
            catch (Exception e2) {
                RepositoryDB.writeExceptionToLog("getHierarchyM1XML(int workspaceSid, String mofId)", e2);
            }
            try {
                stmt.close();
            }
            catch (Exception e2) {
                RepositoryDB.writeExceptionToLog("getHierarchyM1XML(int workspaceSid, String mofId)", e2);
            }
            break block15;
            {
                catch (Exception e) {
                    RepositoryDB.writeExceptionToLog("getHierarchyM1XML(int workspaceSid, String mofId)", e);
                    Object var10_9 = null;
                    RepositoryDB.conClose(con, "getHierarchyM1XML(int workspaceSid, String mofId)");
                    try {
                        set.close();
                    }
                    catch (Exception e2) {
                        RepositoryDB.writeExceptionToLog("getHierarchyM1XML(int workspaceSid, String mofId)", e2);
                    }
                    try {
                        stmt.close();
                    }
                    catch (Exception e2) {
                        RepositoryDB.writeExceptionToLog("getHierarchyM1XML(int workspaceSid, String mofId)", e2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                RepositoryDB.conClose(con, "getHierarchyM1XML(int workspaceSid, String mofId)");
                try {
                    set.close();
                }
                catch (Exception e2) {
                    RepositoryDB.writeExceptionToLog("getHierarchyM1XML(int workspaceSid, String mofId)", e2);
                }
                try {
                    stmt.close();
                }
                catch (Exception e2) {
                    RepositoryDB.writeExceptionToLog("getHierarchyM1XML(int workspaceSid, String mofId)", e2);
                }
                throw throwable;
            }
        }
        location.exiting();
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Hierarchy getHierarchyM1Ser(int workspaceSid, String mofId) {
        Hierarchy h;
        block19: {
            h = null;
            String method = "getHierarchyM1Ser(int workspaceSid, String mofId)";
            location.entering("getHierarchyM1Ser(int workspaceSid, String mofId)");
            Connection con = this.getConnection();
            PreparedStatement stmt = this.getPSSelectSerHM1(con);
            ResultSet set = null;
            stmt.setInt(1, workspaceSid);
            stmt.setString(2, mofId);
            set = stmt.executeQuery();
            byte[] b = null;
            while (set.next()) {
                b = set.getBytes(1);
            }
            if (b != null) {
                try {
                    ByteArrayInputStream bais = new ByteArrayInputStream(b);
                    ObjectInputStream ois = new ObjectInputStream(bais);
                    h = (Hierarchy)ois.readObject();
                }
                catch (IOException e1) {
                    RepositoryServer.getCategory().errorT(location, "getHierarchyM1Ser(int workspaceSid, String mofId)", MMRResourceAccessor.getInstance().getMessageText("0003"), new Object[]{e1.toString()});
                }
                catch (ClassNotFoundException e2) {
                    RepositoryServer.getCategory().errorT(location, "getHierarchyM1Ser(int workspaceSid, String mofId)", MMRResourceAccessor.getInstance().getMessageText("0003"), new Object[]{e2.toString()});
                }
            }
            Object var12_14 = null;
            RepositoryDB.conClose(con, "getHierarchyM1Ser(int workspaceSid, String mofId)");
            try {
                set.close();
            }
            catch (Exception e2) {
                RepositoryDB.writeExceptionToLog("getHierarchyM1Ser(int workspaceSid, String mofId)", e2);
            }
            try {
                stmt.close();
            }
            catch (Exception e2) {
                RepositoryDB.writeExceptionToLog("getHierarchyM1Ser(int workspaceSid, String mofId)", e2);
            }
            break block19;
            {
                catch (Exception e) {
                    RepositoryDB.writeExceptionToLog("getHierarchyM1Ser(int workspaceSid, String mofId)", e);
                    Object var12_15 = null;
                    RepositoryDB.conClose(con, "getHierarchyM1Ser(int workspaceSid, String mofId)");
                    try {
                        set.close();
                    }
                    catch (Exception e2) {
                        RepositoryDB.writeExceptionToLog("getHierarchyM1Ser(int workspaceSid, String mofId)", e2);
                    }
                    try {
                        stmt.close();
                    }
                    catch (Exception e2) {
                        RepositoryDB.writeExceptionToLog("getHierarchyM1Ser(int workspaceSid, String mofId)", e2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var12_16 = null;
                RepositoryDB.conClose(con, "getHierarchyM1Ser(int workspaceSid, String mofId)");
                try {
                    set.close();
                }
                catch (Exception e2) {
                    RepositoryDB.writeExceptionToLog("getHierarchyM1Ser(int workspaceSid, String mofId)", e2);
                }
                try {
                    stmt.close();
                }
                catch (Exception e2) {
                    RepositoryDB.writeExceptionToLog("getHierarchyM1Ser(int workspaceSid, String mofId)", e2);
                }
                throw throwable;
            }
        }
        location.exiting();
        return h;
    }

    public Hierarchy getHierarchyM1ByName(IConnection connection, String name) throws BaseException, BaseRuntimeException {
        String method = "getHierarchyM1ByName(IConnection connection, String name)";
        location.entering("getHierarchyM1ByName(IConnection connection, String name)");
        Hierarchy h = null;
        Iterator iterW = this.getWorkspacesDB(connection.getConnectionSpec().getWorkspacesM1()).iterator();
        while (iterW.hasNext()) {
            Workspace w = (Workspace)iterW.next();
            int wsSid = this.getSIDForValue("WORKSPACE", w.getName());
            String mofId = this.getHierarchyM1ByName(wsSid, name);
            if (mofId == null) continue;
            h = this.getHierarchyM1(connection, mofId);
        }
        location.exiting();
        return h;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String getHierarchyM1ByName(int workspaceSid, String name) throws BaseException, BaseRuntimeException {
        String data;
        block16: {
            data = null;
            String method = "getHierarchyM1ByName(int workspaceSid, String name)";
            location.entering("getHierarchyM1ByName(int workspaceSid, String name)");
            String sql = "SELECT MOFID FROM " + this.tableHM1.getName() + " WHERE " + "WORKSPACE" + " = ? AND " + "QUALNAME" + " = ?";
            PreparedStatement stmt = null;
            ResultSet set = null;
            Connection con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setInt(1, workspaceSid);
            stmt.setString(2, name);
            set = stmt.executeQuery();
            if (set != null) {
                while (set.next()) {
                    data = set.getString(1);
                }
            }
            Object var11_9 = null;
            RepositoryDB.conClose(con, "getHierarchyM1ByName(int workspaceSid, String name)");
            try {
                set.close();
            }
            catch (Exception e2) {
                RepositoryDB.writeExceptionToLog("getHierarchyM1ByName(int workspaceSid, String name)", e2);
            }
            try {
                stmt.close();
            }
            catch (Exception e2) {
                RepositoryDB.writeExceptionToLog("getHierarchyM1ByName(int workspaceSid, String name)", e2);
            }
            break block16;
            {
                catch (Exception e) {
                    RepositoryDB.writeExceptionToLog("getHierarchyM1ByName(int workspaceSid, String name)", e);
                    Object var11_10 = null;
                    RepositoryDB.conClose(con, "getHierarchyM1ByName(int workspaceSid, String name)");
                    try {
                        set.close();
                    }
                    catch (Exception e2) {
                        RepositoryDB.writeExceptionToLog("getHierarchyM1ByName(int workspaceSid, String name)", e2);
                    }
                    try {
                        stmt.close();
                    }
                    catch (Exception e2) {
                        RepositoryDB.writeExceptionToLog("getHierarchyM1ByName(int workspaceSid, String name)", e2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                RepositoryDB.conClose(con, "getHierarchyM1ByName(int workspaceSid, String name)");
                try {
                    set.close();
                }
                catch (Exception e2) {
                    RepositoryDB.writeExceptionToLog("getHierarchyM1ByName(int workspaceSid, String name)", e2);
                }
                try {
                    stmt.close();
                }
                catch (Exception e2) {
                    RepositoryDB.writeExceptionToLog("getHierarchyM1ByName(int workspaceSid, String name)", e2);
                }
                throw throwable;
            }
        }
        location.exiting();
        return data;
    }

    public boolean writeHierarchyM1(IConnection connection, Hierarchy hierarchy) throws BaseException, BaseRuntimeException {
        String method = "writeHierarchyM1(IConnection connection, Hierarchy hierarchy)";
        location.entering("writeHierarchyM1(IConnection connection, Hierarchy hierarchy)");
        if (!this.assertTransactionActive("writeHierarchyM1(IConnection connection, Hierarchy hierarchy)", connection)) {
            return false;
        }
        boolean flag = true;
        Iterator iterW = this.getWorkspacesDB(connection.getConnectionSpec().getWorkspacesM1()).iterator();
        while (iterW.hasNext()) {
            Workspace w = (Workspace)iterW.next();
            if (w.isReadOnly()) continue;
            int wsSid = this.getSIDForValue("WORKSPACE", w.getName());
            String data = hierarchy.writeXML();
            if (this.writeHierarchyM1(this.getConnection(connection), wsSid, hierarchy.getMofId(), hierarchy.getName(), data)) continue;
            flag = false;
        }
        location.exiting();
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeHierarchyM1(Connection con, int workspaceSid, String mofId, String name, String data) {
        boolean flag = false;
        String method = "writeHierarchyM1(Connection con, int workspaceSid, String mofId, String name, String data)";
        location.entering("writeHierarchyM1(Connection con, int workspaceSid, String mofId, String name, String data)");
        PreparedStatement stmt = this.getPSUpdateHM1(con);
        try {
            stmt.setString(1, name);
            stmt.setString(2, data);
            stmt.setInt(3, workspaceSid);
            stmt.setString(4, mofId);
            int n = stmt.executeUpdate();
            if (n == 1) {
                flag = true;
            }
        }
        catch (Exception e) {
            flag = false;
        }
        finally {
            try {
                stmt.close();
            }
            catch (Exception e) {
                RepositoryDB.writeExceptionToLog("writeHierarchyM1(Connection con, int workspaceSid, String mofId, String name, String data)", e);
            }
        }
        if (!flag) {
            stmt = this.getPSInsertHM1(con);
            try {
                stmt.setInt(1, workspaceSid);
                stmt.setString(2, mofId);
                stmt.setString(3, name);
                stmt.setString(4, data);
                stmt.executeUpdate();
                flag = true;
            }
            catch (Exception e) {
                RepositoryDB.writeExceptionToLog("writeHierarchyM1(Connection con, int workspaceSid, String mofId, String name, String data)", e);
                flag = false;
            }
            finally {
                try {
                    stmt.close();
                }
                catch (Exception e) {
                    RepositoryDB.writeExceptionToLog("writeHierarchyM1(Connection con, int workspaceSid, String mofId, String name, String data)", e);
                }
            }
        }
        location.exiting();
        return flag;
    }

    public Hierarchy getHierarchyM0(IConnection connection, String mofId) throws BaseException, BaseRuntimeException {
        String method = "getHierarchyM0(IConnection connection, String mofId)";
        RepositoryServer.getCategory().errorT(location, "getHierarchyM0(IConnection connection, String mofId)", MMRResourceAccessor.getInstance().getMessageText("0000"));
        return null;
    }

    public Hierarchy getHierarchyM0ByName(IConnection connection, String name) throws BaseException, BaseRuntimeException {
        String method = "getHierarchyM0ByName(IConnection connection,String name)";
        RepositoryServer.getCategory().errorT(location, "getHierarchyM0ByName(IConnection connection,String name)", MMRResourceAccessor.getInstance().getMessageText("0000"));
        return null;
    }

    public boolean writeHierarchyM0(IConnection connection, Hierarchy hierarchy) throws BaseException, BaseRuntimeException {
        String method = "writeHierarchyM0(IConnection connection,Hierarchy hierarchy)";
        RepositoryServer.getCategory().errorT(location, "writeHierarchyM0(IConnection connection,Hierarchy hierarchy)", MMRResourceAccessor.getInstance().getMessageText("0000"));
        return false;
    }

    public Collection selectM2TopLevelPackages(IConnection connection) throws BaseException, BaseRuntimeException {
        Namespace ns;
        MofPackage mp;
        String method = "selectM2TopLevelPackages(IConnection connection)";
        location.entering("selectM2TopLevelPackages(IConnection connection)");
        LinkedList<MofPackage> col = new LinkedList<MofPackage>();
        LinkedList<String> l = new LinkedList<String>();
        l.add("Model");
        l.add("MofPackage");
        Collection colPack = this.selectM2AllOfClass(connection, l);
        Iterator iter = colPack.iterator();
        while (iter.hasNext()) {
            mp = (MofPackage)iter.next();
            ns = mp.getContainer();
            if (ns != null && !ns.refMofId().equals("MOF_PACKAGE_M2_ROOT")) continue;
            col.add(mp);
        }
        l.clear();
        l.add("Model");
        l.add("Package");
        colPack = this.selectM2AllOfClass(connection, l);
        iter = colPack.iterator();
        while (iter.hasNext()) {
            mp = (MofPackage)iter.next();
            ns = mp.getContainer();
            if (ns != null && !ns.refMofId().equals("MOF_PACKAGE_M2_ROOT")) continue;
            col.add(mp);
        }
        location.exiting();
        return col;
    }

    public Collection resolveFilesM2(IConnection connection, ModelElement modelElement) throws BaseException, BaseRuntimeException {
        return null;
    }

    public Collection resolveFilesM1(IConnection connection, RefObject ro) throws BaseException, BaseRuntimeException {
        return null;
    }

    public void connectionClosed(IConnection connection) throws BaseException, BaseRuntimeException {
        String method = "connectionClosed(IConnection connection)";
        location.entering("connectionClosed(IConnection connection)");
        this.transactionCommit(connection);
        location.exiting();
    }

    public Properties getProperties() {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        return this.properties;
    }

    public void addLog(Log log) {
    }

    public void removeLog(Log log) {
    }

    public void deploy(IConnection connection, TaskDeployToDB task, String deployUnitName) throws BaseException, BaseRuntimeException {
        byte[] dataSer;
        AssociationsOfObject aoo;
        Iterator iter;
        Workspace w;
        String method = "deploy(IConnection connection, TaskDeployToDB task)";
        this.undeploy(connection, deployUnitName);
        RepositoryDB.conCommit(this.getConnection(connection), "deploy(IConnection connection, TaskDeployToDB task)");
        Iterator iterW = this.getWorkspacesDB(connection.getConnectionSpec().getWorkspacesM2()).iterator();
        while (iterW.hasNext()) {
            w = (Workspace)iterW.next();
            if (!w.isReadOnly()) {
                Map dataM2InstanceXMI = task.getDataM2InstanceXMI();
                if (dataM2InstanceXMI.size() > 0) {
                    String mofId;
                    Map indexM2QualifiedName = task.getIndexM2QualifiedName();
                    HashMap<String, String> indexM2QualifiedNameRev = new HashMap<String, String>(indexM2QualifiedName.size());
                    Iterator iter2 = indexM2QualifiedName.keySet().iterator();
                    while (iter2.hasNext()) {
                        String qn = (String)iter2.next();
                        mofId = (String)indexM2QualifiedName.get(qn);
                        indexM2QualifiedNameRev.put(mofId, qn);
                    }
                    Properties indexM2TypeInformation = task.getIndexM2TypeInformation();
                    iter2 = dataM2InstanceXMI.keySet().iterator();
                    while (iter2.hasNext()) {
                        mofId = (String)iter2.next();
                        String type = (String)indexM2TypeInformation.get(mofId);
                        int typeSid = this.getSIDForValue("OBJTYPE", type);
                        String qn = (String)indexM2QualifiedNameRev.get(mofId);
                        String dataXML = new String(((Bytes)dataM2InstanceXMI.get(mofId)).getData());
                        byte[] dataSer2 = null;
                        this.insertM2(connection, w, mofId, typeSid, qn, dataXML, dataSer2, null, deployUnitName);
                    }
                }
                dataM2InstanceXMI = null;
                Map dataM2AssociationXMI = task.getDataM2AssociationXMI();
                if (dataM2AssociationXMI.size() > 0) {
                    iter = dataM2AssociationXMI.keySet().iterator();
                    while (iter.hasNext()) {
                        String mofId = (String)iter.next();
                        aoo = (AssociationsOfObject)dataM2AssociationXMI.get(mofId);
                        if (aoo == null) continue;
                        String dataXML = aoo.encodeAssocXML(connection);
                        dataSer = aoo.encodeAssocSer(connection);
                        this.insertM2Assoc(connection, w, mofId, dataXML, dataSer);
                    }
                }
                dataM2AssociationXMI = null;
                com.sap.ip.mmr.search.AttributesValues avM2 = task.getAvM2();
                if (avM2.size() > 0) {
                    int workspaceSid = this.getSIDForValue("WORKSPACE", w.getName());
                    this.getAttributesValuesM2().add(this.getConnection(connection), workspaceSid, avM2, connection, w);
                }
                avM2 = null;
                List classDataM2 = task.getClassDataM2();
                if (classDataM2.size() > 0) {
                    Iterator iter3 = classDataM2.iterator();
                    while (iter3.hasNext()) {
                        Bytes bytes = (Bytes)iter3.next();
                        this.insertClassDataM2(connection, w, bytes.getName().toLowerCase(), bytes.getData());
                    }
                }
                classDataM2 = null;
            }
            RepositoryDB.conCommit(this.getConnection(connection), "deploy(IConnection connection, TaskDeployToDB task)");
        }
        iterW = this.getWorkspacesDB(connection.getConnectionSpec().getWorkspacesM1()).iterator();
        while (iterW.hasNext()) {
            w = (Workspace)iterW.next();
            if (w.isReadOnly()) continue;
            Map dataM1InstanceXMI = task.getDataM1InstanceXMI();
            if (dataM1InstanceXMI.size() > 0) {
                Properties indexM1TypeInformation = task.getIndexM1TypeInformation();
                iter = dataM1InstanceXMI.keySet().iterator();
                while (iter.hasNext()) {
                    String mofId = (String)iter.next();
                    String type = (String)indexM1TypeInformation.get(mofId);
                    int typeSid = this.getSIDForValue("OBJTYPE", type);
                    String dataXML = new String(((Bytes)dataM1InstanceXMI.get(mofId)).getData());
                    byte[] dataSer3 = null;
                    this.insertM1(connection, w, mofId, typeSid, dataXML, dataSer3, null, deployUnitName);
                }
            }
            dataM1InstanceXMI = null;
            Map dataM1AssociationXMI = task.getDataM1AssociationXMI();
            if (dataM1AssociationXMI.size() > 0) {
                iter = dataM1AssociationXMI.keySet().iterator();
                while (iter.hasNext()) {
                    String mofId = (String)iter.next();
                    aoo = (AssociationsOfObject)dataM1AssociationXMI.get(mofId);
                    if (aoo == null) continue;
                    String dataXML = aoo.encodeAssocXML(connection);
                    dataSer = aoo.encodeAssocSer(connection);
                    this.insertM1Assoc(connection, w, mofId, dataXML, dataSer);
                }
            }
            dataM1AssociationXMI = null;
            com.sap.ip.mmr.search.AttributesValues avM1 = task.getAvM1();
            if (avM1.size() > 0) {
                int workspaceSid = this.getSIDForValue("WORKSPACE", w.getName());
                this.getAttributesValuesM1().add(this.getConnection(connection), workspaceSid, avM1, connection, w);
            }
            avM1 = null;
            RepositoryDB.conCommit(this.getConnection(connection), "deploy(IConnection connection, TaskDeployToDB task)");
        }
        Collection mofIdsToDeleteM1 = task.getMofIdsToDeleteM1();
        if (mofIdsToDeleteM1.size() > 0) {
            this.deleteM1(connection, mofIdsToDeleteM1);
        }
        mofIdsToDeleteM1 = null;
        Collection mofIdsToDeleteM2 = task.getMofIdsToDeleteM2();
        if (mofIdsToDeleteM2.size() > 0) {
            this.deleteM2(connection, mofIdsToDeleteM2);
        }
        mofIdsToDeleteM2 = null;
        RepositoryDB.conCommit(this.getConnection(connection), "deploy(IConnection connection, TaskDeployToDB task)");
    }

    protected byte[] getBytesOfInputStream(InputStream is) {
        String method = "getBytesOfInputStream(InputStream is)";
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            int size = 4096;
            byte[] data = new byte[4096];
            int n = 0;
            while (n >= 0) {
                n = is.read(data, 0, 4096);
                if (n <= 0) continue;
                baos.write(data, 0, n);
            }
        }
        catch (IOException e) {
            RepositoryDB.writeExceptionToLog("getBytesOfInputStream(InputStream is)", e);
        }
        return baos.toByteArray();
    }

    public Collection getWorkspaceAttributeDescriptions() {
        return null;
    }

    public Collection checkPersistence(IConnection connection) {
        return null;
    }

    protected String getComponentNameMeasurement(Workspace w) {
        return "RepositoryDB::" + w.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMMRDBInformation(IConnection connection) {
        String method = "getMMRDBInformation(IConnection connection)";
        StringBuffer state = new StringBuffer();
        Connection con = this.getConnection();
        try {
            state.append(this.numberRange.getDBInformation(con));
        }
        finally {
            RepositoryDB.conClose(con, "getMMRDBInformation(IConnection connection)");
        }
        state.append("<table cellspacing=\"0\" cellpadding=\"5\" width=\"100%\">");
        state.append("\n");
        state.append("<tr><th>Table</th><th>Number of rows</th></tr>\n");
        state.append(this.getTableCount(connection, this.tableOM1));
        state.append(this.getTableCount(connection, this.tableAM1));
        state.append(this.getTableCount(connection, this.tableOM2));
        state.append(this.getTableCount(connection, this.tableAM2));
        state.append(this.getTableCount(connection, this.tableCM2));
        state.append("</table>");
        state.append("\n");
        return state.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getTableCount(IConnection connection, Table table) {
        String method = "getTableCount(IConnection connection, Table table)";
        StringBuffer state = new StringBuffer();
        String sql = "SELECT COUNT(*) FROM " + table.getName();
        long numOfRows = 0L;
        Connection con = this.getConnection();
        try {
            PreparedStatement stmt = con.prepareStatement(sql);
            ResultSet set = stmt.executeQuery();
            while (set.next()) {
                numOfRows = set.getLong(1);
            }
        }
        catch (Exception e) {
            RepositoryDB.writeExceptionToLog("getTableCount(IConnection connection, Table table)", e);
        }
        finally {
            RepositoryDB.conClose(con, "getTableCount(IConnection connection, Table table)");
        }
        state.append("<tr>");
        state.append("<td>");
        state.append(table.getName());
        state.append("</td>");
        state.append("<td>");
        state.append(numOfRows);
        state.append("</td>");
        state.append("</tr>");
        state.append("\n");
        return state.toString();
    }

    private Collection getWorkspacesDB(Collection wsIn) {
        LinkedList<Workspace> l = new LinkedList<Workspace>();
        Iterator i = wsIn.iterator();
        while (i.hasNext()) {
            Workspace w = (Workspace)i.next();
            Boolean b = (Boolean)w.getProperties().get(WORKSPACE_TYPE_DB);
            if (w.getName().compareTo("[default]") != 0 && (b == null || !b.equals(Boolean.TRUE))) continue;
            l.add(w);
        }
        return l;
    }

    public void workspaceContentHasChanged(IConnection arg0, Workspace arg1) {
    }

    public boolean undeploy(IConnection connection, String deployUnitName) throws BaseException, BaseRuntimeException {
        Collection c;
        String mofId;
        ResultSet set;
        PreparedStatement ps;
        String sql;
        ArrayList<String> mofIds;
        int workspaceSid;
        Workspace w;
        String method = "undeploy(IConnection connection, String deployUnitName)";
        boolean result = true;
        if (deployUnitName == null || deployUnitName.length() < 1) {
            return result;
        }
        Connection con = this.getConnection(connection);
        int deployUnitNameSid = this.getSIDForValue("DEPLOYUNIT", deployUnitName);
        Iterator iterW = this.getWorkspacesDB(connection.getConnectionSpec().getWorkspacesM2()).iterator();
        while (iterW.hasNext()) {
            w = (Workspace)iterW.next();
            if (w.isReadOnly()) continue;
            workspaceSid = this.getSIDForValue("WORKSPACE", w.getName());
            try {
                mofIds = new ArrayList<String>();
                sql = "SELECT MOFID FROM " + this.tableOM2.getName() + " WHERE " + "WORKSPACE" + " = ? " + " AND " + "DEPLOYUNITNAME" + " = ?";
                ps = null;
                ps = con.prepareStatement(sql);
                ps.setInt(1, workspaceSid);
                ps.setInt(2, deployUnitNameSid);
                set = ps.executeQuery();
                while (set.next()) {
                    mofId = set.getString(1);
                    mofIds.add(mofId);
                }
                c = this.deleteM2(connection, w, mofIds);
                if (c == null) continue;
                result = false;
            }
            catch (Exception e) {
                RepositoryDB.writeExceptionToLog("undeploy(IConnection connection, String deployUnitName)", e);
                result = false;
            }
        }
        iterW = this.getWorkspacesDB(connection.getConnectionSpec().getWorkspacesM1()).iterator();
        while (iterW.hasNext()) {
            w = (Workspace)iterW.next();
            if (w.isReadOnly()) continue;
            workspaceSid = this.getSIDForValue("WORKSPACE", w.getName());
            try {
                mofIds = new ArrayList();
                sql = "SELECT MOFID FROM " + this.tableOM1.getName() + " WHERE " + "WORKSPACE" + " = ? " + " AND " + "DEPLOYUNITNAME" + " = ?";
                ps = null;
                ps = con.prepareStatement(sql);
                ps.setInt(1, workspaceSid);
                ps.setInt(2, deployUnitNameSid);
                set = ps.executeQuery();
                while (set.next()) {
                    mofId = set.getString(1);
                    mofIds.add(mofId);
                }
                c = this.deleteM1(connection, w, mofIds);
                if (c == null) continue;
                result = false;
            }
            catch (Exception e) {
                RepositoryDB.writeExceptionToLog("undeploy(IConnection connection, String deployUnitName)", e);
                result = false;
            }
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

