/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.ssl;

import iaik.security.ssl.ChainVerifier;
import iaik.security.ssl.CipherSuite;
import iaik.security.ssl.CipherSuiteList;
import iaik.security.ssl.CompressionMethod;
import iaik.security.ssl.SecurityProvider;
import iaik.security.ssl.SessionManager;
import iaik.security.ssl.TrustDecider;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;

public abstract class SSLContext
implements Cloneable {
    private TrustDecider a;
    private boolean o;
    private PrintWriter f;
    private ChainVerifier g;
    private int[] i;
    private boolean h;
    private SecureRandom c;
    private SessionManager b;
    private CompressionMethod[] d;
    private CipherSuiteList e;
    private static final int l = 4;
    private static final int k = 1;
    public static final int CERTTYPE_RSA_ENCRYPT = 257;
    static final int m = 20;
    static final int n = 6;
    static final int j = 5;
    public static final int CERTTYPE_DSS_FIXED_DH = 4;
    public static final int CERTTYPE_RSA_FIXED_DH = 3;
    public static final int CERTTYPE_DSS_SIGN = 2;
    public static final int CERTTYPE_RSA_SIGN = 1;
    public static final int CERTTYPE_UNKNOWN = 256;
    public static final int VERSION_TLS10 = 769;
    public static final int VERSION_SSL30 = 768;
    public static final int VERSION_SSL20 = 2;
    public static final int VERSION_NOT_CONNECTED = 0;
    public static final String SEND_EMPTY_FRAGMENT = "isasilk.send_empty_fragment";
    public static final String LIBRARY_VERSION_STRING = "3.06";
    public static final double LIBRARY_VERSION = 3.06;

    public void updateCipherSuites() {
        this.e.ensureAvailable();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Enabled cipher suites: \n");
        stringBuffer.append(this.e.a("  "));
        stringBuffer.append("Enabled compression methods: ");
        if (this.d == null) {
            stringBuffer.append("None\n");
        } else {
            stringBuffer.append("\n");
            int n2 = 0;
            while (n2 < this.d.length) {
                stringBuffer.append("  ").append(this.d[n2].getName()).append("\n");
                ++n2;
            }
        }
        return stringBuffer.toString();
    }

    public void setTrustDecider(TrustDecider trustDecider) {
        this.a = trustDecider;
    }

    public void setSessionManager(SessionManager sessionManager) {
        this.b = sessionManager;
    }

    public void setSendEmptyFragment(boolean bl) {
        this.o = bl;
    }

    public void setRandomGenerator(SecureRandom secureRandom) {
        this.c = secureRandom;
    }

    public void setEnabledCompressionMethods(CompressionMethod[] compressionMethodArray) {
        this.d = compressionMethodArray;
    }

    public void setEnabledCipherSuites(CipherSuite[] cipherSuiteArray) {
        this.e = new CipherSuiteList(cipherSuiteArray);
    }

    public void setEnabledCipherSuiteList(CipherSuiteList cipherSuiteList) {
        this.e = cipherSuiteList;
    }

    public void setDebugStream(Writer writer) {
        if (writer == null) {
            this.f = null;
            return;
        }
        this.f = new PrintWriter(writer, true);
    }

    public void setDebugStream(OutputStream outputStream) {
        if (outputStream == null) {
            this.f = null;
            return;
        }
        this.f = new PrintWriter(outputStream, true);
    }

    public void setChainVerifier(ChainVerifier chainVerifier) {
        this.g = chainVerifier;
    }

    public void setCacheTerminatedSessions(boolean bl) {
        this.h = bl;
    }

    public void setAllowedProtocolVersions(int n2, int n3) {
        if (n2 > n3) {
            throw new IllegalArgumentException("The minimum version must be less than or equal to the maximum version!");
        }
        SSLContext.a(n2);
        SSLContext.a(n3);
        this.i[0] = n2;
        this.i[1] = n3;
    }

    static boolean b(int n2) {
        return n2 >= 1 && n2 <= 4;
    }

    public TrustDecider getTrustDecider() {
        return this.a;
    }

    public SessionManager getSessionManager() {
        return this.b;
    }

    public boolean getSendEmptyFragment() {
        return this.o;
    }

    public SecureRandom getRandomGenerator() {
        return this.c;
    }

    public CompressionMethod[] getEnabledCompressionMethods() {
        return this.d;
    }

    public CipherSuite[] getEnabledCipherSuites() {
        return this.e.toArray();
    }

    public CipherSuiteList getEnabledCipherSuiteList() {
        return this.e;
    }

    public PrintWriter getDebugStream() {
        return this.f;
    }

    public ChainVerifier getChainVerifier() {
        return this.g;
    }

    public boolean getCacheTerminatedSessions() {
        return this.h;
    }

    public int[] getAllowedProtocolVersions() {
        return (int[])this.i.clone();
    }

    public static X509Certificate[] convertCertificateChain(Certificate[] certificateArray) throws CertificateException {
        if (certificateArray == null) {
            return null;
        }
        X509Certificate[] x509CertificateArray = new X509Certificate[certificateArray.length];
        int n2 = 0;
        while (n2 < certificateArray.length) {
            if (certificateArray[n2] instanceof X509Certificate) {
                x509CertificateArray[n2] = (X509Certificate)certificateArray[n2];
            } else {
                try {
                    x509CertificateArray[n2] = SecurityProvider.getSecurityProvider().getX509Certificate(certificateArray[n2].getEncoded());
                }
                catch (Exception exception) {
                    throw new CertificateException(exception.toString());
                }
            }
            ++n2;
        }
        return x509CertificateArray;
    }

    void a(SSLContext sSLContext) {
        this.c = sSLContext.c;
        this.e = (CipherSuiteList)sSLContext.e.clone();
        this.d = (CompressionMethod[])sSLContext.d.clone();
        this.b = sSLContext.b;
        this.h = sSLContext.h;
        this.i = (int[])sSLContext.i.clone();
        this.g = sSLContext.g;
        this.f = sSLContext.f;
        this.o = sSLContext.o;
        this.a = sSLContext.a;
    }

    public abstract Object clone();

    private static void a(int n2) throws RuntimeException {
        if (n2 != 2 && n2 != 768 && n2 != 769) {
            throw new IllegalArgumentException("Only versions SSLContext.VERSION_SSL20, SSLContext.VERSION_SSL30, and SSLContext.VERSION_TLS10 allowed!");
        }
    }

    public void addTrustedCertificate(X509Certificate x509Certificate) {
        if (this.g == null) {
            return;
        }
        this.g.addTrustedCertificate(x509Certificate);
    }

    SSLContext(SecureRandom secureRandom) {
        this.c = secureRandom;
        if (this.c == null) {
            this.c = SecurityProvider.getSecurityProvider().getSecureRandom();
        }
        this.e = new CipherSuiteList(2);
        this.d = CompressionMethod.getDefault();
        this.b = SessionManager.getDefault();
        this.i = new int[]{768, 769};
        this.g = new ChainVerifier();
        try {
            this.o = System.getProperty(SEND_EMPTY_FRAGMENT) != null;
        }
        catch (Throwable throwable) {}
        this.a = null;
    }

    SSLContext(int n2) {
    }

    SSLContext() {
    }
}

