/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.relational.sql.model.expr.impl;

import com.sap.ip.bi.sdk.dac.relational.sql.model.IBISQLBaseObject;
import com.sap.ip.bi.sdk.dac.relational.sql.model.clause.IBISQLScalarExpr;
import com.sap.ip.bi.sdk.dac.relational.sql.model.expr.IBISQLQuotedValue;
import com.sap.ip.bi.sdk.dac.relational.sql.model.impl.BISQLBaseObject;
import com.sap.ip.bi.sdk.exception.BISQLException;
import java.sql.DatabaseMetaData;

public final class BISQLQuotedValue
extends BISQLBaseObject
implements IBISQLBaseObject,
IBISQLQuotedValue,
IBISQLScalarExpr {
    private Object quoted = null;

    public BISQLQuotedValue(DatabaseMetaData meta) throws BISQLException {
        super(meta);
        this.quoted = null;
    }

    public BISQLQuotedValue(DatabaseMetaData meta, Object quoted) throws BISQLException {
        super(meta);
        this.quoted = quoted;
    }

    public void setQuoted(Object quoted) {
        this.quoted = quoted;
    }

    public Object getQuoted() {
        return this.quoted;
    }

    public StringBuffer getExpression() throws BISQLException {
        char quote = '\'';
        char escape = '\\';
        StringBuffer sql = new StringBuffer();
        if (this.quoted == null) {
            sql.append("NULL");
        } else {
            sql.append(quote).append((Object)this.escape(this.quoted.toString(), quote, escape)).append(quote);
        }
        return sql;
    }

    private StringBuffer escape(String value, char quote, char escape) {
        if (value == null) {
            return null;
        }
        char[] data = value.toCharArray();
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < data.length) {
            if (data[i] == escape || data[i] == quote) {
                buf.append(escape);
            }
            buf.append(data[i]);
            ++i;
        }
        return buf;
    }
}

