/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.relational.sql.model.clause.impl;

import com.sap.ip.bi.sdk.dac.connector.impl.IBIConnectionInfo;
import com.sap.ip.bi.sdk.dac.relational.sql.model.IBISQLBaseObject;
import com.sap.ip.bi.sdk.dac.relational.sql.model.clause.IBISQLSelectClause;
import com.sap.ip.bi.sdk.dac.relational.sql.model.clause.IBISQLSelectItem;
import com.sap.ip.bi.sdk.dac.relational.sql.model.impl.BISQLBaseObject;
import com.sap.ip.bi.sdk.exception.BISQLException;
import java.sql.DatabaseMetaData;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class BISQLSelectClause
extends BISQLBaseObject
implements IBISQLBaseObject,
IBISQLSelectClause {
    private List selectItem = new ArrayList();
    private static final int selectItem_min = 1;
    private static final int selectItem_max = -1;

    public BISQLSelectClause(DatabaseMetaData meta) throws BISQLException {
        super(meta);
    }

    public BISQLSelectClause(DatabaseMetaData meta, List selectItem) throws BISQLException {
        super(meta);
        this.selectItem = selectItem;
    }

    public IBISQLSelectClause addSelectItem(IBISQLSelectItem selectItem) {
        this.selectItem.add(selectItem);
        return this;
    }

    public List getSelectItem() {
        return this.selectItem;
    }

    public StringBuffer getExpression() throws BISQLException {
        if (this.selectItem == null || this.selectItem.size() < 1) {
            throw new BISQLException(IBIConnectionInfo.DEFAULT.getLocale(), "sdk.dac.rel.query_3003", new Object[]{"selectItem", this.selectItem != null ? new Integer(this.selectItem.size()) : null});
        }
        StringBuffer sql = new StringBuffer("SELECT ");
        String sep = "";
        Iterator i = this.selectItem.iterator();
        while (i.hasNext()) {
            IBISQLSelectItem element = (IBISQLSelectItem)i.next();
            sql.append(sep).append(element.getExpression().toString());
            sep = ", ";
        }
        return sql;
    }
}

