/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.relational.query.tree.impl;

import com.sap.ip.bi.sdk.dac.connector.impl.IBIConnectionInfo;
import com.sap.ip.bi.sdk.dac.relational.query.sql.IBISQLComparisonOperator;
import com.sap.ip.bi.sdk.dac.relational.query.sql.IBISQLKeyword;
import com.sap.ip.bi.sdk.dac.relational.query.tree.IBIWhereTreeColumnValueNode;
import com.sap.ip.bi.sdk.dac.relational.query.tree.impl.BIWhereTreeColumnNode;
import com.sap.ip.bi.sdk.exception.BIRuntimeException;
import org.omg.cwm.resource.relational.Column;

public class BIWhereTreeColumnValueNode
extends BIWhereTreeColumnNode
implements IBIWhereTreeColumnValueNode {
    private IBISQLComparisonOperator oper = null;
    private Object[] value = null;

    public BIWhereTreeColumnValueNode(String tableRef, Column column, IBISQLComparisonOperator oper) {
        super(tableRef, column);
        this.oper = oper;
        this.value = null;
        this.checkArguments();
    }

    public BIWhereTreeColumnValueNode(String tableRef, Column column, IBISQLComparisonOperator oper, Object value) {
        super(tableRef, column);
        this.oper = oper;
        this.value = new Object[]{value};
        this.checkArguments();
    }

    public BIWhereTreeColumnValueNode(String tableRef, Column column, IBISQLComparisonOperator oper, Object low, Object high) {
        super(tableRef, column);
        this.oper = oper;
        this.value = high == null ? new Object[]{low} : new Object[]{low, high};
        this.checkArguments();
    }

    public BIWhereTreeColumnValueNode(String tableRef, Column column, IBISQLComparisonOperator oper, Object[] value) {
        super(tableRef, column);
        this.oper = oper;
        this.value = value;
        this.checkArguments();
    }

    public BIWhereTreeColumnValueNode(Column column, IBISQLComparisonOperator oper, Object value) {
        this(null, column, oper, value);
    }

    public BIWhereTreeColumnValueNode(Column column, IBISQLComparisonOperator oper, Object low, Object high) {
        this(null, column, oper, low, high);
    }

    public BIWhereTreeColumnValueNode(Column column, IBISQLComparisonOperator oper, Object[] value) {
        this((String)null, column, oper, value);
    }

    public BIWhereTreeColumnValueNode(Column column, IBISQLComparisonOperator oper) {
        this(null, column, oper);
    }

    public String getUniqueId() {
        return super.getUniqueId();
    }

    public String toString() {
        StringBuffer str = new StringBuffer(super.toString());
        if (this.oper != null) {
            if (this.oper.equals(IBISQLComparisonOperator.BETWEEN)) {
                str.append(' ').append(this.oper.toString()).append(' ').append(this.value[0].toString()).append(' ').append(IBISQLKeyword.AND.toString()).append(' ').append(this.value[1].toString());
            } else if (this.oper.equals(IBISQLComparisonOperator.IS_NULL)) {
                str.append(' ').append(this.oper.toString());
            } else if (this.oper.equals(IBISQLComparisonOperator.IN)) {
                str.append(' ').append(this.oper.toString()).append(" (");
                String sep = "";
                int i = 0;
                while (i < this.value.length) {
                    str.append(sep).append(this.value[i].toString());
                    sep = ",";
                    ++i;
                }
                str.append(')');
            } else {
                str.append(' ').append(this.oper.toString()).append(this.value[0].toString());
            }
        }
        return str.toString();
    }

    public boolean equals(Object other) {
        if (other instanceof IBIWhereTreeColumnValueNode) {
            return super.equals(other) && this.equalsOper((IBIWhereTreeColumnValueNode)other) && this.equalsValues((IBIWhereTreeColumnValueNode)other);
        }
        return false;
    }

    private boolean equalsOper(IBIWhereTreeColumnValueNode other) {
        return this.oper == null ? this.oper == other.getOper() : this.oper.equals(other.getOper());
    }

    private boolean equalsValues(IBIWhereTreeColumnValueNode other) {
        if (this.value == null) {
            return this.value == other.getValue();
        }
        if (other.getValue() == null || this.value.length != other.getValue().length) {
            return false;
        }
        int i = 0;
        while (i < this.value.length) {
            if (!this.equalsValue(this.value[i], other.getValue()[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean equalsValue(Object thisValue, Object otherValue) {
        return thisValue == null ? thisValue == otherValue : thisValue.equals(otherValue);
    }

    private void checkArguments() {
        if (this.oper == null) {
            throw new RuntimeException();
        }
        if (this.oper.equals(IBISQLComparisonOperator.BETWEEN)) {
            if (this.value == null || this.value.length != 2) {
                throw new BIRuntimeException(IBIConnectionInfo.DEFAULT.getLocale(), "sdk.dac.rel.query_1012", new Object[]{new Integer(2), new Integer(this.value == null ? 0 : this.value.length)});
            }
        } else if (!(this.oper.equals(IBISQLComparisonOperator.IS_NULL) || this.value != null && this.value.length >= 1)) {
            throw new BIRuntimeException(IBIConnectionInfo.DEFAULT.getLocale(), "sdk.dac.rel.query_1012", new Object[]{new Integer(1), new Integer(this.value == null ? 0 : this.value.length)});
        }
    }

    public IBISQLComparisonOperator getOper() {
        return this.oper;
    }

    public Object[] getValue() {
        return this.value;
    }
}

