/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.relational.query.tree.impl;

import com.sap.ip.bi.sdk.dac.connector.impl.IBIConnectionInfo;
import com.sap.ip.bi.sdk.dac.relational.query.IBIQuery;
import com.sap.ip.bi.sdk.dac.relational.query.impl.BIRedoStack;
import com.sap.ip.bi.sdk.dac.relational.query.impl.IBIRedoStack;
import com.sap.ip.bi.sdk.dac.relational.query.sql.IBISQLComparisonOperator;
import com.sap.ip.bi.sdk.dac.relational.query.sql.IBISQLLogicalOperator;
import com.sap.ip.bi.sdk.dac.relational.query.tree.IBIWhereTree;
import com.sap.ip.bi.sdk.dac.relational.query.tree.IBIWhereTreeAndNode;
import com.sap.ip.bi.sdk.dac.relational.query.tree.IBIWhereTreeBinaryNode;
import com.sap.ip.bi.sdk.dac.relational.query.tree.IBIWhereTreeColumnJoinNode;
import com.sap.ip.bi.sdk.dac.relational.query.tree.IBIWhereTreeColumnSubQueryNode;
import com.sap.ip.bi.sdk.dac.relational.query.tree.IBIWhereTreeColumnValueNode;
import com.sap.ip.bi.sdk.dac.relational.query.tree.IBIWhereTreeNode;
import com.sap.ip.bi.sdk.dac.relational.query.tree.IBIWhereTreeNotNode;
import com.sap.ip.bi.sdk.dac.relational.query.tree.IBIWhereTreeOrNode;
import com.sap.ip.bi.sdk.dac.relational.query.tree.IBIWhereTreePredicateNode;
import com.sap.ip.bi.sdk.dac.relational.query.tree.IBIWhereTreeUnaryNode;
import com.sap.ip.bi.sdk.dac.relational.query.tree.impl.BIWhereTreeAndNode;
import com.sap.ip.bi.sdk.dac.relational.query.tree.impl.BIWhereTreeColumnJoinNode;
import com.sap.ip.bi.sdk.dac.relational.query.tree.impl.BIWhereTreeColumnSubQueryNode;
import com.sap.ip.bi.sdk.dac.relational.query.tree.impl.BIWhereTreeColumnValueNode;
import com.sap.ip.bi.sdk.dac.relational.query.tree.impl.BIWhereTreeNotNode;
import com.sap.ip.bi.sdk.dac.relational.query.tree.impl.BIWhereTreeOrNode;
import com.sap.ip.bi.sdk.exception.BIRuntimeException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.omg.cwm.resource.relational.Column;

public class BIWhereTree
implements IBIWhereTree {
    private IBIWhereTreeNode root = null;
    private IBIRedoStack stack = new BIRedoStack();

    public boolean equals(Object other) {
        if (other instanceof IBIWhereTree) {
            return this.equalsRoot(((IBIWhereTree)other).getRoot());
        }
        return false;
    }

    public IBIWhereTreeNode getRoot() {
        return this.root;
    }

    public void setRoot(IBIWhereTreeNode node) {
        this.root = node;
    }

    public void clear() {
        this.root = null;
        this.stack.clear();
    }

    public IBIWhereTreeNode pop() {
        return (IBIWhereTreeNode)this.stack.pop();
    }

    public IBIWhereTreeNode peek() {
        return (IBIWhereTreeNode)this.stack.peek();
    }

    public void pushRoot() {
        this.stack.push(this.root);
    }

    public void popRoot() {
        if (this.stack.size() > 0) {
            this.setRoot(this.pop());
        }
    }

    public void peekRoot() {
        if (this.stack.size() > 0) {
            this.setRoot(this.peek());
        }
    }

    public void push(String tableRef, Column column, IBISQLComparisonOperator oper) {
        this.stack.push(new BIWhereTreeColumnValueNode(tableRef, column, oper));
    }

    public void push(String tableRef, Column column, IBISQLComparisonOperator oper, IBIQuery subQuery) {
        this.stack.push(new BIWhereTreeColumnSubQueryNode(tableRef, column, oper, subQuery));
    }

    public void push(String tableRef, Column column, IBISQLComparisonOperator oper, String tabRef2, Column column2) {
        this.stack.push(new BIWhereTreeColumnJoinNode(tableRef, column, oper, tabRef2, column2));
    }

    public void push(String tableRef, Column column, IBISQLComparisonOperator oper, Object lowValue, Object highValue) {
        this.stack.push(new BIWhereTreeColumnValueNode(tableRef, column, oper, lowValue, highValue));
    }

    public void push(String tableRef, Column column, IBISQLComparisonOperator oper, Object[] values) {
        this.stack.push(new BIWhereTreeColumnValueNode(tableRef, column, oper, values));
    }

    public void push(String tableRef, Column column, IBISQLComparisonOperator oper, Object value) {
        this.stack.push(new BIWhereTreeColumnValueNode(tableRef, column, oper, value));
    }

    public void push(Column column, IBISQLComparisonOperator oper, Object lowValue, Object highValue) {
        this.stack.push(new BIWhereTreeColumnValueNode(column, oper, lowValue, highValue));
    }

    public void push(Column column, IBISQLComparisonOperator oper, Object[] values) {
        this.stack.push(new BIWhereTreeColumnValueNode(column, oper, values));
    }

    public void push(Column column, IBISQLComparisonOperator oper, Object value) {
        this.stack.push(new BIWhereTreeColumnValueNode(column, oper, value));
    }

    public void push(Column column, IBISQLComparisonOperator oper) {
        this.stack.push(new BIWhereTreeColumnValueNode(column, oper));
    }

    public void push(IBISQLLogicalOperator oper) {
        if (oper == null) {
            throw new RuntimeException("sdk.dac.rel.query_1019");
        }
        if (oper == IBISQLLogicalOperator.NOT) {
            if (this.stack.size() < 1) {
                throw new RuntimeException("sdk.dac.rel.query_1019");
            }
            IBIWhereTreeNode node = (IBIWhereTreeNode)this.stack.pop();
            this.stack.push(new BIWhereTreeNotNode(node));
        } else if (oper == IBISQLLogicalOperator.AND) {
            if (this.stack.size() < 2) {
                throw new RuntimeException("sdk.dac.rel.query_1019");
            }
            IBIWhereTreeNode right = (IBIWhereTreeNode)this.stack.pop();
            IBIWhereTreeNode left = (IBIWhereTreeNode)this.stack.pop();
            this.stack.push(new BIWhereTreeAndNode(left, right));
        } else if (oper == IBISQLLogicalOperator.OR) {
            if (this.stack.size() < 2) {
                throw new RuntimeException("sdk.dac.rel.query_1019");
            }
            IBIWhereTreeNode right = (IBIWhereTreeNode)this.stack.pop();
            IBIWhereTreeNode left = (IBIWhereTreeNode)this.stack.pop();
            this.stack.push(new BIWhereTreeOrNode(left, right));
        } else {
            throw new RuntimeException("sdk.dac.rel.query_1019");
        }
    }

    public String toString() {
        return this.infix(this.root);
    }

    public String prefix() {
        return this.prefix(this.root);
    }

    private String prefix(IBIWhereTreeNode node) {
        if (node == null) {
            return "<null>";
        }
        if (node instanceof IBIWhereTreePredicateNode) {
            return ((IBIWhereTreePredicateNode)node).toString();
        }
        if (node instanceof IBIWhereTreeNotNode) {
            return "NOT(" + this.prefix(((IBIWhereTreeNotNode)node).getChild()) + ")";
        }
        if (node instanceof IBIWhereTreeAndNode) {
            return "AND(" + this.prefix(((IBIWhereTreeAndNode)node).getLeft()) + "," + this.prefix(((IBIWhereTreeAndNode)node).getRight()) + ")";
        }
        if (node instanceof IBIWhereTreeOrNode) {
            return "OR(" + this.prefix(((IBIWhereTreeOrNode)node).getLeft()) + "," + this.prefix(((IBIWhereTreeOrNode)node).getRight()) + ")";
        }
        return "??";
    }

    public String infix() {
        return this.infix(this.root);
    }

    private String infix(IBIWhereTreeNode node) {
        if (node == null) {
            return "<null>";
        }
        if (node instanceof IBIWhereTreePredicateNode) {
            return ((IBIWhereTreePredicateNode)node).toString();
        }
        if (node instanceof IBIWhereTreeNotNode) {
            return "(NOT " + this.infix(((IBIWhereTreeNotNode)node).getChild()) + ")";
        }
        if (node instanceof IBIWhereTreeAndNode) {
            return "(" + this.infix(((IBIWhereTreeAndNode)node).getLeft()) + " AND " + this.infix(((IBIWhereTreeAndNode)node).getRight()) + ")";
        }
        if (node instanceof IBIWhereTreeOrNode) {
            return "(" + this.infix(((IBIWhereTreeOrNode)node).getLeft()) + " OR " + this.infix(((IBIWhereTreeOrNode)node).getRight()) + ")";
        }
        return "??";
    }

    public String postfix() {
        return this.postfix(this.root);
    }

    private String postfix(IBIWhereTreeNode node) {
        if (node == null) {
            return "<null>";
        }
        if (node instanceof IBIWhereTreePredicateNode) {
            return ((IBIWhereTreePredicateNode)node).toString();
        }
        if (node instanceof IBIWhereTreeNotNode) {
            return "(" + this.postfix(((IBIWhereTreeNotNode)node).getChild()) + ")NOT";
        }
        if (node instanceof IBIWhereTreeAndNode) {
            return "(" + this.postfix(((IBIWhereTreeAndNode)node).getLeft()) + ", " + this.postfix(((IBIWhereTreeAndNode)node).getRight()) + ")AND";
        }
        if (node instanceof IBIWhereTreeOrNode) {
            return "(" + this.postfix(((IBIWhereTreeOrNode)node).getLeft()) + ", " + this.postfix(((IBIWhereTreeOrNode)node).getRight()) + ")OR";
        }
        return "??";
    }

    public boolean isInCNF() {
        return BIWhereTree.isInCNF(this.root);
    }

    public boolean isInSelectOptions() {
        return BIWhereTree.isInSelectOptions(this.root);
    }

    public boolean isInMDX() {
        return BIWhereTree.isInSelectOptions(this.root);
    }

    private static boolean isInMDX(IBIWhereTreeNode node) {
        if (node == null) {
            return true;
        }
        if (!BIWhereTree.isInSelectOptions(node)) {
            return false;
        }
        Set operators = BIWhereTree.getPredicateOperators(node);
        Iterator i = operators.iterator();
        while (i.hasNext()) {
            IBISQLComparisonOperator oper = (IBISQLComparisonOperator)i.next();
            if (oper != null && oper.equals(IBISQLComparisonOperator.EQUALS) && oper.equals(IBISQLComparisonOperator.IN)) continue;
            return false;
        }
        return true;
    }

    private static boolean isInCNF(IBIWhereTreeNode node) {
        if (node == null) {
            return true;
        }
        if (node instanceof IBIWhereTreePredicateNode) {
            return true;
        }
        if (BIWhereTree.isOrBranch(node) || BIWhereTree.isAndBranch(node)) {
            return true;
        }
        if (node instanceof IBIWhereTreeOrNode) {
            return BIWhereTree.isOrBranch(((IBIWhereTreeOrNode)node).getLeft()) && BIWhereTree.isOrBranch(((IBIWhereTreeOrNode)node).getRight());
        }
        if (node instanceof IBIWhereTreeAndNode) {
            return BIWhereTree.isInCNF(((IBIWhereTreeAndNode)node).getLeft()) && BIWhereTree.isInCNF(((IBIWhereTreeAndNode)node).getRight());
        }
        return false;
    }

    private static boolean isInSelectOptions(IBIWhereTreeNode node) {
        if (node == null) {
            return true;
        }
        if (!BIWhereTree.isInCNF(node)) {
            return false;
        }
        Map branches = BIWhereTree.predicatesOfOrBranches(node);
        if (branches.size() < 1) {
            return true;
        }
        return BIWhereTree.checkPredicatesOfOrBranches(branches);
    }

    public List getPredicateList() {
        ArrayList<Set> result = new ArrayList<Set>();
        Map pred = this.predicatesOfOrBranches();
        Iterator i = pred.keySet().iterator();
        while (i.hasNext()) {
            Set p = (Set)pred.get(i.next());
            result.add(p);
        }
        return result;
    }

    private Map predicatesOfOrBranches() {
        return BIWhereTree.predicatesOfOrBranches(this.root);
    }

    private static Map predicatesOfOrBranches(IBIWhereTreeNode node) {
        HashMap branches = new HashMap();
        BIWhereTree.collectPredicatesOfOrBranches(node, branches);
        return branches;
    }

    private static void collectPredicatesOfOrBranches(IBIWhereTreeNode node, Map branches) {
        HashSet predicates = new HashSet();
        if (BIWhereTree.isOrBranch(node, predicates)) {
            branches.put(node, predicates);
        } else if (node instanceof IBIWhereTreeUnaryNode) {
            BIWhereTree.collectPredicatesOfOrBranches(((IBIWhereTreeUnaryNode)node).getChild(), branches);
        } else if (node instanceof IBIWhereTreeBinaryNode) {
            BIWhereTree.collectPredicatesOfOrBranches(((IBIWhereTreeBinaryNode)node).getLeft(), branches);
            BIWhereTree.collectPredicatesOfOrBranches(((IBIWhereTreeBinaryNode)node).getRight(), branches);
        }
    }

    private static Set columnNamesOfPredicates(Set predicates) {
        HashSet<String> colNames = new HashSet<String>();
        Iterator i = predicates.iterator();
        while (i.hasNext()) {
            IBIWhereTreeNode node = (IBIWhereTreeNode)i.next();
            if (node instanceof IBIWhereTreeNotNode) {
                colNames.add(((IBIWhereTreeColumnValueNode)((IBIWhereTreeNotNode)node).getChild()).getColumn().getName());
                continue;
            }
            if (node instanceof IBIWhereTreeColumnValueNode) {
                colNames.add(((IBIWhereTreeColumnValueNode)node).getColumn().getName());
                continue;
            }
            throw new RuntimeException("sdk.dac.rel.query_1019");
        }
        return colNames;
    }

    private static boolean checkPredicatesOfOrBranches(Map branches) {
        HashSet<String> used = new HashSet<String>();
        Iterator i = branches.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            Set predicates = (Set)entry.getValue();
            if (predicates != null) {
                if (predicates.size() > 1) {
                    Set columns = BIWhereTree.columnNamesOfPredicates(predicates);
                    if (columns.size() > 1) {
                        return false;
                    }
                    used.addAll(columns);
                    continue;
                }
                if (predicates.size() == 1) {
                    IBIWhereTreePredicateNode p;
                    IBIWhereTreeNode n = (IBIWhereTreeNode)predicates.toArray()[0];
                    if (n instanceof IBIWhereTreeNotNode) {
                        p = (IBIWhereTreePredicateNode)((IBIWhereTreeNotNode)n).getChild();
                        if (used.contains(p.getUniqueId())) {
                            return false;
                        }
                        used.add(p.getUniqueId());
                        continue;
                    }
                    if (n instanceof IBIWhereTreePredicateNode) {
                        p = (IBIWhereTreePredicateNode)n;
                        if (used.contains(p.getUniqueId())) {
                            return false;
                        }
                        used.add(p.getUniqueId());
                        continue;
                    }
                    return false;
                }
                return false;
            }
            return false;
        }
        return true;
    }

    private Set getPredicates() {
        return BIWhereTree.getPredicates(this.root);
    }

    private static Set getPredicates(IBIWhereTreeNode node) {
        HashSet set = new HashSet();
        BIWhereTree.getPredicates(node, set);
        return set;
    }

    private static void getPredicates(IBIWhereTreeNode node, Set set) {
        if (node instanceof IBIWhereTreePredicateNode) {
            set.add(((IBIWhereTreePredicateNode)node).getUniqueId());
        } else if (node instanceof IBIWhereTreeBinaryNode) {
            BIWhereTree.getPredicates(((IBIWhereTreeBinaryNode)node).getLeft(), set);
            BIWhereTree.getPredicates(((IBIWhereTreeBinaryNode)node).getRight(), set);
        } else if (node instanceof IBIWhereTreeUnaryNode) {
            if (((IBIWhereTreeUnaryNode)node).getChild() instanceof IBIWhereTreePredicateNode) {
                set.add(((IBIWhereTreePredicateNode)((IBIWhereTreeUnaryNode)node).getChild()).getUniqueId());
            } else {
                BIWhereTree.getPredicates(((IBIWhereTreeUnaryNode)node).getChild(), set);
            }
        }
    }

    public static boolean isOrBranch(IBIWhereTreeNode node) {
        HashSet set = new HashSet();
        return BIWhereTree.isOrBranch(node, set);
    }

    private static boolean isOrBranch(IBIWhereTreeNode node, Set predicates) {
        if (node instanceof IBIWhereTreePredicateNode) {
            predicates.add(node);
            return true;
        }
        if (node instanceof IBIWhereTreeNotNode) {
            if (((IBIWhereTreeNotNode)node).getChild() instanceof IBIWhereTreePredicateNode) {
                predicates.add(node);
                return true;
            }
            return false;
        }
        if (node instanceof IBIWhereTreeOrNode) {
            return BIWhereTree.isOrBranch(((IBIWhereTreeOrNode)node).getLeft(), predicates) && BIWhereTree.isOrBranch(((IBIWhereTreeOrNode)node).getRight(), predicates);
        }
        return false;
    }

    private Set columnNames(IBIWhereTreeNode node) {
        if (node instanceof IBIWhereTreePredicateNode) {
            HashSet<String> set = new HashSet<String>();
            set.add(((IBIWhereTreePredicateNode)node).getUniqueId());
            return set;
        }
        if (node instanceof IBIWhereTreeUnaryNode) {
            return this.columnNames(((IBIWhereTreeUnaryNode)node).getChild());
        }
        if (node instanceof IBIWhereTreeBinaryNode) {
            Set left = this.columnNames(((IBIWhereTreeBinaryNode)node).getLeft());
            Set right = this.columnNames(((IBIWhereTreeBinaryNode)node).getRight());
            HashSet set = new HashSet();
            set.addAll(left);
            set.addAll(right);
            return set;
        }
        return Collections.EMPTY_SET;
    }

    public static boolean isAndBranch(IBIWhereTreeNode node) {
        if (node instanceof IBIWhereTreePredicateNode) {
            return true;
        }
        if (node instanceof IBIWhereTreeAndNode) {
            return BIWhereTree.isAndBranch(((IBIWhereTreeAndNode)node).getLeft()) && BIWhereTree.isAndBranch(((IBIWhereTreeAndNode)node).getRight());
        }
        return false;
    }

    public static IBIWhereTreeNode pushDownOr(IBIWhereTreeNode node) {
        if (node == null) {
            return null;
        }
        if (node instanceof IBIWhereTreeNotNode) {
            return new BIWhereTreeNotNode(BIWhereTree.pushDownOr(((IBIWhereTreeNotNode)node).getChild()));
        }
        if (node instanceof IBIWhereTreeAndNode) {
            return new BIWhereTreeAndNode(BIWhereTree.pushDownOr(((IBIWhereTreeAndNode)node).getLeft()), BIWhereTree.pushDownOr(((IBIWhereTreeAndNode)node).getRight()));
        }
        if (node instanceof IBIWhereTreeOrNode) {
            if (BIWhereTree.isOrBranch(node)) {
                return node;
            }
            IBIWhereTreeNode left = BIWhereTree.pushDownOr(((IBIWhereTreeOrNode)node).getLeft());
            IBIWhereTreeNode right = BIWhereTree.pushDownOr(((IBIWhereTreeOrNode)node).getRight());
            if (!(left instanceof IBIWhereTreeAndNode) && right instanceof IBIWhereTreeAndNode) {
                return new BIWhereTreeAndNode(new BIWhereTreeOrNode(left, ((IBIWhereTreeAndNode)right).getLeft()), new BIWhereTreeOrNode(left, ((IBIWhereTreeAndNode)right).getRight()));
            }
            if (left instanceof IBIWhereTreeAndNode && !(right instanceof IBIWhereTreeAndNode)) {
                return new BIWhereTreeAndNode(new BIWhereTreeOrNode(((IBIWhereTreeAndNode)left).getLeft(), right), new BIWhereTreeOrNode(((IBIWhereTreeAndNode)left).getRight(), right));
            }
            if (left instanceof IBIWhereTreeOrNode && right instanceof IBIWhereTreeOrNode) {
                throw new RuntimeException();
            }
            if (BIWhereTree.size(left) < BIWhereTree.size(right)) {
                return new BIWhereTreeAndNode(new BIWhereTreeOrNode(left, ((IBIWhereTreeAndNode)right).getLeft()), new BIWhereTreeOrNode(left, ((IBIWhereTreeAndNode)right).getRight()));
            }
            return new BIWhereTreeAndNode(new BIWhereTreeOrNode(((IBIWhereTreeAndNode)left).getLeft(), right), new BIWhereTreeOrNode(((IBIWhereTreeAndNode)left).getRight(), right));
        }
        if (node instanceof IBIWhereTreePredicateNode) {
            return node;
        }
        throw new RuntimeException();
    }

    public static int size(IBIWhereTreeNode node) {
        if (node instanceof IBIWhereTreePredicateNode) {
            return 1;
        }
        if (node instanceof IBIWhereTreeUnaryNode) {
            return 1 + BIWhereTree.size(((IBIWhereTreeUnaryNode)node).getChild());
        }
        if (node instanceof IBIWhereTreeBinaryNode) {
            return 1 + BIWhereTree.size(((IBIWhereTreeBinaryNode)node).getLeft()) + BIWhereTree.size(((IBIWhereTreeBinaryNode)node).getRight());
        }
        return 0;
    }

    public static int height(IBIWhereTreeNode node) {
        if (node instanceof IBIWhereTreePredicateNode) {
            return 1;
        }
        if (node instanceof IBIWhereTreeUnaryNode) {
            return 1 + BIWhereTree.height(((IBIWhereTreeUnaryNode)node).getChild());
        }
        if (node instanceof IBIWhereTreeBinaryNode) {
            return 1 + Math.max(BIWhereTree.height(((IBIWhereTreeBinaryNode)node).getLeft()), BIWhereTree.height(((IBIWhereTreeBinaryNode)node).getRight()));
        }
        return 0;
    }

    public static IBIWhereTreeNode pushDownNot(IBIWhereTreeNode node) {
        if (node == null) {
            return null;
        }
        if (node instanceof IBIWhereTreeNotNode) {
            IBIWhereTreeNode child = ((IBIWhereTreeNotNode)node).getChild();
            if (child instanceof IBIWhereTreeNotNode) {
                return BIWhereTree.pushDownNot(((IBIWhereTreeNotNode)child).getChild());
            }
            if (child instanceof IBIWhereTreeAndNode) {
                return new BIWhereTreeOrNode(BIWhereTree.pushDownNot(new BIWhereTreeNotNode(((IBIWhereTreeAndNode)child).getLeft())), BIWhereTree.pushDownNot(new BIWhereTreeNotNode(((IBIWhereTreeAndNode)child).getRight())));
            }
            if (child instanceof IBIWhereTreeOrNode) {
                return new BIWhereTreeAndNode(BIWhereTree.pushDownNot(new BIWhereTreeNotNode(((IBIWhereTreeOrNode)child).getLeft())), BIWhereTree.pushDownNot(new BIWhereTreeNotNode(((IBIWhereTreeOrNode)child).getRight())));
            }
            if (child instanceof IBIWhereTreePredicateNode) {
                return node;
            }
            throw new RuntimeException();
        }
        if (node instanceof IBIWhereTreeAndNode) {
            return new BIWhereTreeAndNode(BIWhereTree.pushDownNot(((IBIWhereTreeAndNode)node).getLeft()), BIWhereTree.pushDownNot(((IBIWhereTreeAndNode)node).getRight()));
        }
        if (node instanceof IBIWhereTreeOrNode) {
            return new BIWhereTreeOrNode(BIWhereTree.pushDownNot(((IBIWhereTreeOrNode)node).getLeft()), BIWhereTree.pushDownNot(((IBIWhereTreeOrNode)node).getRight()));
        }
        if (node instanceof IBIWhereTreePredicateNode) {
            return node;
        }
        throw new RuntimeException();
    }

    public void normalize() {
        this.root = BIWhereTree.normalize(this.root);
    }

    public static IBIWhereTreeNode normalize(IBIWhereTreeNode node) {
        if (node == null) {
            return null;
        }
        return BIWhereTree.pushDownOr(BIWhereTree.pushDownNot(node));
    }

    private boolean equalsRoot(IBIWhereTreeNode other) {
        if (this.root == null) {
            return this.root == other;
        }
        return this.root.equals(other);
    }

    private Set getPredicateOperators() {
        return BIWhereTree.getPredicateOperators(this.root);
    }

    private static Set getPredicateOperators(IBIWhereTreeNode node) {
        HashSet operators = new HashSet();
        BIWhereTree.getPredicateOperators(node, operators);
        return operators;
    }

    private static void getPredicateOperators(IBIWhereTreeNode node, Set operators) {
        if (node != null) {
            if (node instanceof IBIWhereTreeAndNode) {
                BIWhereTree.getPredicateOperators(((IBIWhereTreeAndNode)node).getLeft(), operators);
                BIWhereTree.getPredicateOperators(((IBIWhereTreeAndNode)node).getRight(), operators);
            } else if (node instanceof IBIWhereTreeOrNode) {
                BIWhereTree.getPredicateOperators(((IBIWhereTreeAndNode)node).getLeft(), operators);
                BIWhereTree.getPredicateOperators(((IBIWhereTreeAndNode)node).getRight(), operators);
            } else if (node instanceof IBIWhereTreeColumnValueNode) {
                BIWhereTree.getPredicateOperators(((IBIWhereTreeNotNode)node).getChild(), operators);
            } else if (node instanceof IBIWhereTreeColumnJoinNode) {
                operators.add(((IBIWhereTreeColumnValueNode)node).getOper());
            } else if (node instanceof IBIWhereTreeColumnSubQueryNode) {
                operators.add(((IBIWhereTreeColumnValueNode)node).getOper());
            }
        }
    }

    private static List getCNF(IBIWhereTreeNode node) {
        IBIWhereTreeNode normalized = BIWhereTree.normalize(node);
        return null;
    }

    public static boolean isValuesEnumeration(IBIWhereTreeNode node) {
        if (node == null) {
            return true;
        }
        if (node instanceof IBIWhereTreeOrNode) {
            IBIWhereTreeNode left = ((IBIWhereTreeOrNode)node).getLeft();
            IBIWhereTreeNode right = ((IBIWhereTreeOrNode)node).getRight();
            return BIWhereTree.isValuesEnumeration(left) && BIWhereTree.isValuesEnumeration(right);
        }
        if (node instanceof IBIWhereTreeNotNode) {
            IBIWhereTreeNode child = ((IBIWhereTreeNotNode)node).getChild();
            return BIWhereTree.isValuesEnumeration(child);
        }
        if (node instanceof IBIWhereTreeColumnValueNode) {
            return IBISQLComparisonOperator.EQUALS == ((IBIWhereTreeColumnValueNode)node).getOper();
        }
        return false;
    }

    public static List getEnumerationValues(IBIWhereTreeNode node) {
        if (node == null) {
            return Collections.EMPTY_LIST;
        }
        List list = BIWhereTree.getEnumerationValues(new ArrayList(), node);
        return list;
    }

    private static List getEnumerationValues(List list, IBIWhereTreeNode node) {
        List tmp = list;
        if (node instanceof IBIWhereTreeOrNode) {
            tmp = BIWhereTree.getEnumerationValues(tmp, ((IBIWhereTreeOrNode)node).getLeft());
            tmp = BIWhereTree.getEnumerationValues(tmp, ((IBIWhereTreeOrNode)node).getRight());
            return tmp;
        }
        if (node instanceof IBIWhereTreeNotNode) {
            tmp = BIWhereTree.getEnumerationValues(tmp, ((IBIWhereTreeNotNode)node).getChild());
            return tmp;
        }
        if (node instanceof IBIWhereTreeColumnValueNode) {
            Object[] values = ((IBIWhereTreeColumnValueNode)node).getValue();
            IBISQLComparisonOperator oper = ((IBIWhereTreeColumnValueNode)node).getOper();
            if (oper != IBISQLComparisonOperator.EQUALS) {
                throw new BIRuntimeException(IBIConnectionInfo.DEFAULT.getLocale(), "sdk.dac.rel.query_1029", new Object[]{IBISQLComparisonOperator.EQUALS, oper});
            }
            if (values == null || values.length != 1) {
                throw new BIRuntimeException(IBIConnectionInfo.DEFAULT.getLocale(), "sdk.dac.rel.query_1030", new Object[]{new Integer(1), values == null ? null : new Integer(values.length)});
            }
            tmp.add(values[0]);
            return tmp;
        }
        throw new BIRuntimeException(IBIConnectionInfo.DEFAULT.getLocale(), "sdk.dac.rel.query_1019");
    }
}

