/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.relational.query.sql.impl;

import com.sap.ip.bi.sdk.dac.relational.query.sql.IBISQLComparisonOperator;
import com.sap.ip.bi.sdk.dac.relational.query.sql.IBISQLKeyword;
import com.sap.ip.bi.sdk.dac.relational.query.sql.impl.BISQLKeyword;
import java.util.HashMap;
import java.util.Map;

public class BISQLComparisonOperator
implements IBISQLComparisonOperator {
    private final BISQLKeyword keyword;
    private final int argCount;
    private static Map comparisons = new HashMap();
    public static final BISQLComparisonOperator EQUALS = new BISQLComparisonOperator(BISQLKeyword.EQUALS, 1);
    public static final BISQLComparisonOperator NOT_EQUALS = new BISQLComparisonOperator(BISQLKeyword.NOT_EQUALS, 1);
    public static final BISQLComparisonOperator LESS_EQUALS = new BISQLComparisonOperator(BISQLKeyword.LESS_EQUALS, 1);
    public static final BISQLComparisonOperator LESS_THAN = new BISQLComparisonOperator(BISQLKeyword.LESS_THAN, 1);
    public static final BISQLComparisonOperator GREATER_EQUALS = new BISQLComparisonOperator(BISQLKeyword.GREATER_EQUALS, 1);
    public static final BISQLComparisonOperator GREATER_THAN = new BISQLComparisonOperator(BISQLKeyword.GREATER_THAN, 1);
    public static final BISQLComparisonOperator IN = new BISQLComparisonOperator(BISQLKeyword.IN, -1);
    public static final BISQLComparisonOperator LIKE = new BISQLComparisonOperator(BISQLKeyword.LIKE, 1);
    public static final BISQLComparisonOperator BETWEEN = new BISQLComparisonOperator(BISQLKeyword.BETWEEN, 2);
    public static final BISQLComparisonOperator IS_NULL = new BISQLComparisonOperator(BISQLKeyword.IS_NULL, 0);

    private BISQLComparisonOperator(BISQLKeyword keyword, int argCount) {
        this.keyword = keyword;
        this.argCount = argCount;
        comparisons.put(keyword.toString(), this);
    }

    public int argCount() {
        return this.argCount;
    }

    public String toString() {
        return this.keyword.toString();
    }

    public IBISQLKeyword getKeyword() {
        return this.keyword;
    }

    public boolean equals(String value) {
        return this.keyword != null && this.keyword.equals(value);
    }

    public static IBISQLComparisonOperator get(String function) {
        return (IBISQLComparisonOperator)comparisons.get(function);
    }
}

