/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.relational.query.sql.impl;

import com.sap.ip.bi.sdk.dac.connector.impl.BIConnectionInfo;
import com.sap.ip.bi.sdk.dac.connector.impl.IBIConnectionInfo;
import com.sap.ip.bi.sdk.dac.relational.query.IBIQuery;
import com.sap.ip.bi.sdk.dac.relational.query.IBIQueryExpression;
import com.sap.ip.bi.sdk.dac.relational.query.IBIQueryExpressionColumnRef;
import com.sap.ip.bi.sdk.dac.relational.query.IBIQueryExpressionGroupByRef;
import com.sap.ip.bi.sdk.dac.relational.query.IBIQueryExpressionOrderByRef;
import com.sap.ip.bi.sdk.dac.relational.query.IBIQueryExpressionSelectColumnRef;
import com.sap.ip.bi.sdk.dac.relational.query.IBIQueryExpressionTableRef;
import com.sap.ip.bi.sdk.dac.relational.query.impl.BIQueryExpression;
import com.sap.ip.bi.sdk.dac.relational.query.sql.IBISQLAggregateFunction;
import com.sap.ip.bi.sdk.dac.relational.query.sql.IBISQLComparisonOperator;
import com.sap.ip.bi.sdk.dac.relational.query.sql.IBISQLKeyword;
import com.sap.ip.bi.sdk.dac.relational.query.sql.IBISQLLogicalOperator;
import com.sap.ip.bi.sdk.dac.relational.query.tree.IBIWhereTree;
import com.sap.ip.bi.sdk.dac.relational.query.tree.IBIWhereTreeAndNode;
import com.sap.ip.bi.sdk.dac.relational.query.tree.IBIWhereTreeColumnJoinNode;
import com.sap.ip.bi.sdk.dac.relational.query.tree.IBIWhereTreeColumnSubQueryNode;
import com.sap.ip.bi.sdk.dac.relational.query.tree.IBIWhereTreeColumnValueNode;
import com.sap.ip.bi.sdk.dac.relational.query.tree.IBIWhereTreeNode;
import com.sap.ip.bi.sdk.dac.relational.query.tree.IBIWhereTreeNotNode;
import com.sap.ip.bi.sdk.dac.relational.query.tree.IBIWhereTreeOrNode;
import com.sap.ip.bi.sdk.exception.BIResourceException;
import com.sap.ip.bi.sdk.exception.BIRuntimeException;
import com.sap.ip.bi.sdk.util.BILoggingSetup;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Iterator;
import org.omg.cwm.resource.relational.Catalog;
import org.omg.cwm.resource.relational.Column;
import org.omg.cwm.resource.relational.Schema;
import org.omg.cwm.resource.relational.SqlsimpleType;
import org.omg.cwm.resource.relational.Table;

public class BIParseQueryExpression {
    private static final char SPACE = ' ';
    private static final char COMMA = ',';
    private static final char DOUBLE_QUOTE = '\"';
    private static final char SINGLE_QUOTE = '\'';
    private static final char DOT = '.';
    private static final char ASTERISK = '*';
    private static final char OPEN_PAREN = '(';
    private static final char CLOSE_PAREN = ')';
    private static final String SPACE_S = " ";
    private static final String COMMA_S = ", ";
    private static final String DOUBLE_QUOTE_S = "\"";
    private static final String SINGLE_QUOTE_S = "'";
    private static final String DOT_S = ".";
    private static final String ASTERISK_S = "*";
    private static final String EMPTY_S = "";
    private IBIQueryExpression expr = null;
    private DatabaseMetaData meta = null;
    private IBIConnectionInfo connectionInfo = IBIConnectionInfo.DEFAULT;
    private static final Location loggingLoc = Location.getLocation((String)(class$com$sap$ip$bi$sdk$dac$relational$query$sql$impl$BIParseQueryExpression == null ? (class$com$sap$ip$bi$sdk$dac$relational$query$sql$impl$BIParseQueryExpression = BIParseQueryExpression.class$("com.sap.ip.bi.sdk.dac.relational.query.sql.impl.BIParseQueryExpression")) : class$com$sap$ip$bi$sdk$dac$relational$query$sql$impl$BIParseQueryExpression).getName());
    private static final Category loggingCat = BILoggingSetup.QUERY.getCategory();
    static /* synthetic */ Class class$com$sap$ip$bi$sdk$dac$relational$query$sql$impl$BIParseQueryExpression;

    public BIParseQueryExpression(IBIConnectionInfo connectionInfo, IBIQuery query, DatabaseMetaData meta) throws BIResourceException {
        this.connectionInfo = connectionInfo;
        BIConnectionInfo.assertConnectionInfo((IBIConnectionInfo)connectionInfo);
        if (meta == null || query == null || !(query.getExpression() instanceof BIQueryExpression)) {
            throw new BIResourceException(connectionInfo.getLocale(), "sdk.dac.connector_1200");
        }
        this.expr = (BIQueryExpression)query.getExpression();
        this.meta = meta;
    }

    public String getCommandText() throws BIResourceException {
        String orderBy;
        String groupBy;
        String where;
        String from;
        StringBuffer buffer = new StringBuffer();
        String select = this.parseSelectClause();
        if (select != null) {
            buffer.append(IBISQLKeyword.SELECT.toString()).append(' ').append(select);
        }
        if ((from = this.parseFromClause()) != null) {
            buffer.append(' ').append(IBISQLKeyword.FROM.toString()).append(' ').append(from);
        }
        if ((where = this.parseWhereClause()) != null) {
            buffer.append(' ').append(IBISQLKeyword.WHERE.toString()).append(' ').append(where);
        }
        if ((groupBy = this.parseGroupByClause()) != null) {
            buffer.append(' ').append(IBISQLKeyword.GROUP_BY.toString()).append(' ').append(groupBy);
        }
        if ((orderBy = this.parseOrderByClause()) != null) {
            buffer.append(' ').append(IBISQLKeyword.ORDER_BY.toString()).append(' ').append(orderBy);
        }
        return buffer.toString();
    }

    private String parseSelectClause() throws BIResourceException {
        StringBuffer buffer = new StringBuffer();
        String sep = EMPTY_S;
        Iterator i = this.expr.getColumnRef().iterator();
        while (i.hasNext()) {
            buffer.append(sep).append(this.parseSelectColumnReference((IBIQueryExpressionSelectColumnRef)i.next()));
            sep = COMMA_S;
        }
        if (buffer.length() == 0) {
            return null;
        }
        return buffer.toString();
    }

    private String parseFromClause() throws BIResourceException {
        StringBuffer buffer = new StringBuffer();
        String sep = EMPTY_S;
        Iterator i = this.expr.getTableRef().iterator();
        while (i.hasNext()) {
            buffer.append(sep).append(this.parseTableReference((IBIQueryExpressionTableRef)i.next()));
            sep = COMMA_S;
        }
        if (buffer.length() == 0) {
            return null;
        }
        return buffer.toString();
    }

    private String parseGroupByClause() throws BIResourceException {
        StringBuffer buffer = new StringBuffer();
        String sep = EMPTY_S;
        Iterator i = this.expr.getGroupByRef().iterator();
        while (i.hasNext()) {
            buffer.append(sep).append(this.parseGroupByReference((IBIQueryExpressionGroupByRef)i.next()));
            sep = COMMA_S;
        }
        if (buffer.length() == 0) {
            return null;
        }
        return buffer.toString();
    }

    private String parseOrderByClause() throws BIResourceException {
        StringBuffer buffer = new StringBuffer();
        String sep = EMPTY_S;
        Iterator i = this.expr.getOrderByRef().iterator();
        while (i.hasNext()) {
            buffer.append(sep).append(this.parseOrderByReference((IBIQueryExpressionOrderByRef)i.next()));
            sep = COMMA_S;
        }
        if (buffer.length() == 0) {
            return null;
        }
        return buffer.toString();
    }

    private String parseWhereClause() throws BIResourceException {
        IBIWhereTree tree = this.expr.getWhereTree();
        if (tree.getRoot() != null) {
            String where = this.parseWhereNode(tree.getRoot());
            return where;
        }
        return null;
    }

    private String parseWhereNode(IBIWhereTreeNode node) throws BIResourceException {
        if (node instanceof IBIWhereTreeNotNode) {
            String not = this.parseWhereNode(((IBIWhereTreeNotNode)node).getChild());
            return IBISQLLogicalOperator.NOT.toString() + ' ' + '(' + not + ')';
        }
        if (node instanceof IBIWhereTreeAndNode) {
            String left = this.parseWhereNode(((IBIWhereTreeAndNode)node).getLeft());
            String right = this.parseWhereNode(((IBIWhereTreeAndNode)node).getRight());
            return '(' + left + ')' + ' ' + IBISQLLogicalOperator.AND.toString() + ' ' + '(' + right + ')';
        }
        if (node instanceof IBIWhereTreeOrNode) {
            String left = this.parseWhereNode(((IBIWhereTreeOrNode)node).getLeft());
            String right = this.parseWhereNode(((IBIWhereTreeOrNode)node).getRight());
            return '(' + left + ')' + ' ' + IBISQLLogicalOperator.OR.toString() + ' ' + '(' + right + ')';
        }
        if (node instanceof IBIWhereTreeColumnValueNode) {
            return this.parseWhereColumnValueNode((IBIWhereTreeColumnValueNode)node);
        }
        if (node instanceof IBIWhereTreeColumnJoinNode) {
            return this.parseWhereColumnJoinNode((IBIWhereTreeColumnJoinNode)node);
        }
        if (node instanceof IBIWhereTreeColumnSubQueryNode) {
            return this.parseWhereColumnSubQueryNode((IBIWhereTreeColumnSubQueryNode)node);
        }
        throw new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1019");
    }

    /*
     * Unable to fully structure code
     */
    private String parseWhereColumnValueNode(IBIWhereTreeColumnValueNode node) throws BIResourceException {
        block5: {
            column = this.parseColumnReference(node.getTableRef(), node.getColumn());
            if (IBISQLComparisonOperator.BETWEEN.equals(node.getOper())) {
                low = this.parseColumnValue(node.getColumn(), node.getValue(), 0);
                high = this.parseColumnValue(node.getColumn(), node.getValue(), 1);
                return column + ' ' + node.getOper().toString() + ' ' + low + ' ' + IBISQLKeyword.AND.toString() + ' ' + high;
            }
            if (!IBISQLComparisonOperator.IN.equals(node.getOper())) break block5;
            buffer = new StringBuffer();
            buffer.append(column).append(' ').append(node.getOper().toString()).append(' ').append('(');
            sep = "";
            values = node.getValue();
            i = 0;
            if (true) ** GOTO lbl19
            do {
                buffer.append(sep).append(this.parseColumnValue(node.getColumn(), values, i));
                sep = ", ";
                ++i;
lbl19:
                // 2 sources

                if (values != null) {
                    if (i < values.length) {
                        v0 = true;
                        continue;
                    }
                    v0 = false;
                    continue;
                }
                v0 = false;
            } while (v0);
            buffer.append(')');
            return buffer.toString();
        }
        if (IBISQLComparisonOperator.IS_NULL.equals(node.getOper())) {
            buffer = new StringBuffer();
            buffer.append(column).append(' ').append(node.getOper().toString());
            return buffer.toString();
        }
        value = this.parseColumnValue(node.getColumn(), node.getValue());
        return column + ' ' + node.getOper().toString() + ' ' + value;
    }

    private String parseColumnValue(Column column, Object[] value) {
        if (value == null || value.length == 0) {
            return null;
        }
        if (value.length == 1) {
            return this.quoteLiteral(column, value[0]);
        }
        StringBuffer buffer = new StringBuffer().append('(');
        String sep = EMPTY_S;
        int i = 0;
        while (i < value.length) {
            buffer.append(sep).append(this.quoteLiteral(column, value[i]));
            ++i;
        }
        buffer.append(')');
        return buffer.toString();
    }

    private String parseColumnValue(Column column, Object[] value, int index) {
        if (value == null || value.length == 0) {
            return null;
        }
        return this.quoteLiteral(column, value[index].toString());
    }

    private String parseWhereColumnJoinNode(IBIWhereTreeColumnJoinNode node) throws BIResourceException {
        String left = this.parseColumnReference(node.getTableRef(), node.getColumn());
        String right = this.parseColumnReference(node.getOtherTableRef(), node.getOtherColumn());
        return left + ' ' + node.getOper().toString() + ' ' + right;
    }

    private String parseWhereColumnSubQueryNode(IBIWhereTreeColumnSubQueryNode node) throws BIResourceException {
        String column = this.parseColumnReference(node.getTableRef(), node.getColumn());
        IBIQuery subQuery = node.getSubSelect();
        subQuery.synchronize();
        BIParseQueryExpression subParse = new BIParseQueryExpression(this.connectionInfo, subQuery, this.meta);
        String subSelect = subParse.getCommandText();
        return column + ' ' + node.getOper().toString() + ' ' + '(' + subSelect + ')';
    }

    private String parseTableReference(IBIQueryExpressionTableRef tableRef) throws BIResourceException {
        StringBuffer buffer = new StringBuffer();
        Table table = tableRef.getTable();
        Schema schema = (Schema)table.getNamespace();
        Catalog catalog = (Catalog)schema.getNamespace();
        try {
            if (this.meta.supportsSchemasInDataManipulation() && schema.getName() != null && schema.getName().length() > 0) {
                buffer.append(this.quoteSchema(schema.getName()));
                buffer.append('.');
            }
            buffer.append(this.quoteSchema(table.getName()));
            if (this.meta.supportsCatalogsInDataManipulation() && catalog.getName() != null && catalog.getName().length() > 0) {
                if (this.meta.isCatalogAtStart()) {
                    buffer.insert(0, this.meta.getCatalogSeparator());
                    buffer.insert(0, this.quoteSchema(catalog.getName()));
                } else {
                    buffer.append(this.meta.getCatalogSeparator());
                    buffer.append(this.quoteSchema(catalog.getName()));
                }
            }
        }
        catch (SQLException ex) {
            loggingCat.logThrowableT(400, loggingLoc, ex.toString(), (Throwable)ex);
            throw new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1108", (Throwable)ex);
        }
        if (tableRef.getTableRef() != null) {
            buffer.append(' ').append(this.quoteSchema(tableRef.getTableRef()));
        }
        return buffer.toString();
    }

    private String parseGroupByReference(IBIQueryExpressionGroupByRef groupByRef) throws BIResourceException {
        return this.parseColumnReference(groupByRef);
    }

    private String parseColumnReference(IBIQueryExpressionColumnRef columnRef) throws BIResourceException {
        return this.parseColumnReference(columnRef.getTableRef(), columnRef.getColumn());
    }

    private String parseColumnReference(String tableRef, Column column) throws BIResourceException {
        StringBuffer buffer = new StringBuffer();
        if (tableRef != null) {
            buffer.append(this.quoteSchema(tableRef)).append('.').append(this.quoteSchema(column.getName()));
        } else {
            Table table = (Table)column.getOwner();
            Schema schema = (Schema)table.getNamespace();
            Catalog catalog = (Catalog)schema.getNamespace();
            try {
                if (this.meta.supportsSchemasInDataManipulation() && schema.getName() != null && schema.getName().length() > 0) {
                    buffer.append(this.quoteSchema(schema.getName()));
                    buffer.append('.');
                }
                buffer.append(this.quoteSchema(table.getName()));
                buffer.append('.');
                buffer.append(this.quoteSchema(column.getName()));
                if (this.meta.supportsCatalogsInDataManipulation() && catalog.getName() != null && catalog.getName().length() > 0) {
                    if (this.meta.isCatalogAtStart()) {
                        buffer.insert(0, this.meta.getCatalogSeparator());
                        buffer.insert(0, this.quoteSchema(catalog.getName()));
                    } else {
                        buffer.append(this.meta.getCatalogSeparator());
                        buffer.append(this.quoteSchema(catalog.getName()));
                    }
                }
            }
            catch (SQLException ex) {
                loggingCat.logThrowableT(400, loggingLoc, ex.toString(), (Throwable)ex);
                throw new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1108", (Throwable)ex);
            }
        }
        return buffer.toString();
    }

    private String parseSelectColumnReference(IBIQueryExpressionSelectColumnRef columnRef) throws BIResourceException {
        StringBuffer buffer = new StringBuffer();
        if (columnRef.getAggr() == IBISQLAggregateFunction.COUNT && columnRef.getColumn() == null) {
            buffer.append(columnRef.getAggr().toString()).append('(');
            if (columnRef.getTableRef() != null) {
                buffer.append(this.quoteSchema(columnRef.getTableRef())).append('.');
            }
            buffer.append('*').append(')');
        } else {
            buffer.append(this.parseColumnReference(columnRef));
            if (columnRef.getAggr() != null) {
                buffer.insert(0, '(').insert(0, columnRef.getAggr().toString()).append(')');
            }
        }
        if (columnRef.getColumnRef() != null) {
            buffer.append(' ').append(IBISQLKeyword.AS.toString()).append(' ').append(this.quoteSchema(columnRef.getColumnRef()));
        }
        return buffer.toString();
    }

    private String parseOrderByReference(IBIQueryExpressionOrderByRef orderByRef) throws BIResourceException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.parseColumnReference(orderByRef));
        if (orderByRef.isAscending()) {
            buffer.append(' ').append(IBISQLKeyword.ASC);
        } else {
            buffer.append(' ').append(IBISQLKeyword.DESC);
        }
        return buffer.toString();
    }

    private String quoteSchema(String name) {
        try {
            String quote = this.meta.getIdentifierQuoteString();
            if (quote == null) {
                return name;
            }
            return quote + name + quote;
        }
        catch (SQLException ex) {
            return name;
        }
    }

    private String quoteLiteral(Column column, Object item) {
        int sqlType = ((SqlsimpleType)column.getType()).getTypeNumber();
        switch (sqlType) {
            case -5: {
                return item.toString();
            }
            case 1: {
                return this.quoteObject(item);
            }
            case 91: {
                return this.quoteObject(item);
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                return item.toString();
            }
            case -1: {
                return this.quoteObject(item);
            }
            case 2: {
                return item.toString();
            }
            case 7: {
                return item.toString();
            }
            case 5: {
                return item.toString();
            }
            case 92: {
                return this.quoteObject(item);
            }
            case 93: {
                return this.quoteObject(item);
            }
            case -6: {
                return item.toString();
            }
            case 12: {
                return this.quoteObject(item);
            }
        }
        BIRuntimeException ex = new BIRuntimeException(IBIConnectionInfo.DEFAULT.getLocale(), "sdk_0000", new Object[]{new Integer(sqlType)});
        loggingCat.logThrowableT(400, loggingLoc, "Unknown type: " + sqlType + '|' + column.getName() + '|' + column.getType().getName(), (Throwable)ex);
        return this.quoteObject(item);
    }

    private String quoteObject(Object item) {
        return '\'' + item.toString() + '\'';
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

