/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.relational.query.sql.impl;

import com.sap.ip.bi.sdk.dac.connector.impl.IBIConnectionInfo;
import com.sap.ip.bi.sdk.dac.relational.query.sql.IBIParseNodeFactory;
import com.sap.ip.bi.sdk.dac.relational.query.sql.IBIParseOperation;
import com.sap.ip.bi.sdk.dac.relational.query.sql.IBISQLKeyword;
import com.sap.ip.bi.sdk.dac.relational.query.sql.impl.BIParseExpressionNode;
import com.sap.ip.bi.sdk.dac.relational.query.sql.impl.BISQLKeyword;
import com.sap.ip.bi.sdk.exception.BIResourceException;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.omg.cwm.foundation.expressions.ConstantNode;
import org.omg.cwm.foundation.expressions.ElementNode;
import org.omg.cwm.foundation.expressions.ExpressionNode;
import org.omg.cwm.foundation.expressions.FeatureNode;
import org.omg.cwm.objectmodel.behavioral.Operation;
import org.omg.cwm.resource.relational.Column;
import org.omg.cwm.resource.relational.Table;

class BIParseOperation
extends BIParseExpressionNode
implements IBIParseOperation {
    protected static final char SPACE = ' ';
    protected static final char SCHEMA_SEP = '.';
    protected static final char OPEN_PAREN = '(';
    protected static final char CLOSE_PAREN = ')';
    protected static final int TYPE_UNDEFINED = 0;
    protected static final int TYPE_IS_LIST = 1;
    protected static final int TYPE_CLAUSE = 2;
    protected static final int TYPE_FUNCTION = 4;
    protected static final int TYPE_CONSTANT = 8;
    protected static final int TYPE_STRING = 16;
    protected static final int TYPE_TABLE = 32;
    protected static final int TYPE_ALIAS = 64;
    protected static final int TYPE_COLUMN = 128;
    protected static final int TYPE_REF = 256;
    protected static final int TYPE_SORT_ORDER = 512;
    protected static final int TYPE_SUBSELECT = 1024;
    protected static final OperType UNKNOWN = OperType.UNKNOWN;
    protected static final OperType INTERNAL = OperType.INTERNAL;
    protected static final OperType FUNCTION = OperType.FUNCTION;
    protected static final OperType PREFIX = OperType.PREFIX;
    protected static final OperType INFIX = OperType.INFIX;
    protected static final OperType INFIX_1XN = OperType.INFIX_1XN;
    protected static final OperType POSTFIX = OperType.POSTFIX;
    protected static final ListSeparator SPACE_SEPARATED = ListSeparator.SPACE_SEPARATED;
    protected static final ListSeparator COMMA_SEPARATED = ListSeparator.COMMA_SEPARATED;
    protected static final ListSeparator AND_SEPARATED = ListSeparator.AND_SEPARATED;
    protected static final ListSeparator NO_LIST = ListSeparator.NO_LIST;
    protected static final boolean SUPPORTED = true;
    protected static final boolean NOT_SUPPORTED = true;
    protected static final ParenType PARENS = ParenType.PARENS;
    protected static final ParenType NO_PARENS = ParenType.NO_PARENS;
    protected static final ParenType RHS_PARENS = ParenType.RHS_PARENS;
    protected static final int _KEYWORD = 0;
    protected static final int _OPERTYPE = 1;
    protected static final int _LISTSEP = 2;
    protected static final int _PARENS = 3;
    protected static final int _SUPPORT = 4;
    private static Map operationName = new HashMap();

    protected BIParseOperation(IBIConnectionInfo connectionInfo) {
        super(connectionInfo);
    }

    public BIParseOperation(IBIConnectionInfo connectionInfo, IBIParseNodeFactory factory) throws BIResourceException {
        super(connectionInfo, factory);
    }

    public String evaluate(Operation node, List args) throws BIResourceException {
        this.assertOperationSignature(node, args);
        String name = node.getName();
        StringBuffer buffer = new StringBuffer();
        this.debugStart(node);
        if (this.isOperSupported(name)) {
            OperType type = this.getOperType(name);
            if (type == PREFIX) {
                return this.formatPrefixOperator(name, this.parseArgList(name, args));
            }
            if (type == INFIX) {
                String eval = buffer.append(this.getParen(name, '(')).append(this.parseArgument(name, args, 0)).append(' ').append(name).append(' ').append(this.parseArgument(name, args, 1)).append(this.getParen(name, ')')).toString();
                this.debugEnd();
                return eval;
            }
            if (type == INFIX_1XN) {
                String eval = buffer.append(this.parseArgument(name, args, 0)).append(' ').append(name).append(' ').append(this.getParen(name, '(')).append(this.parseArgList(name, args, 1)).append(this.getParen(name, ')')).toString();
                this.debugEnd();
                return eval;
            }
            if (type == POSTFIX) {
                String eval = buffer.append(this.parseArgument(name, args, 0)).append(' ').append(name).toString();
                this.debugEnd();
                return eval;
            }
            if (type == FUNCTION) {
                String eval = buffer.append(name).append('(').append(this.parseArgList(name, args)).append(' ').append(')').toString();
                this.debugEnd();
                return eval;
            }
            if (type == INTERNAL) {
                if (IBISQLKeyword._ROOT.equals(name)) {
                    String eval = buffer.append(this.parseArgList(name, args)).toString();
                    this.debugEnd();
                    return eval;
                }
                if (IBISQLKeyword._ALIAS.equals(name)) {
                    String eval = buffer.append(this.parseTable(name, args, 0)).append(' ').append(this.quotedString(this.parseArgument(name, args, 1))).toString();
                    this.debugEnd();
                    return eval;
                }
                if (IBISQLKeyword._REF.equals(name)) {
                    String eval = buffer.append(this.quotedString(this.parseArgument(name, args, 0))).append('.').append(this.parseColumnRef(name, args, 1)).toString();
                    this.debugEnd();
                    return eval;
                }
                throw new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1103", new Object[]{name});
            }
            throw new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1104", new Object[]{type});
        }
        String eval = buffer.append(name).append('(').append(this.parseArgList(name, args)).append(')').toString();
        this.debugEnd();
        return eval;
    }

    private String parseArgList(String name, List args, int offset) throws BIResourceException {
        return this.parseArgList(name, args.subList(offset, args.size()));
    }

    private String parseArgList(String name, List args) throws BIResourceException {
        StringBuffer buffer = new StringBuffer();
        ListSeparator separator = ListSeparator.NONE;
        ListSeparator listSep = this.getOperListSep(name);
        Iterator iter = args.iterator();
        int index = 0;
        while (iter.hasNext()) {
            buffer.append(separator).append(' ');
            ExpressionNode n = (ExpressionNode)iter.next();
            if (n instanceof ConstantNode) {
                buffer.append(this.parseConstantNode(name, index, (ConstantNode)n));
            } else if (n instanceof ElementNode) {
                buffer.append(this.parseElementNode(name, index, (ElementNode)n));
            } else if (n instanceof FeatureNode) {
                buffer.append(this.parseFeatureNode(name, index, (FeatureNode)n));
            } else {
                throw new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1105", new Object[]{n == null ? null : n.getClass()});
            }
            separator = listSep;
            ++index;
        }
        return buffer.toString();
    }

    private String parseArgument(String name, List args, int index) throws BIResourceException {
        if (args == null) {
            throw new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1106");
        }
        try {
            Object arg = args.get(index);
            if (arg instanceof ConstantNode) {
                return this.parseConstantNode(name, index, (ConstantNode)arg);
            }
            if (arg instanceof ElementNode) {
                return this.parseElementNode(name, index, (ElementNode)arg);
            }
            if (arg instanceof FeatureNode) {
                return this.parseFeatureNode(name, index, (FeatureNode)arg);
            }
            throw new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1105", new Object[]{arg == null ? null : arg.getClass()});
        }
        catch (IndexOutOfBoundsException ex) {
            throw new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1107", new Object[]{new Integer(index)});
        }
    }

    private String parseConstantNode(String operation, int index, ConstantNode constant) throws BIResourceException {
        return this.factory.createParseConstantNode().evaluate(constant);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String parseElementNode(String operation, int index, ElementNode element) throws BIResourceException {
        StringBuffer buffer = new StringBuffer();
        if (element == null || !(element.getModelElement() instanceof Column) && !(element.getModelElement() instanceof Table)) {
            throw new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1100", new Object[]{element == null ? null : element.getClass()});
        }
        String[] name = this.factory.createParseElementNode().evaluate(element);
        if (IBISQLKeyword._REF.equals(operation)) {
            buffer.append(name[name.length - 1]);
            return buffer.toString();
        } else {
            int sep = 32;
            DatabaseMetaData meta = this.factory.getMetaData();
            if (meta != null) {
                try {
                    if (meta.supportsSchemasInDataManipulation() && name[1] != null && name[1].length() > 0) {
                        buffer.append(name[1]);
                        buffer.append('.');
                    }
                    buffer.append(name[2]);
                    if (name.length == 4) {
                        buffer.append('.');
                        buffer.append(name[3]);
                    }
                    if (!meta.supportsCatalogsInDataManipulation() || name[0] == null || name[0].length() <= 0) return buffer.toString();
                    if (meta.isCatalogAtStart()) {
                        buffer.insert(0, meta.getCatalogSeparator());
                        buffer.insert(0, name[0]);
                        return buffer.toString();
                    }
                    buffer.append(meta.getCatalogSeparator());
                    buffer.append(name[0]);
                    return buffer.toString();
                }
                catch (SQLException ex) {
                    throw new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1108", (Throwable)ex);
                }
            } else {
                int i = 0;
                while (i < name.length) {
                    buffer.append((char)sep).append(name[i]);
                    sep = 46;
                    ++i;
                }
            }
        }
        return buffer.toString();
    }

    private String parseFeatureNode(String operation, int index, FeatureNode feature) throws BIResourceException {
        return this.factory.createParseFeatureNode().evaluate(feature);
    }

    private String parseColumnRef(String name, List args, int index) throws BIResourceException {
        return this.parseElementNode(name, index, (ElementNode)args.get(index));
    }

    private String parseTable(String name, List args, int index) throws BIResourceException {
        return this.parseElementNode(name, index, (ElementNode)args.get(index));
    }

    private void assertOperationSignature(Operation node, List args) throws BIResourceException {
    }

    protected OperType getOperType(String operName) throws BIResourceException {
        if (operationName.containsKey(operName)) {
            return ((SqlOperation)operationName.get(operName)).getType();
        }
        return FUNCTION;
    }

    protected ListSeparator getOperListSep(String operName) throws BIResourceException {
        if (operationName.containsKey(operName)) {
            return ((SqlOperation)operationName.get(operName)).getListSeparator();
        }
        return COMMA_SEPARATED;
    }

    protected ParenType getOperParenType(String operName) throws BIResourceException {
        if (operationName.containsKey(operName)) {
            return ((SqlOperation)operationName.get(operName)).getParenType();
        }
        return PARENS;
    }

    protected boolean isOperSupported(String operName) throws BIResourceException {
        if (operationName.containsKey(operName)) {
            return ((SqlOperation)operationName.get(operName)).isSupported();
        }
        return false;
    }

    protected char getParen(String operName, char paren) throws BIResourceException {
        if (operationName.containsKey(operName)) {
            return ((SqlOperation)operationName.get(operName)).getParenType() == NO_PARENS ? (char)' ' : (char)paren;
        }
        return paren;
    }

    private void debugStart(Operation node) {
    }

    private void debugEnd() {
    }

    private String quotedString(String schemaName) throws BIResourceException {
        try {
            String quote = this.factory.getMetaData().getIdentifierQuoteString();
            if (!quote.equals(" ")) {
                return quote + schemaName + quote;
            }
            return schemaName;
        }
        catch (SQLException ex) {
            return schemaName;
        }
    }

    private String formatPrefixOperator(String name, String argList) throws BIResourceException {
        String eval = name + argList;
        this.debugEnd();
        return eval;
    }

    private String formatInfixOperator(String name, String argList) throws BIResourceException {
        return null;
    }

    static {
        BIParseOperation op = new BIParseOperation(IBIConnectionInfo.DEFAULT);
        operationName.put(IBISQLKeyword._ROOT.toString(), op.new SqlOperation(IBISQLKeyword._ROOT, INTERNAL, SPACE_SEPARATED, NO_PARENS, new int[]{3}, true));
        operationName.put(IBISQLKeyword._ALIAS.toString(), op.new SqlOperation(IBISQLKeyword._ALIAS, INTERNAL, NO_LIST, NO_PARENS, new int[]{32, 16}, true));
        operationName.put(IBISQLKeyword._REF.toString(), op.new SqlOperation(IBISQLKeyword._REF, INTERNAL, NO_LIST, NO_PARENS, new int[]{16, 128}, true));
        operationName.put(IBISQLKeyword.SELECT.toString(), op.new SqlOperation(IBISQLKeyword.SELECT, PREFIX, COMMA_SEPARATED, NO_PARENS, new int[]{0}, true));
        operationName.put(IBISQLKeyword.FROM.toString(), op.new SqlOperation(IBISQLKeyword.FROM, PREFIX, COMMA_SEPARATED, NO_PARENS, new int[]{0}, true));
        operationName.put(IBISQLKeyword.GROUP_BY.toString(), op.new SqlOperation(IBISQLKeyword.GROUP_BY, PREFIX, COMMA_SEPARATED, NO_PARENS, new int[]{0}, true));
        operationName.put(IBISQLKeyword.ORDER_BY.toString(), op.new SqlOperation(IBISQLKeyword.ORDER_BY, PREFIX, COMMA_SEPARATED, NO_PARENS, new int[]{0}, true));
        operationName.put(IBISQLKeyword.HAVING.toString(), op.new SqlOperation(IBISQLKeyword.HAVING, PREFIX, NO_LIST, NO_PARENS, new int[]{0}, true));
        operationName.put(IBISQLKeyword.WHERE.toString(), op.new SqlOperation(IBISQLKeyword.WHERE, PREFIX, NO_LIST, NO_PARENS, new int[]{0}, true));
        operationName.put(IBISQLKeyword.AS.toString(), op.new SqlOperation(IBISQLKeyword.AS, INFIX, NO_LIST, NO_PARENS, new int[]{0}, true));
        operationName.put(IBISQLKeyword.UNION, op.new SqlOperation(IBISQLKeyword.UNION, INFIX, NO_LIST, NO_PARENS, new int[]{0}, true));
        operationName.put(IBISQLKeyword.EXCEPT, op.new SqlOperation(IBISQLKeyword.EXCEPT, INFIX, NO_LIST, NO_PARENS, new int[]{0}, true));
        operationName.put(IBISQLKeyword.INTERSECT.toString(), op.new SqlOperation(IBISQLKeyword.INTERSECT, INFIX, NO_LIST, NO_PARENS, new int[]{0}, true));
        operationName.put(IBISQLKeyword.CORRESPONDING.toString(), op.new SqlOperation(IBISQLKeyword.CORRESPONDING, PREFIX, NO_LIST, NO_PARENS, new int[]{0}, true));
        operationName.put(IBISQLKeyword.ALL.toString(), op.new SqlOperation(IBISQLKeyword.ALL, PREFIX, NO_LIST, NO_PARENS, new int[]{0}, true));
        operationName.put(IBISQLKeyword.DISTINCT.toString(), op.new SqlOperation(IBISQLKeyword.DISTINCT, PREFIX, NO_LIST, NO_PARENS, new int[]{0}, true));
        operationName.put(IBISQLKeyword.ESCAPE.toString(), op.new SqlOperation(IBISQLKeyword.ESCAPE, INFIX, NO_LIST, NO_PARENS, new int[]{0}, true));
        operationName.put(IBISQLKeyword.NOT.toString(), op.new SqlOperation(IBISQLKeyword.NOT, PREFIX, NO_LIST, PARENS, new int[]{0}, true));
        operationName.put(IBISQLKeyword.AND.toString(), op.new SqlOperation(IBISQLKeyword.AND, INFIX, NO_LIST, PARENS, new int[]{0}, true));
        operationName.put(IBISQLKeyword.OR.toString(), op.new SqlOperation(IBISQLKeyword.OR, INFIX, NO_LIST, PARENS, new int[]{0}, true));
        operationName.put(IBISQLKeyword.EXISTS.toString(), op.new SqlOperation(IBISQLKeyword.EXISTS, PREFIX, NO_LIST, PARENS, new int[]{0}, true));
        operationName.put(IBISQLKeyword.UNIQUE.toString(), op.new SqlOperation(IBISQLKeyword.UNIQUE, PREFIX, NO_LIST, PARENS, new int[]{0}, true));
        operationName.put(IBISQLKeyword.EQUALS.toString(), op.new SqlOperation(IBISQLKeyword.EQUALS, INFIX, NO_LIST, NO_PARENS, new int[]{0}, true));
        operationName.put(IBISQLKeyword.NOT_EQUALS.toString(), op.new SqlOperation(IBISQLKeyword.NOT_EQUALS, INFIX, NO_LIST, NO_PARENS, new int[]{0}, true));
        operationName.put(IBISQLKeyword.LESS_EQUALS.toString(), op.new SqlOperation(IBISQLKeyword.LESS_EQUALS, INFIX, NO_LIST, NO_PARENS, new int[]{0}, true));
        operationName.put(IBISQLKeyword.LESS_THAN.toString(), op.new SqlOperation(IBISQLKeyword.LESS_THAN, INFIX, NO_LIST, NO_PARENS, new int[]{0}, true));
        operationName.put(IBISQLKeyword.GREATER_EQUALS.toString(), op.new SqlOperation(IBISQLKeyword.GREATER_EQUALS, INFIX, NO_LIST, NO_PARENS, new int[]{0}, true));
        operationName.put(IBISQLKeyword.GREATER_THAN.toString(), op.new SqlOperation(IBISQLKeyword.GREATER_THAN, INFIX, NO_LIST, NO_PARENS, new int[]{0}, true));
        operationName.put(IBISQLKeyword.IN.toString(), op.new SqlOperation(IBISQLKeyword.IN, INFIX_1XN, COMMA_SEPARATED, RHS_PARENS, new int[]{0}, true));
        operationName.put(IBISQLKeyword.LIKE.toString(), op.new SqlOperation(IBISQLKeyword.LIKE, INFIX, COMMA_SEPARATED, NO_PARENS, new int[]{0}, true));
        operationName.put(IBISQLKeyword.BETWEEN.toString(), op.new SqlOperation(IBISQLKeyword.BETWEEN, INFIX_1XN, AND_SEPARATED, NO_PARENS, new int[]{0}, true));
        operationName.put(IBISQLKeyword.IS_NULL.toString(), op.new SqlOperation(IBISQLKeyword.IS_NULL, POSTFIX, COMMA_SEPARATED, NO_PARENS, new int[]{0}, true));
        operationName.put(IBISQLKeyword.ASC.toString(), op.new SqlOperation(IBISQLKeyword.ASC, POSTFIX, NO_LIST, NO_PARENS, new int[]{0}, true));
        operationName.put(IBISQLKeyword.DESC.toString(), op.new SqlOperation(IBISQLKeyword.DESC, POSTFIX, NO_LIST, NO_PARENS, new int[]{0}, true));
    }

    public class SqlOperation {
        private BISQLKeyword keyword;
        private OperType type;
        private ListSeparator listSeparator;
        private ParenType parenType;
        private boolean isSupported;
        private int[] argType;

        private SqlOperation() {
        }

        public SqlOperation(BISQLKeyword keyword, OperType type, ListSeparator listSeparator, ParenType parenType, int[] argType, boolean isSupported) {
            this.keyword = keyword;
            this.type = type;
            this.listSeparator = listSeparator;
            this.parenType = parenType;
            this.argType = argType;
            this.isSupported = isSupported;
        }

        public BISQLKeyword getKeyword() {
            return this.keyword;
        }

        public OperType getType() {
            return this.type;
        }

        public ListSeparator getListSeparator() {
            return this.listSeparator;
        }

        public ParenType getParenType() {
            return this.parenType;
        }

        public int[] getArgType() {
            return this.argType;
        }

        public boolean isSupported() {
            return this.isSupported;
        }
    }

    static final class ParenType {
        private final String type;
        public static final ParenType PARENS = new ParenType("()");
        public static final ParenType NO_PARENS = new ParenType("...");
        public static final ParenType RHS_PARENS = new ParenType("... ()");

        private ParenType(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }
    }

    protected static class ListSeparator {
        private final String sep;
        public static final ListSeparator SPACE_SEPARATED = new ListSeparator(" ");
        public static final ListSeparator COMMA_SEPARATED = new ListSeparator(",");
        public static final ListSeparator AND_SEPARATED = new ListSeparator(" " + IBISQLKeyword.AND + " ");
        public static final ListSeparator NO_LIST = new ListSeparator("");
        public static final ListSeparator NONE = new ListSeparator("");

        private ListSeparator(String sep) {
            this.sep = sep;
        }

        public String toString() {
            return this.sep;
        }
    }

    protected static class OperType {
        private final String type;
        public static final OperType UNKNOWN = new OperType("UNKNOWN");
        public static final OperType INTERNAL = new OperType("INTERNAL");
        public static final OperType FUNCTION = new OperType("FUNCTION");
        public static final OperType PREFIX = new OperType("PREFIX");
        public static final OperType INFIX = new OperType("INFIX");
        public static final OperType INFIX_1XN = new OperType("INFIX_1XN");
        public static final OperType POSTFIX = new OperType("POSTFIX");

        private OperType(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }
    }
}

