/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.relational.query.sql.impl;

import com.sap.ip.bi.sdk.dac.connector.impl.BIConnectionInfo;
import com.sap.ip.bi.sdk.dac.connector.impl.IBIConnectionInfo;
import com.sap.ip.bi.sdk.dac.relational.query.sql.IBIParseExpressionNode;
import com.sap.ip.bi.sdk.dac.relational.query.sql.IBIParseNodeFactory;
import com.sap.ip.bi.sdk.exception.BIResourceException;

class BIParseExpressionNode
implements IBIParseExpressionNode {
    protected static final String _LEVEL = "_LEVEL";
    protected IBIParseNodeFactory factory = null;
    protected IBIConnectionInfo connectionInfo = IBIConnectionInfo.DEFAULT;

    public BIParseExpressionNode(IBIConnectionInfo connectionInfo) {
        this.connectionInfo = connectionInfo;
        BIConnectionInfo.assertConnectionInfo((IBIConnectionInfo)connectionInfo);
    }

    public BIParseExpressionNode(IBIConnectionInfo connectionInfo, IBIParseNodeFactory factory) throws BIResourceException {
        this.connectionInfo = connectionInfo;
        BIConnectionInfo.assertConnectionInfo((IBIConnectionInfo)connectionInfo);
        if (factory == null) {
            throw new BIResourceException(connectionInfo.getLocale(), "sdk.dac.rel.query_1101");
        }
        this.factory = factory;
    }

    protected int getLevel() {
        Integer level = (Integer)this.factory.getSymbolTable().get(_LEVEL);
        if (level == null) {
            level = new Integer(0);
            this.factory.getSymbolTable().put(_LEVEL, level);
        }
        return level;
    }

    protected void incrLevel() {
        Integer level = new Integer(this.getLevel() + 1);
        this.factory.getSymbolTable().put(_LEVEL, level);
    }

    protected void decrLevel() {
        Integer level = new Integer(this.getLevel() - 1);
        this.factory.getSymbolTable().put(_LEVEL, level);
    }

    protected String indent(int level) {
        StringBuffer b = new StringBuffer();
        int i = 0;
        while (i <= level) {
            b.append(' ');
            ++i;
        }
        return b.toString();
    }
}

