/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.relational.query.sql.impl;

import com.sap.ip.bi.sdk.dac.connector.impl.IBIConnectionInfo;
import com.sap.ip.bi.sdk.dac.relational.query.sql.IBIParseElementNode;
import com.sap.ip.bi.sdk.dac.relational.query.sql.IBIParseNodeFactory;
import com.sap.ip.bi.sdk.dac.relational.query.sql.impl.BIParseExpressionNode;
import com.sap.ip.bi.sdk.exception.BIResourceException;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.omg.cwm.foundation.expressions.ElementNode;
import org.omg.cwm.objectmodel.core.ModelElement;
import org.omg.cwm.resource.relational.Catalog;
import org.omg.cwm.resource.relational.Column;
import org.omg.cwm.resource.relational.Schema;
import org.omg.cwm.resource.relational.Table;

class BIParseElementNode
extends BIParseExpressionNode
implements IBIParseElementNode {
    protected DatabaseMetaData meta = null;

    BIParseElementNode(IBIConnectionInfo connectionInfo, IBIParseNodeFactory factory) throws BIResourceException {
        super(connectionInfo, factory);
        this.meta = factory.getMetaData();
    }

    public String[] evaluate(ElementNode node) throws BIResourceException {
        ModelElement element = node.getModelElement();
        if (element instanceof Column) {
            Column column = (Column)element;
            String[] name = this.evaluateColumn(column);
            this.debug(name);
            return name;
        }
        if (element instanceof Table) {
            Table table = (Table)element;
            String[] name = this.evaluateTable(table);
            this.debug(name);
            return name;
        }
        throw new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1100", new Object[]{element == null ? null : element.getClass()});
    }

    private String[] evaluateColumn(Column column) throws BIResourceException {
        Table table = (Table)column.getOwner();
        Schema schema = (Schema)table.getNamespace();
        Catalog catalog = (Catalog)schema.getNamespace();
        return new String[]{this.quote(catalog.getName()), this.quote(schema.getName()), this.quote(table.getName()), this.quote(column.getName())};
    }

    private String[] evaluateTable(Table table) throws BIResourceException {
        Schema schema = (Schema)table.getNamespace();
        Catalog catalog = (Catalog)schema.getNamespace();
        return new String[]{this.quote(catalog.getName()), this.quote(schema.getName()), this.quote(table.getName())};
    }

    private void debug(String[] name) {
    }

    private String join(String[] name) {
        StringBuffer b = new StringBuffer(name[0]);
        int i = 1;
        while (i < name.length) {
            b.append('.').append(name[i]);
            ++i;
        }
        return b.toString();
    }

    private String quote(String name) throws BIResourceException {
        try {
            String quote = this.factory.getMetaData().getIdentifierQuoteString();
            if (quote == null) {
                return name;
            }
            return quote + name + quote;
        }
        catch (SQLException ex) {
            return name;
        }
    }
}

