/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.relational.query.sql.impl;

import com.sap.ip.bi.sdk.dac.connector.impl.IBIConnectionInfo;
import com.sap.ip.bi.sdk.dac.relational.query.impl.IBISchemaLiteral;
import com.sap.ip.bi.sdk.dac.relational.query.sql.IBIParseConstantNode;
import com.sap.ip.bi.sdk.dac.relational.query.sql.IBIParseNodeFactory;
import com.sap.ip.bi.sdk.dac.relational.query.sql.impl.BIParseExpressionNode;
import com.sap.ip.bi.sdk.exception.BIResourceException;
import com.sap.ip.bi.sdk.exception.BIRuntimeException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import org.omg.cwm.foundation.expressions.ConstantNode;

class BIParseConstantNode
extends BIParseExpressionNode
implements IBIParseConstantNode {
    private HashMap literal = new HashMap();
    private static final String defaultLiteralPrefix = "'";
    private static final String defaultLiteralSuffix = "'";
    private static final String DATA_TYPE = "DATA_TYPE";
    private static final String LITERAL_PREFIX = "LITERAL_PREFIX";
    private static final String LITERAL_SUFFIX = "LITERAL_SUFFIX";
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$StringBuffer;
    static /* synthetic */ Class class$java$lang$String;

    BIParseConstantNode(IBIConnectionInfo connectionInfo, IBIParseNodeFactory factory) throws BIResourceException {
        super(connectionInfo, factory);
        try {
            ResultSet typeInfo = factory.getMetaData().getTypeInfo();
            if (typeInfo != null) {
                while (typeInfo.next()) {
                    String prefix = typeInfo.getString(LITERAL_PREFIX);
                    String suffix = typeInfo.getString(LITERAL_PREFIX);
                    switch (typeInfo.getInt(DATA_TYPE)) {
                        case 1: {
                            this.literal.put(class$java$lang$Character == null ? BIParseConstantNode.class$("java.lang.Character") : class$java$lang$Character, new QuoteString(prefix, suffix));
                            break;
                        }
                        case 91: {
                            this.literal.put(class$java$util$Date == null ? BIParseConstantNode.class$("java.util.Date") : class$java$util$Date, new QuoteString(prefix, suffix));
                            this.literal.put(class$java$sql$Date == null ? BIParseConstantNode.class$("java.sql.Date") : class$java$sql$Date, new QuoteString(prefix, suffix));
                            break;
                        }
                        case 92: {
                            this.literal.put(class$java$sql$Time == null ? BIParseConstantNode.class$("java.sql.Time") : class$java$sql$Time, new QuoteString(prefix, suffix));
                            break;
                        }
                        case 93: {
                            this.literal.put(class$java$sql$Timestamp == null ? BIParseConstantNode.class$("java.sql.Timestamp") : class$java$sql$Timestamp, new QuoteString(prefix, suffix));
                            break;
                        }
                        case 0: {
                            this.literal.put(null, new QuoteString(prefix, suffix));
                            break;
                        }
                        case 8: {
                            this.literal.put(class$java$lang$Double == null ? BIParseConstantNode.class$("java.lang.Double") : class$java$lang$Double, new QuoteString(prefix, suffix));
                            break;
                        }
                        case 6: 
                        case 7: {
                            this.literal.put(class$java$lang$Float == null ? BIParseConstantNode.class$("java.lang.Float") : class$java$lang$Float, new QuoteString(prefix, suffix));
                            break;
                        }
                        case 2: 
                        case 3: {
                            this.literal.put(class$java$math$BigDecimal == null ? BIParseConstantNode.class$("java.math.BigDecimal") : class$java$math$BigDecimal, new QuoteString(prefix, suffix));
                            break;
                        }
                        case -5: {
                            this.literal.put(class$java$math$BigInteger == null ? BIParseConstantNode.class$("java.math.BigInteger") : class$java$math$BigInteger, new QuoteString(prefix, suffix));
                            break;
                        }
                        case -6: 
                        case 4: 
                        case 5: {
                            this.literal.put(class$java$lang$Integer == null ? BIParseConstantNode.class$("java.lang.Integer") : class$java$lang$Integer, new QuoteString(prefix, suffix));
                            this.literal.put(class$java$lang$Long == null ? BIParseConstantNode.class$("java.lang.Long") : class$java$lang$Long, new QuoteString(prefix, suffix));
                            break;
                        }
                        case -1: 
                        case 12: {
                            this.literal.put(class$java$lang$StringBuffer == null ? BIParseConstantNode.class$("java.lang.StringBuffer") : class$java$lang$StringBuffer, new QuoteString(prefix, suffix));
                            this.literal.put(class$java$lang$String == null ? BIParseConstantNode.class$("java.lang.String") : class$java$lang$String, new QuoteString(prefix, suffix));
                            break;
                        }
                        case -7: 
                        case -4: 
                        case -3: 
                        case -2: 
                        case 1111: 
                        case 2000: 
                        case 2001: 
                        case 2002: 
                        case 2003: 
                        case 2004: 
                        case 2005: 
                        case 2006: {
                            break;
                        }
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public String evaluate(ConstantNode node) throws BIResourceException {
        this.debug(node);
        Object value = node.getValue();
        if (value instanceof IBISchemaLiteral) {
            return value.toString();
        }
        QuoteString q = (QuoteString)this.literal.get(value.getClass());
        if (q != null) {
            return q.getPrefix() + value.toString() + q.getSuffix();
        }
        throw new BIRuntimeException(IBIConnectionInfo.DEFAULT.getLocale(), "sdk_0000", new Object[]{value != null ? value.getClass() : null, value});
    }

    private void debug(ConstantNode node) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class QuoteString {
        String prefix = null;
        String suffix = null;

        private QuoteString() {
        }

        public QuoteString(String prefix, String suffix) {
            this.prefix = prefix == null ? "" : prefix;
            this.suffix = suffix == null ? "" : suffix;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getSuffix() {
            return this.suffix;
        }
    }
}

