/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.relational.query.sapq.impl;

import com.sap.ip.bi.sdk.dac.connector.impl.BIConnectionInfo;
import com.sap.ip.bi.sdk.dac.connector.impl.IBIConnectionInfo;
import com.sap.ip.bi.sdk.dac.relational.query.sapq.IBISapqSelectOption;
import com.sap.ip.bi.sdk.dac.relational.query.tree.IBIWhereTreeNode;
import com.sap.ip.bi.sdk.dac.relational.query.tree.impl.BIWhereTreeAndNode;
import com.sap.ip.bi.sdk.dac.relational.query.tree.impl.BIWhereTreeColumnValueNode;
import com.sap.ip.bi.sdk.dac.relational.query.tree.impl.BIWhereTreeNotNode;
import com.sap.ip.bi.sdk.dac.relational.query.tree.impl.BIWhereTreeOrNode;
import com.sap.ip.bi.sdk.exception.BIRuntimeException;
import java.util.Arrays;
import org.omg.cwm.resource.relational.Column;

public class BISapqSelectOption
implements IBISapqSelectOption {
    private static final boolean EXTERNAL_TO_INTERNAL = true;
    private static final boolean INTERNAL_TO_EXTERNAL = false;
    private static final char ABAP_MATCH_MULTIPLE_CHARS = '*';
    private static final char ABAP_MATCH_SINGLE_CHAR = '+';
    private static final char ABAP_MATCH_ESCAPE = '#';
    private static final char[] INTERNAL = new char[]{'*', '+', '#'};
    private static final char[] EXTERNAL = new char[]{'%', '_', '\\'};
    private static final char MATCH_MULTIPLE_CHARS = '\u0000';
    private static final char MATCH_SINGLE_CHAR = '\u0001';
    private static final char MATCH_ESCAPE = '\u0002';
    private final String tableRef;
    private final Column column;
    private final IBISapqSelectOption.Kind kind;
    private final IBISapqSelectOption.Sign sign;
    private final IBISapqSelectOption.Option option;
    private final String low;
    private final String high;
    private IBIConnectionInfo connectionInfo = IBIConnectionInfo.DEFAULT;

    public BISapqSelectOption(IBIConnectionInfo connectionInfo, Column column, IBISapqSelectOption.Kind kind, IBISapqSelectOption.Sign sign, IBISapqSelectOption.Option option, String low, String high) throws BIRuntimeException {
        this.connectionInfo = connectionInfo;
        BIConnectionInfo.assertConnectionInfo((IBIConnectionInfo)connectionInfo);
        this.tableRef = null;
        this.column = column;
        this.kind = kind;
        this.sign = sign;
        this.option = option;
        this.low = low;
        this.high = high;
        this.assertArguments();
    }

    public BISapqSelectOption(IBIConnectionInfo connectionInfo, String tableRef, Column column, IBISapqSelectOption.Kind kind, IBISapqSelectOption.Sign sign, IBISapqSelectOption.Option option, String low, String high) throws BIRuntimeException {
        this.connectionInfo = connectionInfo;
        BIConnectionInfo.assertConnectionInfo((IBIConnectionInfo)connectionInfo);
        this.tableRef = tableRef;
        this.column = column;
        this.kind = kind;
        this.sign = sign;
        this.option = option;
        this.low = low;
        this.high = high;
        this.assertArguments();
    }

    public BISapqSelectOption(IBIConnectionInfo connectionInfo, Column column, String kind, String sign, String option, String low, String high) throws BIRuntimeException {
        this.connectionInfo = connectionInfo;
        BIConnectionInfo.assertConnectionInfo((IBIConnectionInfo)connectionInfo);
        this.tableRef = null;
        this.column = column;
        this.kind = IBISapqSelectOption.Kind.get(kind);
        this.sign = IBISapqSelectOption.Sign.get(sign);
        this.option = IBISapqSelectOption.Option.get(option);
        this.low = low;
        this.high = high;
        this.assertArguments();
    }

    public BISapqSelectOption(IBIConnectionInfo connectionInfo, String tableRef, Column column, String kind, String sign, String option, String low, String high) throws BIRuntimeException {
        this.connectionInfo = connectionInfo;
        BIConnectionInfo.assertConnectionInfo((IBIConnectionInfo)connectionInfo);
        this.tableRef = tableRef;
        this.column = column;
        this.kind = IBISapqSelectOption.Kind.get(kind);
        this.sign = IBISapqSelectOption.Sign.get(sign);
        this.option = IBISapqSelectOption.Option.get(option);
        this.low = low;
        this.high = high;
        this.assertArguments();
    }

    private void assertArguments() throws BIRuntimeException {
        if (this.column == null) {
            throw new BIRuntimeException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1024");
        }
        if (this.kind == null) {
            throw new BIRuntimeException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1024");
        }
        if (this.sign == null) {
            throw new BIRuntimeException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1024");
        }
        if (this.option == null) {
            throw new BIRuntimeException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1024");
        }
    }

    public String getTableRef() {
        return this.tableRef;
    }

    public Column getColumn() {
        return this.column;
    }

    public IBISapqSelectOption.Kind getKind() {
        return this.kind;
    }

    public IBISapqSelectOption.Sign getSign() {
        return this.sign;
    }

    public IBISapqSelectOption.Option getOption() {
        return this.option;
    }

    public String getLow() {
        return this.low;
    }

    public String getHigh() {
        return this.high;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append('[').append(this.column.getName()).append('|').append(this.kind.toString()).append('|').append(this.sign.toString()).append('|').append(this.option.toString()).append('|').append(this.low).append('|').append(this.high).append(']');
        return buf.toString();
    }

    public static String replaceSQLSpecialChars(String toReplace) {
        return BISapqSelectOption.replaceSpecialChars(toReplace, true);
    }

    public static String replaceABAPSpecialChars(String toReplace) {
        return BISapqSelectOption.replaceSpecialChars(toReplace, false);
    }

    private static String replaceSpecialChars(String toReplace, boolean externalToInternal) {
        char[] internal = null;
        char[] external = null;
        if (toReplace == null) {
            return null;
        }
        if (externalToInternal) {
            internal = INTERNAL;
            external = EXTERNAL;
        } else {
            internal = EXTERNAL;
            external = INTERNAL;
        }
        char[] data = toReplace.toCharArray();
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < data.length) {
            if (data[i] == internal[0] || data[i] == internal[1] || data[i] == internal[2]) {
                buf.append(internal[2]).append(data[i]);
            } else if (data[i] == external[0]) {
                buf.append(internal[0]);
            } else if (data[i] == external[1]) {
                buf.append(internal[1]);
            } else if (data[i] == external[2]) {
                if (i + 1 < data.length) {
                    if (data[++i] == external[0] || data[i] == external[1] || data[i] == external[2]) {
                        buf.append(data[i]);
                    } else {
                        buf.append(internal[2]).append(data[i]);
                    }
                } else {
                    buf.append(internal[2]);
                }
            } else {
                buf.append(data[i]);
            }
            ++i;
        }
        return buf.toString();
    }

    public static IBIWhereTreeNode toWhereTreeNode(IBISapqSelectOption[] selectOptions) {
        Arrays.sort(selectOptions);
        Column col = null;
        IBISapqSelectOption.Sign sign = null;
        IBIWhereTreeNode root = null;
        IBIWhereTreeNode including = null;
        IBIWhereTreeNode excluding = null;
        IBIWhereTreeNode branch = null;
        if (selectOptions.length >= 1) {
            int i = 0;
            while (i < selectOptions.length) {
                IBISapqSelectOption option = selectOptions[i];
                branch = BISapqSelectOption.optionToNode(option);
                if (!option.getColumn().equals(col)) {
                    col = option.getColumn();
                    sign = option.getSign();
                    root = BISapqSelectOption.createRoot(root, including, excluding);
                    excluding = null;
                    including = null;
                    if (option.getSign() == IBISapqSelectOption.Sign.I) {
                        including = branch;
                    } else {
                        excluding = branch;
                    }
                } else if (option.getSign() == IBISapqSelectOption.Sign.I) {
                    including = BISapqSelectOption.createOrBranch(including, branch);
                } else {
                    excluding = BISapqSelectOption.createAndBranch(excluding, branch);
                }
                ++i;
            }
            root = BISapqSelectOption.createRoot(root, including, excluding);
        }
        return root;
    }

    private static IBIWhereTreeNode createRoot(IBIWhereTreeNode root, IBIWhereTreeNode left, IBIWhereTreeNode right) {
        if (root == null) {
            if (right == null) {
                if (left == null) {
                    return null;
                }
                return left;
            }
            if (left == null) {
                return right;
            }
            return new BIWhereTreeAndNode(left, right);
        }
        if (right == null) {
            if (left == null) {
                return root;
            }
            return new BIWhereTreeAndNode(root, left);
        }
        if (left == null) {
            return new BIWhereTreeAndNode(root, right);
        }
        return new BIWhereTreeAndNode(root, new BIWhereTreeAndNode(left, right));
    }

    private static IBIWhereTreeNode createOrBranch(IBIWhereTreeNode left, IBIWhereTreeNode right) {
        return BISapqSelectOption.createBranch(true, left, right);
    }

    private static IBIWhereTreeNode createAndBranch(IBIWhereTreeNode left, IBIWhereTreeNode right) {
        return BISapqSelectOption.createBranch(false, left, right);
    }

    private static IBIWhereTreeNode createBranch(boolean isOrBranch, IBIWhereTreeNode left, IBIWhereTreeNode right) {
        if (right == null) {
            if (left == null) {
                return null;
            }
            return left;
        }
        if (left == null) {
            return right;
        }
        if (isOrBranch) {
            return new BIWhereTreeOrNode(left, right);
        }
        return new BIWhereTreeAndNode(left, right);
    }

    private static IBIWhereTreeNode optionToNode(IBISapqSelectOption option) {
        BIWhereTreeColumnValueNode node = new BIWhereTreeColumnValueNode(option.getTableRef(), option.getColumn(), option.getOption().getSQL(), option.getLow(), option.getOption() == IBISapqSelectOption.Option.BETWEEN || option.getOption() == IBISapqSelectOption.Option.NOT_BETWEEN ? option.getHigh() : null);
        if (option.getSign() == IBISapqSelectOption.Sign.I) {
            if (option.getOption().isNegated()) {
                return new BIWhereTreeNotNode(node);
            }
            return node;
        }
        if (!option.getOption().isNegated()) {
            return new BIWhereTreeNotNode(node);
        }
        return node;
    }

    public int compareTo(Object other) throws ClassCastException {
        if (!(other instanceof IBISapqSelectOption)) {
            throw new ClassCastException();
        }
        return this.compareToColumn((IBISapqSelectOption)other);
    }

    private int compareToColumn(IBISapqSelectOption other) {
        if (this.column.getName() == null) {
            if (other.getColumn() != null) {
                return -1;
            }
            return this.compareToSign(other);
        }
        int c = this.column.getName().compareTo(other.getColumn().getName());
        if (c == 0) {
            return this.compareToSign(other);
        }
        return c;
    }

    private int compareToSign(IBISapqSelectOption other) {
        if (this.sign == other.getSign()) {
            return this.compareToOption(other);
        }
        int c = this.sign.compareTo(other.getSign());
        if (c == 0) {
            return this.compareToOption(other);
        }
        return c;
    }

    private int compareToOption(IBISapqSelectOption other) {
        if (this.option == other.getOption()) {
            return this.compareToKind(other);
        }
        int c = this.option.compareTo(other.getOption());
        if (c == 0) {
            return this.compareToLow(other);
        }
        return c;
    }

    private int compareToKind(IBISapqSelectOption other) {
        if (this.kind == other.getKind()) {
            return this.compareToLow(other);
        }
        int c = this.kind.compareTo(other.getKind());
        if (c == 0) {
            return this.compareToLow(other);
        }
        return c;
    }

    private int compareToLow(IBISapqSelectOption other) {
        if (this.low == null) {
            if (other.getLow() == null) {
                return 0;
            }
            return -1;
        }
        int c = this.low.compareTo(other.getLow());
        if (c == 0) {
            return this.compareToHigh(other);
        }
        return c;
    }

    private int compareToHigh(IBISapqSelectOption other) {
        if (this.high == null) {
            if (other.getHigh() == null) {
                return 0;
            }
            return -1;
        }
        return this.high.compareTo(other.getHigh());
    }
}

