/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.relational.query.sapq.impl;

import com.sap.ip.bi.sdk.dac.relational.query.sapq.impl.BIParseExpressionNode;
import com.sap.ip.bi.sdk.dac.relational.query.sapq.impl.IBIParseExpressionNode;
import com.sap.ip.bi.sdk.exception.BIResourceException;
import java.util.Map;
import org.omg.cwm.foundation.expressions.ElementNode;
import org.omg.cwm.objectmodel.core.ModelElement;
import org.omg.cwm.resource.relational.Catalog;
import org.omg.cwm.resource.relational.Column;
import org.omg.cwm.resource.relational.Schema;
import org.omg.cwm.resource.relational.Table;

class BIParseElementNode
extends BIParseExpressionNode
implements IBIParseExpressionNode {
    BIParseElementNode(Map symbolTable) throws BIResourceException {
        super(symbolTable);
    }

    public String[] evaluate(ElementNode node) throws BIResourceException {
        ModelElement element = node.getModelElement();
        if (element instanceof Column) {
            Column column = (Column)element;
            String[] name = this.evaluateColumn(column);
            this.debug(name);
            return name;
        }
        if (element instanceof Table) {
            Table table = (Table)element;
            String[] name = this.evaluateTable(table);
            this.debug(name);
            return name;
        }
        throw new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1100", new Object[]{element == null ? null : element.getClass()});
    }

    private String[] evaluateColumn(Column column) throws BIResourceException {
        Table table = (Table)column.getOwner();
        Schema schema = (Schema)table.getNamespace();
        Catalog catalog = (Catalog)schema.getNamespace();
        return new String[]{this.quote(catalog.getName()), this.quote(schema.getName()), this.quote(table.getName()), this.quote(column.getName())};
    }

    private String[] evaluateTable(Table table) throws BIResourceException {
        Schema schema = (Schema)table.getNamespace();
        Catalog catalog = (Catalog)schema.getNamespace();
        return new String[]{this.quote(catalog.getName()), this.quote(schema.getName()), this.quote(table.getName())};
    }

    private void debug(String[] name) {
    }

    private String join(String[] name) {
        StringBuffer b = new StringBuffer(name[0]);
        int i = 1;
        while (i < name.length) {
            b.append('.').append(name[i]);
            ++i;
        }
        return b.toString();
    }

    private String quote(String name) throws BIResourceException {
        return name;
    }
}

