/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.relational.query.sapq;

import com.sap.ip.bi.sdk.dac.relational.query.sql.IBISQLComparisonOperator;
import org.omg.cwm.resource.relational.Column;

public interface IBISapqSelectOption
extends Comparable {
    public static final char MATCH_MULTIPLE_CHARS = '%';
    public static final char MATCH_SINGLE_CHAR = '_';
    public static final char MATCH_ESCAPE = '\\';

    public String getTableRef();

    public Column getColumn();

    public Kind getKind();

    public Sign getSign();

    public Option getOption();

    public String getLow();

    public String getHigh();

    public static final class Option
    extends Enum
    implements Comparable {
        private static final boolean NEGATED = true;
        private final int index;
        private final IBISQLComparisonOperator oper;
        private final boolean isNegated;
        public static final Option EQUALS = new Option("EQ", 1, IBISQLComparisonOperator.EQUALS);
        public static final Option BETWEEN = new Option("BT", 2, IBISQLComparisonOperator.BETWEEN);
        public static final Option CONTAINS_PATTERN = new Option("CP", 3, IBISQLComparisonOperator.LIKE);
        public static final Option GREATER_THAN = new Option("GT", 4, IBISQLComparisonOperator.GREATER_THAN);
        public static final Option GREATER_EQUALS = new Option("GE", 5, IBISQLComparisonOperator.GREATER_EQUALS);
        public static final Option LESS_THAN = new Option("LT", 6, IBISQLComparisonOperator.LESS_THAN);
        public static final Option LESS_EQUALS = new Option("LE", 7, IBISQLComparisonOperator.LESS_EQUALS);
        public static final Option NOT_EQUALS = new Option("NE", 8, IBISQLComparisonOperator.NOT_EQUALS);
        public static final Option NOT_BETWEEN = new Option("NB", 9, IBISQLComparisonOperator.BETWEEN, true);
        public static final Option NOT_CONTAINS_PATTERN = new Option("NP", 10, IBISQLComparisonOperator.LIKE, true);
        public static final Option EQ = EQUALS;
        public static final Option BT = BETWEEN;
        public static final Option CP = CONTAINS_PATTERN;
        public static final Option LE = LESS_EQUALS;
        public static final Option GE = GREATER_EQUALS;
        public static final Option NE = NOT_EQUALS;
        public static final Option NB = NOT_BETWEEN;
        public static final Option NP = NOT_CONTAINS_PATTERN;
        public static final Option GT = GREATER_THAN;
        public static final Option LT = LESS_THAN;

        private Option(String type, int index, IBISQLComparisonOperator oper, boolean isNegated) {
            super(type);
            this.index = index;
            this.oper = oper;
            this.isNegated = isNegated;
        }

        private Option(String type, int index, IBISQLComparisonOperator oper) {
            super(type);
            this.index = index;
            this.oper = oper;
            this.isNegated = false;
        }

        public int compareTo(Object other) throws ClassCastException {
            if (!(other instanceof Option)) {
                throw new ClassCastException();
            }
            return -(((Option)other).index - this.index);
        }

        public IBISQLComparisonOperator getSQL() {
            return this.oper;
        }

        public boolean isNegated() {
            return this.isNegated;
        }

        public static Option get(String type) {
            if ("EQ".equalsIgnoreCase(type)) {
                return EQ;
            }
            if ("BT".equalsIgnoreCase(type)) {
                return BT;
            }
            if ("CP".equalsIgnoreCase(type)) {
                return CP;
            }
            if ("GT".equalsIgnoreCase(type)) {
                return GT;
            }
            if ("GE".equalsIgnoreCase(type)) {
                return GE;
            }
            if ("LT".equalsIgnoreCase(type)) {
                return LT;
            }
            if ("LE".equalsIgnoreCase(type)) {
                return LE;
            }
            if ("NE".equalsIgnoreCase(type)) {
                return NE;
            }
            if ("NB".equalsIgnoreCase(type)) {
                return NB;
            }
            if ("NP".equalsIgnoreCase(type)) {
                return NP;
            }
            return null;
        }
    }

    public static final class Sign
    extends Enum
    implements Comparable {
        private final int index;
        public static final Sign INCLUDING;
        public static final Sign I;
        public static final Sign EXCLUDING;
        public static final Sign E;

        private Sign(String type, int index) {
            super(type);
            this.index = index;
        }

        public int compareTo(Object other) throws ClassCastException {
            if (!(other instanceof Sign)) {
                throw new ClassCastException();
            }
            return this.index - ((Sign)other).index;
        }

        public static Sign get(String type) {
            if ("I".equalsIgnoreCase(type)) {
                return I;
            }
            if ("E".equalsIgnoreCase(type)) {
                return E;
            }
            return null;
        }

        static {
            I = INCLUDING = new Sign("I", 0);
            E = EXCLUDING = new Sign("E", 1);
        }
    }

    public static final class Kind
    extends Enum
    implements Comparable {
        private final int index;
        public static final Kind PARAMETER;
        public static final Kind P;
        public static final Kind SELECT_OPTION;
        public static final Kind S;

        private Kind(String type, int index) {
            super(type);
            this.index = index;
        }

        public int compareTo(Object other) throws ClassCastException {
            if (!(other instanceof Kind)) {
                throw new ClassCastException();
            }
            return this.index - ((Sign)other).index;
        }

        public static Kind get(String type) {
            if ("S".equalsIgnoreCase(type)) {
                return S;
            }
            if ("P".equalsIgnoreCase(type)) {
                return P;
            }
            return null;
        }

        static {
            P = PARAMETER = new Kind("P", 0);
            S = SELECT_OPTION = new Kind("S", 1);
        }
    }

    public static class Enum {
        private final String type;

        protected Enum(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Enum)) {
                return false;
            }
            return this.type.equals(((Enum)other).type);
        }

        public boolean equals(String other) {
            return this.type.equalsIgnoreCase(other);
        }
    }
}

