/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.relational.query.mdx.impl;

import com.sap.ip.bi.sdk.dac.connector.impl.BIConnectionInfo;
import com.sap.ip.bi.sdk.dac.connector.impl.IBIConnectionInfo;
import com.sap.ip.bi.sdk.dac.olap.mdx.model.BIMdxObjectsFactory;
import com.sap.ip.bi.sdk.dac.olap.mdx.model.cond.IBIMdxBooleanPrimaryByVxOpVx;
import com.sap.ip.bi.sdk.dac.olap.mdx.model.cond.IBIMdxCompOp;
import com.sap.ip.bi.sdk.dac.olap.mdx.model.cond.IBIMdxSearchCondition;
import com.sap.ip.bi.sdk.dac.olap.mdx.model.def.IBIMdxFactor;
import com.sap.ip.bi.sdk.dac.olap.mdx.model.def.IBIMdxValueExpressionPrimary;
import com.sap.ip.bi.sdk.dac.olap.mdx.model.ele.IBIMdxLevelById;
import com.sap.ip.bi.sdk.dac.olap.mdx.model.ele.IBIMdxMember;
import com.sap.ip.bi.sdk.dac.olap.mdx.model.ele.IBIMdxMemberById;
import com.sap.ip.bi.sdk.dac.olap.mdx.model.ele.IBIMdxSet;
import com.sap.ip.bi.sdk.dac.olap.mdx.model.ele.IBIMdxSetByRange;
import com.sap.ip.bi.sdk.dac.olap.mdx.model.ele.IBIMdxSetBySetc;
import com.sap.ip.bi.sdk.dac.olap.mdx.model.ele.IBIMdxSetByTupc;
import com.sap.ip.bi.sdk.dac.olap.mdx.model.nvf.IBIMdxNumericValueFunction;
import com.sap.ip.bi.sdk.dac.olap.mdx.model.stat.IBIMdxAxisName;
import com.sap.ip.bi.sdk.dac.olap.mdx.model.stat.IBIMdxAxisSpecification;
import com.sap.ip.bi.sdk.dac.olap.mdx.model.stat.IBIMdxCubeSpecification;
import com.sap.ip.bi.sdk.dac.olap.mdx.model.stat.IBIMdxFormulaSpecification;
import com.sap.ip.bi.sdk.dac.olap.mdx.model.stat.IBIMdxMemberName;
import com.sap.ip.bi.sdk.dac.olap.mdx.model.stat.IBIMdxMemberSpecification;
import com.sap.ip.bi.sdk.dac.olap.mdx.model.stat.IBIMdxSelectStatement;
import com.sap.ip.bi.sdk.dac.olap.mdx.model.stat.IBIMdxSingleFormulaSpecification;
import com.sap.ip.bi.sdk.dac.olap.mdx.model.stat.IBIMdxSlicerSpecification;
import com.sap.ip.bi.sdk.dac.olap.mdx.model.svx.IBIMdxSvxFilter;
import com.sap.ip.bi.sdk.dac.olap.mdx.model.svx.IBIMdxSvxLevelMembers;
import com.sap.ip.bi.sdk.dac.relational.query.IBIQuery;
import com.sap.ip.bi.sdk.dac.relational.query.IBIQueryExpressionOrderByRef;
import com.sap.ip.bi.sdk.dac.relational.query.IBIQueryExpressionSelectColumnRef;
import com.sap.ip.bi.sdk.dac.relational.query.IBIQueryExpressionTableRef;
import com.sap.ip.bi.sdk.dac.relational.query.impl.BIQueryExpression;
import com.sap.ip.bi.sdk.dac.relational.query.sql.IBISQLAggregateFunction;
import com.sap.ip.bi.sdk.dac.relational.query.sql.IBISQLComparisonOperator;
import com.sap.ip.bi.sdk.dac.relational.query.tree.IBIWhereTree;
import com.sap.ip.bi.sdk.dac.relational.query.tree.IBIWhereTreeColumnValueNode;
import com.sap.ip.bi.sdk.dac.result.impl.BIColumnMetaData;
import com.sap.ip.bi.sdk.exception.BIResourceException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.omg.cwm.objectmodel.core.CorePackage;
import org.omg.cwm.objectmodel.core.ModelElement;
import org.omg.cwm.objectmodel.core.TaggedElement;
import org.omg.cwm.objectmodel.core.TaggedValue;
import org.omg.cwm.resource.relational.Column;
import org.omg.cwm.resource.relational.SqlsimpleType;

public class BIParseQueryExpression {
    private CorePackage core = null;
    private static final String CORE_PACKAGE = "org.omg.cwm.objectmodel.Core";
    private TaggedElement taggedElement = null;
    private Map tags = new HashMap();
    private static final String OLAP_TYPE = "OLAP_TYPE";
    private static final String TYPE_DIMENSION = "DIMENSION";
    private static final String TYPE_MEASURE = "MEASURE";
    private static final String LEVEL_UNIQUE_NAME = "LEVEL_UNIQUE_NAME";
    private static final String MEASURE_UNIQUE_NAME = "MEASURE_UNIQUE_NAME";
    private static final String DIMENSION_UNIQUE_NAME = "DIMENSION_UNIQUE_NAME";
    private BIQueryExpression expr = null;
    private BIColumnMetaData[] metaData = null;
    private int[] indexMap = null;
    private Set measures = new HashSet();
    private Set dimensions = new HashSet();
    private Set selected = new HashSet();
    private Set aggregated = new HashSet();
    private Set ordered = new HashSet();
    private List with = new ArrayList();
    private List where = new ArrayList();
    private List rowAxis = new ArrayList();
    private Set rowWhere = new HashSet();
    private List columnAxis = new ArrayList();
    private Map predicates = new HashMap();
    private static BIMdxObjectsFactory mdx = BIMdxObjectsFactory.createInstance();
    private static final boolean usingMsOlapProvider = true;
    private IBIConnectionInfo connectionInfo = IBIConnectionInfo.DEFAULT;

    public BIParseQueryExpression(IBIQuery query, IBIConnectionInfo connectionInfo) throws BIResourceException {
        this.connectionInfo = connectionInfo;
        BIConnectionInfo.assertConnectionInfo((IBIConnectionInfo)this.connectionInfo);
        if (query == null || !(query.getExpression() instanceof BIQueryExpression)) {
            throw new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1014");
        }
        this.expr = (BIQueryExpression)query.getExpression();
        this.metaData = null;
    }

    /*
     * Unable to fully structure code
     */
    public BIColumnMetaData[] getColumnMetaData() throws BIResourceException {
        block9: {
            if (this.metaData == null) {
                max = this.expr.getColumnRef().size();
                measures = new BIColumnMetaData[max];
                dimensions = new BIColumnMetaData[max];
                this.metaData = new BIColumnMetaData[max];
                this.indexMap = new int[max + 1];
                index = new HashMap<String, Integer>();
                measuresCount = 0;
                dimensionsCount = 0;
                i = 0;
                while (i < max) {
                    cref = (IBIQueryExpressionSelectColumnRef)this.expr.getColumnRef().get(i);
                    column = cref.getColumn();
                    colName = cref.getColumnRef() != null ? cref.getColumnRef() : column.getName();
                    m = new BIColumnMetaData(this.connectionInfo, ((SqlsimpleType)column.getType()).getTypeNumber().intValue(), colName);
                    if (this.isMeasure(column)) {
                        measures[measuresCount++] = m;
                    } else {
                        dimensions[dimensionsCount++] = m;
                    }
                    index.put(colName, new Integer(i + 1));
                    ++i;
                }
                try {
                    i = 0;
                    while (i < dimensionsCount) {
                        this.metaData[i] = dimensions[i];
                        this.indexMap[i + 1] = (Integer)index.get(this.metaData[i].getColumnName());
                        ++i;
                    }
                    i = 0;
                    while (i < measuresCount) {
                        j = dimensionsCount + i;
                        this.metaData[j] = measures[i];
                        this.indexMap[j + 1] = (Integer)index.get(this.metaData[j].getColumnName());
                        ++i;
                    }
                    break block9;
                }
                catch (SQLException ex) {
                    i = 0;
                    ** while (i < this.metaData.length + 1)
                }
lbl-1000:
                // 1 sources

                {
                    this.indexMap[i] = i;
                    ++i;
                    continue;
                }
            }
        }
        return this.metaData;
    }

    public int[] getRemappingIndex(BIColumnMetaData[] metaData) throws BIResourceException {
        if (this.indexMap == null) {
            this.getColumnMetaData();
        }
        return this.indexMap;
    }

    public String getCommandText() throws BIResourceException {
        this.preProcess();
        IBIMdxFormulaSpecification withClause = this.getWithClause();
        List selectClause = this.getSelectClause();
        IBIMdxCubeSpecification fromClause = this.getFromClause();
        IBIMdxSlicerSpecification whereClause = this.getWhereClause();
        IBIMdxSelectStatement stmt = mdx.createSelectStatement(withClause, selectClause, fromClause, whereClause, null, null);
        Iterator iter = stmt.getAxisSpecification().iterator();
        while (iter.hasNext()) {
            IBIMdxAxisSpecification axisSpecification = (IBIMdxAxisSpecification)iter.next();
            if (!axisSpecification.getAxisName().isRows()) continue;
            axisSpecification.setNonEmpty(true);
        }
        return stmt.getExpression().toString();
    }

    private IBIMdxFormulaSpecification getWithClause() throws BIResourceException {
        IBIMdxFormulaSpecification withClause = mdx.createFormulaSpecification();
        int slicerCount = 0;
        int entries = 0;
        Iterator i = this.with.iterator();
        while (i.hasNext()) {
            Object item = i.next();
            if (item instanceof IBIQueryExpressionSelectColumnRef) {
                ++entries;
                withClause.addSingleFormulaSpecification(this.getWithClauseAggregation((IBIQueryExpressionSelectColumnRef)item));
                continue;
            }
            if (item instanceof String) {
                ++entries;
                Set pred = (Set)this.predicates.get(item);
                withClause.addSingleFormulaSpecification(this.getWithClauseWhereFilter(pred, ++slicerCount));
                continue;
            }
            throw new BIResourceException(this.connectionInfo.getLocale(), "sdk_0000");
        }
        if (entries == 0) {
            return null;
        }
        return withClause;
    }

    private IBIMdxSingleFormulaSpecification getWithClauseWhereFilter(Set pred, int slicerCount) throws BIResourceException {
        IBIWhereTreeColumnValueNode first = (IBIWhereTreeColumnValueNode)pred.toArray()[0];
        Column c = first.getColumn();
        if (!this.isDimension(c)) {
            throw new BIResourceException(this.connectionInfo.getLocale(), "sdk_0000");
        }
        String uniqueName = this.getDimensionUniqueName(c);
        IBIMdxMemberSpecification formulaSpec = null;
        IBIMdxSearchCondition search = this.getWhereFilter(pred);
        IBIMdxSvxLevelMembers filterMembers = mdx.createSvxLevelMembers(mdx.createLevelById(uniqueName));
        IBIMdxMemberName filterName = mdx.createMemberName(uniqueName + ".SLICER_MEMBER" + slicerCount);
        IBIMdxMemberById filterMember = mdx.createMemberById(uniqueName + ".SLICER_MEMBER" + slicerCount);
        this.where.add(filterMember);
        formulaSpec = mdx.createMemberSpecification(filterName, mdx.createFactor(false, mdx.createNvfAggregate(mdx.createSvxFilter(filterMembers, search), null)), null, null);
        return formulaSpec;
    }

    private IBIMdxSearchCondition getWhereFilter(Set pred) throws BIResourceException {
        boolean isDimension;
        String uniqueName;
        IBIWhereTreeColumnValueNode first = (IBIWhereTreeColumnValueNode)pred.toArray()[0];
        Column c = first.getColumn();
        String dimensionUniqueName = this.getDimensionUniqueName(c);
        if (this.isDimension(c)) {
            uniqueName = this.getLevelUniqueName(c);
            isDimension = true;
        } else {
            uniqueName = this.getMeasureUniqueName(c);
            isDimension = false;
        }
        IBIMdxSearchCondition search = null;
        Iterator i = pred.iterator();
        while (i.hasNext()) {
            IBIWhereTreeColumnValueNode node = (IBIWhereTreeColumnValueNode)i.next();
            IBIMdxBooleanPrimaryByVxOpVx booleanPrimary = this.getWithClauseWhereFilterNode(uniqueName, dimensionUniqueName, isDimension, node);
            search = search == null ? mdx.createBooleanTerm(null, mdx.createBooleanFactor(false, booleanPrimary)) : mdx.createSearchConditionBySrchcBool(search, false, mdx.createBooleanTerm(null, mdx.createBooleanFactor(false, booleanPrimary)));
        }
        return search;
    }

    private IBIMdxBooleanPrimaryByVxOpVx getWithClauseWhereFilterNode(String uniqueName, String dimensionUniqueName, boolean isDimension, IBIWhereTreeColumnValueNode node) throws BIResourceException {
        IBIMdxValueExpressionPrimary col = null;
        col = isDimension ? mdx.createValueExpressionPrimaryByMsOlapPropVal(mdx.createDimensionById(dimensionUniqueName), mdx.createUserDefinedPropertyById("Name"), false) : mdx.createValueExpressionPrimaryByCubnTupVal(null, mdx.createMemberById(uniqueName), false);
        IBIMdxValueExpressionPrimary low = null;
        if (!isDimension) {
            try {
                Float.parseFloat(node.getValue()[0].toString());
                low = mdx.createExactNumericLiteral(node.getValue()[0].toString());
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        if (low == null) {
            low = mdx.createCharacterStringLiteral(node.getValue()[0].toString());
        }
        if (node.getOper() == IBISQLComparisonOperator.BETWEEN) {
            throw new BIResourceException(this.connectionInfo.getLocale(), "sdk_1001", new Object[]{node.getOper().toString()});
        }
        IBIMdxBooleanPrimaryByVxOpVx filterExpression = mdx.createBooleanPrimaryByVxOpVx(col, low, this.getMdxCompOp(node.getOper()));
        return filterExpression;
    }

    private IBIMdxCompOp getMdxCompOp(IBISQLComparisonOperator oper) throws BIResourceException {
        IBIMdxCompOp mdxOper = mdx.createCompOp();
        if (oper == IBISQLComparisonOperator.EQUALS) {
            mdxOper.setEquals(true);
        } else if (oper == IBISQLComparisonOperator.GREATER_THAN) {
            mdxOper.setGreaterThanOperator(true);
        } else if (oper == IBISQLComparisonOperator.GREATER_EQUALS) {
            mdxOper.setGreaterThanOrEqualsOperator(true);
        } else if (oper == IBISQLComparisonOperator.LESS_THAN) {
            mdxOper.setLessThanOperator(true);
        } else if (oper == IBISQLComparisonOperator.LESS_EQUALS) {
            mdxOper.setLessThanOrEqualsOperator(true);
        } else if (oper == IBISQLComparisonOperator.NOT_EQUALS) {
            mdxOper.setNotEquals(true);
        } else {
            throw new BIResourceException(this.connectionInfo.getLocale(), "sdk_1001", new Object[]{oper.toString()});
        }
        return mdxOper;
    }

    private IBIMdxSingleFormulaSpecification getWithClauseAggregationCountDimension(IBIQueryExpressionSelectColumnRef cref) throws BIResourceException {
        throw new BIResourceException(this.connectionInfo.getLocale(), "sdk_0000");
    }

    private IBIMdxSingleFormulaSpecification getWithClauseAggregation(IBIQueryExpressionSelectColumnRef cref) throws BIResourceException {
        if (!this.isMeasure(cref.getColumn())) {
            if (cref.getAggr() != IBISQLAggregateFunction.COUNT) {
                throw new BIResourceException(this.connectionInfo.getLocale(), "sdk_0000", new Object[]{"Operation ", cref.getAggr().toString(), " is not supported for ", cref.getColumn().getName()});
            }
            return this.getWithClauseAggregationCountDimension(cref);
        }
        IBIMdxMemberSpecification aggrMemberSpec = null;
        IBIMdxMemberById ct = mdx.createMemberById(this.getMeasureUniqueName(cref.getColumn()));
        IBISQLAggregateFunction aggrFunc = cref.getAggr();
        IBIMdxFactor factor = null;
        IBIMdxNumericValueFunction mdxAggrFunc = null;
        IBIMdxFactor mdxAggrVx = mdx.createFactor(false, mdx.createValueExpressionPrimaryByCubnTupVal(null, ct, false));
        if (aggrFunc == IBISQLAggregateFunction.AVG) {
            mdxAggrFunc = mdx.createNvfAvg(this.getCrossJoinedRows(false), mdxAggrVx);
        } else if (aggrFunc == IBISQLAggregateFunction.MAX) {
            mdxAggrFunc = mdx.createNvfMax(this.getCrossJoinedRows(false), mdxAggrVx);
        } else if (aggrFunc == IBISQLAggregateFunction.MIN) {
            mdxAggrFunc = mdx.createNvfMin(this.getCrossJoinedRows(false), mdxAggrVx);
        } else if (aggrFunc == IBISQLAggregateFunction.SUM) {
            mdxAggrFunc = mdx.createNvfSum(this.getCrossJoinedRows(false), mdxAggrVx);
        } else {
            if (aggrFunc == IBISQLAggregateFunction.COUNT) {
                throw new BIResourceException(this.connectionInfo.getLocale(), "sdk_0000");
            }
            throw new BIResourceException(this.connectionInfo.getLocale(), "sdk_0000", new Object[]{"Operation ", aggrFunc.toString(), " is not supported for ", cref.getColumn().getName()});
        }
        factor = mdx.createFactor(false, mdxAggrFunc);
        aggrMemberSpec = mdx.createMemberSpecification(mdx.createMemberName(this.getDimensionUniqueName(cref.getColumn()) + ".[" + cref.getColumnRef() + "]"), factor, null, null);
        return aggrMemberSpec;
    }

    private IBIMdxSet getCrossJoinedRows(boolean withFilters) throws BIResourceException {
        Set pred;
        String uname;
        IBIMdxSet rows = null;
        Iterator i = this.rowAxis.iterator();
        while (i.hasNext()) {
            Object item = i.next();
            IBIQueryExpressionSelectColumnRef c = (IBIQueryExpressionSelectColumnRef)item;
            uname = this.getLevelUniqueName(c.getColumn());
            pred = (Set)this.predicates.get(uname);
            if (withFilters && pred != null && this.isEnumeration(pred)) {
                IBIMdxSetBySetc set = mdx.createSetBySetc();
                ArrayList<IBIMdxMemberById> single = new ArrayList<IBIMdxMemberById>();
                Iterator j = pred.iterator();
                while (j.hasNext()) {
                    IBIWhereTreeColumnValueNode node = (IBIWhereTreeColumnValueNode)j.next();
                    if (IBISQLComparisonOperator.EQUALS == node.getOper()) {
                        single.add(mdx.createMemberById(this.getDimensionUniqueName(node.getColumn()) + ".[" + (String)node.getValue()[0] + "]"));
                        continue;
                    }
                    IBIMdxMemberById low = mdx.createMemberById(this.getLevelUniqueName(node.getColumn()) + ".[" + (String)node.getValue()[0] + "]");
                    IBIMdxMemberById high = mdx.createMemberById(this.getLevelUniqueName(node.getColumn()) + ".[" + (String)node.getValue()[1] + "]");
                    IBIMdxSetByRange range = mdx.createSetByRange(low, high);
                    set.addSet(range);
                }
                if (single.size() != 0) {
                    Iterator s = single.iterator();
                    while (s.hasNext()) {
                        IBIMdxMember member = (IBIMdxMember)s.next();
                        set.addSet(mdx.createSetByTup(member));
                    }
                }
                if (pred.size() == 0) continue;
                if (rows == null) {
                    rows = mdx.createSetBySet(set);
                    continue;
                }
                rows = mdx.createSvxCrossJoin(rows, set);
                continue;
            }
            IBIMdxLevelById l = mdx.createLevelById(uname);
            IBIMdxSvxLevelMembers m = mdx.createSvxLevelMembers(l);
            IBIMdxSearchCondition bool = null;
            IBIMdxSvxFilter filtered = null;
            if (withFilters && pred != null) {
                bool = this.getWhereFilter(pred);
                filtered = mdx.createSvxFilter(m, bool);
            }
            if (rows == null) {
                if (filtered != null) {
                    rows = filtered;
                    continue;
                }
                rows = m;
                continue;
            }
            rows = filtered != null ? mdx.createSvxCrossJoin(rows, filtered) : mdx.createSvxCrossJoin(rows, m);
        }
        IBIMdxSearchCondition rowSearch = null;
        Iterator i2 = this.rowWhere.iterator();
        while (i2.hasNext()) {
            uname = (String)i2.next();
            pred = (Set)this.predicates.get(uname);
            if (!withFilters || pred == null) continue;
            IBIMdxSearchCondition search = this.getWhereFilter(pred);
            if (rowSearch != null) {
                search = mdx.createBooleanTerm(mdx.createBooleanTerm(null, mdx.createBooleanFactor(false, mdx.createBooleanPrimaryBySrchc(rowSearch))), mdx.createBooleanFactor(false, mdx.createBooleanPrimaryBySrchc(search)));
            }
            rowSearch = search;
        }
        if (rowSearch != null) {
            rows = mdx.createSvxFilter(rows, rowSearch);
        }
        return rows;
    }

    private List getSelectClause() throws BIResourceException {
        ArrayList<IBIMdxAxisSpecification> select = new ArrayList<IBIMdxAxisSpecification>();
        IBIMdxAxisName columnsName = mdx.createAxisName();
        columnsName.setColumns(true);
        IBIMdxAxisSpecification columnsSpec = mdx.createAxisSpecification(false, this.getOnColumns(), null, columnsName);
        select.add(columnsSpec);
        IBIMdxAxisName rowsName = mdx.createAxisName();
        rowsName.setRows(true);
        IBIMdxAxisSpecification rowsSpec = mdx.createAxisSpecification(false, this.getCrossJoinedRows(true), null, rowsName);
        select.add(rowsSpec);
        return select;
    }

    private IBIMdxSetByTupc getOnColumns() throws BIResourceException {
        ArrayList<IBIMdxMemberById> cols = new ArrayList<IBIMdxMemberById>();
        Iterator i = this.columnAxis.iterator();
        while (i.hasNext()) {
            IBIQueryExpressionSelectColumnRef cref = (IBIQueryExpressionSelectColumnRef)i.next();
            IBIMdxMemberById member = null;
            member = cref.getAggr() != null ? mdx.createMemberById(this.getDimensionUniqueName(cref.getColumn()) + ".[" + cref.getColumnRef() + "]") : mdx.createMemberById(this.getMeasureUniqueName(cref.getColumn()));
            cols.add(member);
        }
        IBIMdxSetByTupc columnSet = mdx.createSetByTupc(cols);
        return columnSet;
    }

    private IBIMdxCubeSpecification getFromClause() throws BIResourceException {
        IBIMdxCubeSpecification cubeSpecification = mdx.createCubeSpecification(Arrays.asList(mdx.createCubeName("[" + ((IBIQueryExpressionTableRef)this.expr.getTableRef().get(0)).getTable().getName() + "]")));
        return cubeSpecification;
    }

    private IBIMdxSlicerSpecification getWhereClause() throws BIResourceException {
        ArrayList slicerMembers = new ArrayList();
        Iterator i = this.where.iterator();
        while (i.hasNext()) {
            slicerMembers.add(i.next());
        }
        if (slicerMembers.size() <= 0) {
            return null;
        }
        IBIMdxSlicerSpecification slicerSpecification = mdx.createSlicerSpecification(null, mdx.createTupleByMemc(slicerMembers));
        return slicerSpecification;
    }

    private void preProcess() throws BIResourceException {
        String uniqueName;
        Iterator i;
        if (this.expr.getTableRef() == null || this.expr.getTableRef().size() != 1) {
            throw new BIResourceException(this.connectionInfo.getLocale(), "sdk_0000");
        }
        if (this.expr.getColumnRef() != null) {
            i = this.expr.getColumnRef().iterator();
            while (i.hasNext()) {
                IBIQueryExpressionSelectColumnRef c = (IBIQueryExpressionSelectColumnRef)i.next();
                uniqueName = this.getUniqueName(c.getColumn());
                if (this.isMeasure(c.getColumn())) {
                    this.measures.add(uniqueName);
                    this.columnAxis.add(c);
                } else if (this.isDimension(c.getColumn())) {
                    this.dimensions.add(uniqueName);
                    this.rowAxis.add(c);
                }
                if (c.getAggr() != null) {
                    this.aggregated.add(uniqueName);
                    this.with.add(c);
                }
                this.selected.add(uniqueName);
            }
        }
        if (this.expr.getOrderByRef() != null) {
            if (this.expr.getOrderByRef().size() > 1) {
                throw new BIResourceException(this.connectionInfo.getLocale(), "sdk_0000", new Object[]{this.getClass(), "prepProcess()", "order by", new Integer(this.expr.getOrderByRef().size())});
            }
            i = this.expr.getOrderByRef().iterator();
            while (i.hasNext()) {
                IBIQueryExpressionOrderByRef o = (IBIQueryExpressionOrderByRef)i.next();
                uniqueName = this.getUniqueName(o.getColumn());
                this.ordered.add(uniqueName);
            }
        }
        if (this.expr.getGroupByRef() == null || this.expr.getGroupByRef().size() != 0) {
            // empty if block
        }
        IBIWhereTree tree = this.expr.getWhereTree();
        tree.normalize();
        if (tree != null) {
            if (!tree.isInMDX()) {
                throw new BIResourceException(this.connectionInfo.getLocale(), "sdk_0000");
            }
            List pred = tree.getPredicateList();
            Iterator i2 = pred.iterator();
            while (i2.hasNext()) {
                Set p = (Set)i2.next();
                if (p.size() <= 0) continue;
                IBIWhereTreeColumnValueNode node = (IBIWhereTreeColumnValueNode)p.toArray()[0];
                Column c = node.getColumn();
                String uname = this.getUniqueName(c);
                this.predicates.put(uname, p);
                if (!this.isMeasure(c)) {
                    if (!this.selected.contains(uname)) {
                        this.with.add(uname);
                        continue;
                    }
                    this.rowWhere.add(uname);
                    continue;
                }
                this.rowWhere.add(uname);
            }
        }
    }

    private boolean isEnumeration(Set pred) {
        if (pred == null) {
            return false;
        }
        Iterator i = pred.iterator();
        while (i.hasNext()) {
            IBIWhereTreeColumnValueNode node = (IBIWhereTreeColumnValueNode)i.next();
            if (IBISQLComparisonOperator.EQUALS == node.getOper() || IBISQLComparisonOperator.BETWEEN == node.getOper()) continue;
            return false;
        }
        return true;
    }

    private String getUniqueName(Column column) throws BIResourceException {
        if (this.isMeasure(column)) {
            return this.getMeasureUniqueName(column);
        }
        if (this.isDimension(column)) {
            return this.getLevelUniqueName(column);
        }
        throw new BIResourceException(this.connectionInfo.getLocale(), "sdk_0000", new Object[]{this.getClass(), "getUniqueName()", column});
    }

    private String getMeasureUniqueName(Column column) throws BIResourceException {
        return this.getTaggedValue((ModelElement)column, MEASURE_UNIQUE_NAME);
    }

    private String getLevelUniqueName(Column column) throws BIResourceException {
        return this.getTaggedValue((ModelElement)column, LEVEL_UNIQUE_NAME);
    }

    private String getDimensionUniqueName(Column column) throws BIResourceException {
        return this.getTaggedValue((ModelElement)column, DIMENSION_UNIQUE_NAME);
    }

    private boolean isMeasure(Column column) throws BIResourceException {
        return TYPE_MEASURE.equals(this.getOlapType(column));
    }

    private boolean isDimension(Column column) throws BIResourceException {
        return TYPE_DIMENSION.equals(this.getOlapType(column));
    }

    private String getOlapType(Column column) throws BIResourceException {
        return this.getTaggedValue((ModelElement)column, OLAP_TYPE);
    }

    private String getTaggedValue(ModelElement element, String tag) throws BIResourceException {
        if (element == null || tag == null) {
            return null;
        }
        this.assertTags(element);
        return (String)((Map)this.tags.get(element)).get(tag);
    }

    private void assertTags(ModelElement element) throws BIResourceException {
        if (!this.tags.containsKey(element)) {
            this.tags.put(element, this.getTags(element));
        }
    }

    private Map getTags(ModelElement element) throws BIResourceException {
        if (element == null) {
            return Collections.EMPTY_MAP;
        }
        if (this.core == null) {
            this.core = (CorePackage)element.refOutermostPackage().refPackage(CORE_PACKAGE);
        }
        if (this.taggedElement == null) {
            this.taggedElement = this.core.getTaggedElement();
        }
        Hashtable<String, String> map = new Hashtable<String, String>();
        Iterator i = this.taggedElement.getTaggedValue(element).iterator();
        while (i.hasNext()) {
            TaggedValue tv = (TaggedValue)i.next();
            map.put(tv.getTag(), tv.getValue());
        }
        return map;
    }
}

