/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.relational.query.impl;

import com.sap.ip.bi.sdk.dac.relational.query.impl.IBIRedoStack;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class BIRedoStack
implements IBIRedoStack {
    private Stack stack = new Stack();
    private Stack redo = new Stack();

    public void clear() {
        this.stack.clear();
        this.redo.clear();
    }

    public int search(Object item) {
        return this.stack.search(item);
    }

    public Object get(int index) {
        if (index < 0 || index >= this.stack.size()) {
            throw new IndexOutOfBoundsException();
        }
        return this.stack.get(index);
    }

    public Object push(Object item) {
        this.redo.clear();
        return this.stack.push(item);
    }

    public Object pop() {
        Object top = this.stack.pop();
        this.redo.clear();
        return top;
    }

    public Object peek() {
        Object top = this.stack.peek();
        return top;
    }

    public boolean empty() {
        return this.stack.empty();
    }

    public int size() {
        return this.stack.size();
    }

    public boolean hasRedo() {
        return !this.redo.empty();
    }

    public boolean hasUndo() {
        return !this.stack.empty();
    }

    public Object undo() {
        if (this.stack.empty()) {
            throw new EmptyStackException();
        }
        Object top = this.stack.pop();
        this.redo.push(top);
        return top;
    }

    public Object redo() {
        if (this.redo.empty()) {
            throw new EmptyStackException();
        }
        Object top = this.redo.pop();
        this.stack.push(top);
        return top;
    }

    public Iterator iterator() {
        return this.stack.iterator();
    }

    public Object[] toArray() {
        return this.stack.stack.toArray();
    }

    private class Stack {
        private List stack = new ArrayList();

        public void clear() {
            this.stack.clear();
        }

        public Object push(Object item) {
            this.stack.add(item);
            return item;
        }

        public Object pop() {
            if (this.stack.isEmpty()) {
                throw new EmptyStackException();
            }
            Object item = this.stack.get(this.stack.size() - 1);
            this.stack.remove(this.stack.size() - 1);
            return item;
        }

        public Object peek() {
            if (this.stack.isEmpty()) {
                throw new EmptyStackException();
            }
            return this.stack.get(this.stack.size() - 1);
        }

        public int size() {
            return this.stack.size();
        }

        public int search(Object item) {
            int index = 0;
            java.util.Iterator i = this.stack.iterator();
            while (i.hasNext()) {
                if (item == null ? item == i.next() : item.equals(i.next())) {
                    return this.stack.size() - index;
                }
                ++index;
            }
            return -1;
        }

        public Object get(int index) {
            if (index < 0 || index >= this.stack.size()) {
                throw new IndexOutOfBoundsException();
            }
            return this.stack.get(index);
        }

        public boolean empty() {
            return this.stack.size() == 0;
        }

        public java.util.Iterator iterator() {
            return new Iterator();
        }

        private class Iterator
        implements java.util.Iterator {
            private int current;

            public Iterator() {
                this.current = Stack.this.stack.size();
            }

            public boolean hasNext() {
                return this.current > 0;
            }

            public Object next() {
                --this.current;
                if (this.current < 0) {
                    throw new NoSuchElementException();
                }
                return Stack.this.stack.get(this.current);
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

