/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.olap.query.impl.mdx.util;

import com.sap.ip.bi.sdk.dac.olap.query.impl.mdx.util.BIParserInfo;
import com.sap.ip.bi.sdk.dac.olap.query.main.IBIAxis;
import com.sap.ip.bi.sdk.dac.olap.query.main.IBIAxisDimension;
import com.sap.ip.bi.sdk.dac.olap.query.main.IBISetExpression;
import com.sap.ip.bi.sdk.dac.olap.query.msx.IBICompositeMemberSetExpression;
import com.sap.ip.bi.sdk.dac.olap.query.msx.IBIMemberSelection;
import com.sap.ip.bi.sdk.dac.olap.query.tsx.IBICompositeTupleSetExpression;
import com.sap.ip.bi.sdk.dac.olap.query.tsx.IBITupleSelection;
import com.sap.ip.bi.sdk.exception.BIOlapQueryRuntimeException;
import com.sap.ip.bi.sdk.util.impl.BIEnumerationSupports;
import java.util.Iterator;
import java.util.List;

public class BIStepAnalyzer {
    private BIStepAnalyzer() {
    }

    public static Status getStatus(IBIAxis axis) {
        return BIStepAnalyzer.getStatus(axis.getTupleSet().getTupleSetExpression());
    }

    public static Status getStatus(IBIAxisDimension axisDimension) {
        return BIStepAnalyzer.getStatus(axisDimension.getMemberSet().getMemberSetExpression());
    }

    public static Status getStatus(List setExpressions) {
        Status status = Status.NO_STEPS;
        Iterator i = setExpressions.iterator();
        while (i.hasNext()) {
            IBISetExpression setExpression = (IBISetExpression)i.next();
            if (!setExpression.isActive()) continue;
            if (setExpression instanceof IBIMemberSelection || setExpression instanceof IBICompositeMemberSetExpression || setExpression instanceof IBITupleSelection || setExpression instanceof IBICompositeTupleSetExpression) {
                status = Status.FIRST_IS_SELECTION;
                break;
            }
            status = Status.FIRST_IS_NOT_SELECTION;
            break;
        }
        return status;
    }

    public static boolean memberSelectionNeeded(List setExpressions, BIParserInfo info) {
        Status statusMemberSet = BIStepAnalyzer.getStatus(setExpressions);
        if (statusMemberSet == Status.FIRST_IS_NOT_SELECTION) {
            return true;
        }
        if (statusMemberSet == Status.FIRST_IS_SELECTION) {
            return false;
        }
        if (statusMemberSet == Status.NO_STEPS) {
            Status statusTupleSet = BIStepAnalyzer.getStatus(info.context.currentAxis.getTupleSet().getTupleSetExpression());
            return statusTupleSet != Status.FIRST_IS_SELECTION;
        }
        throw new BIOlapQueryRuntimeException(info.locale, "sdk.dac.olap.query_1020", new Object[]{info.context.currentAxisDimension.getDimension()});
    }

    public static class Status
    extends BIEnumerationSupports {
        public static Status NO_STEPS = new Status("NO_STEPS");
        public static Status FIRST_IS_SELECTION = new Status("FIRST_IS_SELECTION");
        public static Status FIRST_IS_NOT_SELECTION = new Status("FIRST_IS_NOT_SELECTION");

        private Status(String name) {
            super(name);
        }
    }
}

