/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.olap.query.impl.mdx.util;

import com.sap.ip.bi.sdk.dac.olap.query.impl.factory.BIQueryFactory;
import com.sap.ip.bi.sdk.dac.olap.query.impl.mdx.util.BIParserInfo;
import com.sap.ip.bi.sdk.dac.olap.query.member.IBIMember;
import com.sap.ip.bi.sdk.exception.BIOlapQueryException;
import com.sap.ip.bi.sdk.exception.BIOlapQueryRuntimeException;
import java.util.Iterator;
import org.omg.cwm.analysis.olap.Cube;
import org.omg.cwm.analysis.olap.Dimension;
import org.omg.cwm.analysis.olap.Hierarchy;
import org.omg.cwm.analysis.olap.Level;
import org.omg.cwm.objectmodel.core.Attribute;
import org.omg.cwm.objectmodel.core.CorePackage;
import org.omg.cwm.objectmodel.core.ModelElement;
import org.omg.cwm.objectmodel.core.TaggedValue;

public class BIName {
    private BIName() {
    }

    public static String getName(Cube cube, BIParserInfo info) throws BIOlapQueryException {
        String name = BIName.getNameInternal((ModelElement)cube, info);
        if (!name.startsWith("[") || !name.endsWith("]")) {
            name = "[" + name + "]";
        }
        return name;
    }

    public static String getName(Dimension dimension, BIParserInfo info) throws BIOlapQueryException {
        return BIName.getNameInternal((ModelElement)dimension, info);
    }

    public static String getName(Hierarchy hierarchy, BIParserInfo info) throws BIOlapQueryException {
        return BIName.getNameInternal((ModelElement)hierarchy, info);
    }

    public static String getName(Level level, BIParserInfo info) throws BIOlapQueryException {
        return BIName.getNameInternal((ModelElement)level, info);
    }

    public static String getName(IBIMember member, BIParserInfo info) throws BIOlapQueryException {
        return BIName.getNameInternal((ModelElement)member, info);
    }

    public static String getName(Attribute attribute, BIParserInfo info) throws BIOlapQueryException {
        return BIName.getNameInternal((ModelElement)attribute, info);
    }

    private static String getNameInternal(ModelElement olapMetadataObject, BIParserInfo info) throws BIOlapQueryException {
        CorePackage corePackage = ((BIQueryFactory)info.olap.getQueryFactory()).getCorePackage();
        String key = null;
        if (olapMetadataObject instanceof Cube) {
            key = "CUBE_NAME";
        } else if (olapMetadataObject instanceof Dimension) {
            key = "DIMENSION_NAME";
        } else if (olapMetadataObject instanceof Hierarchy) {
            key = "HIERARCHY_NAME";
        } else if (olapMetadataObject instanceof Level) {
            key = "LEVEL_NAME";
        } else if (olapMetadataObject instanceof IBIMember) {
            key = "MEMBER_NAME";
        } else if (olapMetadataObject instanceof Attribute) {
            String name = ((Attribute)olapMetadataObject).getName();
            if (name != null) {
                return name;
            }
            key = "PROPERTY_NAME";
        } else {
            throw new BIOlapQueryRuntimeException(info.locale, "sdk.dac.olap.query_1009", new Object[]{olapMetadataObject.toString()});
        }
        Iterator iterator = corePackage.getTaggedElement().getTaggedValue(olapMetadataObject).iterator();
        while (iterator.hasNext()) {
            TaggedValue taggedValue = (TaggedValue)iterator.next();
            if (!taggedValue.getTag().equals(key)) continue;
            return taggedValue.getValue();
        }
        throw new BIOlapQueryRuntimeException(info.locale, "sdk.dac.olap.query_1010", new Object[]{"NAME", olapMetadataObject.toString()});
    }
}

