/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.olap.query.impl.mdx.util;

import com.sap.ip.bi.sdk.dac.olap.mdx.model.ele.IBIMdxMember;
import com.sap.ip.bi.sdk.dac.olap.mdx.model.stat.IBIMdxSingleFormulaSpecification;
import com.sap.ip.bi.sdk.dac.olap.query.impl.mdx.util.BIParserInfo;
import com.sap.ip.bi.sdk.dac.olap.query.impl.mdx.util.BIUniqueName;
import com.sap.ip.bi.sdk.dac.olap.query.member.IBICalculatedMember;
import com.sap.ip.bi.sdk.exception.BIOlapQueryException;
import java.util.HashMap;
import java.util.Map;

public class BICalculatedMembersManager {
    private Map calculatedMemberName = new HashMap();
    private Map calculatedMemberFormula = new HashMap();
    private Map calculatedMemberMdxMember = new HashMap();

    public String createName(IBICalculatedMember calculatedMember, BIParserInfo info) throws BIOlapQueryException {
        String suffix = calculatedMember.getId();
        if (!suffix.startsWith("[") || !suffix.endsWith("]")) {
            suffix = "[" + suffix + "]";
        }
        String prefix = BIUniqueName.getUniqueName(calculatedMember.getAxisDimension().getDimension(), info);
        return prefix + "." + suffix;
    }

    public void addCalculatedMember(IBICalculatedMember calculatedMember, String name, IBIMdxSingleFormulaSpecification formula, IBIMdxMember mdxMember) throws BIOlapQueryException {
        if (!this.calculatedMemberName.containsKey(calculatedMember)) {
            this.calculatedMemberName.put(calculatedMember, name);
            this.calculatedMemberFormula.put(calculatedMember, formula);
            this.calculatedMemberMdxMember.put(calculatedMember, mdxMember);
        }
    }

    public boolean calculatedMemberExists(IBICalculatedMember calculatedMember) throws BIOlapQueryException {
        return this.calculatedMemberName.containsKey(calculatedMember);
    }

    public String getCalculatedMemberName(IBICalculatedMember calculatedMember) throws BIOlapQueryException {
        return (String)this.calculatedMemberName.get(calculatedMember);
    }

    public IBIMdxSingleFormulaSpecification getCalculatedMemberFormula(IBICalculatedMember calculatedMember) throws BIOlapQueryException {
        return (IBIMdxSingleFormulaSpecification)this.calculatedMemberFormula.get(calculatedMember);
    }

    public IBIMdxMember getCalculatedMemberMdxMember(IBICalculatedMember calculatedMember) throws BIOlapQueryException {
        return (IBIMdxMember)this.calculatedMemberMdxMember.get(calculatedMember);
    }
}

