/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.olap.query.impl.mdx.sub.bw;

import com.sap.ip.bi.sdk.dac.connector.olap.BISAPVariableConstants;
import com.sap.ip.bi.sdk.dac.olap.mdx.model.cond.IBIMdxCompOp;
import com.sap.ip.bi.sdk.dac.olap.mdx.model.def.IBIMdxValueExpression;
import com.sap.ip.bi.sdk.dac.olap.mdx.model.ele.IBIMdxExpression;
import com.sap.ip.bi.sdk.dac.olap.mdx.model.ele.IBIMdxHierarchyById;
import com.sap.ip.bi.sdk.dac.olap.mdx.model.ele.IBIMdxMember;
import com.sap.ip.bi.sdk.dac.olap.mdx.model.stat.IBIMdxSelectStatement;
import com.sap.ip.bi.sdk.dac.olap.mdx.model.var.IBIMdxSapHierarchyVariable;
import com.sap.ip.bi.sdk.dac.olap.mdx.model.var.IBIMdxSapSingleVariableSpecification;
import com.sap.ip.bi.sdk.dac.olap.mdx.model.var.IBIMdxSapVariableSpecification;
import com.sap.ip.bi.sdk.dac.olap.query.impl.mdx.sub.BIQueryParser;
import com.sap.ip.bi.sdk.dac.olap.query.impl.mdx.util.BIParserInfo;
import com.sap.ip.bi.sdk.dac.olap.query.types.IBIRelationalOperatorType;
import com.sap.ip.bi.sdk.dac.olap.query.types.IBIRelationalOperatorTypeEnum;
import com.sap.ip.bi.sdk.dac.olap.query.types.IBISapRangeSignType;
import com.sap.ip.bi.sdk.dac.olap.query.types.IBISapRangeSignTypeEnum;
import com.sap.ip.bi.sdk.dac.olap.query.types.IBISapVariableSelectionType;
import com.sap.ip.bi.sdk.dac.olap.query.types.IBISapVariableSelectionTypeEnum;
import com.sap.ip.bi.sdk.dac.olap.query.var.IBISapHierarchyValue;
import com.sap.ip.bi.sdk.dac.olap.query.var.IBISapHierarchyVariable;
import com.sap.ip.bi.sdk.dac.olap.query.var.IBISapMemberValueRange;
import com.sap.ip.bi.sdk.dac.olap.query.var.IBISapMemberVariable;
import com.sap.ip.bi.sdk.dac.olap.query.var.IBISapNumericValueRange;
import com.sap.ip.bi.sdk.dac.olap.query.var.IBISapNumericVariable;
import com.sap.ip.bi.sdk.dac.olap.query.var.IBISapVariable;
import com.sap.ip.bi.sdk.dac.olap.query.var.IBISapVariableValue;
import com.sap.ip.bi.sdk.dac.olap.query.var.IBISapVariableValueRange;
import com.sap.ip.bi.sdk.exception.BIOlapQueryException;
import com.sap.ip.bi.sdk.exception.BIResourceException;
import com.sap.ip.bi.sdk.exception.impl.BIOlapQueryExceptionAssure;
import com.sap.ip.bi.sdk.util.BILoggingSetup;
import com.sap.ip.bi.sdk.util.impl.BITrace;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.omg.cwm.objectmodel.core.ModelElement;
import org.omg.cwm.objectmodel.core.TaggedValue;
import org.omg.cwm.objectmodel.instance.Object;
import org.omg.cwm.objectmodel.instance.Slot;

public class BIBwQueryParser
extends BIQueryParser {
    private static final Category category = BILoggingSetup.QUERY.getCategory();
    private static final Location location = Location.getLocation((Class)(class$com$sap$ip$bi$sdk$dac$olap$query$impl$mdx$sub$bw$BIBwQueryParser == null ? (class$com$sap$ip$bi$sdk$dac$olap$query$impl$mdx$sub$bw$BIBwQueryParser = BIBwQueryParser.class$("com.sap.ip.bi.sdk.dac.olap.query.impl.mdx.sub.bw.BIBwQueryParser")) : class$com$sap$ip$bi$sdk$dac$olap$query$impl$mdx$sub$bw$BIBwQueryParser));
    private static final BITrace trace = new BITrace(location);
    private static final BIOlapQueryExceptionAssure assure = new BIOlapQueryExceptionAssure(class$com$sap$ip$bi$sdk$dac$olap$query$impl$mdx$sub$bw$BIBwQueryParser == null ? (class$com$sap$ip$bi$sdk$dac$olap$query$impl$mdx$sub$bw$BIBwQueryParser = BIBwQueryParser.class$("com.sap.ip.bi.sdk.dac.olap.query.impl.mdx.sub.bw.BIBwQueryParser")) : class$com$sap$ip$bi$sdk$dac$olap$query$impl$mdx$sub$bw$BIBwQueryParser, BILoggingSetup.QUERY.getCategory());
    static /* synthetic */ Class class$com$sap$ip$bi$sdk$dac$olap$query$impl$mdx$sub$bw$BIBwQueryParser;

    protected BIBwQueryParser() {
    }

    public IBIMdxSelectStatement parse(BIParserInfo info) throws BIOlapQueryException {
        IBIMdxSelectStatement iBIMdxSelectStatement;
        String method = "parse(BIParserInfo)";
        trace.enter("parse(BIParserInfo)", new java.lang.Object[]{info});
        try {
            assure.notNull("parse(BIParserInfo)", info.locale, (java.lang.Object)info);
            info.selectStatement = info.mdxFactory.createSelectStatement();
            info.selectStatement.setCellProps(this.createCellProps(info));
            info.selectStatement.setCubeSpecification(this.createCubeSpecification(info));
            info.selectStatement.setFormulaSpecification(this.createFormulaSpecification(info));
            info.selectStatement.setAxisSpecification(this.createAxisSpecification(info));
            info.selectStatement.setSlicerSpecification(this.createSlicerSpecification(info));
            info.selectStatement.setSapVariableSpecification(this.createSapVariableSpecification(info));
            iBIMdxSelectStatement = info.selectStatement;
            java.lang.Object var5_4 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var5_5 = null;
            trace.exit();
            throw throwable;
        }
        trace.exit();
        return iBIMdxSelectStatement;
    }

    protected IBIMdxSapVariableSpecification createSapVariableSpecification(BIParserInfo info) throws BIOlapQueryException {
        IBIMdxSapVariableSpecification iBIMdxSapVariableSpecification;
        String method = "createSapVariableSpecification(BIParserInfo)";
        trace.enter("createSapVariableSpecification(BIParserInfo)", new java.lang.Object[]{info});
        try {
            assure.notNull("createSapVariableSpecification(BIParserInfo)", info.locale, (java.lang.Object)info);
            IBIMdxSapVariableSpecification variableSpecification = null;
            Iterator i = info.query.getSapVariable().iterator();
            while (i.hasNext()) {
                Slot slot = (Slot)i.next();
                IBISapVariable variable = (IBISapVariable)slot.getFeature();
                IBISapVariableSelectionType sel = variable.getSelectionType();
                if (sel == IBISapVariableSelectionTypeEnum.SINGLEVALUE || sel == IBISapVariableSelectionTypeEnum.INTERVAL) {
                    if (slot.getValue() != null) {
                        IBIMdxSapSingleVariableSpecification singleVariableSpecification = this.getSingleVariableSpecification(variable, (IBISapVariableValue)slot.getValue(), info);
                        if (variableSpecification == null) {
                            variableSpecification = info.mdxFactory.createSapVariableSpecification();
                        }
                        variableSpecification.addSapSingleVariableSpecification(singleVariableSpecification);
                        continue;
                    }
                    if (!variable.isMandatory()) continue;
                    if (variableSpecification == null) {
                        variableSpecification = info.mdxFactory.createSapVariableSpecification();
                    }
                    variableSpecification.addSapSingleVariableSpecification(this.getSingleVariableSpecification(variable, info));
                    continue;
                }
                if (sel != IBISapVariableSelectionTypeEnum.COMPLEX) continue;
                Collection slots = ((Object)slot.getValue()).getSlot();
                if (slots.size() > 0) {
                    Iterator j = slots.iterator();
                    while (j.hasNext()) {
                        Slot singleSlot = (Slot)j.next();
                        IBIMdxSapSingleVariableSpecification singleVariableSpecification = this.getSingleVariableSpecification(variable, (IBISapVariableValue)singleSlot.getValue(), info);
                        if (variableSpecification == null) {
                            variableSpecification = info.mdxFactory.createSapVariableSpecification();
                        }
                        variableSpecification.addSapSingleVariableSpecification(singleVariableSpecification);
                    }
                    continue;
                }
                if (!variable.isMandatory()) continue;
                if (variableSpecification == null) {
                    variableSpecification = info.mdxFactory.createSapVariableSpecification();
                }
                variableSpecification.addSapSingleVariableSpecification(this.getSingleVariableSpecification(variable, info));
            }
            iBIMdxSapVariableSpecification = variableSpecification;
            java.lang.Object var13_12 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var13_13 = null;
            trace.exit();
            throw throwable;
        }
        trace.exit();
        return iBIMdxSapVariableSpecification;
    }

    protected IBIMdxSapSingleVariableSpecification getSingleVariableSpecification(IBISapVariable variable, IBISapVariableValue value, BIParserInfo info) throws BIOlapQueryException {
        IBIMdxSapHierarchyVariable iBIMdxSapHierarchyVariable;
        String method = "getSingleVariableSpecification(IBISapVariable, IBISapVariableValue, BIParserInfo)";
        trace.enter("getSingleVariableSpecification(IBISapVariable, IBISapVariableValue, BIParserInfo)", new java.lang.Object[]{variable, value, info});
        try {
            assure.notNull("getSingleVariableSpecification(IBISapVariable, IBISapVariableValue, BIParserInfo)", info.locale, (java.lang.Object)variable, (java.lang.Object)value, (java.lang.Object)info);
            IBIMdxSapSingleVariableSpecification single = null;
            String name = variable.getName();
            if (variable instanceof IBISapMemberVariable && value instanceof IBISapMemberValueRange) {
                IBISapMemberValueRange memberValue = (IBISapMemberValueRange)value;
                boolean including = this.getIncluding(memberValue.getSign());
                IBIMdxCompOp compOp = this.getCompOp(value, info);
                ArrayList<IBIMdxMember> members = new ArrayList<IBIMdxMember>();
                members.add(info.parserFactory.getMemberParser().parse(memberValue.getLow(), info));
                if (memberValue.getOption() == IBIRelationalOperatorTypeEnum.BETWEEN) {
                    members.add(info.parserFactory.getMemberParser().parse(memberValue.getHigh(), info));
                }
                single = info.mdxFactory.createSapMemberVariable(name, including, compOp, members);
            } else if (variable instanceof IBISapHierarchyVariable && value instanceof IBISapHierarchyValue) {
                IBISapHierarchyValue hierarchyValue = (IBISapHierarchyValue)value;
                IBIMdxHierarchyById mdxHierarchy = (IBIMdxHierarchyById)info.parserFactory.getMetadataParser().parse(hierarchyValue.getHierarchy(), info);
                single = info.mdxFactory.createSapHierarchyVariable(name, mdxHierarchy);
            } else if (variable instanceof IBISapNumericVariable && value instanceof IBISapNumericValueRange) {
                IBISapNumericValueRange numericValue = (IBISapNumericValueRange)value;
                boolean including = this.getIncluding(numericValue.getSign());
                IBIMdxCompOp compOp = this.getCompOp(value, info);
                ArrayList<IBIMdxValueExpression> valueExpressions = new ArrayList<IBIMdxValueExpression>();
                valueExpressions.add(info.parserFactory.getInputReferenceParser().parseJavaWrapperClass(numericValue.getLow().getValue(), info));
                if (numericValue.getOption() == IBIRelationalOperatorTypeEnum.BETWEEN) {
                    valueExpressions.add(info.parserFactory.getInputReferenceParser().parseJavaWrapperClass(numericValue.getHigh().getValue(), info));
                }
                single = info.mdxFactory.createSapNumericVariable(name, including, compOp, valueExpressions);
            } else {
                BIOlapQueryException exception = new BIOlapQueryException(info.locale, "sdk.dac.olap.query_4003", new java.lang.Object[]{variable.getName()});
                category.errorT(location, exception.getLocalizedMessage());
                throw exception;
            }
            iBIMdxSapHierarchyVariable = single;
            java.lang.Object var12_16 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var12_17 = null;
            trace.exit();
            throw throwable;
        }
        trace.exit();
        return iBIMdxSapHierarchyVariable;
    }

    protected IBIMdxSapSingleVariableSpecification getSingleVariableSpecification(IBISapVariable variable, BIParserInfo info) throws BIOlapQueryException {
        IBIMdxSapHierarchyVariable iBIMdxSapHierarchyVariable;
        String method = "getSingleVariableSpecification(IBISapVariable, BIParserInfo)";
        trace.enter("getSingleVariableSpecification(IBISapVariable, BIParserInfo)", new java.lang.Object[]{variable, info});
        try {
            ArrayList<IBIMdxExpression> values;
            assure.notNull("getSingleVariableSpecification(IBISapVariable, BIParserInfo)", info.locale, (java.lang.Object)variable, (java.lang.Object)info);
            IBIMdxSapSingleVariableSpecification single = null;
            Collection taggedValues = null;
            try {
                taggedValues = info.olap.getTaggedValue((ModelElement)variable);
            }
            catch (BIResourceException e) {
                throw new BIOlapQueryException(info.locale, (Throwable)e);
            }
            String defaultLow = null;
            String defaultHigh = null;
            Iterator i = taggedValues.iterator();
            while (i.hasNext()) {
                TaggedValue taggedValue = (TaggedValue)i.next();
                String tag = taggedValue.getTag();
                if (tag.equals(BISAPVariableConstants.DEFAULT_LOW)) {
                    defaultLow = taggedValue.getValue();
                    continue;
                }
                if (!tag.equals(BISAPVariableConstants.DEFAULT_HIGH)) continue;
                defaultHigh = taggedValue.getValue();
            }
            IBIMdxCompOp compOp = null;
            if (variable.getSelectionType() != IBISapVariableSelectionTypeEnum.INTERVAL) {
                compOp = info.mdxFactory.createCompOp();
                compOp.setEquals(true);
            }
            if (variable instanceof IBISapMemberVariable) {
                values = new ArrayList<IBIMdxExpression>();
                if (defaultLow != null) {
                    values.add(info.mdxFactory.createMemberById(defaultLow));
                }
                if (defaultHigh != null) {
                    values.add(info.mdxFactory.createMemberById(defaultHigh));
                }
                single = info.mdxFactory.createSapMemberVariable(variable.getName(), true, compOp, values);
            } else if (variable instanceof IBISapHierarchyVariable) {
                single = info.mdxFactory.createSapHierarchyVariable(variable.getName(), info.mdxFactory.createHierarchyById(defaultLow));
            } else {
                values = new ArrayList();
                if (defaultLow != null) {
                    values.add(info.mdxFactory.createNumericValueExpressionByNumericLiteral(defaultLow));
                }
                if (defaultHigh != null) {
                    values.add(info.mdxFactory.createNumericValueExpressionByNumericLiteral(defaultHigh));
                }
                single = info.mdxFactory.createSapNumericVariable(variable.getName(), true, compOp, values);
            }
            iBIMdxSapHierarchyVariable = single;
            java.lang.Object var12_12 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var12_13 = null;
            trace.exit();
            throw throwable;
        }
        trace.exit();
        return iBIMdxSapHierarchyVariable;
    }

    protected IBIMdxCompOp getCompOp(IBISapVariableValue value, BIParserInfo info) throws BIOlapQueryException {
        IBIMdxCompOp mdxCompOp = null;
        if (value instanceof IBISapVariableValueRange) {
            IBIRelationalOperatorType operator = ((IBISapVariableValueRange)value).getOption();
            mdxCompOp = info.mdxFactory.createCompOp();
            if (operator == IBIRelationalOperatorTypeEnum.BETWEEN) {
                mdxCompOp = null;
            } else if (operator == IBIRelationalOperatorTypeEnum.EQUAL) {
                mdxCompOp.setEquals(true);
            } else if (operator == IBIRelationalOperatorTypeEnum.GREATERTHAN) {
                mdxCompOp.setGreaterThanOperator(true);
            } else if (operator == IBIRelationalOperatorTypeEnum.GREATERTHANEQUAL) {
                mdxCompOp.setGreaterThanOrEqualsOperator(true);
            } else if (operator == IBIRelationalOperatorTypeEnum.LESSTHAN) {
                mdxCompOp.setLessThanOperator(true);
            } else if (operator == IBIRelationalOperatorTypeEnum.LESSTHANEQUAL) {
                mdxCompOp.setLessThanOrEqualsOperator(true);
            } else if (operator == IBIRelationalOperatorTypeEnum.NOTEQUAL) {
                mdxCompOp.setNotEquals(true);
            } else {
                BIOlapQueryException exception = new BIOlapQueryException(info.locale, "sdk.dac.olap.query_4004", new java.lang.Object[]{operator == null ? "<null>" : operator.toString()});
                category.errorT(location, exception.getLocalizedMessage());
                throw exception;
            }
        }
        return mdxCompOp;
    }

    protected boolean getIncluding(IBISapRangeSignType rangeSignType) {
        return rangeSignType == IBISapRangeSignTypeEnum.INCLUDING;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

