/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.olap.query.impl.mdx;

import com.sap.ip.bi.sdk.dac.connector.IBIOlap;
import com.sap.ip.bi.sdk.dac.olap.mdx.model.BIMdxObjectsFactory;
import com.sap.ip.bi.sdk.dac.olap.query.impl.QueryExecuterImpl;
import com.sap.ip.bi.sdk.dac.olap.query.impl.mdx.IBIMdxGenerator;
import com.sap.ip.bi.sdk.dac.olap.query.impl.mdx.sub.BIParserFactory;
import com.sap.ip.bi.sdk.dac.olap.query.impl.mdx.sub.BIQueryParser;
import com.sap.ip.bi.sdk.dac.olap.query.impl.mdx.util.BICalculatedMembersManager;
import com.sap.ip.bi.sdk.dac.olap.query.impl.mdx.util.BIParserContext;
import com.sap.ip.bi.sdk.dac.olap.query.impl.mdx.util.BIParserInfo;
import com.sap.ip.bi.sdk.dac.olap.query.main.IBIQuery;
import com.sap.ip.bi.sdk.dac.result.IBIDataSet;
import com.sap.ip.bi.sdk.exception.BIOlapQueryException;
import com.sap.ip.bi.sdk.exception.BIOlapQueryRuntimeException;
import java.util.HashMap;
import java.util.Locale;
import javax.resource.ResourceException;

public class BIMdxGenerator
implements IBIMdxGenerator {
    private final BIParserInfo info = new BIParserInfo();

    private BIMdxGenerator(IBIQuery query, BIParserFactory parserFactory, BIMdxObjectsFactory mdxFactory, IBIOlap olap) {
        this.info.query = query;
        try {
            this.info.locale = QueryExecuterImpl.queryExecuter.getInternalMemory(query).getOlapQueryResultProcessor().getConnectionInfo().getLocale();
            this.info.user = QueryExecuterImpl.queryExecuter.getInternalMemory(query).getOlapQueryResultProcessor().getConnectionInfo().getUser();
        }
        catch (ResourceException e) {
            throw new BIOlapQueryRuntimeException(Locale.getDefault(), (Throwable)e);
        }
        this.info.selectStatement = null;
        this.info.parserFactory = parserFactory;
        this.info.mdxFactory = mdxFactory;
        this.info.olap = olap;
        this.info.calculatedMembersManager = null;
    }

    public static IBIMdxGenerator createMdxGenerator(IBIQuery query, BIParserFactory parserFactory, IBIOlap olap) {
        return new BIMdxGenerator(query, parserFactory, BIMdxObjectsFactory.createInstance(), olap);
    }

    public String getMdxExpression() throws BIOlapQueryException {
        this.info.calculatedMembersManager = new BICalculatedMembersManager();
        this.info.parserCache = new HashMap();
        this.info.context = new BIParserContext();
        BIQueryParser queryParser = this.info.parserFactory.getQueryParser();
        this.info.selectStatement = queryParser.parse(this.info);
        StringBuffer expression = this.info.selectStatement.getExpression();
        return expression.toString();
    }

    public IBIDataSet doPostProcessing(IBIDataSet dataSet) throws BIOlapQueryException {
        IBIDataSet changedDataSet = dataSet;
        changedDataSet = this.info.parserFactory.getTotalsParser().parse(dataSet, this.info);
        return changedDataSet;
    }
}

