/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.olap.query.impl;

import com.sap.ip.bi.sdk.dac.olap.query.IBIAllFactory;
import com.sap.ip.bi.sdk.dac.olap.query.impl.BICommandUtils;
import com.sap.ip.bi.sdk.dac.olap.query.impl.QueryExecuterImpl;
import com.sap.ip.bi.sdk.dac.olap.query.main.IBIAxis;
import com.sap.ip.bi.sdk.dac.olap.query.main.IBIAxisDimension;
import com.sap.ip.bi.sdk.dac.olap.query.main.IBIQuery;
import com.sap.ip.bi.sdk.dac.olap.query.member.IBIMember;
import com.sap.ip.bi.sdk.dac.olap.query.tsx.IBITuple;
import com.sap.ip.bi.sdk.dac.olap.query.tsx.IBITupleList;
import com.sap.ip.bi.sdk.dac.olap.query.types.IBIJoinType;
import com.sap.ip.bi.sdk.dac.olap.query.types.IBIJoinTypeEnum;
import com.sap.ip.bi.sdk.dac.result.IBIAxisCursor;
import com.sap.ip.bi.sdk.dac.result.IBICursorColumn;
import com.sap.ip.bi.sdk.dac.result.IBIDataSet;
import com.sap.ip.bi.sdk.dac.result.IBIDimensionCursor;
import com.sap.ip.bi.sdk.exception.BIJmiVerifyException;
import com.sap.ip.bi.sdk.util.BILoggingSetup;
import com.sap.ip.bi.sdk.util.impl.IBIMonitor;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import javax.jmi.reflect.JmiException;
import org.omg.cwm.analysis.olap.Dimension;

public class BIQuerySimplification {
    private static final Category category = BILoggingSetup.QUERY.getCategory();
    private static final Location location = Location.getLocation((Class)(class$com$sap$ip$bi$sdk$dac$olap$query$impl$BIQuerySimplification == null ? (class$com$sap$ip$bi$sdk$dac$olap$query$impl$BIQuerySimplification = BIQuerySimplification.class$("com.sap.ip.bi.sdk.dac.olap.query.impl.BIQuerySimplification")) : class$com$sap$ip$bi$sdk$dac$olap$query$impl$BIQuerySimplification));
    private static final QueryExecuterImpl queryExecuterImpl = new QueryExecuterImpl();
    static /* synthetic */ Class class$com$sap$ip$bi$sdk$dac$olap$query$impl$BIQuerySimplification;

    public static void simplify(IBIQuery query, IBIDataSet dataSet, IBIMonitor monitor) throws JmiException {
        String method = "simplify(IBIQuery, IBIDataSet, IBIMonitor)";
        location.entering("simplify(IBIQuery, IBIDataSet, IBIMonitor)", new Object[]{query, dataSet, monitor});
        try {
            location.debug(category, (Object)"simplifying query definition...");
            monitor.compAction(class$com$sap$ip$bi$sdk$dac$olap$query$impl$BIQuerySimplification == null ? (class$com$sap$ip$bi$sdk$dac$olap$query$impl$BIQuerySimplification = BIQuerySimplification.class$("com.sap.ip.bi.sdk.dac.olap.query.impl.BIQuerySimplification")) : class$com$sap$ip$bi$sdk$dac$olap$query$impl$BIQuerySimplification, "simplify(IBIQuery, IBIDataSet, IBIMonitor)", "simplifying query definition...");
            if (dataSet != null) {
                BIQuerySimplification.simplifyKernl(query, dataSet, monitor);
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            location.exiting();
            throw throwable;
        }
        location.exiting();
    }

    private static void simplifyKernl(IBIQuery query, IBIDataSet dataSet, IBIMonitor monitor) throws JmiException {
        try {
            Iterator axesIterator = query.getAxis().iterator();
            Iterator axisCursorsIterator = dataSet.getAxisCursor().iterator();
            while (axesIterator.hasNext()) {
                IBIAxis axis = (IBIAxis)axesIterator.next();
                IBIAxisCursor axisCursor = (IBIAxisCursor)axisCursorsIterator.next();
                int stepsSum = 0;
                Iterator axisDimensionsIterator = axis.getAxisDimension().iterator();
                while (axisDimensionsIterator.hasNext()) {
                    IBIAxisDimension axisDimension = (IBIAxisDimension)axisDimensionsIterator.next();
                    stepsSum += axisDimension.getMemberSet().getMemberSetExpression().size();
                }
                if (axis.getAxisDimension().size() <= 0 || stepsSum <= 0 && axis.getTupleSet().getTupleSetExpression().size() == 1 && axis.getTupleSet().getTupleSetExpression().get(0) instanceof IBITupleList) continue;
                try {
                    BIQuerySimplification.simplifyByTupleEnumeration(axis, axisCursor, query, dataSet, monitor);
                }
                catch (JmiException e) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            throw new BIJmiVerifyException(queryExecuterImpl.getLocale(queryExecuterImpl.getInternalMemory(query)), "sdk.dac.olap.query_1006", (Throwable)e);
        }
    }

    private static void simplifyByTupleEnumeration(IBIAxis axis, IBIAxisCursor axisCursor, IBIQuery query, IBIDataSet dataSet, IBIMonitor monitor) throws JmiException {
        try {
            HashMap<String, IBIMember> memberCache = new HashMap<String, IBIMember>();
            IBIAllFactory allFactory = query.getCommandProcessor().getQueryFactory().getAllFactory();
            IBITupleList tupleList = allFactory.createTupleList(Collections.EMPTY_LIST, (IBIJoinType)IBIJoinTypeEnum.INITIAL);
            while (axisCursor.next()) {
                IBITuple tuple = allFactory.createTuple(Collections.EMPTY_LIST);
                Iterator axisDimensionsIterator = axis.getAxisDimension().iterator();
                Iterator dimensionCursorsIterator = axisCursor.getDimensionCursor().iterator();
                while (axisDimensionsIterator.hasNext()) {
                    IBIAxisDimension axisDimension = (IBIAxisDimension)axisDimensionsIterator.next();
                    IBIDimensionCursor dimensionCursor = (IBIDimensionCursor)dimensionCursorsIterator.next();
                    String memberName = dimensionCursor.getString(IBICursorColumn.MEMBER_NAME.toString());
                    String memberUniqueName = dimensionCursor.getString(IBICursorColumn.MEMBER_UNIQUE_NAME.toString());
                    Dimension dimension = axisDimension.getDimension();
                    IBIMember member = null;
                    if (memberCache.containsKey(memberUniqueName)) {
                        member = (IBIMember)memberCache.get(memberUniqueName);
                        if (member.getDimension() != dimension) {
                            member = BIQuerySimplification.createMember(allFactory, dimension, memberName, memberUniqueName);
                        }
                    } else {
                        member = BIQuerySimplification.createMember(allFactory, dimension, memberName, memberUniqueName);
                        memberCache.put(memberUniqueName, member);
                    }
                    tuple.getMember().add(member);
                }
                tupleList.getTuple().add(tuple);
            }
            BICommandUtils.clear(axis);
            axis.getTupleSet().getTupleSetExpression().add(tupleList);
            location.debug(category, (Object)"definition for axis simplified");
        }
        catch (Exception e) {
            throw new BIJmiVerifyException(queryExecuterImpl.getLocale(queryExecuterImpl.getInternalMemory(query)), "sdk.dac.olap.query_1006", (Throwable)e);
        }
    }

    private static IBIMember createMember(IBIAllFactory allFactory, Dimension dimension, String memberName, String memberUniqueName) throws Exception {
        HashMap<String, String> taggedValues = new HashMap<String, String>();
        taggedValues.put("MEMBER_NAME", memberName);
        taggedValues.put("MEMBER_UNIQUE_NAME", memberUniqueName);
        IBIMember member = allFactory.createMember(dimension, memberName, null, taggedValues);
        return member;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

