/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.olap.query.impl;

import com.sap.ip.bi.sdk.dac.olap.query.impl.BICommandInfo;
import com.sap.ip.bi.sdk.dac.olap.query.impl.BICommandUtils;
import com.sap.ip.bi.sdk.dac.olap.query.input.IBIInputReference;
import com.sap.ip.bi.sdk.dac.olap.query.input.IBILiteralReference;
import com.sap.ip.bi.sdk.dac.olap.query.input.IBIMemberReference;
import com.sap.ip.bi.sdk.dac.olap.query.main.IBIAxis;
import com.sap.ip.bi.sdk.dac.olap.query.main.IBIAxisDimension;
import com.sap.ip.bi.sdk.dac.olap.query.main.IBISetExpression;
import com.sap.ip.bi.sdk.dac.olap.query.member.IBIMember;
import com.sap.ip.bi.sdk.dac.olap.query.msx.IBICompositeMemberSetExpression;
import com.sap.ip.bi.sdk.dac.olap.query.msx.IBIConditionBasedFilter;
import com.sap.ip.bi.sdk.dac.olap.query.msx.IBIRankingFilter;
import com.sap.ip.bi.sdk.dac.olap.query.msx.IBISort;
import com.sap.ip.bi.sdk.dac.olap.query.tsx.IBICompositeTupleSetExpression;
import com.sap.ip.bi.sdk.dac.olap.query.tsx.IBITuple;
import com.sap.ip.bi.sdk.dac.olap.query.types.IBIJoinType;
import com.sap.ip.bi.sdk.dac.olap.query.types.IBIRankType;
import com.sap.ip.bi.sdk.dac.olap.query.types.IBIRelationalOperatorType;
import com.sap.ip.bi.sdk.dac.olap.query.types.IBIRelationalOperatorTypeEnum;
import com.sap.ip.bi.sdk.dac.olap.query.types.IBISapVariableSelectionTypeEnum;
import com.sap.ip.bi.sdk.dac.olap.query.types.IBISortDirectionType;
import com.sap.ip.bi.sdk.dac.olap.query.var.IBISapHierarchyValue;
import com.sap.ip.bi.sdk.dac.olap.query.var.IBISapHierarchyVariable;
import com.sap.ip.bi.sdk.dac.olap.query.var.IBISapMemberValueRange;
import com.sap.ip.bi.sdk.dac.olap.query.var.IBISapMemberVariable;
import com.sap.ip.bi.sdk.dac.olap.query.var.IBISapNumericValueRange;
import com.sap.ip.bi.sdk.dac.olap.query.var.IBISapNumericVariable;
import com.sap.ip.bi.sdk.dac.olap.query.var.IBISapVariable;
import com.sap.ip.bi.sdk.dac.olap.query.var.IBISapVariableValue;
import com.sap.ip.bi.sdk.exception.BIOlapQueryException;
import com.sap.ip.bi.sdk.exception.BIOlapQueryRuntimeException;
import com.sap.ip.bi.sdk.exception.impl.BIOlapQueryExceptionAssure;
import com.sap.ip.bi.sdk.util.BILoggingSetup;
import com.sap.ip.bi.sdk.util.impl.BITrace;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.omg.cwm.analysis.olap.Dimension;
import org.omg.cwm.objectmodel.core.Attribute;
import org.omg.cwm.objectmodel.core.StructuralFeature;
import org.omg.cwm.objectmodel.instance.Instance;
import org.omg.cwm.objectmodel.instance.Object;
import org.omg.cwm.objectmodel.instance.Slot;

public class BICommandUtils {
    private static final Category category = BILoggingSetup.QUERY.getCategory();
    private static final Location location = Location.getLocation((Class)(class$com$sap$ip$bi$sdk$dac$olap$query$impl$BICommandUtils == null ? (class$com$sap$ip$bi$sdk$dac$olap$query$impl$BICommandUtils = BICommandUtils.class$("com.sap.ip.bi.sdk.dac.olap.query.impl.BICommandUtils")) : class$com$sap$ip$bi$sdk$dac$olap$query$impl$BICommandUtils));
    private static final BITrace trace = new BITrace(location);
    private static final BIOlapQueryExceptionAssure assure = new BIOlapQueryExceptionAssure(class$com$sap$ip$bi$sdk$dac$olap$query$impl$BICommandUtils == null ? (class$com$sap$ip$bi$sdk$dac$olap$query$impl$BICommandUtils = BICommandUtils.class$("com.sap.ip.bi.sdk.dac.olap.query.impl.BICommandUtils")) : class$com$sap$ip$bi$sdk$dac$olap$query$impl$BICommandUtils, BILoggingSetup.QUERY.getCategory());
    static /* synthetic */ Class class$com$sap$ip$bi$sdk$dac$olap$query$impl$BICommandUtils;

    private BICommandUtils() {
    }

    public static AxisDimensionInfo getAxisDimension(Dimension dimension, boolean includeSlicer, BICommandInfo info) throws BIOlapQueryException {
        IBIAxisDimension axisDimension;
        Iterator iteratorAxisDimensions;
        AxisDimensionInfo axisDimensionInfo = new AxisDimensionInfo();
        axisDimensionInfo.axisDimension = null;
        axisDimensionInfo.dimension = dimension;
        axisDimensionInfo.axisIndex = 0;
        Iterator iteratorAxes = info.query.getAxis().iterator();
        while (iteratorAxes.hasNext()) {
            axisDimensionInfo.positionIndex = 0;
            iteratorAxisDimensions = ((IBIAxis)iteratorAxes.next()).getAxisDimension().iterator();
            while (iteratorAxisDimensions.hasNext()) {
                axisDimension = (IBIAxisDimension)iteratorAxisDimensions.next();
                if (axisDimension.getDimension() == dimension) {
                    axisDimensionInfo.axisDimension = axisDimension;
                    break;
                }
                ++axisDimensionInfo.positionIndex;
            }
            ++axisDimensionInfo.axisIndex;
        }
        if (axisDimensionInfo.axisDimension == null && includeSlicer) {
            axisDimensionInfo.axisIndex = -1;
            axisDimensionInfo.positionIndex = 0;
            iteratorAxisDimensions = info.query.getSlicer().getAxisDimension().iterator();
            while (iteratorAxisDimensions.hasNext()) {
                axisDimension = (IBIAxisDimension)iteratorAxisDimensions.next();
                if (axisDimension.getDimension() == dimension) {
                    axisDimensionInfo.axisDimension = axisDimension;
                    break;
                }
                ++axisDimensionInfo.positionIndex;
            }
        }
        if (axisDimensionInfo.axisDimension != null) {
            return axisDimensionInfo;
        }
        throw new BIOlapQueryRuntimeException(info.locale, "sdk.dac.olap.query_2001", new java.lang.Object[]{dimension, info.query.getLabel()});
    }

    public static IBIAxis getAxis(IBITuple tuple, boolean includeSlicer, BICommandInfo info) throws BIOlapQueryException {
        ArrayList<Dimension> dimensions = new ArrayList<Dimension>();
        Iterator i = tuple.getMember().iterator();
        while (i.hasNext()) {
            IBIMember member = (IBIMember)i.next();
            dimensions.add(member.getDimension());
        }
        return BICommandUtils.getAxis(dimensions, includeSlicer, info);
    }

    public static IBIAxis getAxis(List dimensions, boolean includeSlicer, BICommandInfo info) throws BIOlapQueryException {
        Iterator i = info.query.getAxis().iterator();
        block0: while (i.hasNext()) {
            IBIAxis axis = (IBIAxis)i.next();
            if (axis.getAxisDimension().size() != dimensions.size()) continue;
            Iterator j = axis.getAxisDimension().iterator();
            Iterator k = dimensions.iterator();
            while (j.hasNext()) {
                IBIAxisDimension axisDimension = (IBIAxisDimension)j.next();
                Dimension dimension = (Dimension)k.next();
                if (axisDimension.getDimension() != dimension) continue block0;
            }
            return axis;
        }
        boolean once = includeSlicer;
        while (once) {
            block8: {
                IBIAxis axis = info.query.getSlicer();
                if (axis.getAxisDimension().size() == dimensions.size()) {
                    Iterator j = axis.getAxisDimension().iterator();
                    Iterator k = dimensions.iterator();
                    while (j.hasNext()) {
                        IBIAxisDimension axisDimension = (IBIAxisDimension)j.next();
                        Dimension dimension = (Dimension)k.next();
                        if (axisDimension.getDimension() == dimension) {
                            continue;
                        }
                        break block8;
                    }
                    return axis;
                }
            }
            once = false;
        }
        String dimensionNames = "";
        Iterator i2 = dimensions.iterator();
        while (i2.hasNext()) {
            Dimension dimension = (Dimension)i2.next();
            if (!dimensionNames.equals("")) {
                dimensionNames = dimensionNames + ", ";
            }
            dimensionNames = dimensionNames + dimension.getName();
        }
        throw new BIOlapQueryRuntimeException(info.locale, "sdk.dac.olap.query_2003", new java.lang.Object[]{dimensionNames, info.query.toString()});
    }

    public static IBIRankingFilter createRankingFilter(Dimension dimension, IBILiteralReference value, IBIMember measure, IBIRankType rankType, IBIJoinType joinType, BICommandInfo info) throws BIOlapQueryException {
        IBIAxisDimension axisDimension = BICommandUtils.getAxisDimension((Dimension)dimension, (boolean)true, (BICommandInfo)info).axisDimension;
        IBIMemberReference numericExpression = info.queryFactory.getInputFactory().createMemberReference(measure);
        IBIRankingFilter rankingFilter = info.queryFactory.getMemberSetFactory().createRankingFilter(rankType, value, (IBIInputReference)numericExpression, joinType);
        BICommandUtils.addNoneSortStep((IBISetExpression)rankingFilter, axisDimension.getMemberSet().getMemberSetExpression(), info);
        return rankingFilter;
    }

    public static IBIConditionBasedFilter createConditionBasedFilter(Dimension dimension, double value, double upperValue, IBIMember measure, IBIRelationalOperatorType relationalOperator, IBIJoinType joinType, BICommandInfo info) throws BIOlapQueryException {
        IBIAxisDimension axisDimension = BICommandUtils.getAxisDimension((Dimension)dimension, (boolean)true, (BICommandInfo)info).axisDimension;
        IBIMemberReference leftExpression = null;
        IBILiteralReference rightExpression = null;
        IBIMemberReference betweenExpression = null;
        if (relationalOperator == IBIRelationalOperatorTypeEnum.BETWEEN) {
            leftExpression = info.queryFactory.getInputFactory().createLiteralReference(new Double(value));
            betweenExpression = info.queryFactory.getInputFactory().createMemberReference(measure);
            rightExpression = info.queryFactory.getInputFactory().createLiteralReference(new Double(upperValue));
        } else {
            leftExpression = info.queryFactory.getInputFactory().createMemberReference(measure);
            rightExpression = info.queryFactory.getInputFactory().createLiteralReference(new Double(value));
        }
        IBIConditionBasedFilter conditionBasedFilter = info.queryFactory.getMemberSetFactory().createConditionBasedFilter(relationalOperator, (IBIInputReference)leftExpression, (IBIInputReference)rightExpression, (IBIInputReference)betweenExpression, joinType);
        BICommandUtils.addNoneSortStep((IBISetExpression)conditionBasedFilter, axisDimension.getMemberSet().getMemberSetExpression(), info);
        return conditionBasedFilter;
    }

    public static IBISetExpression getLastNoneSortStep(List steps, BICommandInfo info) throws BIOlapQueryException {
        IBISetExpression setExpression = null;
        if (steps.size() > 0) {
            if (steps.get(steps.size() - 1) instanceof IBISort) {
                if (steps.size() > 1) {
                    setExpression = (IBISetExpression)steps.get(steps.size() - 2);
                }
            } else {
                setExpression = (IBISetExpression)steps.get(steps.size() - 1);
            }
        }
        return setExpression;
    }

    public static void addNoneSortStep(IBISetExpression setExpression, List steps, BICommandInfo info) throws BIOlapQueryException {
        if (steps.size() <= 0) {
            steps.add(setExpression);
        } else if (steps.get(steps.size() - 1) instanceof IBISort) {
            steps.add(steps.size() - 1, setExpression);
        } else {
            steps.add(setExpression);
        }
    }

    public static IBISort getSort(Dimension dimension, BICommandInfo info) throws BIOlapQueryException {
        IBIAxisDimension axisDimension = BICommandUtils.getAxisDimension((Dimension)dimension, (boolean)true, (BICommandInfo)info).axisDimension;
        List memberSetExpressions = axisDimension.getMemberSet().getMemberSetExpression();
        IBISort sort = null;
        if (memberSetExpressions.size() > 0 && memberSetExpressions.get(memberSetExpressions.size() - 1) instanceof IBISort) {
            sort = (IBISort)memberSetExpressions.get(memberSetExpressions.size() - 1);
        }
        return sort;
    }

    public static IBISort setSortStep(Dimension dimension, IBISortDirectionType sortDirection, boolean breakingHierarchy, IBIMember measure, Attribute attribute, BICommandInfo info) throws BIOlapQueryException {
        IBIAxisDimension axisDimension = BICommandUtils.getAxisDimension((Dimension)dimension, (boolean)true, (BICommandInfo)info).axisDimension;
        List memberSetExpressions = axisDimension.getMemberSet().getMemberSetExpression();
        IBISort sort = BICommandUtils.getSort(dimension, info);
        java.lang.Object expression = null;
        expression = measure != null ? info.queryFactory.getInputFactory().createMemberReference(measure) : info.queryFactory.getInputFactory().createAttributeReference(attribute);
        if (sort != null) {
            sort.setSortDirection(sortDirection);
            sort.setBreakingHierarchy(breakingHierarchy);
            sort.setExpression((IBIInputReference)expression);
        } else {
            sort = info.queryFactory.getMemberSetFactory().createSort((IBIInputReference)expression, sortDirection, breakingHierarchy);
            memberSetExpressions.add(sort);
        }
        return sort;
    }

    public static void setInitialState(BICommandInfo info) {
        final class AxisHandler {
            AxisHandler() {
            }

            final void handle(IBIAxis axis, List axisDimensions, List measuresAxisDimensions) {
                Iterator<E> i = axis.getAxisDimension().iterator();
                while (i.hasNext()) {
                    IBIAxisDimension axisDimension = (IBIAxisDimension)i.next();
                    axisDimension.getSelectedAttribute().clear();
                    axisDimension.getCalculatedMember().clear();
                    axisDimension.getMemberSet().getMemberSetExpression().clear();
                    axisDimension.getMemberSet().setDistinct(false);
                    axisDimension.getMemberSet().setHierarchized(false);
                    if (axisDimension.getDimension().isMeasure()) {
                        measuresAxisDimensions.add(axisDimension);
                        continue;
                    }
                    axisDimensions.add(axisDimension);
                }
                axis.getAxisDimension().clear();
                axis.getTupleSet().setDistinct(false);
                axis.getTupleSet().setHierarchized(false);
                axis.getTupleSet().getTupleSetExpression().clear();
            }
        }
        AxisHandler handler = new AxisHandler();
        ArrayList axisDimensions = new ArrayList();
        ArrayList measuresAxisDimensions = new ArrayList();
        Iterator i = info.query.getAxis().iterator();
        while (i.hasNext()) {
            IBIAxis axis = (IBIAxis)i.next();
            handler.handle(axis, axisDimensions, measuresAxisDimensions);
        }
        handler.handle(info.query.getSlicer(), axisDimensions, measuresAxisDimensions);
        Iterator i2 = axisDimensions.iterator();
        while (i2.hasNext()) {
            IBIAxisDimension axisDimension = (IBIAxisDimension)i2.next();
            info.query.getSlicer().getAxisDimension().add(axisDimension);
        }
        IBIAxisDimension measuresAxisDimension = (IBIAxisDimension)measuresAxisDimensions.get(0);
        IBIAxis columnsAxis = (IBIAxis)info.query.getAxis().get(0);
        columnsAxis.getAxisDimension().add(measuresAxisDimension);
    }

    public static void moveDimension(Dimension dimension, int axisIndex, int positionIndex, BICommandInfo info) throws BIOlapQueryException {
        AxisDimensionInfo axisDimensionInfo = BICommandUtils.getAxisDimension(dimension, true, info);
        IBIAxisDimension axisDimension = axisDimensionInfo.axisDimension;
        if (axisIndex < 0) {
            if (axisDimension.getAxis() != info.query.getSlicer()) {
                axisDimension.getAxis().getAxisDimension().remove(axisDimension);
                info.query.getSlicer().getAxisDimension().add(axisDimension);
            }
            return;
        }
        int axesCount = info.query.getAxis().size();
        if (axisIndex >= axesCount) {
            int i = 0;
            while (i < axisIndex - axesCount + 1) {
                IBIAxis axis = info.queryFactory.getMainFactory().createAxis(true, false, false);
                info.query.getAxis().add(axis);
                ++i;
            }
        }
        IBIAxis targetAxis = (IBIAxis)info.query.getAxis().get(axisIndex);
        int axisDimensionsCount = targetAxis.getAxisDimension().size();
        if (axisDimension.getAxis() != targetAxis) {
            axisDimension.getAxis().getTupleSet().getTupleSetExpression().clear();
            targetAxis.getTupleSet().getTupleSetExpression().clear();
            axisDimension.getAxis().getAxisDimension().remove(axisDimension);
        }
        if (axisDimension.getAxis() != targetAxis || positionIndex != axisDimensionInfo.positionIndex) {
            if (positionIndex < 0 || positionIndex >= axisDimensionsCount) {
                targetAxis.getAxisDimension().remove(axisDimension);
                targetAxis.getAxisDimension().add(axisDimension);
            } else {
                targetAxis.getAxisDimension().remove(axisDimension);
                targetAxis.getAxisDimension().add(positionIndex, axisDimension);
            }
        }
    }

    public static void clear(IBIAxis axis) {
        Iterator axisDimensionsIterator = axis.getAxisDimension().iterator();
        while (axisDimensionsIterator.hasNext()) {
            IBIAxisDimension axisDimension = (IBIAxisDimension)axisDimensionsIterator.next();
            axisDimension.getMemberSet().getMemberSetExpression().clear();
        }
        axis.getTupleSet().getTupleSetExpression().clear();
    }

    public static IBISetExpression getSetExpressionById(String id, BICommandInfo info) throws BIOlapQueryException {
        IBISetExpression setExpression = null;
        final class SetExpressionSearcher {
            SetExpressionSearcher() {
            }

            final IBISetExpression search(String id, List setExpressions) {
                Iterator<E> i = setExpressions.iterator();
                while (i.hasNext()) {
                    IBISetExpression nestedSetExpression;
                    IBISetExpression setExpression = (IBISetExpression)i.next();
                    if (setExpression.getId().equalsIgnoreCase(id)) {
                        return setExpression;
                    }
                    if (!(setExpression instanceof IBICompositeTupleSetExpression ? (nestedSetExpression = this.search(id, ((IBICompositeTupleSetExpression)setExpression).getTupleSetExpression())) != null : setExpression instanceof IBICompositeMemberSetExpression && (nestedSetExpression = this.search(id, ((IBICompositeMemberSetExpression)setExpression).getMemberSetExpression())) != null)) continue;
                    return nestedSetExpression;
                }
                return null;
            }
        }
        SetExpressionSearcher setExpressionSearcher = new SetExpressionSearcher();
        int i = 0;
        while (i < 2) {
            Iterator j = i == 0 ? null : info.query.getAxis().iterator();
            while (i == 0 ? true : j.hasNext()) {
                IBIAxis axis;
                IBIAxis iBIAxis = axis = i == 0 ? info.query.getSlicer() : (IBIAxis)j.next();
                if (axis != null) {
                    setExpression = setExpressionSearcher.search(id, axis.getTupleSet().getTupleSetExpression());
                    if (setExpression != null) {
                        return setExpression;
                    }
                    Iterator k = axis.getAxisDimension().iterator();
                    while (k.hasNext()) {
                        setExpression = setExpressionSearcher.search(id, ((IBIAxisDimension)k.next()).getMemberSet().getMemberSetExpression());
                        if (setExpression == null) continue;
                        return setExpression;
                    }
                }
                if (i == 0) break;
            }
            ++i;
        }
        throw new BIOlapQueryException(info.locale, "sdk.dac.olap.query_2002", new java.lang.Object[]{id, info.query.getId() != null ? info.query.getId() : "null"});
    }

    public static Slot getSlotForVariable(IBISapVariable variable, BICommandInfo info) throws BIOlapQueryException {
        String method = "getSlotForVariable(IBISapVariable, BICommandInfo)";
        assure.notNull("getSlotForVariable(IBISapVariable, BICommandInfo)", info.locale, (java.lang.Object)variable, (java.lang.Object)info);
        Slot foundSlot = null;
        Iterator i = info.query.getSapVariable().iterator();
        while (i.hasNext()) {
            Slot slot = (Slot)i.next();
            if (slot.getFeature() != variable) continue;
            foundSlot = slot;
            break;
        }
        if (foundSlot == null) {
            BIOlapQueryException exception = new BIOlapQueryException(info.locale, "sdk.dac.olap.query_4001", new java.lang.Object[]{variable.getName(), info.query.getLabel()});
            category.errorT(location, exception.getLocalizedMessage());
            throw exception;
        }
        return foundSlot;
    }

    public static Instance getVariableValue(IBISapVariable variable, BICommandInfo info) throws BIOlapQueryException {
        Slot foundSlot = BICommandUtils.getSlotForVariable(variable, info);
        if (variable.getSelectionType() == IBISapVariableSelectionTypeEnum.COMPLEX) {
            if (!(foundSlot.getValue() instanceof Object)) {
                foundSlot.setValue((Instance)info.queryPackages.instancePackage.getObject().createObject());
            }
        } else if (variable instanceof IBISapHierarchyVariable) {
            if (!(foundSlot.getValue() instanceof IBISapHierarchyValue)) {
                foundSlot.setValue((Instance)info.queryPackages.queryVarPackage.getIBISapHierarchyValue().createIBISapHierarchyValue());
            }
        } else if (variable instanceof IBISapMemberVariable) {
            if (!(foundSlot.getValue() instanceof IBISapMemberValueRange)) {
                foundSlot.setValue((Instance)info.queryPackages.queryVarPackage.getIBISapMemberValueRange().createIBISapMemberValueRange());
            }
        } else if (variable instanceof IBISapNumericVariable && !(foundSlot.getValue() instanceof IBISapNumericValueRange)) {
            foundSlot.setValue((Instance)info.queryPackages.queryVarPackage.getIBISapNumericValueRange().createIBISapNumericValueRange());
        }
        return foundSlot.getValue();
    }

    public static Slot createAndAddSlot(IBISapVariable variable, IBISapVariableValue value, Object object, BICommandInfo info) {
        Slot slot = info.queryPackages.instancePackage.getSlot().createSlot();
        slot.setFeature((StructuralFeature)variable);
        slot.setValue((Instance)value);
        object.getSlot().add(slot);
        return slot;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static final class AxisDimensionInfo {
        public IBIAxisDimension axisDimension = null;
        public Dimension dimension = null;
        public int axisIndex = 0;
        public int positionIndex = 0;
    }
}

