/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xsl.xslt.output;

import com.sap.engine.lib.xml.parser.helpers.CharArray;
import com.sap.engine.lib.xml.parser.helpers.Entity;
import com.sap.engine.lib.xsl.xslt.output.Method;
import com.sap.engine.lib.xsl.xslt.output.OutputException;
import com.sap.engine.lib.xsl.xslt.output.Tools;
import java.util.HashSet;

final class MethodXML
extends Method {
    private boolean isInCDATASection;
    private HashSet cDataSectionElements;
    private boolean cDataSectionElementsEmpty;
    private boolean hasDTDEntity;

    MethodXML() {
    }

    void startDocument(String omit, String version, String encoding, String standalone) throws OutputException {
        if (encoding.equalsIgnoreCase("utf-16")) {
            this.encoder.outDirect('\u00ff');
            this.encoder.outDirect('\u00fe');
        } else if (encoding.equalsIgnoreCase("utf-16be")) {
            this.encoder.outDirect('\u00fe');
            this.encoder.outDirect('\u00ff');
        }
        if (!Tools.isYes(omit)) {
            if (Tools.notEmpty(version) && !version.equals("1.0")) {
                version = "1.0";
            }
            this.encoder.out("<?xml version=\"1.0\"");
            if (Tools.notEmpty(encoding)) {
                this.encoder.out(" encoding=\"");
                this.encoder.out(this.owner.getEncoder().getEncodingName());
                this.encoder.out('\"');
            }
            this.encoder.out("?>\n");
        }
        this.isInCDATASection = false;
        this.cDataSectionElements = this.owner.getCDataSectionElements();
        this.cDataSectionElementsEmpty = this.cDataSectionElements.isEmpty();
    }

    void endDocument() throws OutputException {
    }

    void startElement0(CharArray uri, CharArray localName, CharArray qName) throws OutputException {
        this.encoder.out('<');
        this.encoder.out(qName);
        if (!this.cDataSectionElementsEmpty && this.cDataSectionElements.contains(qName.getString())) {
            this.isInCDATASection = true;
        }
    }

    void attribute(CharArray uri, CharArray localName, CharArray qName, CharArray value) throws OutputException {
        this.encoder.out(' ');
        this.encoder.out(qName);
        this.encoder.out("=\"");
        this.encoder.outAttribute(value, '\"');
        this.encoder.out('\"');
    }

    void startElement1(boolean isEmpty) throws OutputException {
        if (isEmpty) {
            this.encoder.out("/>");
            this.isInCDATASection = false;
        } else {
            this.encoder.out('>');
        }
    }

    void endElement(CharArray uri, CharArray localName, CharArray qName, boolean isEmpty) throws OutputException {
        if (!isEmpty) {
            this.encoder.out("</").out(qName).out('>');
            if (!this.cDataSectionElementsEmpty && this.cDataSectionElements.contains(qName.getString())) {
                this.isInCDATASection = false;
            }
        }
    }

    void processingInstruction(CharArray target, CharArray data) throws OutputException {
        if (data.length() == 0) {
            this.encoder.out("<?").out(target).out("?>");
        } else {
            this.encoder.out("<?");
            this.encoder.out(target);
            this.encoder.out(' ');
            this.encoder.out(data);
            this.encoder.out("?>");
        }
    }

    void startCDATA() throws OutputException {
        this.isInCDATASection = true;
    }

    void endCDATA() throws OutputException {
        this.isInCDATASection = false;
    }

    void startDTD(String name, String publicId, String systemId) throws OutputException {
        this.encoder.out("<!DOCTYPE ").out(name);
        if (Tools.notEmpty(publicId)) {
            this.encoder.out(" PUBLIC '").out(publicId).out("' '").out(systemId).out('\'');
        } else if (Tools.notEmpty(systemId)) {
            this.encoder.out(" SYSTEM '").out(systemId).out('\'');
        }
        this.hasDTDEntity = false;
    }

    void endDTD() throws OutputException {
        if (this.hasDTDEntity) {
            this.encoder.out("]>").outln();
        } else {
            this.encoder.out(">").outln();
        }
    }

    void characters(char[] ch, int start, int length) throws OutputException {
        if (this.isInCDATASection) {
            this.encoder.outCDATA(ch, start, length);
        } else {
            this.encoder.outEscaped(ch, start, length);
        }
    }

    void comment(char[] ch, int start, int length) throws OutputException {
        this.encoder.out("<!--").out(ch, start, length).out("-->");
    }

    void onDTDEntity(Entity ent) throws OutputException {
        if (!this.hasDTDEntity) {
            this.encoder.out(" [\n");
            this.hasDTDEntity = true;
        }
        this.encoder.out("<!ENTITY ").out(ent.getName());
        if (ent.isInternal()) {
            try {
                this.encoder.out(" \"").out(ent.getValue()).out("\">\n");
            }
            catch (Exception e) {
                throw new OutputException(e);
            }
        } else {
            if (ent.getPub().length() > 0) {
                this.encoder.out(" PUBLIC '").out(ent.getPub()).out("' '").out(ent.getSys()).out('\'');
            } else if (ent.getSys().length() > 0) {
                this.encoder.out(" SYSTEM '").out(ent.getSys()).out('\'');
            }
            this.encoder.out(">\n");
        }
    }
}

