/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xsl.xslt.output;

import com.sap.engine.lib.xml.parser.helpers.CharArray;
import com.sap.engine.lib.xml.signature.SignatureContext;
import com.sap.engine.lib.xsl.xslt.output.AttributeRepr;
import com.sap.engine.lib.xsl.xslt.output.CanonicalDocHandlerSerializer;
import com.sap.engine.lib.xsl.xslt.output.OutputException;
import com.sap.engine.lib.xsl.xslt.output.SortableVector;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.TreeMap;

public class ExclusiveCanonicalDocHandlerSerializer
extends CanonicalDocHandlerSerializer {
    protected String[] inclusiveNamespaces = null;
    protected TreeMap usedNamespaces = new TreeMap();
    protected Hashtable currentNamespaces = null;
    protected Hashtable namespacesInScope = null;

    public void init() {
        super.init();
        this.inclusiveNamespaces = null;
    }

    public void init(OutputStream stream, Properties prop) throws OutputException {
        super.init(stream, prop);
        this.inclusiveNamespaces = null;
    }

    public void init(String[] inclusiveNamespaces) {
        super.init();
        this.inclusiveNamespaces = inclusiveNamespaces;
    }

    public void init(OutputStream stream, Properties prop, String[] inclusiveNamespaces, Hashtable namespacesInScope) throws OutputException {
        super.init(stream, prop);
        this.inclusiveNamespaces = inclusiveNamespaces;
        this.namespacesInScope = namespacesInScope;
    }

    public void startElementStart(CharArray uri, CharArray localName, CharArray qName) throws Exception {
        int i;
        super.startElementStart(uri, localName, qName);
        this.usedNamespaces.clear();
        if (this.namespacesInScope != null && this.inclusiveNamespaces != null) {
            i = 0;
            while (i < this.inclusiveNamespaces.length) {
                if (this.namespacesInScope.containsKey(this.inclusiveNamespaces[i])) {
                    this.usedNamespaces.put(this.inclusiveNamespaces[i], this.namespacesInScope.get(this.inclusiveNamespaces[i]));
                }
                ++i;
            }
            this.namespacesInScope = null;
        }
        i = qName.indexOf(':');
        Hashtable hashtable = this.currentNamespaces = this.namespacesStack.isEmpty() ? SignatureContext.EMPTY : (Hashtable)this.namespacesStack.peek();
        if (i != -1) {
            String temp = qName.toString().substring(0, i);
            String tempuri = (String)this.currentNamespaces.get(temp);
            if (!SignatureContext.equals(tempuri, uri.getString())) {
                this.usedNamespaces.put(temp, uri.getString());
            }
        } else {
            String tempuri = (String)this.currentNamespaces.get(SignatureContext.DEFAULT_STR);
            if (!SignatureContext.equals(tempuri, uri.getString())) {
                this.usedNamespaces.put(SignatureContext.DEFAULT_STR, uri.getString());
            }
        }
    }

    public void startElementEnd(boolean b) throws Exception {
        Iterator enum1;
        if (this.currentAttribs != null && this.currentAttribs.size() > 0) {
            int length = this.currentAttribs.size();
            int i = 0;
            while (i < length) {
                String tempuri;
                AttributeRepr a = (AttributeRepr)this.currentAttribs.elementAt(i);
                CharArray namespaceDecl = SignatureContext.getNamespaceDeclaration(a.prefix, a.localName);
                if (namespaceDecl == null) {
                    if (a.prefix != null && a.prefix.length() != 0 && !SignatureContext.equals(tempuri = (String)this.currentNamespaces.get(a.prefix.toString()), a.uri)) {
                        this.usedNamespaces.put(a.prefix.toString(), a.uri == null ? "" : a.uri);
                    }
                } else if (!SignatureContext.XMLNS.equals(a.prefix) && !SignatureContext.equals(tempuri = (String)this.currentNamespaces.get(namespaceDecl.toString()), a.uri)) {
                    this.usedNamespaces.put(namespaceDecl.toString(), a.uri == null ? "" : a.uri);
                }
                ++i;
            }
            this.currentAttribs.ensureCapacity(this.currentAttribs.size() + this.usedNamespaces.size());
            Iterator enum12 = this.usedNamespaces.keySet().iterator();
            if (enum12.hasNext()) {
                this.currentNamespaces = (Hashtable)this.currentNamespaces.clone();
                while (enum12.hasNext()) {
                    String name = (String)enum12.next();
                    String uri = (String)this.usedNamespaces.get(name);
                    AttributeRepr rep = null;
                    if (SignatureContext.XML.equals(name) && "http://www.w3.org/XML/1998/namespace".equals(uri)) continue;
                    if (SignatureContext.DEFAULT.equals(name)) {
                        rep = new AttributeRepr(null, SignatureContext.XMLNS, SignatureContext.XMLNS, this.copyCharArray(uri));
                    } else {
                        CharArray qname = new CharArray(10, 6 + name.length());
                        qname.append(SignatureContext.XMLNS);
                        qname.append(':');
                        qname.append(name);
                        rep = new AttributeRepr(null, this.copyCharArray(name), qname, this.copyCharArray(uri));
                    }
                    this.currentAttribs.addElement(rep);
                    this.currentNamespaces.put(name.toString(), uri);
                }
            }
            this.currentAttribs.sort((Comparator)SignatureContext.ac);
            length = this.currentAttribs.size();
            int i2 = 0;
            while (i2 < length) {
                AttributeRepr a = (AttributeRepr)this.currentAttribs.elementAt(i2);
                this.indenter.attribute(this.copyCharArray(a.uri), a.localName, a.qname, a.value);
                ++i2;
            }
            this.currentAttribs.clear();
        } else if (this.usedNamespaces.size() > 0 && (enum1 = this.usedNamespaces.keySet().iterator()).hasNext()) {
            this.currentNamespaces = (Hashtable)this.currentNamespaces.clone();
            while (enum1.hasNext()) {
                String name = (String)enum1.next();
                String uri = (String)this.usedNamespaces.get(name);
                if (SignatureContext.DEFAULT.equals(name)) {
                    this.indenter.attribute(null, SignatureContext.XMLNS, SignatureContext.XMLNS, this.copyCharArray(uri));
                } else {
                    CharArray qname = new CharArray(10, 6 + name.length());
                    qname.append(SignatureContext.XMLNS);
                    qname.append(':');
                    qname.append(name);
                    this.indenter.attribute(null, this.copyCharArray(name), qname, this.copyCharArray(uri));
                }
                this.currentNamespaces.put(name.toString(), uri);
            }
        }
        this.namespacesStack.push(this.currentNamespaces);
        this.indenter.startElement1(false);
    }

    public void addAttribute(CharArray uri, CharArray prefix, CharArray localName, CharArray qname, String type, CharArray value) throws Exception {
        CharArray namespaceDecl = SignatureContext.getNamespaceDeclaration(prefix, localName);
        if (namespaceDecl != null) {
            String tempuri;
            if (this.isInclusive(namespaceDecl) && !SignatureContext.equals(tempuri = (String)this.currentNamespaces.get(namespaceDecl.toString()), value.toString())) {
                this.usedNamespaces.put(namespaceDecl.toString(), value.toString());
            }
            return;
        }
        AttributeRepr toAdd = this.getAttribRepr(uri, localName, qname, value);
        if (this.currentAttribs == null) {
            this.currentAttribs = new SortableVector(3, 5);
        }
        this.currentAttribs.add(toAdd);
    }

    protected boolean isInclusive(CharArray name) {
        return this.inclusiveNamespaces != null && Arrays.binarySearch(this.inclusiveNamespaces, name.toString()) >= 0;
    }

    public void release() {
        super.release();
        this.currentNamespaces = null;
        this.usedNamespaces.clear();
    }
}

