/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xsl.xslt;

import com.sap.engine.lib.xml.parser.helpers.CharArray;
import com.sap.engine.lib.xsl.xpath.XPathContext;
import com.sap.engine.lib.xsl.xpath.XPathException;
import com.sap.engine.lib.xsl.xslt.AttributeValueTemplateHandler;
import com.sap.engine.lib.xsl.xslt.InternalAttributeList;
import com.sap.engine.lib.xsl.xslt.QName;
import com.sap.engine.lib.xsl.xslt.XSLAttribute;
import com.sap.engine.lib.xsl.xslt.XSLAttributeSet;
import com.sap.engine.lib.xsl.xslt.XSLContentNode;
import com.sap.engine.lib.xsl.xslt.XSLException;
import com.sap.engine.lib.xsl.xslt.XSLNode;
import com.sap.engine.lib.xsl.xslt.XSLStylesheet;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public final class XSLElement
extends XSLContentNode {
    private CharArray name = new CharArray(15);
    private CharArray namespace = new CharArray(30);
    private Vector attributeSets = new Vector();
    private InternalAttributeList attImpl = new InternalAttributeList();
    private Vector attrs = null;
    private boolean isXSLElement = false;
    private AttributeValueTemplateHandler nameTemplate = new AttributeValueTemplateHandler();
    private AttributeValueTemplateHandler namespaceTemplate = new AttributeValueTemplateHandler();
    public static final String[] REQPAR = new String[]{"name"};
    public static final String[] OPTPAR = new String[]{"namespace", "use-attribute-sets"};

    public XSLElement(XSLStylesheet owner, XSLNode parent) throws XSLException {
        super(owner, parent);
    }

    public XSLElement(XSLStylesheet owner, XSLNode parent, Element el) throws XSLException {
        super(owner, parent, el);
        String useAttributeSets;
        this.attrs = new Vector();
        String prefix = el.getPrefix();
        String namespaceUriStr = el.getNamespaceURI();
        if (prefix == null) {
            prefix = "";
        }
        if (namespaceUriStr == null) {
            namespaceUriStr = "";
        }
        if (owner.getNamespaceAliases().get(prefix) != null) {
            String prf = (String)owner.getNamespaceAliases().get(prefix);
            this.name.clear();
            this.name.append(prf);
            this.name.append(':');
            this.name.append(el.getLocalName());
            this.namespace.set(owner.getNamespaceHandler().get(new CharArray(prf)));
        } else {
            this.name.set(el.getNodeName());
            this.name.trim();
            this.namespace.set(namespaceUriStr);
            this.namespace.trim();
            if (el.getNamespaceURI() != null && el.getNamespaceURI().equals("http://www.w3.org/1999/XSL/Transform") && el.getLocalName().equals("element")) {
                this.name.set(el.getAttribute("name"));
                this.name.trim();
                if (el.getAttribute("namespace").length() > 0) {
                    this.namespace.set(el.getAttribute("namespace"));
                    this.namespace.trim();
                } else {
                    CharArray defaultNS = owner.getNamespaceHandler().getDefault();
                    if (defaultNS != null) {
                        this.namespace.set(defaultNS);
                    } else {
                        this.namespace.clear();
                    }
                }
                this.isXSLElement = true;
            }
        }
        this.nameTemplate.init(this.name, owner.etBuilder);
        this.namespaceTemplate.init(this.namespace, owner.etBuilder);
        if (this.nameTemplate.countTokens() == 1 && this.name.indexOf(':') > -1) {
            String sname = this.name.toString();
            String prf = sname.substring(0, sname.indexOf(58));
            if (this.namespaceTemplate.countTokens() == 0) {
                this.namespaceTemplate.init(owner.getNamespaceHandler().get(new CharArray(prf)), owner.etBuilder);
            }
        }
        if (!this.isXSLElement) {
            NamedNodeMap elatt = el.getAttributes();
            XSLAttribute xsattr = null;
            int i = 0;
            while (i < elatt.getLength()) {
                Attr at = (Attr)elatt.item(i);
                xsattr = new XSLAttribute(owner, this, at.getNamespaceURI(), at.getName(), at.getValue());
                xsattr.setProcessByElement();
                this.attrs.add(xsattr);
                ++i;
            }
        }
        if ((useAttributeSets = el.getAttribute("use-attribute-sets")) != null && useAttributeSets.length() > 0) {
            StringTokenizer tok = new StringTokenizer(useAttributeSets, " \n\r\t");
            while (tok.hasMoreElements()) {
                String setName = tok.nextToken();
                XSLAttributeSet set = owner.getAttributeSet(setName);
                if (set == null) {
                    throw new XSLException("Cannot find attribute set with name: " + setName + ", xsl: " + owner.getBaseURI());
                }
                this.attributeSets.add(set);
            }
        }
        int i = 0;
        while (i < this.attributeSets.size()) {
            XSLAttributeSet xslattrset = (XSLAttributeSet)this.attributeSets.get(i);
            Vector v = xslattrset.getAttributes();
            int j = 0;
            while (j < v.size()) {
                XSLAttribute xslattr = (XSLAttribute)v.get(j);
                xslattr.setProcessByElement();
                int b = this.findXSLAttribute(this.attrs, xslattr);
                if (b > -1) {
                    this.attrs.set(b, xslattr);
                } else {
                    this.attrs.add(xslattr);
                }
                ++j;
            }
            ++i;
        }
    }

    public void process(XPathContext xcont, int node) throws XSLException, XPathException {
        this.owner.getOutputProcessor().startElement0();
        CharArray instName = this.owner.crPoolXSLElement.getObject().reuse();
        CharArray instPrefName = this.owner.crPoolXSLElement.getObject().reuse();
        this.nameTemplate.processTo(instName, this.owner.getXPathProcessor(), xcont, this.varContext);
        this.namespaceTemplate.processTo(this.namespace, this.owner.getXPathProcessor(), xcont, this.varContext);
        XSLAttribute xsatt = null;
        this.attImpl.clear();
        int i = 0;
        while (i < this.attrs.size()) {
            xsatt = (XSLAttribute)this.attrs.get(i);
            xsatt.processStart();
            xsatt.process(xcont, node);
            xsatt.processEnd();
            QName q = xsatt.getQName();
            this.attImpl.addAttribute(q.uri, q.prefix, q.rawname, q.localname, xsatt.getValue());
            ++i;
        }
        instPrefName.substring(instName, instName.indexOf(':') + 1);
        this.owner.getOutputProcessor().startElement(this.namespace, instPrefName, instName, this.attImpl);
        this.processFromFirst(xcont, node);
        this.owner.getOutputProcessor().endElement(this.namespace, instPrefName, instName);
        this.owner.crPoolXSLElement.releaseObject(instPrefName);
        this.owner.crPoolXSLElement.releaseObject(instName);
    }

    public void print(String ind) {
        System.out.println(ind + "#XSLElement: name = " + this.name);
        XSLAttribute xsatt = null;
        int i = 0;
        while (i < this.attrs.size()) {
            xsatt = (XSLAttribute)this.attrs.get(i);
            xsatt.print(ind + "  ");
            ++i;
        }
        if (this.getFirst() != null) {
            this.getFirst().print(ind + "  ");
        }
        if (this.getNext() != null) {
            this.getNext().print(ind);
        }
    }

    public Vector getAttributes() {
        return this.attrs;
    }

    public String[] getRequiredParams() {
        return REQPAR;
    }

    public String[] getOptionalParams() {
        return OPTPAR;
    }

    public XSLNode changeOwner(XSLStylesheet newOwner) {
        super.changeOwner(newOwner);
        if (this.attrs != null) {
            int i = 0;
            while (i < this.attrs.size()) {
                ((XSLNode)this.attrs.get(i)).changeOwner(newOwner);
                ++i;
            }
        }
        return this;
    }
}

