/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xsl.xpath.xobjects;

import com.sap.engine.lib.xml.parser.helpers.CharArray;
import com.sap.engine.lib.xsl.xpath.ETItem;
import com.sap.engine.lib.xsl.xpath.Symbols;
import com.sap.engine.lib.xsl.xpath.XFunction;
import com.sap.engine.lib.xsl.xpath.XPathContext;
import com.sap.engine.lib.xsl.xpath.XPathException;
import com.sap.engine.lib.xsl.xpath.xobjects.XBoolean;
import com.sap.engine.lib.xsl.xpath.xobjects.XNodeSet;
import com.sap.engine.lib.xsl.xpath.xobjects.XNumber;
import com.sap.engine.lib.xsl.xpath.xobjects.XObject;

public final class XString
extends XObject
implements ETItem,
XFunction {
    public static final int TYPE = 2;
    protected CharArray value = new CharArray(20);

    public int getType() {
        return 2;
    }

    public CharArray getValue() {
        return this.value;
    }

    protected XString reuse() {
        this.value.clear();
        return this;
    }

    protected XString reuse(String v) {
        this.value.set(v);
        return this;
    }

    protected XString reuse(CharArray v, int b, int e) {
        this.value.set(v, b, e);
        return this;
    }

    protected XString reuse(CharArray v) {
        this.value.set(v);
        return this;
    }

    protected XString reuse(XNumber xn) {
        if (Double.isNaN(xn.value)) {
            this.value.set("NaN");
            return this;
        }
        if (xn.value == 0.0 || xn.value == -0.0) {
            this.value.set("0");
            return this;
        }
        if (xn.value == Double.POSITIVE_INFINITY) {
            this.value.set("Infinity");
            return this;
        }
        if (xn.value == Double.NEGATIVE_INFINITY) {
            this.value.set("-Infinity");
            return this;
        }
        if (xn.value == (double)((int)xn.value)) {
            this.factory.staticInteger.intToCharArray((int)xn.value, this.value);
        } else {
            this.factory.staticDouble.doubleToString(xn.value, this.value);
        }
        return this;
    }

    protected XString reuse(XBoolean xb) {
        this.value.set(xb.value ? "true" : "false");
        return this;
    }

    protected XString reuse(XNodeSet xns) {
        xns.stringValue(this.value);
        return this;
    }

    protected XString reuseFull(XNodeSet xns) {
        CharArray v = xns.fullStringValue();
        if (v == null) {
            v = CharArray.EMPTY;
        }
        this.value.set(v);
        return this;
    }

    public XNumber toXNumber() throws XPathException {
        return this.factory.getXNumber(this);
    }

    public XString toXString() throws XPathException {
        return this;
    }

    public XBoolean toXBoolean() throws XPathException {
        return this.factory.getXBoolean(this);
    }

    public XObject evaluate(XPathContext context) {
        return this;
    }

    public void print(int indent) {
        Symbols.printSpace(indent);
        System.out.println("XString(" + this.value + ")");
    }

    public XObject execute(XObject[] a, XPathContext context) throws XPathException {
        if (a.length == 0) {
            return context.getXFactCurrent().getXString(context.dtm.getStringValue(context.node));
        }
        return a[0].toXString();
    }

    public boolean confirmArgumentTypes(XObject[] a) {
        return a.length <= 1;
    }

    public String getFunctionName() {
        return "string";
    }

    public String toString() {
        return this.value.getString();
    }

    public boolean match(XPathContext c) throws XPathException {
        throw new XPathException(this.getClass() + " cannot be matched.");
    }

    public boolean equals(Object o) {
        if (!(o instanceof XString)) {
            return false;
        }
        XString x = (XString)o;
        return x.value.equals(this.value);
    }
}

