/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xsl.xpath.xobjects;

import com.sap.engine.lib.xml.parser.helpers.CharArray;
import com.sap.engine.lib.xsl.xpath.ETItem;
import com.sap.engine.lib.xsl.xpath.Symbols;
import com.sap.engine.lib.xsl.xpath.XFunction;
import com.sap.engine.lib.xsl.xpath.XPathContext;
import com.sap.engine.lib.xsl.xpath.XPathException;
import com.sap.engine.lib.xsl.xpath.xobjects.XBoolean;
import com.sap.engine.lib.xsl.xpath.xobjects.XNodeSet;
import com.sap.engine.lib.xsl.xpath.xobjects.XObject;
import com.sap.engine.lib.xsl.xpath.xobjects.XObjectFactory;
import com.sap.engine.lib.xsl.xpath.xobjects.XString;

public final class XNumber
extends XObject
implements ETItem,
XFunction {
    public static final int TYPE = 1;
    protected double value;

    public int getType() {
        return 1;
    }

    public double getValue() {
        return this.value;
    }

    protected XNumber reuse() {
        this.value = Double.NaN;
        return this;
    }

    protected XNumber reuse(double v) {
        this.value = v;
        return this;
    }

    protected XNumber reuse(XNumber xn) {
        this.value = xn.value;
        return this;
    }

    private void initWithCharArray(CharArray ca) {
        if (ca == null) {
            this.value = Double.NaN;
        } else {
            try {
                this.value = this.factory.staticDouble.stringToDouble(ca);
            }
            catch (NumberFormatException e) {
                this.value = Double.NaN;
            }
        }
    }

    private void initWithXString(XString xs) {
        this.initWithCharArray(xs.value);
    }

    public XNumber reuse(XString xs) {
        this.initWithXString(xs);
        return this;
    }

    public XNumber reuse(XBoolean xb) {
        this.value = xb.value ? 1.0 : 0.0;
        return this;
    }

    public XNumber reuse(XNodeSet xns) {
        this.initWithCharArray(xns.stringValue());
        return this;
    }

    public XNumber toXNumber() {
        return this;
    }

    public XString toXString() {
        return this.factory.getXString(this);
    }

    public XBoolean toXBoolean() {
        return this.factory.getXBoolean(this);
    }

    public XObject evaluate(XPathContext context) {
        return this;
    }

    public void print(int indent) {
        Symbols.printSpace(indent);
        System.out.println("XNumber(" + this.value + ")");
    }

    public XObject execute(XObject[] a, XPathContext context) throws XPathException {
        if (a.length == 0) {
            XObjectFactory f = context.getXFactCurrent();
            return f.getXNumber(f.getXString(context.dtm.getStringValue(context.node)));
        }
        return a[0].toXNumber();
    }

    public boolean confirmArgumentTypes(XObject[] a) {
        return a.length <= 1;
    }

    public String getFunctionName() {
        return "number";
    }

    public boolean match(XPathContext c) throws XPathException {
        throw new XPathException(this.getClass() + " cannot be matched.");
    }

    public String toString() {
        return Double.toString(this.value);
    }
}

