/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xsl.xpath.functions;

import com.sap.engine.lib.xsl.xpath.DTMFactory;
import com.sap.engine.lib.xsl.xpath.XFunction;
import com.sap.engine.lib.xsl.xpath.XPathContext;
import com.sap.engine.lib.xsl.xpath.XPathException;
import com.sap.engine.lib.xsl.xpath.xobjects.XNodeSet;
import com.sap.engine.lib.xsl.xpath.xobjects.XObject;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;

public final class XFDocument
implements XFunction {
    public boolean confirmArgumentTypes(XObject[] a) {
        return a.length == 1 || a.length == 2;
    }

    public XObject execute(XObject[] a, XPathContext context) throws XPathException {
        XNodeSet r = context.getXFactCurrent().getXNodeSet(context.dtm);
        r.clear();
        String s = a[0].toXString().getValue().getString();
        Integer x = (Integer)context.dtm.xfDocumentCache.get(s);
        String base = null;
        base = a.length == 1 ? (context.currentNode != null && context.currentNode.realBaseURI != null ? context.currentNode.realBaseURI : context.owner.getBaseURI()) : context.owner.getSourceBaseURI();
        if (x != null) {
            r.add(x);
        } else {
            Source source = null;
            try {
                Source ss;
                DOMSource ds;
                source = context.owner.getURIResolver().resolve(s, base);
                if (source == null) {
                    source = context.owner.getDefaultResolver().resolve(s, base);
                }
                if (source != null && source.getSystemId() == null && s != null) {
                    source.setSystemId(s);
                }
                if (source == null) {
                    return r;
                }
                if (source instanceof DOMSource ? (ds = (DOMSource)source).getNode() == null || ds.getNode() instanceof Document && ds.getNode().getChildNodes().getLength() == 0 : (source instanceof StreamSource ? ((StreamSource)(ss = (StreamSource)source)).getInputStream() == null && ((StreamSource)ss).getReader() == null && ((StreamSource)ss).getSystemId() == null : source instanceof SAXSource && ((SAXSource)(ss = (SAXSource)source)).getInputSource() == null && ((SAXSource)ss).getXMLReader() == null && ((SAXSource)ss).getSystemId() == null)) {
                    return r;
                }
            }
            catch (Exception e) {
                try {
                    context.owner.sendWarning("Exception while loading External XMLSource in 'document': " + e);
                    return r;
                }
                catch (Exception ez) {
                    throw new XPathException("Exception while sending warning. in 'document' - function", e);
                }
            }
            DTMFactory dtmfact = context.owner.getDTMFactory();
            dtmfact.setDTM(context.dtm);
            int index = dtmfact.appendDocument(context.dtm, source);
            r.add(index);
            context.dtm.xfDocumentCache.put(s, new Integer(index));
        }
        return r;
    }

    public String getFunctionName() {
        return "document";
    }
}

