/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xsl.xpath;

import com.sap.engine.lib.xml.parser.handlers.NamespaceHandler;
import com.sap.engine.lib.xml.parser.helpers.CharArray;
import com.sap.engine.lib.xsl.xpath.DTM;
import com.sap.engine.lib.xsl.xpath.DTMFactory;
import com.sap.engine.lib.xsl.xpath.ETBuilder;
import com.sap.engine.lib.xsl.xpath.XPathContext;
import com.sap.engine.lib.xsl.xpath.XPathException;
import com.sap.engine.lib.xsl.xpath.XPathProcessor;
import com.sap.engine.lib.xsl.xpath.xobjects.XNodeSet;
import com.sap.engine.lib.xsl.xpath.xobjects.XObject;
import com.sap.engine.lib.xsl.xslt.NamespaceManager;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class XPathMatcher {
    protected XPathProcessor xpp = null;
    protected XPathContext xpc = null;
    protected ETBuilder builder = new ETBuilder();
    protected DTM dtm = new DTM();
    protected DTMFactory dtmfact = new DTMFactory();
    protected NamespaceHandler nshandler = null;
    protected NamespaceManager nsmanager = null;

    public XPathMatcher(String file) throws FileNotFoundException, XPathException {
        this.init(file);
    }

    public XPathMatcher(InputStream in) throws FileNotFoundException, XPathException {
        this.init(in);
    }

    public void init(String file) throws FileNotFoundException, XPathException {
        this.nshandler = new NamespaceHandler(null);
        this.nsmanager = new NamespaceManager();
        this.builder.setNamespaceStuff(this.nsmanager, this.nshandler);
        this.dtmfact.initialize(this.dtm, new NamespaceManager(), file);
        this.xpp = new XPathProcessor(this.dtm);
        this.xpc = this.dtm.getInitialContext();
    }

    public void init(InputStream in) throws XPathException {
        this.nshandler = new NamespaceHandler(null);
        this.nsmanager = new NamespaceManager();
        this.builder.setNamespaceStuff(this.nsmanager, this.nshandler);
        this.dtmfact.initialize(this.dtm, new NamespaceManager(), in);
        this.xpp = new XPathProcessor(this.dtm);
        this.xpc = this.dtm.getInitialContext();
    }

    public XObject process(String query) throws XPathException {
        return this.xpp.process(this.builder.process(query), this.xpc);
    }

    public boolean match(String query) throws XPathException {
        return this.process(query).toXBoolean().getValue();
    }

    public void printET(String query) throws Exception {
        this.builder.process(query).print();
    }

    public void setContext(String query) throws XPathException {
        XNodeSet xns = (XNodeSet)this.xpp.process(this.builder.process(query), this.xpc);
        this.xpc.node = xns.firstInDocumentOrder();
    }

    public void setContextNode(int node) {
        this.xpc.node = node;
    }

    public void setContextSize(int size) {
        this.xpc.size = size;
    }

    public void setContextPosition(int pos) {
        this.xpc.position = pos;
    }

    public void addPrefixMapping(String prefix, String uri) {
        this.nshandler.add(new CharArray(prefix), new CharArray(uri));
    }

    public static void main(String[] args) throws Exception {
        XPathMatcher m = new XPathMatcher("c:/develop/xml2000/bugs/2001.05.04c/input.xml");
        m.addPrefixMapping("cpx", "urn:sap-com:ifr:cp");
        System.out.println("" + m.process("/cpx:storedData"));
    }
}

