/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xsl.xpath;

import com.sap.engine.lib.xsl.xpath.ETItem;
import com.sap.engine.lib.xsl.xpath.Symbols;
import com.sap.engine.lib.xsl.xpath.XPathContext;
import com.sap.engine.lib.xsl.xpath.XPathException;
import com.sap.engine.lib.xsl.xpath.xobjects.XObject;

public final class ETVariableReference
implements ETItem {
    protected String name;

    protected ETVariableReference(String name) {
        this.name = name;
    }

    public void print(int indent) {
        Symbols.printSpace(indent);
        System.out.println("ETVariableReference($" + this.name + ")");
    }

    public XObject evaluate(XPathContext context) throws XPathException {
        XObject r = null;
        try {
            r = context.variableBindings.get(this.name);
        }
        catch (ClassCastException e) {
            throw new XPathException("Variable '$" + this.name + "' has not been bound to an XObject, but to a " + r.getClass());
        }
        if (r == null) {
            throw new XPathException("Variable '$" + this.name + "' has not been bound to a value");
        }
        return r;
    }

    public boolean match(XPathContext c) throws XPathException {
        throw new XPathException("Cannot match a variable reference in a Template Match Pattern");
    }

    public boolean equals() {
        return false;
    }
}

