/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xsl.xpath;

import com.sap.engine.lib.xml.parser.helpers.CharArray;
import com.sap.engine.lib.xsl.xpath.ETItem;
import com.sap.engine.lib.xsl.xpath.Symbols;
import com.sap.engine.lib.xsl.xpath.XPathContext;
import com.sap.engine.lib.xsl.xpath.XPathException;
import com.sap.engine.lib.xsl.xpath.xobjects.XNodeSet;
import com.sap.engine.lib.xsl.xpath.xobjects.XObject;
import com.sap.engine.lib.xsl.xslt.QName;

public final class ETLocationStep
implements ETItem {
    public String axis;
    public QName nodeTest;
    protected int axisType;
    protected int nodeTestType;
    protected CharArray pitarget = null;
    public static final int ETLS_ALL = 1;
    public static final int ETLS_ALLNS = 6;
    public static final int ETLS_NODE = 2;
    public static final int ETLS_COMMENT = 3;
    public static final int ETLS_TEXT = 4;
    public static final int ETLS_PI = 5;
    public static final CharArray CH_ALL = new CharArray("*");
    public static final CharArray CH_NODE = new CharArray("node");
    public static final CharArray CH_COMMENT = new CharArray("comment");
    public static final CharArray CH_TEXT = new CharArray("text");
    public static final CharArray CH_PI = new CharArray("processing-instruction");

    public ETLocationStep(String axis, QName nodeTest) {
        this.axis = axis;
        this.nodeTest = nodeTest;
        this.axisType = 1000;
        if (nodeTest.rawname.equals("*")) {
            this.nodeTestType = 1;
        } else if (nodeTest.localname.equals("*")) {
            this.nodeTestType = 8;
        } else if (nodeTest.localname.equals("node()")) {
            this.nodeTestType = 3;
        } else if (nodeTest.localname.equals("comment()")) {
            this.nodeTestType = 6;
        } else if (nodeTest.localname.equals("text()")) {
            this.nodeTestType = 4;
        } else if (nodeTest.localname.startsWith(CH_PI)) {
            this.nodeTestType = 5;
            CharArray pt = nodeTest.localname;
            int i = 0;
            while (i < pt.length()) {
                if (pt.charAt(i) == '\'' || pt.charAt(i) == '\"') {
                    this.pitarget = new CharArray();
                    ++i;
                    while (pt.charAt(i) != '\'' && pt.charAt(i) != '\"' && i < pt.length()) {
                        this.pitarget.append(pt.charAt(i));
                        ++i;
                    }
                }
                ++i;
            }
        } else {
            this.nodeTestType = 0;
        }
        if (axis.equals("child")) {
            this.axisType = 1001;
        } else if (axis.equals("attribute")) {
            this.axisType = 1002;
        } else if (axis.equals("descendant-or-self")) {
            this.axisType = 1003;
        }
    }

    public void print(int indent) {
        Symbols.printSpace(indent);
        System.out.println("ETLocationStep(axis='" + this.axis + "', nodeTest='" + this.nodeTest + "')");
    }

    public XObject evaluate(XPathContext context) throws XPathException {
        XNodeSet xn = context.getXFactCurrent().getXNodeSet().reuse(context, this.axis, this.nodeTest);
        return xn;
    }

    public QName getNodeTest() {
        return this.nodeTest;
    }

    public boolean match(XPathContext c) throws XPathException {
        if (this.axisType == 1001 && c.dtm.nodeType[c.node] != 2) {
            switch (this.nodeTestType) {
                case 1: {
                    return c.dtm.nodeType[c.node] == 1;
                }
                case 3: {
                    return c.node != 0;
                }
                case 4: {
                    return c.dtm.nodeType[c.node] == 3;
                }
                case 5: {
                    return c.dtm.nodeType[c.node] == 7 && (this.pitarget == null || this.pitarget != null && this.pitarget.equals(c.dtm.name[c.node].localname));
                }
                case 6: {
                    return c.dtm.nodeType[c.node] == 8;
                }
            }
            if (c.dtm.name[c.node] != null && this.nodeTest.localname.equals(CH_ALL) && c.dtm.name[c.node].uri.equals(this.nodeTest.uri)) {
                return true;
            }
            return c.dtm.name[c.node] != null && c.dtm.name[c.node].uri.equals(this.nodeTest.uri) && c.dtm.name[c.node].localname.equals(this.nodeTest.localname);
        }
        if (this.axisType == 1002 && c.dtm.nodeType[c.node] == 2) {
            if (this.nodeTestType == 1) {
                return true;
            }
            return c.dtm.name[c.node] != null && c.dtm.name[c.node].uri.equals(this.nodeTest.uri) && c.dtm.name[c.node].localname.equals(this.nodeTest.localname);
        }
        return false;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ETLocationStep)) {
            return false;
        }
        ETLocationStep e = (ETLocationStep)o;
        return e.axisType == this.axisType && e.nodeTestType == this.nodeTestType && e.nodeTest.equals(this.nodeTest);
    }
}

